<?php
/*
* Template Name: Library
*/
global $theme_options;
get_header();

$post = get_post();
setup_postdata($post);
?>

<!-- START BREADCRUMB -->
<div id="breadcrumb" style="background-image: url('<?=get_field( 'background_breadcrumb', $post->ID )['url']?>')">
	<div class="container">
		<div class="mb-4">
			<h2 class="head-after"><?=wp_strip_all_tags( get_the_content() )?></h2>
		</div>
		<nav>
			<ol>
				<li class="breadcrumb-item">
					<a href="<?=get_home_url()?>"><i class="mdi mdi-home"></i> <?=pll_e('page-home')?></a>
				</li>
				<li class="breadcrumb-item active">
					<?=wp_strip_all_tags( get_the_title() )?>
				</li>
			</ol>
		</nav>
	</div>
</div>
<!-- END BREADCRUMB -->
<!-- START LATEST NEWS -->
<?php $title = get_field( 'title', $post->ID );
$video_clip = get_field( 'video_clip', $post->ID );
$video_clip = count( $video_clip ) == 1 ? $video_clip[0] : $video_clip;
$mobile_app = get_field( 'mobile_app', $post->ID );
$mobile_app = count( $mobile_app ) == 1 ? $mobile_app[0] : $mobile_app;
$document = get_field( 'document', $post->ID );
$document = count( $document ) == 1 ? $document[0] : $document; ?>
<div class="split-section" id="latest-news">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<div class="text-center">
					<h5 class="head-after mb-4"><?=$title?></h5>
				</div>
			</div>
			<!-- Latest News -->
			<div class="col-lg-12">
				<!-- tab -->
				<div class="mb-5">
					<ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
						<li class="nav-item">
							<a aria-controls="video-clip-link" aria-selected="true" class="nav-link active" data-toggle="pill" href="#video-clip-link" id="video-clip-tab" role="tab"><?=$video_clip['title']?></a>
						</li>
						<li class="nav-item">
							<a aria-controls="mobile-app-link" aria-selected="false" class="nav-link" data-toggle="pill" href="#mobile-app-link" id="mobile-app-tab" role="tab"><?=$mobile_app['title']?></a>
						</li>
						<li class="nav-item">
							<a aria-controls="document-link" aria-selected="false" class="nav-link" data-toggle="pill" href="#document-link" id="document-tab" role="tab"><?=$document['title']?></a>
						</li>
					</ul>
					<div class="tab-content" id="pills-tabContent">
						<div aria-labelledby="video-clip-tab" class="tab-pane fade show active" id="video-clip-link" role="tabpanel">
							<?php if( is_array($video_clip['content']) && count($video_clip['content']) > 0 ) : ?>
							<div class="row d-flex align-items-center">
								<?php foreach( $video_clip['content'] as $k => $v ) : ?>
								<div class="col-lg-4">
									<div class="video-btn">
										<div>
											<img alt="" class="w-100" src="<?=$v['image']['url']?>"/>
										</div>
										<button class="btn btn-lg btn-primary clickplay" data-target="#video_<?=$k?>" data-toggle="modal" index-data="<?=$k?>" type="button">
											<i class="mdi mdi-play-speed mdi-40px">
											</i>
										</button>
									</div>
									<p class="text-justify"><?=$v['sub_content']?></p>
								</div>
								<!-- Video -->
								<div class="modal fade" id="video_<?=$k?>" role="dialog">
									<div class="modal-dialog modal-lg">
										<div class="modal-content">
											<div class="modal-header">
												<button class="close" data-dismiss="modal" type="button">
													×
												</button>
											</div>
											<div class="modal-body">
												<input id="videoinput-<?=$k?>" type="hidden" value="<?=$v['link_video']?>" />
												<iframe id="vidframe-<?=$k?>"></iframe>
											</div>
										</div>
									</div>
								</div>
								<?php endforeach; ?>
							</div>
							<?php endif; ?>
						</div>
						<div aria-labelledby="mobile-app-tab" class="tab-pane fade" id="mobile-app-link" role="tabpanel">
							<?php if( is_array($mobile_app['content']) && count($mobile_app['content']) > 0 ) : ?>
							<div class="row d-flex align-items-center">
								<?php foreach( $mobile_app['content'] as $k => $v ) : ?>
								<div class="col-lg-4">
									<a href="<?=$v['link_download']?>" target="<?=$v['target']?>">
										<i class="mdi <?=$v['icon']?>"></i> <?=$v['sub_title']?>
									</a>
								</div>
								<?php endforeach; ?>
							</div>
							<?php endif; ?>
						</div>
						<div aria-labelledby="document-tab" class="tab-pane fade" id="document-link" role="tabpanel">
							<?php if( is_array($document['content']) && count($document['content']) > 0 ) : ?>
							<div class="row d-flex align-items-center">
								<?php foreach( $document['content'] as $k => $v ) : ?>
								<div class="col-lg-4">
									<a href="<?=$v['link_download']?>" download>
										<i class="mdi <?=$v['icon']?>"></i> <?=$v['sub_title']?>
									</a>
								</div>
								<?php endforeach; ?>
							</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<!-- END LATEST NEWS -->
<!-- START GET SOLUTIONS -->
<?=getSolutions( $post )?>
<!-- END GET SOLUTIONS -->
<!-- START CLIENTS -->
<?=getClients( $post )?>
<!-- END CLIENTS -->
			
<?php get_footer(); ?>