<?php
if( function_exists('acf_add_options_page') ) {
    acf_add_options_page();
}

if( file_exists( get_template_directory() . '/inc/redux-config.php' ) ) {
	require_once( get_template_directory() . '/inc/redux-config.php' );
}

if( ! function_exists( 'tqsmart_setup' ) ) {
	function tqsmart_setup() {
		add_theme_support('category-thumbnails');
		add_filter('show_admin_bar', '__return_false');
		register_nav_menus(
			array(
				'menu_primary' => __( 'Menu đầu trang' ),
				'our_services' => __( 'Menu dịch vụ' ),
			)
		);
	}
	add_action( 'after_setup_theme', 'tqsmart_setup' );
}
if( ! function_exists( 'tqsmart_register_string' ) ) {
	function tqsmart_register_string() {
		pll_register_string('view-detail', 'view-detail', 'general');
		pll_register_string('view-more', 'view-more', 'general');
		pll_register_string('page-home', 'page-home', 'general');
		pll_register_string('previous', 'previous', 'general');
		pll_register_string('next', 'next', 'general');
		pll_register_string('tags', 'tags', 'general');
		pll_register_string('relate-news', 'relate-news', 'general');
		pll_register_string('relate-recruitment', 'relate-recruitment', 'general');
		pll_register_string('relate-service', 'relate-service', 'general');
		pll_register_string('404-error', '404-error', 'page 404');
		pll_register_string('oops', 'oops', 'page 404');
		pll_register_string('page-not-found', 'page-not-found', 'page 404');
		pll_register_string('get-in-touch', 'get-in-touch', 'footer');
		pll_register_string('address', 'address', 'footer');
		pll_register_string('phone', 'phone', 'footer');
		pll_register_string('email', 'email', 'footer');
		pll_register_string('our-services', 'our-services', 'footer');
	}
	add_action('init', 'tqsmart_register_string');
}
if( ! function_exists( 'register_my_cpts' ) ) {
	function register_my_cpts() {
		$args = [
			"label" => __( "Tin tức" ),
			"labels" => [
				"name" => __( "Tin tức" ),
				"singular_name" => __( "Tin tức" ),
			],
			"description" => "",
			"public" => true,
			"publicly_queryable" => true,
			"show_ui" => true,
			"delete_with_user" => false,
			"show_in_rest" => true,
			"rest_base" => "",
			"rest_controller_class" => "WP_REST_Posts_Controller",
			"has_archive" => true,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"delete_with_user" => false,
			"exclude_from_search" => false,
			"capability_type" => "post",
			"map_meta_cap" => true,
			"hierarchical" => false,
			"rewrite" => [ "slug" => "news", "with_front" => true ],
			"query_var" => true,
			"menu_position" => 5,
			"supports" => [ "title", "editor", "thumbnail", "excerpt", "trackbacks", "custom-fields", "comments", "revisions", "author", "page-attributes", "post-formats" ],
			"taxonomies" => [ "post_tag" ],
		];
		register_post_type( "news", $args );
		
		$args = [
			"label" => __( "Dịch vụ" ),
			"labels" => [
				"name" => __( "Dịch vụ" ),
				"singular_name" => __( "Dịch vụ" ),
			],
			"description" => "",
			"public" => true,
			"publicly_queryable" => true,
			"show_ui" => true,
			"delete_with_user" => false,
			"show_in_rest" => true,
			"rest_base" => "",
			"rest_controller_class" => "WP_REST_Posts_Controller",
			"has_archive" => true,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"delete_with_user" => false,
			"exclude_from_search" => false,
			"capability_type" => "post",
			"map_meta_cap" => true,
			"hierarchical" => false,
			"rewrite" => [ "slug" => "service", "with_front" => true ],
			"query_var" => true,
			"menu_position" => 6,
			"supports" => [ "title", "editor", "thumbnail", "excerpt", "trackbacks", "custom-fields", "comments", "revisions", "author", "page-attributes", "post-formats" ],
			"taxonomies" => [],
		];
		register_post_type( "service", $args );
		
		$args = [
			"label" => __( "Tuyển dụng" ),
			"labels" => [
				"name" => __( "Tuyển dụng" ),
				"singular_name" => __( "Tuyển dụng" ),
			],
			"description" => "",
			"public" => true,
			"publicly_queryable" => true,
			"show_ui" => true,
			"delete_with_user" => false,
			"show_in_rest" => true,
			"rest_base" => "",
			"rest_controller_class" => "WP_REST_Posts_Controller",
			"has_archive" => true,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"delete_with_user" => false,
			"exclude_from_search" => false,
			"capability_type" => "post",
			"map_meta_cap" => true,
			"hierarchical" => false,
			"rewrite" => [ "slug" => "recruitment", "with_front" => true ],
			"query_var" => true,
			"menu_position" => 7,
			"supports" => [ "title", "editor", "thumbnail", "excerpt", "trackbacks", "custom-fields", "comments", "revisions", "author", "page-attributes", "post-formats" ],
			"taxonomies" => [],
		];
		register_post_type( "recruitment", $args );
	}
	add_action( 'init', 'register_my_cpts' );
}

function buildTree( $elements = null, $parentId = 0 ) {
    $branch = array();
	if( is_array($elements) && count($elements) > 0 ) {
		foreach ( $elements as &$element ) {
			if ( $element->menu_item_parent == $parentId ) {
				$children = buildTree( $elements, $element->ID );
				if ( $children ) {
					$element->children = $children;
				}
				$branch[$element->ID] = $element;
				unset( $element );
			}
		}
	}
    return $branch;
}

function custom_paginate_links( $args = '' ) {
	global $wp_query, $wp_rewrite;
	$pagenum_link = html_entity_decode( get_pagenum_link() );
	$url_parts    = explode( '?', $pagenum_link );
	$total   = isset( $wp_query->max_num_pages ) ? $wp_query->max_num_pages : 1;
	$current = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
	$pagenum_link = trailingslashit( $url_parts[0] ) . '%_%';
	$format  = $wp_rewrite->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
	$format .= $wp_rewrite->using_permalinks() ? user_trailingslashit( $wp_rewrite->pagination_base . '/%#%', 'paged' ) : '?paged=%#%';
	$defaults = array(
		'base'               => $pagenum_link,
		'format'             => $format,
		'total'              => $total,
		'current'            => $current,
		'aria_current'       => 'page',
		'show_all'           => false,
		'prev_next'          => true,
		'prev_text'          => __( '&laquo;' ),
		'next_text'          => __( '&raquo;' ),
		'end_size'           => 1,
		'mid_size'           => 2,
		'type'               => 'plain',
		'add_args'           => array(),
		'add_fragment'       => '',
		'before_page_number' => '',
		'after_page_number'  => '',
	);
	$args = wp_parse_args( $args, $defaults );
	if ( ! is_array( $args['add_args'] ) ) {
		$args['add_args'] = array();
	}
	if ( isset( $url_parts[1] ) ) {
		$format       = explode( '?', str_replace( '%_%', $args['format'], $args['base'] ) );
		$format_query = isset( $format[1] ) ? $format[1] : '';
		wp_parse_str( $format_query, $format_args );
		wp_parse_str( $url_parts[1], $url_query_args );
		foreach ( $format_args as $format_arg => $format_arg_value ) {
			unset( $url_query_args[ $format_arg ] );
		}
		$args['add_args'] = array_merge( $args['add_args'], urlencode_deep( $url_query_args ) );
	}
	$total = (int) $args['total'];
	if ( $total < 2 ) {
		return;
	}
	$current  = (int) $args['current'];
	$end_size = (int) $args['end_size'];
	if ( $end_size < 1 ) {
		$end_size = 1;
	}
	$mid_size = (int) $args['mid_size'];
	if ( $mid_size < 0 ) {
		$mid_size = 2;
	}
	$add_args   = $args['add_args'];
	$r          = '';
	$page_links = array();
	$dots       = false;
	if ( $args['prev_next'] && $current && 1 < $current ) :
		$link = str_replace( '%_%', 2 == $current ? '' : $args['format'], $args['base'] );
		$link = str_replace( '%#%', $current - 1, $link );
		if ( $add_args ) {
			$link = add_query_arg( $add_args, $link );
		}
		$link .= $args['add_fragment'];

		$page_links[] = sprintf(
			'<li class="page-item"><a class="prev page-numbers page-link" href="%s">%s</a></li>',
			esc_url( apply_filters( 'paginate_links', $link ) ),
			$args['prev_text']
		);
	endif;
	for ( $n = 1; $n <= $total; $n++ ) :
		if ( $n == $current ) :
			$page_links[] = sprintf(
				'<li class="page-item active"><span aria-current="%s" class="page-numbers current page-link">%s</span></li>',
				esc_attr( $args['aria_current'] ),
				$args['before_page_number'] . number_format_i18n( $n ) . $args['after_page_number']
			);
			$dots = true;
		else :
			if ( $args['show_all'] || ( $n <= $end_size || ( $current && $n >= $current - $mid_size && $n <= $current + $mid_size ) || $n > $total - $end_size ) ) :
				$link = str_replace( '%_%', 1 == $n ? '' : $args['format'], $args['base'] );
				$link = str_replace( '%#%', $n, $link );
				if ( $add_args ) {
					$link = add_query_arg( $add_args, $link );
				}
				$link .= $args['add_fragment'];
				$page_links[] = sprintf(
					'<li class="page-item"><a class="page-numbers page-link" href="%s">%s</a></li>',
					esc_url( apply_filters( 'paginate_links', $link ) ),
					$args['before_page_number'] . number_format_i18n( $n ) . $args['after_page_number']
				);
				$dots = true;
			elseif ( $dots && ! $args['show_all'] ) :
				$page_links[] = '<li class="page-item"><span class="page-numbers dots">' . __( '&hellip;' ) . '</span></li>';
				$dots = false;
			endif;
		endif;
	endfor;
	if ( $args['prev_next'] && $current && $current < $total ) :
		$link = str_replace( '%_%', $args['format'], $args['base'] );
		$link = str_replace( '%#%', $current + 1, $link );
		if ( $add_args ) {
			$link = add_query_arg( $add_args, $link );
		}
		$link .= $args['add_fragment'];
		$page_links[] = sprintf(
			'<li class="page-item"><a class="next page-numbers page-link" href="%s">%s</a></li>',
			esc_url( apply_filters( 'paginate_links', $link ) ),
			$args['next_text']
		);
	endif;
	switch ( $args['type'] ) {
		case 'array':
			return $page_links;
		case 'list':
			$r .= "<ul class='pagination'>\n\t";
			$r .= join( "\n\t", $page_links );
			$r .= "\n</ul>\n";
			break;
		default:
			$r = join( "\n", $page_links );
			break;
	}

	return $r;
}
function getClients( $post = null ) {
	$response = "";
	$post = is_null( $post ) ? get_post() : $post;
	setup_postdata($post);
	$clients = get_field( 'clients', 'options' );
	if( is_array( $clients ) && count( $clients ) > 0 ) {
		$response = <<<EOF
<div id="clients">
	<div class="container">
		<div class="owl-carousel" id="clients-carousel">
EOF;
			foreach( $clients as $k => $v )  {
				if( $v['show'] ) {
					$response .= <<<EOF
			<div class="item">
				<div class="card">
					<a href="{$v['link']}" title="{$v['title']}" target="_blank">
						<img alt="{$v['title']}" src="{$v['image']['url']}" class="img-fluid"/>
					</a>
				</div>
			</div>
EOF;
				}
			}
			$response .= <<<EOF
		</div>
	</div>
</div>
EOF;
	}
	wp_reset_postdata();
	return $response;
}
function getSolutions( $post = null ) {
	$response = "";
	$post = is_null( $post ) ? get_post() : $post;
	setup_postdata($post);
	$solutions = get_field( 'solutions_'.pll_current_language(), 'options' );
	if( isset( $solutions[0] ) && is_array( $solutions[0] ) ) {
		$response = <<<EOF
<div id="get-solutions" style="background: #f1f1f1;">
	<div class="container">
		<div class="row d-flex align-items-center">
			<div class="col-lg-9">
				<h4 class="mb-2">{$solutions[0]['title']}</h4>
				<p class="mb-0">{$solutions[0]['content']}</p>
			</div>
			<div class="col-lg-3">
				<a class="btn btn-primary btn-block" href="{$solutions[0]['link']}">{$solutions[0]['button']}</a>
			</div>
		</div>
	</div>
</div>
EOF;
	}
	wp_reset_postdata();
	return $response;
}
function latest( $limit = 5, $type = 'news' , $id = 0 ) {
	$response = "";
	$args = array(
		'post_type' => $type,
		'order' => 'DESC',
		'orderby' => 'ID',
		'posts_per_page' => $limit,
	);
	if( $id > 0 ) {
		$args['post__not_in'] = array($id); 
	}
	$query = new WP_Query( $args );
	if ( $query->have_posts() ) {
		while ( $query->have_posts() ) {
			$query->the_post();
			$src = get_the_post_thumbnail_url();
			$title = get_the_title();
			$link = get_permalink();
			$response .= <<<EOF
<div class="row">
	<div class="col-sm-4">
		<img class="mb-3 img-relate-news" src="{$src}" />
	</div>
	<div class="col-sm-8">
		<p>
			<a href="{$link}">
				{$title}
			</a>
		</p>
	</div>
</div>
EOF;
		}

	}
	return $response;
}
function tags() {
	$response = "";
	$tags = get_tags(array(
		'hide_empty' => false
	));
	if( is_array($tags) && count($tags) > 0 ) {
		$response .= "<ul class='tags'>";
		foreach($tags as $k => $v) {
			$response .= "<li>
				<a class='btn btn-sm btn-border' href='".get_tag_link($v)."'>
					{$v->name}
				</a>
			</li>";
		}
		$response .= "</ul>";
	}
	return $response;
}