<?php
/*
* Template Name: Service
*/
global $theme_options;
get_header();

$post = get_post();
setup_postdata($post);
?>

<!-- START BREADCRUMB -->
<div id="breadcrumb" style="background-image: url('<?=get_field( 'background_breadcrumb', $post->ID )['url']?>')">
	<div class="container">
		<div class="mb-4">
			<h2 class="head-after"><?=wp_strip_all_tags( get_the_content() )?></h2>
		</div>
		<nav>
			<ol>
				<li class="breadcrumb-item">
					<a href="<?=get_home_url()?>"><i class="mdi mdi-home"></i> <?=pll_e('page-home')?></a>
				</li>
				<li class="breadcrumb-item active">
					<?=wp_strip_all_tags( get_the_title() )?>
				</li>
			</ol>
		</nav>
	</div>
</div>
<!-- END BREADCRUMB -->
<!-- START WHAT WE OFFER -->
<?php $service = get_field( 'service', $post->ID );
$service = count( $service ) == 1 ? $service[0] : $service;
if( is_array( $service['content'] ) && count( $service['content'] ) > 0 ) : ?>
<div id="what-we-offer">
	<div class="container">
		<div class="row">
			<!-- What We Offer -->
			<div class="col-lg-12">
				<div class="text-center">
					<h5 class="head-after mb-4"><?=$service['title']?></h5>
				</div>
			</div>
			<?php foreach( $service['content'] as $k => $v ) : ?>
			<div class="col-lg-4">
				<div class="card p-3">
					<div class="row d-flex align-items-center">
						<div class="col-sm-3">
							<?=$v['icon']?>
						</div>
						<div class="col-sm-9">
							<div class="pt-4 pb-4">
								<h5>
									<a href="#service_<?=$k?>" class="js-anchor-link"><?=$v['sub_title']?></a>
								</h5>
								<p><?=$v['sub_content']?></p>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php endforeach; ?>
		</div>
	</div>
</div>
<!-- END WHAT WE OFFER -->
<!-- START WHO WE ARE -->
<?php foreach( $service['content'] as $k => $section ) : ?>
<div class="split-section" style="background-color: <?=$section['background']?>" id="service_<?=$k?>">
	<div class="container">
		<div class="row d-flex align-items-center">
			<div class="col-lg-12">
				<div class="text-center">
					<h5 class="head-after mb-4">
						<a href="<?=get_permalink($section['service'][0])?>"><?=get_post_field('post_title', $section['service'][0])?></a>
					</h5>
					<p><?=get_post_field('post_excerpt', $section['service'][0])?></p>
					<img class="img-fluid" src="<?=get_the_post_thumbnail_url($section['service'][0])?>">
				</div>
			</div>
		</div>
	</div>
</div>
<?php endforeach;
endif; ?>
<!-- END WHO WE ARE -->
<!-- START EXPERT WORKERS -->
<?php if( get_field( 'products', $post->ID ) ) :
	$category_product = get_field( 'category_products_'.pll_current_language(), 'options' );
	$category_product = count($category_product) == 1 ? $category_product[0] : $category_product;
	if( is_array( $category_product ) && count( $category_product ) > 0 ) : ?>
<div id="expert-workers">
	<div class="container">
		<div class="row">
			<!-- Expert Workers -->
			<div class="col-lg-12">
				<div class="text-center mb-5">
					<h5 class="head-after mb-4"><?=$category_product['title']?></h5>
					<p style="text-align: center;"><?=$category_product['sub_title']?></p>
				</div>
			</div>
				<?php foreach($category_product['category'] as $k => $v) :
				$thumb_id = get_woocommerce_term_meta( $v->term_id, 'thumbnail_id', true ); ?>
			<div class="col-lg-3">
				<div class="item">
					<div class="workers-img">
						<img alt="" class="w-100" src="<?=wp_get_attachment_url(  $thumb_id )?>"/>
					</div>
					<div class="">
						<div class="workers-details">
							<h4>
								<a href="<?=get_category_link($v)?>"><?=$v->name?></a>
							</h4>
						</div>
					</div>
				</div>
			</div>
				<?php endforeach; ?>
		</div>
	</div>
</div>
	<?php endif;
endif; ?>
<!-- END EXPERT WORKERS -->
<!-- START GET SOLUTIONS -->
<?=getSolutions( $post )?>
<!-- END GET SOLUTIONS -->
<!-- START CLIENTS -->
<?=getClients( $post )?>
<!-- END CLIENTS -->
	
<?php get_footer(); ?>