<?php
/*
* Template Name: Home
*/
global $theme_options;
get_header();

$post = get_post();
?>

<?php $carousel = get_field( 'carousel', $post->ID );
if( is_array($carousel) && count($carousel) > 0 ) : ?>
<div id="main-slider">
	<div class="carousel slide carousel-fade" data-interval="5000" data-ride="carousel" id="carouselExampleIndicators">
		<ol class="carousel-indicators">
			<li class="active" data-slide-to="0" data-target="#carouselExampleIndicators">
			</li>
			<li data-slide-to="1" data-target="#carouselExampleIndicators">
			</li>
			<li data-slide-to="2" data-target="#carouselExampleIndicators">
			</li>
		</ol>
		<div class="carousel-inner" role="listbox">
			<?php foreach($carousel as $k => $v) : ?>
			<div class="carousel-item <?=($k==0) ? 'active' : ''?>" style="background-image: url('<?=$v['background']['url']?>')">
				<div class="carousel-caption">
					<div class="container">
						<h3><?=$v['title']?></h3>
						<p class="mb-4 text-center"><?=$v['sub_title']?></p>
						<?php if(! empty( $v['link_more'] ) && ! empty( $v['text_more'] )) : ?>
						<a class="btn btn-xl btn-primary" href="<?=$v['link_more']?>" target="<?=$v['target_more']?>"><?=$v['text_more']?></a>
						<?php endif; ?>
						<?php if(! empty( $v['link_now'] ) && ! empty( $v['text_now'] )) :
							if( $v['type_now'] == 'popup' ) : ?>
							<a class="btn btn-xl btn-border clickplay" data-target="#video_<?=$k?>cc" data-toggle="modal" index-data="<?=$k?>cc"><?=$v['text_now']?></a>
							<?php else : ?>
							<a class="btn btn-xl btn-border" href="<?=$v['link_now']?>"><?=$v['text_now']?></a>
							<?php endif;
						endif; ?>
					</div>
				</div>
			</div>
			<?php endforeach; ?>
		</div>
		<!-- Previous Btn -->
		<a class="carousel-control-prev" data-slide="prev" href="#carouselExampleIndicators" role="button">
			<span aria-hidden="true" class="carousel-control-prev-icon">
			</span>
			<span class="sr-only"><?=pll_e('previous')?></span>
		</a>
		<!-- Next Btn -->
		<a class="carousel-control-next" data-slide="next" href="#carouselExampleIndicators" role="button">
			<span aria-hidden="true" class="carousel-control-next-icon">
			</span>
			<span class="sr-only"><?=pll_e('next')?>
			</span>
		</a>
	</div>
</div>
<?php foreach($carousel as $k => $v) : ?>
<?php if(! empty( $v['link_now'] ) && ! empty( $v['text_now'] )) :
	if( $v['type_now'] == 'popup' ) : ?>
	<div class="modal fade" id="video_<?=$k?>cc" role="dialog">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<button class="close" data-dismiss="modal" type="button">×</button>
				</div>
				<div class="modal-body">
					<input id="videoinput-<?=$k?>cc" type="hidden" value="<?=$v['link_now']?>" />
					<iframe id="vidframe-<?=$k?>cc"></iframe>
				</div>
			</div>
		</div>
	</div>
	<?php endif;
endif; ?>
<?php endforeach; ?>
<?php endif; ?>
<?php $section = get_field( 'section', $post->ID );
if( is_array($section) && count($section) > 0 ) : ?>
<!-- START WHO WE ARE -->
<?php foreach( $section as $k => $v):
	if($v['image_position'] == 'left') :?>
<div class="split-section home-sectionl">
	<div class="container">
		<div class="form-group col-lg-12 p-0">
			<div class="row">
				<!-- Left Side -->
				<div class="col-lg-6">
					<div class="video-btn">
						<div class="img-bg">
							<img alt="" class="w-100" src="<?=$v['image_url']['url']?>"/>
						</div>
						<button class="btn btn-lg btn-primary clickplay" data-target="#video_<?=$k?>" data-toggle="modal" type="button" index-data="<?=$k?>"><i class="mdi mdi-play-speed mdi-40px"></i></button>
					</div>
				</div>
				<!-- Right Side -->
				<div class="col-lg-6">
					<h1><?=$v['title']?></h1>
					<p class="text-justify"><?=$v['description']?></p>
					<a class="btn btn-primary" href="<?=$v['link']?>"><?=pll_e('view-more')?></a>
				</div>
				<!-- Video -->
				<div class="modal fade" id="video_<?=$k?>" role="dialog">
					<div class="modal-dialog modal-lg">
						<div class="modal-content">
							<div class="modal-header">
								<button class="close" data-dismiss="modal" type="button">×</button>
							</div>
							<div class="modal-body">
								<input id="videoinput-<?=$k?>" type="hidden" value="<?=$v['video_url']?>" />
								<iframe id="vidframe-<?=$k?>"></iframe>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
	<?php else : ?>
<div class="split-section home-sectionc">
	<div class="container">
		<div class="form-group col-lg-12 p-0">
			<div class="row">
				<!-- Left Side -->
				<div class="col-lg-6">
					<h1><?=$v['title']?></h1>
					<p class="text-justify"><?=$v['description']?></p>
					<a class="btn btn-primary" href="<?=$v['link']?>"><?=pll_e('view-more')?></a>
				</div>
				<!-- Right Side -->
				<div class="col-lg-6">
					<div class="video-btn">
						<div class="img-bg">
							<img alt="" class="w-100" src="<?=$v['image_url']['url']?>"/>
						</div>
						<button class="btn btn-lg btn-primary clickplay" data-target="#video_<?=$k?>" data-toggle="modal" type="button" index-data="<?=$k?>"><i class="mdi mdi-play-speed mdi-40px"></i></button>
					</div>
				</div>
				<!-- Video -->
				<div class="modal fade" id="video_<?=$k?>" role="dialog">
					<div class="modal-dialog modal-lg">
						<div class="modal-content">
							<div class="modal-header">
								<button class="close" data-dismiss="modal" type="button">×</button>
							</div>
							<div class="modal-body">
								<input id="videoinput-<?=$k?>" type="hidden" value="<?=$v['video_url']?>" />
								<iframe id="vidframe-<?=$k?>"></iframe>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php endif;
endforeach; ?>
<!-- END WHO WE ARE -->
<?php endif; ?>

<?php get_footer(); ?>