<div class="btn-notification" ng-click="showTarget('.app-notification-area')" ng-if="displayNotify>0">
    <div class="total">
        {{notifylist.length}}/{{newmessage}}
    </div>
    <div class="background">
        <svg viewbox="0 0 60.731 60.73">
            <g>
                <g>
                    <path d="M14.882,0.77v16.388H0v30.109h6.693v12.694l11.31-12.694h21.579V35.561h0.405l12.937,14.517V35.561h7.808V0.77H14.882z     M58.482,33.307h-7.811v10.862l-9.681-10.862h-23.86V3.016h41.351V33.307z">
                    </path>
                </g>
            </g>
        </svg>
    </div>
</div>
<div class="overlay-notification" ng-click="closeTarget('.app-notification-area')">
</div>
<div class="content-notification">
    <div class="title">
        <div class="layout-fixed">
            <div>
                <div class="text-title-5 clr-black">
                    Chat notifications
                </div>
                <div class="text-title-2 mgT3" ng-if="notifylist.length> 0">
                    <span>
                        {{notifylist.length}} message
                    </span>
                    •
                    <span class="clr-red">
                        {{newmessage}} unread
                    </span>
                </div>
            </div>
            <div class="w50px clear">
                <button class="popup-close-button bg-transparent pd0-i biger-3-time right" ng-click="closeTarget('.app-notification-area')" type="button">
                </button>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="content-inner">
            <div class="none">
                <audio id="myAudio">
                    <source src="sounds/ding.mp3" type="audio/mpeg">
                        Your browser does not support the audio element.
                    </source>
                </audio>
            </div>
            <script>
                var just_number_one = false;
                $(window).mousedown(function () {
                    myAudio = document.getElementById("myAudio");
                    if (!just_number_one) {
                        just_number_one = true;
                        myAudio.play();
                        myAudio.pause();
                    }
                });
            </script>
            <ion-scroll class="scroll-area" direction="y" has-bouncing="true" overflow-scroll="false">
                <ul class="list-item-07">
                    <li direction="right" ng-class="item.hashtag==true ? 'active' : ''" ng-click="openChat(item)" ng-if="item.message != ''" ng-repeat="item in notifylist" ng-right-click="openChatTab(item)" on-swipe-left="closeNotify(item)" transitiontype="slide">
                        <div>
                            <div class="thumb">
                                <div class="box-image-thumnail-2 w50px h50px">
                                    <a class="image-outer" href="javascript:void(0)">
                                        <img ng-src="{{item.image_pic}}"/>
                                    </a>
                                </div>
                            </div>
                            <div class="description">
                                <div class="layout-fixed">
                                    <div class="name">
                                        {{item.name}}
                                    </div>
                                    <div class="w40px clear v-top-i pdR3">
                                        <button class="bg-transparent right biger-3-time" ng-click="closeNotify(item)">
                                            <svg class="h14px clr-symbol-clickable alert" viewbox="0 0 59 59">
                                                <path d="M52.5,6H38.456c-0.11-1.25-0.495-3.358-1.813-4.711C35.809,0.434,34.751,0,33.499,0H23.5c-1.252,0-2.31,0.434-3.144,1.289   C19.038,2.642,18.653,4.75,18.543,6H6.5c-0.552,0-1,0.447-1,1s0.448,1,1,1h46c0.552,0,1-0.447,1-1S53.052,6,52.5,6z M20.553,6   c0.112-1.048,0.435-2.496,1.24-3.319C22.24,2.223,22.799,2,23.5,2h9.999c0.701,0,1.26,0.223,1.708,0.681   c0.805,0.823,1.128,2.271,1.24,3.319H20.553z">
                                                </path>
                                                <path d="M10.456,54.021C10.493,55.743,11.565,59,15.364,59h28.272c3.799,0,4.871-3.257,4.907-4.958L50.376,10H8.624L10.456,54.021z    M17.5,42h24c0.552,0,1,0.447,1,1s-0.448,1-1,1h-24c-0.552,0-1-0.447-1-1S16.948,42,17.5,42z M17.5,47h24c0.552,0,1,0.447,1,1   s-0.448,1-1,1h-24c-0.552,0-1-0.447-1-1S16.948,47,17.5,47z M17.5,52h24c0.552,0,1,0.447,1,1s-0.448,1-1,1h-24   c-0.552,0-1-0.447-1-1S16.948,52,17.5,52z">
                                                </path>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                                <div class="content">
                                    <div class="nowrap" ng-bind-html="item.message">
                                    </div>
                                </div>
                                <div class="date">
                                    <div class="layout-fixed">
                                        <div>
                                            <div class="text-title-2" ng-if="item.counter>1">
                                                {{item.counter}} message
                                            </div>
                                        </div>
                                        <div class="text-right">
                                            <div class="text-date-1">
                                                {{::formatTime(item.servertime)}}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>
            </ion-scroll>
        </div>
    </div>
    <div class="more">
        <div class="layout-fixed">
            <div onclick="redirectTo('chat.html')">
                <div class="text-link-1">
                    More notications on chat
                </div>
            </div>
            <div class="w50px clear" ng-click="closeNotify('all')" ng-if="notifylist.length>=2">
                <button class="bg-transparent right biger-3-time" type="button">
                    <svg class="h20px clr-symbol-clickable" viewbox="0 0 384 384">
                        <rect height="42.667" width="298.667" x="42.667" y="170.667">
                        </rect>
                        <rect height="42.667" width="298.667" x="0" y="256">
                        </rect>
                        <rect height="42.667" width="298.667" x="85.333" y="85.333">
                        </rect>
                    </svg>
                </button>
            </div>
        </div>
    </div>
</div>