<ion-scroll class="scroll-area" direction="y" has-bouncing="false" overflow-scroll="false" delegate-handle="scrollCustomerContent">
    <ul class="lst-customers stripe-1 except-app-create-button">
        <li class="box-setting-4 overhidden" ng-repeat="item in customers" ng-class="{'inactive':item.status=='0'}">
            <div class="content content-in">
                <div class="itm row-one-content">
                    <div class="layout-fixed">
                        <div class="v-top-i" ng-click="getCustomerData(item.id)">
                            <div class="name clr-clickable uppercase">{{item.fullname}}</div>
                            <div class="text-name-2">{{item.display_name}}</div>
                        </div>
                        <div class="w40px clear v-top-i">
                            <svg ng-if="item.flag_id=='1'" class="icon-flag-1 h20px right" viewBox="0 0 60 60"><polygon style="fill:#FFFF00;" points="52,23.5 10,40 10,22 10,4 " /> <path d="M9,0C8.448,0,8,0.447,8,1v3v55c0,0.553,0.448,1,1,1s1-0.447,1-1V4V1C10,0.447,9.552,0,9,0z" /> </svg>
                            <svg ng-if="item.flag_id=='2'" class="icon-flag-1 h20px right" viewBox="0 0 60 60"><polygon style="fill:#FECB1F;" points="52,23.5 10,40 10,22 10,4 " /> <path d="M9,0C8.448,0,8,0.447,8,1v3v55c0,0.553,0.448,1,1,1s1-0.447,1-1V4V1C10,0.447,9.552,0,9,0z" /> </svg>
                            <svg ng-if="item.flag_id=='3'" class="icon-flag-1 h20px right" viewBox="0 0 60 60"><polygon style="fill:#FF0000;" points="52,23.5 10,40 10,22 10,4 " /> <path d="M9,0C8.448,0,8,0.447,8,1v3v55c0,0.553,0.448,1,1,1s1-0.447,1-1V4V1C10,0.447,9.552,0,9,0z" /> </svg>
                            <svg ng-if="item.flag_id=='4'" class="icon-flag-1 h20px right" viewBox="0 0 60 60"><polygon style="fill:#008000;" points="52,23.5 10,40 10,22 10,4 " /> <path d="M9,0C8.448,0,8,0.447,8,1v3v55c0,0.553,0.448,1,1,1s1-0.447,1-1V4V1C10,0.447,9.552,0,9,0z" /> </svg>
                        </div>
                        <div class="w40px clear v-top-i relative">
                            <button class="bg-transparent right biger-3-time" onclick="openQuickOption(this)">
                                <svg class="h16px clr-symbol-clickable" viewBox="0 0 512 512"> <circle fill="#1075BB" cx="61.793" cy="256" r="61.793" /> <circle fill="#1075BB" cx="450.207" cy="256" r="61.793" /> <circle fill="#1075BB" cx="256" cy="256" r="61.793" /> </svg>
                            </button>
                            <div class="quick-popup box-popup-1 display-top-right mgT20" onclick="closeQuickOption(this)">
                                <div class="popup-content w150px">
                                    <ul class="list-item-03">
                                        <li ng-click="editCustomers(item.id)" ng-if="hideEditCustomer">
                                            <div class="layout-fixed">
                                                <div class="icon-area">
                                                    <svg class="h15px" viewBox="0 0 285 285"> <path d="M216.818,271.424H26.821V81.427h61.713c3.748,0,6.788-3.04,6.788-6.788V13.576h121.496v29.246    c0.3-0.037,0.591-0.115,0.903-0.127c1.753-0.068,5.165,0.019,9.708,1.237c0.909,0.235,1.917,0.572,2.965,0.934V6.788    c0-3.748-3.04-6.788-6.788-6.788H87.894c-1.8,0-3.532,0.714-4.803,1.985l-67.86,67.861c-1.271,1.271-1.985,2.993-1.985,4.793    v203.583c0,3.741,3.04,6.778,6.788,6.778h203.573c3.748,0,6.788-3.037,6.788-6.778V173.01c-3.68,3.612-8.554,5.592-13.576,5.765    L216.818,271.424L216.818,271.424z" fill="#FFF" /> <path d="M267.485,46.164c-4.305-4.305-7.768-4.289-8.139-4.268c-0.52,0.016-1.015,0.235-1.379,0.597l-15.422,15.422    c2.242,1.395,4.704,3.278,7.301,5.875c2.61,2.61,4.49,5.068,5.888,7.308L271.14,55.68c0.377-0.371,0.587-0.857,0.612-1.376    C271.771,53.917,271.783,50.469,267.485,46.164z" fill="#FFF" /> <path d="M254.571,110.462l-7.465,7.465l-4.966-4.96l13.347-13.347c1.15-1.15,1.831-2.703,1.905-4.323    c0.049-1.206,0.111-12.088-13.421-25.621c-13.529-13.539-24.412-13.467-25.621-13.427c-1.63,0.081-3.17,0.761-4.32,1.911    L98.851,173.325c-0.708,0.705-1.252,1.584-1.565,2.549l-16.124,48.372c-0.779,2.338-0.173,4.917,1.581,6.673    c1.735,1.744,4.32,2.345,6.655,1.565l48.384-16.131c0.959-0.321,1.818-0.865,2.533-1.552l97.032-97.035l4.958,4.96l-30.996,30.986    c-2.65,2.66-2.65,6.946,0,9.605c1.33,1.33,3.062,1.985,4.802,1.985c1.732,0,3.473-0.655,4.793-1.985l43.267-43.263    c2.647-2.647,2.647-6.939,0-9.593C261.517,107.809,257.218,107.809,254.571,110.462z" fill="#FFF" /> </svg>
                                                </div>
                                                <div class="name-area text-link-1">
                                                    Edit information
                                                </div>
                                            </div>
                                        </li>
                                        <li ng-click="confirmDeleteCustomer(item.id, item.fullname , item.status)" ng-if="item.status=='1' && hideDeleteCustomer">
                                            <div class="layout-fixed">
                                                <div class="icon-area">
                                                    <svg class="h16px" viewBox="0 0 59 59"> <path d="M52.5,6H38.456c-0.11-1.25-0.495-3.358-1.813-4.711C35.809,0.434,34.751,0,33.499,0H23.5c-1.252,0-2.31,0.434-3.144,1.289   C19.038,2.642,18.653,4.75,18.543,6H6.5c-0.552,0-1,0.447-1,1s0.448,1,1,1h46c0.552,0,1-0.447,1-1S53.052,6,52.5,6z M20.553,6   c0.112-1.048,0.435-2.496,1.24-3.319C22.24,2.223,22.799,2,23.5,2h9.999c0.701,0,1.26,0.223,1.708,0.681   c0.805,0.823,1.128,2.271,1.24,3.319H20.553z" /> <path d="M10.456,54.021C10.493,55.743,11.565,59,15.364,59h28.272c3.799,0,4.871-3.257,4.907-4.958L50.376,10H8.624L10.456,54.021z    M17.5,42h24c0.552,0,1,0.447,1,1s-0.448,1-1,1h-24c-0.552,0-1-0.447-1-1S16.948,42,17.5,42z M17.5,47h24c0.552,0,1,0.447,1,1   s-0.448,1-1,1h-24c-0.552,0-1-0.447-1-1S16.948,47,17.5,47z M17.5,52h24c0.552,0,1,0.447,1,1s-0.448,1-1,1h-24   c-0.552,0-1-0.447-1-1S16.948,52,17.5,52z" /> </svg>
                                                </div>
                                                <div class="name-area text-link-1">
                                                    Inactive
                                                </div>
                                            </div>
                                        </li>
                                        <li ng-click="confirmDeleteCustomer(item.id, item.fullname , item.status)" ng-if="item.status!='1' && hideDeleteCustomer">
                                            <div class="layout-fixed">
                                                <div class="icon-area">
                                                    <svg class="h15px" viewBox="0 0 64 64"> <path d="m1.253,42.328l9.126,5.32c0.025,0.014 0.051,0.019 0.076,0.032 0.081,0.043 0.165,0.073 0.252,0.105 0.085,0.031 0.168,0.063 0.256,0.082 0.08,0.018 0.162,0.024 0.246,0.032 0.062,0.006 0.125,0.024 0.187,0.024 0.036,0 0.069-0.012 0.104-0.014 0.031-0.001 0.063,0.007 0.096,0.004 0.051-0.005 0.095-0.026 0.144-0.035 0.098-0.017 0.192-0.037 0.286-0.069 0.078-0.025 0.152-0.056 0.227-0.091 0.086-0.04 0.168-0.086 0.248-0.138 0.07-0.046 0.137-0.095 0.2-0.149 0.07-0.06 0.134-0.125 0.198-0.195 0.06-0.068 0.115-0.138 0.166-0.214 0.023-0.037 0.058-0.064 0.08-0.104 0.017-0.028 0.016-0.062 0.031-0.091 0.03-0.058 0.072-0.108 0.098-0.17l3.631-8.989c0.418-1.036-0.082-2.214-1.119-2.633-1.035-0.415-2.214,0.084-2.633,1.118l-1.865,4.615c-1.244-4.161-1.1-8.437-1.097-8.555 0-13.71 11.153-24.864 24.864-24.864 13.709,0 24.863,11.154 24.863,24.864 0,13.709-11.154,24.864-24.863,24.864-1.117,0-2.023,0.906-2.023,2.022 0,1.117 0.906,2.023 2.023,2.023 15.941,0 28.909-12.968 28.909-28.909 0-15.941-12.968-28.91-28.909-28.91s-28.91,12.97-28.909,28.829c-0.01,0.251-0.156,4.451 1.039,8.972l-3.896-2.271c-0.965-0.564-2.204-0.236-2.766,0.729-0.562,0.965-0.236,2.204 0.73,2.766z" /> </svg>
                                                </div>
                                                <div class="name-area text-link-1">
                                                    Active
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                                <div class="popup-overlay"></div>
                            </div>
                        </div>
                    </div>
                    <div class="layout-fixed mgT10" ng-click="openGoogleMap(item.street)">
                        <div class="w20px lh1">
                            <svg class="h12px clr-symbol" viewBox="0 0 97.713 97.713"> <g> <path d="M48.855,0C29.021,0,12.883,16.138,12.883,35.974c0,5.174,1.059,10.114,3.146,14.684   c8.994,19.681,26.238,40.46,31.31,46.359c0.38,0.441,0.934,0.695,1.517,0.695s1.137-0.254,1.517-0.695   c5.07-5.898,22.314-26.676,31.311-46.359c2.088-4.57,3.146-9.51,3.146-14.684C84.828,16.138,68.69,0,48.855,0z M48.855,54.659   c-10.303,0-18.686-8.383-18.686-18.686c0-10.304,8.383-18.687,18.686-18.687s18.686,8.383,18.686,18.687   C67.542,46.276,59.159,54.659,48.855,54.659z" style="fill: #b1c7d7" /> </g> </svg>
                        </div>
                        <div class="text">{{item.street}}</div>
                    </div>
                    <div class="layout-fixed mgT4">
                        <div class="w20px lh1">
                            <svg class="h12px clr-symbol" viewBox="0 0 203.613 203.613"> <path d="M59.316,32.273v139.066c0,16.279-12.65,29.523-28.2,29.523h-2.915C12.651,200.863,0,187.619,0,171.339V32.273  C0,15.995,12.651,2.75,28.201,2.75h2.915C46.666,2.75,59.316,15.995,59.316,32.273z M203.613,41.203v119.467  c0,12.789-10.405,23.194-23.195,23.194H74.415c-2.762,0-5-2.238-5-5V24.749c0-2.762,2.238-5,5-5h107.743  C193.988,19.749,203.613,29.373,203.613,41.203z M110.59,150.696c0-3.531-2.862-6.393-6.393-6.393c-3.531,0-6.393,2.862-6.393,6.393  s2.862,6.393,6.393,6.393C107.728,157.089,110.59,154.227,110.59,150.696z M110.59,121.954c0-3.531-2.862-6.393-6.393-6.393  c-3.531,0-6.393,2.862-6.393,6.393c0,3.531,2.862,6.393,6.393,6.393C107.728,128.347,110.59,125.485,110.59,121.954z M110.59,93.212  c0-3.531-2.862-6.393-6.393-6.393c-3.531,0-6.393,2.862-6.393,6.393c0,3.531,2.862,6.393,6.393,6.393  C107.728,99.605,110.59,96.743,110.59,93.212z M142.968,150.696c0-3.531-2.862-6.393-6.393-6.393c-3.531,0-6.393,2.862-6.393,6.393  s2.862,6.393,6.393,6.393C140.106,157.089,142.968,154.227,142.968,150.696z M142.968,121.954c0-3.531-2.862-6.393-6.393-6.393  c-3.531,0-6.393,2.862-6.393,6.393c0,3.531,2.862,6.393,6.393,6.393C140.106,128.347,142.968,125.485,142.968,121.954z   M142.968,93.212c0-3.531-2.862-6.393-6.393-6.393c-3.531,0-6.393,2.862-6.393,6.393c0,3.531,2.862,6.393,6.393,6.393  C140.106,99.605,142.968,96.743,142.968,93.212z M175.346,150.696c0-3.531-2.862-6.393-6.393-6.393  c-3.531,0-6.393,2.862-6.393,6.393s2.862,6.393,6.393,6.393C172.484,157.089,175.346,154.227,175.346,150.696z M175.346,121.954  c0-3.531-2.862-6.393-6.393-6.393c-3.531,0-6.393,2.862-6.393,6.393c0,3.531,2.862,6.393,6.393,6.393  C172.484,128.347,175.346,125.485,175.346,121.954z M175.346,93.212c0-3.531-2.862-6.393-6.393-6.393  c-3.531,0-6.393,2.862-6.393,6.393c0,3.531,2.862,6.393,6.393,6.393C172.484,99.605,175.346,96.743,175.346,93.212z M187.017,47.521  c0-5.812-4.729-10.54-10.54-10.54H91.011c-2.762,0-5,2.238-5,5v19.097c0,2.762,2.238,5,5,5h91.006c2.762,0,5-2.238,5-5V47.521z" fill="#b1c7d7" /> </svg>
                        </div>
                        <div class="text" ng-bind-html="item.phone_number.replace('(','<span class=\'ft-symbol\'>(</span>').replace(')','<span class=\'ft-symbol\'>)</span>')"></div>
                    </div>
                    <div class="layout-fixed mgT4">
                        <div class="w20px lh1">
                            <svg class="h12px clr-symbol" viewBox="0 0 58 58"> <path d="M58,17c0-1.575-0.72-3.026-1.974-4.02C57.28,12.026,58,10.575,58,9c0-2.402-1.711-4.469-4.087-4.932   C53.469,1.711,51.402,0,49,0c-1.575,0-3.026,0.72-4.02,1.974C44.026,0.72,42.575,0,41,0s-3.026,0.72-4.02,1.974   C36.026,0.72,34.575,0,33,0s-3.026,0.72-4.02,1.974C28.026,0.72,26.575,0,25,0s-3.026,0.72-4.02,1.974C20.026,0.72,18.575,0,17,0   s-3.026,0.72-4.02,1.974C12.026,0.72,10.575,0,9,0C6.598,0,4.531,1.711,4.068,4.087C1.711,4.531,0,6.598,0,9   c0,1.575,0.72,3.026,1.974,4.02C0.72,13.974,0,15.425,0,17s0.72,3.026,1.974,4.02C0.72,21.974,0,23.425,0,25s0.72,3.026,1.974,4.02   C0.72,29.974,0,31.425,0,33s0.72,3.026,1.974,4.02C0.72,37.974,0,39.425,0,41s0.72,3.026,1.974,4.02C0.72,45.974,0,47.425,0,49   c0,2.402,1.711,4.469,4.087,4.932C4.531,56.289,6.598,58,9,58c1.575,0,3.026-0.72,4.02-1.974C13.974,57.28,15.425,58,17,58   s3.026-0.72,4.02-1.974C21.974,57.28,23.425,58,25,58s3.026-0.72,4.02-1.974C29.974,57.28,31.425,58,33,58s3.026-0.72,4.02-1.974   C37.974,57.28,39.425,58,41,58s3.026-0.72,4.02-1.974C45.974,57.28,47.425,58,49,58c2.402,0,4.469-1.711,4.932-4.087   C56.289,53.469,58,51.402,58,49c0-1.575-0.72-3.026-1.974-4.02C57.28,44.026,58,42.575,58,41s-0.72-3.026-1.974-4.02   C57.28,36.026,58,34.575,58,33s-0.72-3.026-1.974-4.02C57.28,28.026,58,26.575,58,25s-0.72-3.026-1.974-4.02   C57.28,20.026,58,18.575,58,17z M54.815,14.611C55.568,15.185,56,16.055,56,17s-0.432,1.815-1.185,2.389   C54.303,19.779,54.01,20.366,54.01,21s0.293,1.221,0.806,1.611C55.568,23.185,56,24.055,56,25s-0.432,1.815-1.185,2.389   C54.303,27.779,54.01,28.366,54.01,29s0.293,1.221,0.806,1.611C55.568,31.185,56,32.055,56,33s-0.432,1.815-1.185,2.389   C54.303,35.779,54.01,36.366,54.01,37s0.293,1.221,0.806,1.611C55.568,39.185,56,40.055,56,41s-0.432,1.815-1.185,2.389   C54.303,43.779,54.01,44.366,54.01,45s0.293,1.221,0.806,1.611C55.568,47.185,56,48.055,56,49c0,1.441-1.026,2.682-2.439,2.948   c-0.824,0.155-1.457,0.788-1.612,1.612C51.682,54.974,50.441,56,49,56c-0.945,0-1.815-0.432-2.389-1.185   C46.221,54.303,45.634,54.01,45,54.01s-1.221,0.293-1.611,0.806C42.815,55.568,41.945,56,41,56s-1.815-0.432-2.389-1.185   c-0.781-1.025-2.441-1.025-3.223,0C34.815,55.568,33.945,56,33,56s-1.815-0.432-2.389-1.185c-0.781-1.025-2.441-1.025-3.223,0   C26.815,55.568,25.945,56,25,56s-1.815-0.432-2.389-1.185c-0.781-1.025-2.441-1.025-3.223,0C18.815,55.568,17.945,56,17,56   s-1.815-0.432-2.389-1.185c-0.781-1.025-2.441-1.025-3.223,0C10.815,55.568,9.945,56,9,56c-1.441,0-2.682-1.026-2.948-2.439   c-0.155-0.824-0.788-1.457-1.612-1.612C3.026,51.682,2,50.441,2,49c0-0.945,0.432-1.815,1.185-2.389   C3.697,46.221,3.99,45.634,3.99,45s-0.293-1.221-0.806-1.611C2.432,42.815,2,41.945,2,41s0.432-1.815,1.185-2.389   C3.697,38.221,3.99,37.634,3.99,37s-0.293-1.221-0.806-1.611C2.432,34.815,2,33.945,2,33s0.432-1.815,1.185-2.389   C3.697,30.221,3.99,29.634,3.99,29s-0.293-1.221-0.806-1.611C2.432,26.815,2,25.945,2,25s0.432-1.815,1.185-2.389   C3.697,22.221,3.99,21.634,3.99,21s-0.293-1.221-0.806-1.611C2.432,18.815,2,17.945,2,17s0.432-1.815,1.185-2.389   C3.697,14.221,3.99,13.634,3.99,13s-0.293-1.221-0.806-1.611C2.432,10.815,2,9.945,2,9c0-1.441,1.026-2.682,2.439-2.948   c0.824-0.155,1.457-0.788,1.612-1.612C6.318,3.026,7.559,2,9,2c0.945,0,1.815,0.432,2.389,1.185c0.781,1.025,2.441,1.025,3.223,0   C15.185,2.432,16.055,2,17,2s1.815,0.432,2.389,1.185c0.781,1.025,2.441,1.025,3.223,0C23.185,2.432,24.055,2,25,2   s1.815,0.432,2.389,1.185c0.781,1.025,2.441,1.025,3.223,0C31.185,2.432,32.055,2,33,2s1.815,0.432,2.389,1.185   c0.781,1.025,2.441,1.025,3.223,0C39.185,2.432,40.055,2,41,2s1.815,0.432,2.389,1.185c0.781,1.025,2.441,1.025,3.223,0   C47.185,2.432,48.055,2,49,2c1.441,0,2.682,1.026,2.948,2.439c0.155,0.824,0.788,1.457,1.612,1.612C54.974,6.318,56,7.559,56,9   c0,0.945-0.432,1.815-1.185,2.389C54.303,11.779,54.01,12.366,54.01,13S54.303,14.221,54.815,14.611z" /> <path d="M48.282,7H9.718C8.219,7,7,8.219,7,9.718v38.564C7,49.781,8.219,51,9.718,51h38.564C49.781,51,51,49.781,51,48.282V9.718   C51,8.219,49.781,7,48.282,7z M24,46c-3.309,0-6-2.691-6-6s2.691-6,6-6s6,2.691,6,6S27.309,46,24,46z M44.639,43.77   C44.452,43.925,44.226,44,44.001,44c-0.288,0-0.573-0.123-0.771-0.361c-0.684-0.824-1.777-0.824-2.461,0   C40.042,44.517,39.058,45,38,45s-2.042-0.483-2.77-1.361c-0.684-0.824-1.777-0.824-2.461,0c-0.351,0.425-0.982,0.486-1.408,0.131   c-0.425-0.353-0.483-0.982-0.131-1.408C31.958,41.483,32.942,41,34,41s2.042,0.483,2.77,1.361c0.684,0.824,1.777,0.824,2.461,0   C39.958,41.483,40.942,41,42,41s2.042,0.483,2.77,1.361C45.122,42.787,45.063,43.417,44.639,43.77z M44.639,37.77   C44.452,37.925,44.226,38,44.001,38c-0.288,0-0.573-0.123-0.771-0.361c-0.684-0.824-1.777-0.824-2.461,0   C40.042,38.517,39.058,39,38,39s-2.042-0.483-2.77-1.361c-0.684-0.824-1.777-0.824-2.461,0c-0.351,0.424-0.982,0.485-1.408,0.131   c-0.425-0.353-0.483-0.982-0.131-1.408C31.958,35.483,32.942,35,34,35s2.042,0.483,2.77,1.361c0.684,0.824,1.777,0.824,2.461,0   C39.958,35.483,40.942,35,42,35s2.042,0.483,2.77,1.361C45.122,36.787,45.063,37.417,44.639,37.77z" /> </svg>
                        </div>
                        <div>
                            <a class="text" href="javascript:void(0)"><div class="first-capitalize">{{item.email}}</div></a>
                        </div>
                    </div>
                    <div class="layout-fixed mgT10">
                        <div>
                            <div class="layout-fixed w-auto-i">
                                <div class="pdR10">
                                    <button type="button" class="button-function-1 green w34px h34px" ng-click="openPopupPhone(item)">
                                        <svg class="h14px" viewBox="0 0 202.918 202.918"> <path d="M185.815,168.463c-0.641,2.686-3.338,4.348-6.023,3.703c-2.687-0.641-4.345-3.338-3.703-6.023  c2.783-11.662,1.322-21.9-3.907-27.386c-3.482-3.652-8.442-4.899-14.737-3.716c-12.512,2.359-20.484,13.166-29.716,25.68  c-7.73,10.477-16.491,22.352-29.351,30.305c-12.503,7.732-26.774,11.893-40.589,11.893c-1.304,0-2.602-0.036-3.895-0.111  c-15.025-0.866-27.414-6.857-33.988-16.438c-8.301-12.096-3.537-24.684,2.934-33.277l-5.057-6.758  c-3.798-5.074-2.803-12.353,2.218-16.223l32.649-25.162c2.058-1.587,4.518-2.426,7.113-2.426c3.659,0,7.151,1.748,9.342,4.675  l12.042,16.092c9.594-4.324,20.569-11.658,32.472-23.738c12.029-12.207,19.245-23.423,23.482-33.092l-16.074-12.388  c-5.022-3.87-6.017-11.148-2.218-16.224l24.825-33.175C145.825,1.748,149.317,0,152.976,0c2.596,0,5.055,0.839,7.114,2.426  l18.787,14.479c0.024,0.019,0.042,0.043,0.066,0.062c0.145,0.118,0.275,0.249,0.405,0.382c0.117,0.117,0.235,0.23,0.338,0.356  c0.07,0.086,0.128,0.179,0.191,0.27c0.136,0.191,0.265,0.384,0.371,0.589c0.024,0.048,0.043,0.098,0.066,0.146  c0.125,0.261,0.229,0.528,0.307,0.804c0.002,0.006,0.005,0.012,0.007,0.018c0.475,1.748,10.961,43.469-45.93,101.204  c-40.888,41.493-73.748,47.69-89.697,47.69c-0.001,0-0.001,0-0.002,0c-6.224-0.001-9.797-0.948-10.184-1.057  c-0.011-0.003-0.02-0.009-0.03-0.012c-0.264-0.077-0.515-0.179-0.761-0.298c-0.07-0.033-0.143-0.061-0.211-0.098  c-0.185-0.1-0.357-0.218-0.528-0.341c-0.109-0.077-0.22-0.15-0.322-0.235c-0.117-0.099-0.223-0.211-0.331-0.321  c-0.132-0.133-0.261-0.265-0.377-0.411c-0.023-0.03-0.053-0.052-0.075-0.082l-3.043-4.067c-3.37,5.259-5.698,12.339-0.986,19.204  c9.55,13.914,39.363,17.646,64.967,1.809c11.218-6.937,19.019-17.511,26.564-27.736c10.047-13.618,19.537-26.481,35.909-29.568  c9.564-1.803,18.026,0.555,23.829,6.643C186.998,139.806,189.389,153.49,185.815,168.463z" fill="#FFFFFF" /> </svg>
                                    </button>
                                </div>
                                <div class="pdR10">
                                    <button type="button" class="button-function-1 w34px h34px" ng-click="redirectTo('order.html#/board/order/' + item.id + '/0/order/' + backPage + '/' + item.id)">
                                        <svg class="h14px" viewBox="0 0 60 60"> <path d="M60,4.293c0-2.206-1.794-4-4-4H4c-2.206,0-4,1.794-4,4c0,1.859,1.28,3.411,3,3.858v3.142c0-0.553,0.448-1,1-1h2   c0.552,0,1,0.447,1,1s-0.448,1-1,1H4c-0.552,0-1-0.447-1-1v45.414l3-3l6,6l6-6l6,6l6-6l6,6l6-6l6,6l6-6l3,3V11.293   c0,0.553-0.448,1-1,1h-2c-0.552,0-1-0.447-1-1s0.448-1,1-1h2c0.552,0,1,0.447,1,1V8.151C58.72,7.704,60,6.152,60,4.293z M31,33.293   c0.552,0,1,0.447,1,1s-0.448,1-1,1h-2c-0.552,0-1-0.447-1-1s0.448-1,1-1H31z M29,27.293c0-0.271,0.11-0.521,0.29-0.71   c0.38-0.37,1.05-0.37,1.42,0c0.18,0.189,0.29,0.439,0.29,0.71c0,0.27-0.11,0.52-0.29,0.71c-0.19,0.18-0.45,0.29-0.71,0.29   c-0.26,0-0.52-0.11-0.71-0.29C29.11,27.813,29,27.563,29,27.293z M29,21.293c-0.552,0-1-0.447-1-1s0.448-1,1-1h15   c0.552,0,1,0.447,1,1s-0.448,1-1,1H29z M30.846,11.293c0-0.553,0.448-1,1-1h3.692c0.552,0,1,0.447,1,1s-0.448,1-1,1h-3.692   C31.294,12.293,30.846,11.846,30.846,11.293z M38.231,11.293c0-0.553,0.448-1,1-1h3.692c0.552,0,1,0.447,1,1s-0.448,1-1,1h-3.692   C38.679,12.293,38.231,11.846,38.231,11.293z M8.692,11.293c0-0.553,0.448-1,1-1h3.692c0.552,0,1,0.447,1,1s-0.448,1-1,1H9.692   C9.14,12.293,8.692,11.846,8.692,11.293z M20,27.293c-0.552,0-1-0.447-1-1c0-1.302-0.839-2.402-2-2.816v5.438l2.229,1.734   c0.777,0.604,1.281,1.511,1.383,2.488c0.1,0.957-0.182,1.882-0.793,2.605c-0.734,0.867-1.728,1.446-2.819,1.668v0.882   c0,0.553-0.448,1-1,1s-1-0.447-1-1v-0.878c-2.279-0.465-4-2.484-4-4.899c0-0.553,0.448-1,1-1s1,0.447,1,1   c0,1.302,0.839,2.402,2,2.816v-5.438l-2.229-1.734c-0.777-0.604-1.282-1.513-1.383-2.491c-0.1-0.956,0.183-1.881,0.794-2.603   c0.733-0.867,1.728-1.446,2.818-1.668v-1.104c0-0.553,0.448-1,1-1s1,0.447,1,1v1.101c2.279,0.465,4,2.484,4,4.899   C21,26.846,20.552,27.293,20,27.293z M20.77,12.293h-3.692c-0.552,0-1-0.447-1-1s0.448-1,1-1h3.692c0.552,0,1,0.447,1,1   S21.322,12.293,20.77,12.293z M23.461,11.293c0-0.553,0.448-1,1-1h3.692c0.552,0,1,0.447,1,1s-0.448,1-1,1h-3.692   C23.909,12.293,23.461,11.846,23.461,11.293z M44,42.293H29c-0.552,0-1-0.447-1-1s0.448-1,1-1h15c0.552,0,1,0.447,1,1   S44.552,42.293,44,42.293z M34,34.293c0-0.26,0.11-0.521,0.29-0.71c0.38-0.37,1.05-0.37,1.42,0c0.18,0.18,0.29,0.439,0.29,0.71   c0,0.27-0.11,0.52-0.29,0.71c-0.19,0.18-0.45,0.29-0.71,0.29c-0.26,0-0.52-0.11-0.71-0.29C34.11,34.813,34,34.553,34,34.293z    M49.71,42.003c-0.19,0.18-0.45,0.29-0.71,0.29c-0.26,0-0.52-0.11-0.71-0.29c-0.18-0.19-0.29-0.45-0.29-0.71   c0-0.271,0.11-0.521,0.29-0.71c0.38-0.37,1.04-0.37,1.42,0c0.18,0.189,0.29,0.439,0.29,0.71C50,41.553,49.89,41.813,49.71,42.003z    M49,35.293H39c-0.552,0-1-0.447-1-1s0.448-1,1-1h10c0.552,0,1,0.447,1,1S49.552,35.293,49,35.293z M49,28.293H34   c-0.552,0-1-0.447-1-1s0.448-1,1-1h15c0.552,0,1,0.447,1,1S49.552,28.293,49,28.293z M49.71,21.003c-0.19,0.18-0.44,0.29-0.71,0.29   c-0.26,0-0.52-0.11-0.71-0.29c-0.18-0.19-0.29-0.45-0.29-0.71c0-0.271,0.11-0.521,0.29-0.71c0.37-0.37,1.05-0.37,1.42,0   c0.18,0.189,0.29,0.45,0.29,0.71S49.89,20.813,49.71,21.003z M50.308,12.293h-3.692c-0.552,0-1-0.447-1-1s0.448-1,1-1h3.692   c0.552,0,1,0.447,1,1S50.86,12.293,50.308,12.293z M57,6.024V3.293H3v2.731C2.403,5.679,2,5.032,2,4.293c0-1.103,0.897-2,2-2h52   c1.103,0,2,0.897,2,2C58,5.032,57.597,5.679,57,6.024z" style="fill: rgb(255, 255, 255);" /> <path d="M13.377,25.461c0.046,0.439,0.272,0.848,0.622,1.12L15,27.36v-3.877c-0.494,0.176-0.944,0.464-1.292,0.875   C13.452,24.66,13.334,25.052,13.377,25.461z" style="fill: rgb(255, 255, 255);" /> <path d="M17,35.326c0.494-0.176,0.944-0.464,1.292-0.875c0.256-0.303,0.374-0.695,0.331-1.105   c-0.046-0.438-0.272-0.847-0.622-1.118L17,31.449V35.326z" style="fill: rgb(255, 255, 255);" /> </svg>
                                    </button>
                                </div>
                                <div ng-if="viewJobsiteList">
                                    <button type="button" class="button-function-4 w34px h34px" ng-class="{ 'white' : item.cntJs == 0 }" ng-click="openlistjobsite(item.id,'lists')">
                                        <svg viewBox="0 0 496 496" class="h17px" xmlns="http://www.w3.org/2000/svg"><path d="m168 424v64h-112v-288h112zm0 0" fill="#ccd1d9"/><path d="m168 168v32h-120c-4.398438 0-8-3.601562-8-8v-16c0-4.398438 3.601562-8 8-8zm0 0" fill="#969faa"/><path d="m407.679688 120h-239.679688v368h272v-368zm0 0" fill="#e6e9ed"/><path d="m152 72h304v48h-304zm0 0" fill="#969faa"/><path d="m88 232h80v48h-80zm0 0" fill="#fcd770"/><path d="m88 328h80v48h-80zm0 0" fill="#fcd770"/><path d="m88 376h80v48h-80zm0 0" fill="#fcd770"/><path d="m88 280h80v48h-80zm0 0" fill="#fcd770"/><path d="m304 344h72v144h-72zm0 0" fill="#d3a06c"/><path d="m232 344h72v144h-72zm0 0" fill="#d3a06c"/><g fill="#ffeaa7"><path d="m256 280h48v32h-48zm0 0"/><path d="m256 248h48v32h-48zm0 0"/><path d="m304 280h48v32h-48zm0 0"/><path d="m208 248h48v32h-48zm0 0"/><path d="m352 280h48v32h-48zm0 0"/><path d="m208 280h48v32h-48zm0 0"/><path d="m304 248h48v32h-48zm0 0"/><path d="m352 248h48v32h-48zm0 0"/></g><path d="m388.960938 52.160156c4.480468 6.160156 8.160156 12.800782 11.039062 19.839844 4.160156 9.921875 6.800781 20.640625 7.601562 31.839844-6.640624-4.878906-14.722656-7.839844-23.601562-7.839844-9.839844 0-18.800781 5.519531-23.121094 14.320312l-1.757812 3.359376c-4.320313 8.800781-13.28125 14.320312-23.121094 14.320312-13.28125 0-24 10.71875-24 24s10.71875 24 24 24c8.800781 0 16 7.199219 16 16 0 3.921875.71875 7.679688 1.839844 11.28125-14.800782 8.078125-31.761719 12.71875-49.839844 12.71875-16.238281 0-31.601562-3.761719-45.359375-10.320312l.078125-.160157c2.960938-2.960937 5.679688-6.160156 8-9.679687 8.640625-12.960938 13.28125-28.160156 13.28125-43.679688v-8.558594c0-8.5625-7.039062-15.601562-15.601562-15.601562-17.917969 0-32.398438-14.480469-32.398438-32.398438 0-4.960937-1.199219-9.921874-3.441406-14.402343l-2.636719-5.4375c-3.042969-6.082031-7.042969-11.441407-11.683594-16.160157 17.921875-30.882812 51.441407-51.601562 89.761719-51.601562 1.601562 0 3.28125 0 4.878906.160156v.078125c-3.039062 5.042969-4.878906 10.882813-4.878906 17.121094 0 13.679687-8.320312 26-20.960938 31.039063l-7.039062 2.800781c-7.28125 2.878906-12 9.921875-12 17.679687 0 10.5625 8.558594 19.121094 19.121094 19.121094h31.359375c12.960937 0 24.71875-7.921875 29.519531-20s16.558594-20 29.519531-20c5.601563 0 10.800781-1.441406 15.441407-3.839844zm0 0" fill="#69d6f4"/><path d="m407.601562 120c-2.640624 36-23.679687 66.878906-53.761718 83.28125-1.121094-3.601562-1.839844-7.359375-1.839844-11.28125 0-8.800781-7.199219-16-16-16-13.28125 0-24-10.71875-24-24s10.71875-24 24-24c9.839844 0 18.800781-5.519531 23.121094-14.320312l1.757812-3.359376c4.320313-8.800781 13.28125-14.320312 23.121094-14.320312 8.878906 0 16.960938 2.960938 23.601562 7.839844.320313 2.71875.398438 5.441406.398438 8.160156s-.078125 5.359375-.320312 8zm0 0" fill="#b4dd7f"/><path d="m308.878906 8.160156c33.121094 1.519532 62.242188 18.558594 80.082032 44-4.640626 2.398438-9.839844 3.839844-15.441407 3.839844-12.960937 0-24.71875 7.921875-29.519531 20s-16.558594 20-29.519531 20h-31.359375c-10.5625 0-19.121094-8.558594-19.121094-19.121094 0-7.757812 4.71875-14.800781 12-17.679687l7.039062-2.800781c12.640626-5.039063 20.960938-17.359376 20.960938-31.039063 0-6.238281 1.839844-12.078125 4.878906-17.121094zm0 0" fill="#b4dd7f"/><path d="m200 112c0-14.160156 2.800781-27.679688 8-40 1.761719-4.320312 3.839844-8.398438 6.238281-12.398438 4.640625 4.71875 8.640625 10.078126 11.683594 16.160157l2.636719 5.4375c2.242187 4.480469 3.441406 9.441406 3.441406 14.402343 0 17.917969 14.480469 32.398438 32.398438 32.398438 8.5625 0 15.601562 7.039062 15.601562 15.601562v8.558594c0 15.519532-4.640625 30.71875-13.28125 43.679688-2.320312 3.519531-5.039062 6.71875-8 9.679687l-.078125.160157c-32.402344-15.757813-55.441406-47.917969-58.242187-85.679688-.320313-2.640625-.398438-5.28125-.398438-8zm0 0" fill="#b4dd7f"/><path d="m480 480h16v16h-16zm0 0"/><path d="m0 480h16v16h-16zm0 0"/><path d="m304 0c-44.566406 0-83.015625 26.222656-101.039062 64h-58.960938v64h16v32h-112c-8.824219 0-16 7.175781-16 16v16c0 8.824219 7.175781 16 16 16v272h-16v16h432v-16h-16v-352h16v-64h-58.960938c-18.023437-37.777344-56.472656-64-101.039062-64zm96 112c0 32.121094-15.910156 60.535156-40.207031 77.96875-1.050781-12.273438-11.257813-21.96875-23.792969-21.96875-8.824219 0-16-7.175781-16-16s7.175781-16 16-16c12.921875 0 24.535156-7.175781 30.3125-18.734375l1.6875-3.378906c3.046875-6.09375 9.175781-9.886719 16-9.886719 5.566406 0 10.953125 1.558594 15.816406 4.398438.046875 1.203124.183594 2.386718.183594 3.601562zm-24.832031-64.199219c-.542969.03125-1.089844.199219-1.632813.199219-16.375 0-30.886718 9.832031-36.96875 25.03125-3.628906 9.097656-12.308594 14.96875-22.101562 14.96875h-31.386719c-6.109375 0-11.078125-4.96875-11.078125-11.078125 0-4.554687 2.734375-8.601563 6.960938-10.289063l7.015624-2.808593c15.816407-6.320313 26.023438-21.398438 26.023438-38.433594 0-3.054687.617188-6.023437 1.742188-8.894531 24.3125 2.457031 45.890624 14.097656 61.425781 31.304687zm-78.039063-31.449219c-.6875 2.976563-1.128906 6-1.128906 9.039063 0 10.449219-6.265625 19.707031-15.960938 23.578125l-7.015624 2.808594c-10.34375 4.132812-17.023438 14.007812-17.023438 25.144531 0 14.925781 12.152344 27.078125 27.078125 27.078125h31.386719c16.375 0 30.886718-9.832031 36.96875-25.03125 3.628906-9.097656 12.308594-14.96875 22.101562-14.96875 4.152344 0 8.25-.710938 12.273438-1.976562 5.246094 8.550781 9.191406 17.96875 11.550781 28.007812-4.320313-1.277344-8.792969-2.03125-13.359375-2.03125-12.921875 0-24.535156 7.175781-30.3125 18.734375l-1.6875 3.378906c-3.046875 6.09375-9.175781 9.886719-16 9.886719-17.648438 0-32 14.351562-32 32s14.351562 32 32 32c4.414062 0 8 3.585938 8 8 0 2.222656.214844 4.511719.601562 6.863281-12.355468 5.800781-26.082031 9.136719-40.601562 9.136719-11.28125 0-22.0625-2.054688-32.128906-5.648438.503906-.6875 1.082031-1.359374 1.542968-2.054687 9.539063-14.304687 14.585938-30.960937 14.585938-48.160156v-8.496094c0-13.039063-10.601562-23.640625-23.640625-23.640625-13.429687 0-24.359375-10.929688-24.359375-24.359375 0-6.214844-1.472656-12.464844-4.257812-18.054687l-2.695313-5.394532c-2.351563-4.695312-5.480469-9.085937-8.957031-13.296875 16.023437-24.03125 42.589844-40.375 73.039062-42.542969zm-81.425781 58.007813c1.066406 1.648437 2.167969 3.28125 3.03125 4.992187l2.691406 5.382813c1.6875 3.378906 2.574219 7.144531 2.574219 10.90625 0 22.253906 18.105469 40.359375 40.359375 40.359375 4.207031 0 7.640625 3.433594 7.640625 7.640625v8.496094c0 14.03125-4.121094 27.617187-11.894531 39.289062-.929688 1.390625-1.96875 2.773438-3.144531 4.175781-29.183594-16.488281-48.960938-47.753906-48.960938-83.601562 0-13.351562 2.753906-26.070312 7.703125-37.640625zm-55.703125 5.640625h36.71875c-3.039062 10.152344-4.71875 20.878906-4.71875 32h-32zm0 192h-64v-32h64zm-64 16h64v32h-64zm0 48h64v32h-64zm0 48h64v32h-64zm-48-208h112v16h-112zm16 32h96v16h-80v208h80v48h-96zm304 272h-56v-128h56zm-72 0h-56v-128h56zm136 0h-48v-144h-160v144h-48v-352h17.28125c7.808594 54.183594 54.40625 96 110.71875 96s102.921875-41.816406 110.71875-96h17.28125zm16-400v32h-32c0-11.121094-1.679688-21.847656-4.71875-32zm0 0"/><path d="m200 240v80h208v-80zm192 32h-32v-16h32zm-96 16v16h-32v-16zm-32-16v-16h32v16zm48 16h32v16h-32zm0-16v-16h32v16zm-64-16v16h-32v-16zm-32 32h32v16h-32zm144 16v-16h32v16zm0 0"/><path d="m328 400h16v16h-16zm0 0"/><path d="m264 400h16v16h-16zm0 0"/></svg>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </li>
        <ion-infinite-scroll on-infinite="LoadMoreCustomer()" ng-if="checkLoadMore" distance="1%"> </ion-infinite-scroll>
    </ul>
</ion-scroll>
