<ion-view class="chat" view-title="Chat" hide-nav-bar="true">
    <ion-content scroll="false">
        <div class="app-main">
            <div class="app-header">
                <div class="chat-header bg-header-1 layout-fixed full-h">
                    <div class="w50px clear pdL10" onclick="appDashboardMenuToggle('show')">
                        <button class="bg-transparent left">
                            <svg class="h22px clr-symbol-clickable" viewBox="0 0 252 252">
                                <rect style="fill: #3C85BE" width="57" height="57" />
                                <rect style="fill: #3C85BE" x="65" width="57" height="57" />
                                <rect style="fill: #3C85BE" x="130" width="57" height="57" />
                                <rect style="fill: #3C85BE" x="195" width="57" height="57" />
                                <rect style="fill: #3C85BE" y="65" width="57" height="57" />
                                <rect style="fill: #3C85BE" x="65" y="65" width="57" height="57" />
                                <rect style="fill: #3C85BE" x="130" y="65" width="57" height="57" />
                                <rect style="fill: #3C85BE" x="195" y="65" width="57" height="57" /> <!---->
                                <rect style="fill: #3C85BE" y="130" width="57" height="57" />
                                <rect style="fill: #3C85BE" x="65" y="130" width="57" height="57" />
                                <rect style="fill: #3C85BE" x="130" y="130" width="57" height="57" />
                                <rect style="fill: #3C85BE" x="195" y="130" width="57" height="57" />
                                <rect style="fill: #3C85BE" y="195" width="57" height="57" />
                                <rect style="fill: #3C85BE" x="65" y="195" width="57" height="57" />
                                <rect style="fill: #3C85BE" x="130" y="195" width="57" height="57" />
                                <rect style="fill: #3C85BE" x="195" y="195" width="57" height="57" />
                            </svg>
                        </button>
                    </div>
                    <div class="clear">
                        <div class="app-title-name left full-w">
                            <div class="text-title-header-1 nowrap mgT2">Chat</div>
                        </div>
                    </div>
                    <div class="w50px clear pdR10" ng-if="isAdmin">
                        <button class="app-exp-inp-icon bg-transparent right biger-3-time" ng-click="showpPopupFile(-1)"></button>
                    </div>
                    <div class="w50px clear pdR10">
                        <button class="app-search-icon bg-transparent right biger-3-time" ng-click="showTarget('#optionChatSearch')"></button>
                    </div>
                </div>
            </div>
            <div class="chat-tab app-tab-switch">
                <div class="tab-link tab-link-2 full-h">
                    <ul class="layout-fixed full-h">
                        <li ng-class="tabChatActive == 'Recent' ? 'active' : ''" ng-click="setTabChat('Recent')">
                            <div class="layout-fixed w-auto-i center full-h">
                                <div class="pdR5">
                                    <button class="icon bg-transparent left full-h w30px">
                                        <svg class="h24px" viewBox="0 0 472.829 472.829"> <path d="M398.065,128.657l13.898-13.896c3.867,1.792,8.597,1.122,11.791-2.073l2.474-2.471c4.087-4.096,4.087-10.741,0-14.832    l-17.807-17.806c-4.099-4.099-10.739-4.099-14.835,0l-2.466,2.471c-4.095,4.095-4.095,10.736,0,14.832l0.551,0.542l-12.868,12.878    C345.882,77.891,303.118,57.83,255.479,53.51V40.678h1.862c9.637,0,17.434-7.805,17.434-17.43v-5.816    C274.775,7.8,266.964,0,257.341,0H215.49c-9.633,0-17.433,7.805-17.433,17.431v5.816c0,9.63,7.805,17.43,17.433,17.43h1.855    v12.767C114.664,62.627,32.405,146.157,26.613,251.12c-6.389,115.691,82.531,214.995,198.224,221.387    c3.939,0.219,7.843,0.322,11.742,0.322c111.415,0,203.498-87.206,209.638-198.551C449.253,219.286,430.73,168.025,398.065,128.657    z M418.25,272.724c-5.511,99.875-90.847,177.325-191.867,171.801C126.122,438.987,49.06,352.922,54.588,252.652    c5.325-96.482,85.117-172.066,181.667-172.066c3.39,0,6.77,0.096,10.202,0.281C346.713,86.402,423.782,172.475,418.25,272.724z     M398.331,260.883h-11.321c0.012-0.326,0.106-0.612,0.106-0.93c-0.014-12.98-10.58-23.539-23.552-23.539H272.24    c-8.315-14.423-23.989-23.836-41.088-23.836c-0.269,0-0.535,0.038-0.803,0.038V92.893    C323.129,92.893,398.331,168.105,398.331,260.883z M373.45,257.339c-0.006,5.262-4.282,9.541-9.535,9.541H263.458    c-4.099,13.778-16.865,23.825-31.969,23.825c-18.431,0-33.364-14.938-33.368-33.366c0-18.424,14.937-33.362,33.368-33.362    c15.104,0,27.871,10.052,31.974,23.839h100.444C369.167,247.815,373.444,252.083,373.45,257.339z" /> </svg>
                                    </button>
                                </div>
                                <div class="text-left">
                                    <div class="text">Recent</div>
                                    <div class="number notification">{{countRecent}}<i class="ion-chatbubbles fz12 mgL3"></i></div>
                                </div>
                            </div>
                        </li>
                        <li ng-class="tabChatActive == 'Contact' ? 'active' : ''" ng-click="setTabChat('Contact')">
                            <div class="layout-fixed w-auto-i center full-h">
                                <div class="pdR5">
                                    <button class="icon bg-transparent left full-h w30px">
                                        <svg class="h24px" viewBox="0 0 55 55"> <path fill="#FFFFFF" d="M55,27.5C55,12.337,42.663,0,27.5,0S0,12.337,0,27.5c0,8.009,3.444,15.228,8.926,20.258l-0.026,0.023l0.892,0.752  c0.058,0.049,0.121,0.089,0.179,0.137c0.474,0.393,0.965,0.766,1.465,1.127c0.162,0.117,0.324,0.234,0.489,0.348  c0.534,0.368,1.082,0.717,1.642,1.048c0.122,0.072,0.245,0.142,0.368,0.212c0.613,0.349,1.239,0.678,1.88,0.98  c0.047,0.022,0.095,0.042,0.142,0.064c2.089,0.971,4.319,1.684,6.651,2.105c0.061,0.011,0.122,0.022,0.184,0.033  c0.724,0.125,1.456,0.225,2.197,0.292c0.09,0.008,0.18,0.013,0.271,0.021C25.998,54.961,26.744,55,27.5,55  c0.749,0,1.488-0.039,2.222-0.098c0.093-0.008,0.186-0.013,0.279-0.021c0.735-0.067,1.461-0.164,2.178-0.287  c0.062-0.011,0.125-0.022,0.187-0.034c2.297-0.412,4.495-1.109,6.557-2.055c0.076-0.035,0.153-0.068,0.229-0.104  c0.617-0.29,1.22-0.603,1.811-0.936c0.147-0.083,0.293-0.167,0.439-0.253c0.538-0.317,1.067-0.648,1.581-1  c0.185-0.126,0.366-0.259,0.549-0.391c0.439-0.316,0.87-0.642,1.289-0.983c0.093-0.075,0.193-0.14,0.284-0.217l0.915-0.764  l-0.027-0.023C51.523,42.802,55,35.55,55,27.5z M2,27.5C2,13.439,13.439,2,27.5,2S53,13.439,53,27.5  c0,7.577-3.325,14.389-8.589,19.063c-0.294-0.203-0.59-0.385-0.893-0.537l-8.467-4.233c-0.76-0.38-1.232-1.144-1.232-1.993v-2.957  c0.196-0.242,0.403-0.516,0.617-0.817c1.096-1.548,1.975-3.27,2.616-5.123c1.267-0.602,2.085-1.864,2.085-3.289v-3.545  c0-0.867-0.318-1.708-0.887-2.369v-4.667c0.052-0.52,0.236-3.448-1.883-5.864C34.524,9.065,31.541,8,27.5,8  s-7.024,1.065-8.867,3.168c-2.119,2.416-1.935,5.346-1.883,5.864v4.667c-0.568,0.661-0.887,1.502-0.887,2.369v3.545  c0,1.101,0.494,2.128,1.34,2.821c0.81,3.173,2.477,5.575,3.093,6.389v2.894c0,0.816-0.445,1.566-1.162,1.958l-7.907,4.313  c-0.252,0.137-0.502,0.297-0.752,0.476C5.276,41.792,2,35.022,2,27.5z" /> </svg>
                                    </button>
                                </div>
                                <div class="text-left">
                                    <div class="text">Contact</div>
                                    <div class="number">{{count_contact}} {{countContact}}</div>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="app-content">
                <div class="app-content-inner content-pd">
                    <ion-scroll class="scroll-area" direction="y" has-bouncing="false" overflow-scroll="false" ng-if="tabChatActive == 'Recent'" delegate-handle="scrollChatRecent">
                        <div class="box-expandable box-setting-4 form-field-container no-saperator">
                            <div class="title">
                                Group
                                <div class="icon-right row-fixed-5 mgB5">
                                    <button class="bg-transparent pd0-i" type="button" onclick="showTarget('#optionChatGroups')" ontouchstart="showTarget('#optionChatGroups')">
                                        <svg class="block h18px clr-symbol-clickable" viewBox="0 0 384 384"><circle r="42.667" cy="42.667" cx="192" /><circle r="42.667" cy="192" cx="192" /><circle r="42.667" cy="341.333" cx="192" /></svg>
                                    </button>
                                </div>
                            </div>
                            <ul class="lst-chat-user group lst-chat-recent content content-in" ng-if="filter.group">
                                <li class="itm row-one-content" ng-repeat="(index, item) in rooms | orderBy:['msg.isread','-item.time'] | filter:{name:search.Text}" ng-class="{'item-expandable' : index > 4}">
                                    <div class="layout-fixed">
                                        <div class="w50px v-top-i">
                                            <div class="thumnail" ng-click="showTarget('#popupEditChatGroup')" onclick="showTarget('#popupEditChatGroup')" ng-click="editRooms(item.id)">
                                                <img src="resources/images/thumnails/group-default.png" ng-if="!item.icon">
                                                <img ng-src="{{item.icon}}" ng-if="item.icon"> <!--Hinh chua bind-->
                                                <!--<button class="unread-counter box-counter-2 orange">3</button>--><!--Neu co tin nhan chua doc-->
                                            </div>
                                        </div>
                                        <div class="v-top-i" ng-click="showTarget('#popupChatDetail') ; chatContent(item.id,true)">
                                            <div class="layout-fixed">
                                                <div class="v-top-i">
                                                    <div class="name clr-black uppercase">{{item.name}}</div>
                                                </div>
                                            </div>
                                            <div class="layout-fixed mgT5">
                                                <div class="v-top-i">
                                                    <div class="text baseline nowrap" ng-class="{'unread-text':item.msg.isread=='0'}" ng-bind-html="replaceHtml(item.msg)"></div>
                                                    <div class="text-date-1 lowercase mgT8">{{formatDate(item,'timestamp')}}</div>
                                                </div>
                                                <div class="w30px clear">
                                                    <button class="app-item-next-icon bg-transparent pd0-i right"></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                <li class="more-overlay no-item-more" onclick="toggleExpand(this)" ng-click="resizeScroll('scrollChatRecent')" ng-if="rooms.length > 5">
                                    <div class="h30px layout-fixed w-auto-i center">
                                        <div class="text-link-1 pdR10"><span class="more-text">Show all</span><span class="less-text">Show less</span></div>
                                        <div>
                                            <button class="more-icon bg-transparent pd0-i relative" type="button">
                                                <svg class="h12px clr-symbol-clickable" style="position: absolute; left: 4px; top: 1px" viewBox="0 0 210 210"> <path fill="#F19338 " d="M25,80C11.215,80,0,91.215,0,105s11.215,25,25,25c13.785,0,25-11.215,25-25S38.785,80,25,80z" /> <path fill="#F19338 " d="M105,80c-13.785,0-25,11.215-25,25s11.215,25,25,25c13.785,0,25-11.215,25-25S118.785,80,105,80z" /> <path fill="#F19338" d="M185,80c-13.785,0-25,11.215-25,25s11.215,25,25,25c13.785,0,25-11.215,25-25S198.785,80,185,80z" /> </svg>
                                                <svg class="h24px" viewBox="0 0 512 512">  <path d="M196.267,375.467H47.787C24.747,375.467,0,359.253,0,332.8V46.933C0,22.187,23.04,0,47.787,0h417.28  C489.813,0,512,22.187,512,46.933v243.2c0,5.12-3.413,8.533-8.533,8.533c-5.12,0-8.533-3.413-8.533-8.533v-243.2  c0-15.36-14.507-29.867-29.867-29.867H47.787c-15.36,0-30.72,14.507-30.72,29.867V332.8c0,15.36,16.213,25.6,30.72,25.6h148.48  c5.12,0,8.533,3.413,8.533,8.533S201.387,375.467,196.267,375.467" style="fill:#1075BB;" /> <path d="M375.467,512L263.68,396.8c-40.107-40.107-40.107-104.96,0-145.067l0,0  c40.107-40.107,104.96-40.107,145.067,0L512,349.867V512H375.467z" style="fill:#FDC794;" /> <path d="M288.427,372.907l35.84,35.84c4.267,4.267,9.387,5.973,15.36,5.973l0,0  c46.933-3.413,83.627-40.107,87.04-87.04l0,0c0-5.973-1.707-11.093-5.973-15.36l-35.84-35.84c-26.453-26.453-69.973-26.453-96.427,0  l0,0C261.12,302.933,261.12,345.6,288.427,372.907" style="fill:#FFF;" /> <path d="M366.933,354.133c-16.213,16.213-24.747,40.96-34.987,58.88c2.56,0.853,5.12,1.707,8.533,0.853  c46.933-3.413,83.627-40.107,87.04-87.04c0-2.56,0-4.267-0.853-6.827h-0.853C407.04,331.093,383.147,337.067,366.933,354.133" style="fill:#FFFFFF;" /> <path d="M418.133,477.867c-2.56,0-4.267-0.853-5.973-2.56c-3.413-3.413-3.413-8.533,0-11.947l55.467-55.467  c3.413-3.413,8.533-3.413,11.947,0c3.413,3.413,3.413,8.533,0,11.947l-55.467,55.467C422.4,477.013,420.693,477.867,418.133,477.867  " style="fill:#F9A671;" /> </svg>
                                            </button>
                                            <button class="less-icon bg-transparent pd0-i relative" type="button">
                                                <svg class="h16px clr-symbol-clickable" viewBox="0 0 407.437 407.437"> <polygon points="203.718,84.507 386.258,266.453 407.437,245.205 203.718,42.15 0,245.205 21.179,266.453  " /> <polygon points="0,344.039 21.179,365.287 203.718,183.341 386.258,365.287 407.437,344.039 203.718,140.984  " /> </svg>
                                            </button>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                        <div class="box-setting-4 form-field-container">
                            <div class="title">
                                Person
                                <div class="icon-right row-fixed-5 mgB5">
                                    <button class="bg-transparent pd0-i" type="button" ng-click="showTarget('#optionChatPersons')">
                                        <svg class="block h18px clr-symbol-clickable" viewBox="0 0 384 384"><circle r="42.667" cy="42.667" cx="192" /><circle r="42.667" cy="192" cx="192" /><circle r="42.667" cy="341.333" cx="192" /></svg>
                                    </button>
                                </div>
                            </div>
                            <ul class="lst-chat-user person lst-chat-recent content content-in" ng-if="filter.person">
                                <li class="itm row-one-content" ng-hide="item.userhide=='1'" ng-class="{online:item.status,idle:item.idle,offline:!item.status}" ng-repeat="item in users|orderBy:['msg.isread','-item.time']| filter:filterUser | filter:{nick_name:search.Text,is_active_user:'1'}" ng-if="item.msg.contents">
                                    <div class="layout-fixed">
                                        <div class="w50px v-top-i">
                                            <div class="thumnail" ng-click="showpPopupPersion(item)">
                                                <img ng-src="{{item.image_pic || 'resources/images/thumnails/profile-default.png'}}">
                                            </div>
                                        </div>
                                        <div class="v-top-i" ng-click="showTarget('#popupChatDetail') ; chatContent(item.id,false)">
                                            <div class="layout-fixed">
                                                <div class="v-top-i">
                                                    <div class="name clr-black capitalize">{{item.display_name}}</div>
                                                </div>
                                                <div class="w110px v-top-i text-right">
                                                    <div class="text-date-1 lowercase">{{formatDate(item,'timestamp')}}</div>
                                                </div>
                                            </div>
                                            <div class="layout-fixed mgT10">
                                                <div>
                                                    <div class="text baseline nowrap" ng-class="{'unread-text':item.msg.isread=='0'}" ng-bind-html="item.msg.contents"></div>
                                                </div>
                                                <div class="w30px clear">
                                                    <button class="app-item-next-icon bg-transparent pd0-i right"></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </ion-scroll>
                    <ion-scroll class="scroll-area" direction="y" has-bouncing="false" overflow-scroll="false" ng-if="tabChatActive == 'Contact'" delegate-handle="scrollChatContact">
                        <div class="box-setting-4 form-field-container except-app-tab-switch">
                            <ul class="lst-chat-user lst-chat-contact content content-in">
                                <li class="itm row-one-content" ng-hide="item.userhide=='1'" ng-class="{online:item.status,idle:item.idle,offline:!item.status}" ng-repeat="item in users |  filter:{is_active_user:'1'}">
                                    <div class="layout-fixed">
                                        <div class="w50px v-top-i">
                                            <div class="thumnail" ng-click="showpPopupPersion(item)">
                                                <img ng-src="{{ item.image_pic || resources/images/thumnails/profile-default.png}}" />
                                            </div>
                                        </div>
                                        <div ng-click="showTarget('#popupChatDetail') ; chatContent(item.id,false)">
                                            <div class="layout-fixed">
                                                <div class="v-top-i">
                                                    <div class="name clr-black capitalize">{{item.display_name}}</div>
                                                </div>
                                            </div>
                                            <div class="layout-fixed mgT8">
                                                <div class="text-name-2 nowrap">{{item.title}}</div>
                                            </div>
                                        </div>
                                        <div class="w30px clear">
                                            <button class="app-item-next-icon bg-transparent pd0-i right"></button>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </ion-scroll>
                </div>
            </div>
        </div>
        <div class="app-content-popup-area">
            <div id="optionChatStatus" class="app-confirm-popup">
                <div class="overlay-area" ng-click="closeTarget('#optionChatStatus')"></div>
                <div class="content-area popup-2">
                    <div class="title">
                        <div class="icon">
                            <svg class="h20px" viewBox="0 0 60 60"> <path d="M14,36C8.486,36,4,40.486,4,46s4.486,10,10,10s10-4.486,10-10S19.514,36,14,36z M14,54c-4.411,0-8-3.589-8-8s3.589-8,8-8   s8,3.589,8,8S18.411,54,14,54z" /> <path d="M46,32H14C6.28,32,0,38.28,0,46s6.28,14,14,14h32c7.72,0,14-6.28,14-14S53.72,32,46,32z M46,58H14C7.383,58,2,52.617,2,46   s5.383-12,12-12h32c6.617,0,12,5.383,12,12S52.617,58,46,58z" /> <path d="M14,28h32c7.72,0,14-6.28,14-14S53.72,0,46,0H14C6.28,0,0,6.28,0,14S6.28,28,14,28z M46,4c5.514,0,10,4.486,10,10   s-4.486,10-10,10s-10-4.486-10-10S40.486,4,46,4z" /> </svg>
                        </div>
                        Chat change status
                    </div>
                    <div class="content row-fixed-15 pdB0-i">
                        <ul class="list-item-03" ng-click="closeTarget('#optionChatStatus')">
                            <li ng-repeat="item in chatstatuses" ng-if="item.id=='2'||item.id=='1'" ng-click="changeStatus(item)">
                                <div class="layout-fixed">
                                    <div class="name-area text-link-1">
                                        {{item.name}}
                                    </div>
                                    <div class="w60px clear">
                                        <div class="chat-status-icon {{item.clazz}} relative-i right"></div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div id="optionChatSearch" class="app-confirm-popup">
                <div class="overlay-area" ng-click="closeTarget('#optionChatSearch')"></div>
                <div class="content-area popup-2">
                    <div class="title">
                        <div class="icon">
                            <svg class="h20px" viewBox="0 0 60 60"> <path d="M14,36C8.486,36,4,40.486,4,46s4.486,10,10,10s10-4.486,10-10S19.514,36,14,36z M14,54c-4.411,0-8-3.589-8-8s3.589-8,8-8   s8,3.589,8,8S18.411,54,14,54z" /> <path d="M46,32H14C6.28,32,0,38.28,0,46s6.28,14,14,14h32c7.72,0,14-6.28,14-14S53.72,32,46,32z M46,58H14C7.383,58,2,52.617,2,46   s5.383-12,12-12h32c6.617,0,12,5.383,12,12S52.617,58,46,58z" /> <path d="M14,28h32c7.72,0,14-6.28,14-14S53.72,0,46,0H14C6.28,0,0,6.28,0,14S6.28,28,14,28z M46,4c5.514,0,10,4.486,10,10   s-4.486,10-10,10s-10-4.486-10-10S40.486,4,46,4z" /> </svg>
                        </div>
                        Chat search option
                    </div>
                    <div class="content row-fixed-15 pdB0-i">
                        <ul class="list-item-03" ng-click="closeTarget('#optionChatSearch')">
                            <li ng-click="searchContact()">
                                <div class="layout-fixed">
                                    <div class="icon-area">
                                        <svg class="h15px" viewBox="0 0 43.028 43.028"><path d="M39.561,33.971l-0.145,0.174c-4.774,5.728-11.133,8.884-17.902,8.884c-6.77,0-13.128-3.155-17.903-8.884l-0.144-0.174   l0.034-0.223c0.922-6.014,4.064-10.845,8.847-13.606l0.34-0.196l0.271,0.284c2.259,2.37,5.297,3.674,8.554,3.674   s6.295-1.305,8.554-3.674l0.271-0.284l0.34,0.196c4.783,2.761,7.925,7.592,8.848,13.606L39.561,33.971z M21.514,21.489   c5.924,0,10.744-4.82,10.744-10.744C32.258,4.821,27.438,0,21.514,0S10.77,4.821,10.77,10.744S15.59,21.489,21.514,21.489z" fill="#b1c7d7" /></svg>
                                    </div>
                                    <input ion-autocomplete
                                           type="text"
                                           id="searchContact"
                                           readonly="readonly"
                                           class="ion-autocomplete-tags-input"
                                           placeholder="Find"
                                           items-method="filterContact(query)"
                                           ng-model="autocompleteList.tagsInputUser"
                                           max-selected-items="1"
                                           autocomplete="off"
                                           item-view-value-key="display_name"
                                           items-method-value-key="items"
                                           items-clicked-method="onSelectUserSearchContact(callback)"
                                           style="display: none"
                                           manage-externally="true"
                                           external-model="initialSearchUser"
                                           model-to-item-method="setValueForInputSearchUser(modelValue)">
                                    <div class="name-area text-link-1">
                                        Search contact
                                    </div>
                                </div>
                            </li>
                            <li ng-click="showSearchMessage()" ng-if="showButtonSearchMessege">
                                <div class="layout-fixed">
                                    <div class="icon-area">
                                        <svg class="h15px" viewBox="0 0 60.731 60.73"> <g> <g> <path fill="#FFFFFF" d="M14.882,0.77v16.388H0v30.109h6.693v12.694l11.31-12.694h21.579V35.561h0.405l12.937,14.517V35.561h7.808V0.77H14.882z     M58.482,33.307h-7.811v10.862l-9.681-10.862h-23.86V3.016h41.351V33.307z" /> </g> </g> </svg>
                                    </div>
                                    <div class="name-area text-link-1">
                                        Search message
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <form id="popupChatSearchChat" name="popupChatSearchChat" compile-html="dataChatHtml.popupChatSearchChat" class="app-content-popup" ng-submit="beforeSearch()" novalidate></form>
            <div id="popupChatSearchChatResult" compile-html="dataChatHtml.popupChatSearchChatResult" class="app-content-popup"></div>
            <div id="popupChatSearchChatResultList" compile-html="dataChatHtml.popupChatSearchChatResultList" class="app-content-popup"></div>
            <div id="popupChatFilter" compile-html="dataChatHtml.popupChatFilter" class="app-content-popup"></div>
            <div id="optionChatGroups" class="app-confirm-popup">
                <div class="overlay-area" ng-click="closeTarget('#optionChatGroups')"></div>
                <div class="content-area popup-2">
                    <div class="title">
                        <div class="icon">
                            <svg class="h20px" viewBox="0 0 60 60"> <path d="M14,36C8.486,36,4,40.486,4,46s4.486,10,10,10s10-4.486,10-10S19.514,36,14,36z M14,54c-4.411,0-8-3.589-8-8s3.589-8,8-8   s8,3.589,8,8S18.411,54,14,54z" /> <path d="M46,32H14C6.28,32,0,38.28,0,46s6.28,14,14,14h32c7.72,0,14-6.28,14-14S53.72,32,46,32z M46,58H14C7.383,58,2,52.617,2,46   s5.383-12,12-12h32c6.617,0,12,5.383,12,12S52.617,58,46,58z" /> <path d="M14,28h32c7.72,0,14-6.28,14-14S53.72,0,46,0H14C6.28,0,0,6.28,0,14S6.28,28,14,28z M46,4c5.514,0,10,4.486,10,10   s-4.486,10-10,10s-10-4.486-10-10S40.486,4,46,4z" /> </svg>
                        </div>
                        Groups option
                    </div>
                    <div class="content row-fixed-15 pdB0-i">
                        <ul class="list-item-03" ng-click="closeTarget('#optionChatGroups')">
                            <li ng-click="buildingDataRoom()">
                                <div class="layout-fixed">
                                    <div class="icon-area">
                                        <svg class="h17px" viewBox="0 0 513.321 513.321"> <path d="M269.493,295.159c32.082-23.527,51.332-62.026,51.332-102.664c0-70.581-57.749-128.33-128.33-128.33     s-128.33,57.749-128.33,128.33c0,40.638,19.249,79.137,51.332,102.664C53.471,322.963,8.555,380.712,0,449.155h42.777     c10.694-72.72,74.859-128.33,149.718-128.33s139.024,55.61,149.718,128.33h42.777     C376.435,380.712,331.519,322.964,269.493,295.159L269.493,295.159z M192.495,278.048c-47.055,0-85.553-38.499-85.553-85.553     s38.499-85.553,85.553-85.553s85.553,38.499,85.553,85.553S239.55,278.048,192.495,278.048L192.495,278.048z" /> <path d="M442.739,290.881c17.11-21.388,27.805-49.193,27.805-76.998c0-76.998-68.443-136.885-143.302-128.33     c6.416,6.416,10.694,14.972,14.972,23.527c4.278,6.416,6.416,12.833,8.555,19.249c49.193,8.555,76.998,44.916,76.998,85.553     c0,27.805-14.972,53.471-34.221,68.443c-6.416,4.278-8.555,10.694-8.555,17.11c0,10.694,6.416,19.249,17.11,21.388     c38.499,8.555,68.443,42.777,68.443,83.414h42.777C513.32,357.185,485.515,312.27,442.739,290.881L442.739,290.881z" /> </svg>
                                    </div>
                                    <div class="name-area text-link-1">
                                        Add new group
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <form id="popupAddChatGroup" compile-html="dataChatHtml.popupAddChatGroup" name="formAddRooms" ng-submit="createRooms(formAddRooms)" novalidate="" class="app-content-popup"></form>
            <form id="popupEditChatGroup" compile-html="dataChatHtml.popupEditChatGroup" class="app-content-popup" name="formEditRooms" ng-submit="updateRooms(formEditRooms)" novalidate=""></form>
            <div id="optionChatPersons" class="app-confirm-popup">
                <div class="overlay-area" ng-click="closeTarget('#optionChatPersons')"></div>
                <div class="content-area popup-2">
                    <div class="title">
                        <div class="icon">
                            <svg class="h20px" viewBox="0 0 60 60"> <path d="M14,36C8.486,36,4,40.486,4,46s4.486,10,10,10s10-4.486,10-10S19.514,36,14,36z M14,54c-4.411,0-8-3.589-8-8s3.589-8,8-8   s8,3.589,8,8S18.411,54,14,54z" /> <path d="M46,32H14C6.28,32,0,38.28,0,46s6.28,14,14,14h32c7.72,0,14-6.28,14-14S53.72,32,46,32z M46,58H14C7.383,58,2,52.617,2,46   s5.383-12,12-12h32c6.617,0,12,5.383,12,12S52.617,58,46,58z" /> <path d="M14,28h32c7.72,0,14-6.28,14-14S53.72,0,46,0H14C6.28,0,0,6.28,0,14S6.28,28,14,28z M46,4c5.514,0,10,4.486,10,10   s-4.486,10-10,10s-10-4.486-10-10S40.486,4,46,4z" /> </svg>
                        </div>
                        Persons option
                    </div>
                    <div class="content row-fixed-15 pdB0-i">
                        <ul class="list-item-03">
                            <li>
                                <div class="layout-fixed">
                                    <div class="icon-area">
                                        <svg class="h15px" viewBox="0 0 379.561 379.561"><path d="M320.838,121.929c-7.321-5.677-15.604-11.61-24.664-17.362L341.498,58.6c6.204-6.292,6.133-16.423-0.16-22.627  c-6.292-6.204-16.422-6.134-22.626,0.159L267.12,88.456c-23.253-11.018-49.587-18.963-77.192-18.963l-0.991,0.003  c-52.262,0.369-99.981,29.932-130.81,54.667C27.632,148.631-0.073,180.32,0,190.649c0.082,11.702,26.981,42.234,58.737,66.671  c6.646,5.114,15.073,11.145,24.875,17.249L37.87,320.962c-6.204,6.292-6.133,16.423,0.16,22.627  c3.117,3.074,7.175,4.607,11.233,4.607c4.132,0,8.263-1.591,11.394-4.766l52.21-52.951c22.666,10.535,49.101,18.651,76.752,18.651  l1.007-0.003c55.525-0.392,105.776-33.566,130.788-53.307c31.603-24.942,58.231-56.011,58.148-67.845  C379.484,176.988,352.043,146.126,320.838,121.929z M111.314,189.864c-0.305-43.336,34.578-78.714,77.913-79.019  c15.975-0.113,30.86,4.569,43.314,12.681l-107.938,109.47C116.318,220.657,111.427,205.839,111.314,189.864z M190.334,267.777  c-15.784,0.111-30.5-4.462-42.863-12.396l107.777-109.308c8.107,12.25,12.887,26.9,12.999,42.684  C268.552,232.094,233.669,267.472,190.334,267.777z" /></svg>
                                    </div>
                                    <div class="name-area text-link-1">
                                        Hide all person
                                    </div>
                                    <div class="w60px clear">
                                        <div class="checkedbox-toggle-1 block-i right">
                                            <input ng-change="hideAllContact(userhideall)" ng-model="userhideall" type="checkbox" ng-checked="userhideall"><i></i><span></span>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div id="optionChatPerson" class="app-confirm-popup">
                <div class="overlay-area" ng-click="closeTarget('#optionChatPerson')"></div>
                <div class="content-area popup-2">
                    <div class="title">
                        <div class="icon">
                            <svg class="h20px" viewBox="0 0 60 60"> <path d="M14,36C8.486,36,4,40.486,4,46s4.486,10,10,10s10-4.486,10-10S19.514,36,14,36z M14,54c-4.411,0-8-3.589-8-8s3.589-8,8-8   s8,3.589,8,8S18.411,54,14,54z" /> <path d="M46,32H14C6.28,32,0,38.28,0,46s6.28,14,14,14h32c7.72,0,14-6.28,14-14S53.72,32,46,32z M46,58H14C7.383,58,2,52.617,2,46   s5.383-12,12-12h32c6.617,0,12,5.383,12,12S52.617,58,46,58z" /> <path d="M14,28h32c7.72,0,14-6.28,14-14S53.72,0,46,0H14C6.28,0,0,6.28,0,14S6.28,28,14,28z M46,4c5.514,0,10,4.486,10,10   s-4.486,10-10,10s-10-4.486-10-10S40.486,4,46,4z" /> </svg>
                        </div>
                        {{userhide.name}} option
                    </div>
                    <div class="content row-fixed-15 pdB0-i">
                        <ul class="list-item-03">
                            <li>
                                <div class="layout-fixed">
                                    <div class="icon-area">
                                        <svg class="h15px" viewBox="0 0 379.561 379.561"><path d="M320.838,121.929c-7.321-5.677-15.604-11.61-24.664-17.362L341.498,58.6c6.204-6.292,6.133-16.423-0.16-22.627  c-6.292-6.204-16.422-6.134-22.626,0.159L267.12,88.456c-23.253-11.018-49.587-18.963-77.192-18.963l-0.991,0.003  c-52.262,0.369-99.981,29.932-130.81,54.667C27.632,148.631-0.073,180.32,0,190.649c0.082,11.702,26.981,42.234,58.737,66.671  c6.646,5.114,15.073,11.145,24.875,17.249L37.87,320.962c-6.204,6.292-6.133,16.423,0.16,22.627  c3.117,3.074,7.175,4.607,11.233,4.607c4.132,0,8.263-1.591,11.394-4.766l52.21-52.951c22.666,10.535,49.101,18.651,76.752,18.651  l1.007-0.003c55.525-0.392,105.776-33.566,130.788-53.307c31.603-24.942,58.231-56.011,58.148-67.845  C379.484,176.988,352.043,146.126,320.838,121.929z M111.314,189.864c-0.305-43.336,34.578-78.714,77.913-79.019  c15.975-0.113,30.86,4.569,43.314,12.681l-107.938,109.47C116.318,220.657,111.427,205.839,111.314,189.864z M190.334,267.777  c-15.784,0.111-30.5-4.462-42.863-12.396l107.777-109.308c8.107,12.25,12.887,26.9,12.999,42.684  C268.552,232.094,233.669,267.472,190.334,267.777z" /></svg>
                                    </div>
                                    <div class="name-area text-link-1">
                                        Hide
                                    </div>
                                    <div class="w60px clear">
                                        <div class="checkedbox-toggle-1 block-i right">
                                            <input type="checkbox" ng-model="userhide.status" ng-checked="userhide.status" ng-change="hideContact(userhide.status)"><i></i><span></span>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li ng-click="openPopupFileAlbumChat()">
                                <div class="layout-fixed">
                                    <div class="icon-area">
                                        <svg class="h15px" viewBox="0 0 502.69 502.69"><path fill="#FFFFFF" d="M486.896,253.06H138.312c-13.352,0-29.077,9.772-34.966,21.743L9.621,464.713c-5.889,11.972,0.194,21.743,13.503,21.743     h348.605c13.352,0,29.077-9.772,34.966-21.743l93.747-189.909C506.331,262.832,500.248,253.06,486.896,253.06z" /><path fill="#FFFFFF" d="M138.312,228.771h258.785v-0.906h33.629V16.234H120.02v37.9H62.598v87.124H30.631C13.805,141.259,0,155.085,0,171.868     V429.38l81.624-165.318C91.503,243.957,115.921,228.771,138.312,228.771z M89.627,81.119c4.379,0,15.337,0,30.393,0v119.718     c-15.056,0-26.014,0-30.393,0C89.627,180.841,89.627,101.18,89.627,81.119z M403.74,43.241c0,21.398,0,136.219,0,157.596     c-6.73,0-29.272,0-58.22,0c-16.588,0-127.57,0-198.451,0c0-21.377,0-136.198,0-157.596     C170.323,43.241,380.444,43.241,403.74,43.241z" /></svg>
                                    </div>
                                    <div class="name-area text-link-1">
                                        File shared
                                    </div>
                                </div>
                            </li>
                            <li ng-click="showpPopupSetting()">
                                <div class="layout-fixed">
                                    <div class="icon-area">
                                        <svg class="h17px" viewBox="0 0 60 60"><path style="fill:#FFF;" d="M55,31h4c0.553,0,1-0.447,1-1s-0.447-1-1-1h-4c-0.007,0-0.013,0.004-0.021,0.004c-0.059-1.506-0.249-3.014-0.586-4.507  c0.005-0.001,0.009,0,0.014-0.002l3.863-1.035c0.533-0.143,0.85-0.691,0.707-1.225s-0.689-0.848-1.225-0.707l-3.863,1.035  c-0.008,0.002-0.013,0.008-0.02,0.01c-0.445-1.427-1.024-2.832-1.742-4.198c0.007-0.004,0.016-0.005,0.023-0.01l3.464-2  c0.479-0.276,0.643-0.888,0.366-1.366c-0.277-0.479-0.891-0.644-1.366-0.366l-3.464,2c-0.01,0.006-0.016,0.016-0.026,0.023  c-0.824-1.306-1.748-2.513-2.761-3.613c0.006-0.006,0.015-0.008,0.021-0.014l2.828-2.828c0.391-0.391,0.391-1.023,0-1.414  s-1.023-0.391-1.414,0l-2.828,2.828c-0.007,0.007-0.009,0.016-0.015,0.023c-1.125-1.039-2.33-1.965-3.604-2.769  c0.004-0.007,0.011-0.012,0.015-0.02l2-3.464C45.643,4.907,45.479,4.296,45,4.02c-0.478-0.276-1.09-0.114-1.366,0.366l-2,3.464  c-0.005,0.009-0.005,0.019-0.009,0.028c-1.348-0.707-2.754-1.289-4.201-1.739c0.003-0.01,0.01-0.018,0.013-0.028l1.035-3.863  c0.143-0.533-0.174-1.082-0.707-1.225c-0.53-0.141-1.082,0.174-1.225,0.707l-1.035,3.863c-0.003,0.011,0,0.022-0.002,0.033  c-1.408-0.318-2.843-0.519-4.291-0.59C31.144,4.984,31.074,4.938,31,4.895V1c0-0.553-0.447-1-1-1s-1,0.447-1,1v3.895  c-0.073,0.042-0.142,0.088-0.209,0.139c-1.435,0.068-2.871,0.265-4.294,0.586c-0.002-0.009,0.001-0.018-0.002-0.027L23.46,1.729  c-0.142-0.534-0.689-0.849-1.225-0.707c-0.533,0.143-0.85,0.691-0.707,1.225l1.035,3.863c0.002,0.009,0.009,0.016,0.011,0.025  c-1.427,0.446-2.831,1.027-4.198,1.746c-0.005-0.01-0.005-0.022-0.011-0.032l-2-3.464C16.089,3.905,15.476,3.743,15,4.02  c-0.479,0.276-0.643,0.888-0.366,1.366l2,3.464c0.004,0.008,0.011,0.013,0.016,0.02c-1.306,0.824-2.509,1.751-3.608,2.764  c-0.005-0.006-0.007-0.013-0.012-0.019l-2.828-2.828c-0.391-0.391-1.023-0.391-1.414,0s-0.391,1.023,0,1.414l2.828,2.828  c0.003,0.003,0.008,0.004,0.011,0.008c-1.039,1.125-1.958,2.336-2.761,3.611c-0.006-0.004-0.009-0.01-0.016-0.014l-3.464-2  C4.908,14.356,4.296,14.521,4.02,15c-0.276,0.479-0.112,1.09,0.366,1.366l3.464,2c0.007,0.004,0.015,0.005,0.022,0.009  c-0.706,1.348-1.289,2.753-1.739,4.199c-0.008-0.002-0.014-0.009-0.022-0.011l-3.863-1.035c-0.531-0.14-1.082,0.174-1.225,0.707  s0.174,1.082,0.707,1.225l3.863,1.035c0.008,0.002,0.016,0.001,0.024,0.003c-0.334,1.478-0.531,2.986-0.594,4.506  C5.015,29.004,5.008,29,5,29H1c-0.553,0-1,0.447-1,1s0.447,1,1,1h4c0.007,0,0.013-0.004,0.021-0.004  c0.059,1.506,0.249,3.015,0.586,4.508c-0.005,0.001-0.009,0-0.014,0.001L1.729,36.54c-0.533,0.143-0.85,0.691-0.707,1.225  c0.119,0.447,0.523,0.741,0.965,0.741c0.086,0,0.173-0.011,0.26-0.034l3.863-1.035c0.008-0.002,0.013-0.008,0.02-0.01  c0.445,1.427,1.024,2.833,1.743,4.199c-0.008,0.004-0.016,0.004-0.024,0.008l-3.464,2C3.907,43.91,3.743,44.521,4.02,45  c0.186,0.321,0.521,0.5,0.867,0.5c0.17,0,0.342-0.043,0.499-0.134l3.464-2c0.01-0.006,0.016-0.016,0.026-0.023  c0.824,1.306,1.748,2.513,2.761,3.613c-0.006,0.006-0.015,0.008-0.021,0.014l-2.828,2.828c-0.391,0.391-0.391,1.023,0,1.414  c0.195,0.195,0.451,0.293,0.707,0.293s0.512-0.098,0.707-0.293l2.828-2.828c0.007-0.007,0.009-0.016,0.015-0.023  c1.125,1.039,2.331,1.966,3.606,2.77c-0.005,0.008-0.012,0.011-0.016,0.019l-2,3.464c-0.276,0.479-0.112,1.09,0.366,1.366  c0.157,0.091,0.329,0.134,0.499,0.134c0.346,0,0.682-0.179,0.867-0.5l2-3.464c0.005-0.009,0.005-0.019,0.01-0.028  c1.349,0.707,2.754,1.29,4.202,1.739c-0.003,0.01-0.011,0.018-0.014,0.028l-1.035,3.863c-0.143,0.533,0.174,1.082,0.707,1.225  c0.087,0.023,0.174,0.034,0.26,0.034c0.441,0,0.846-0.294,0.965-0.741l1.035-3.863c0.003-0.011,0-0.022,0.002-0.033  c1.479,0.334,2.987,0.535,4.509,0.597C29.005,54.981,29,54.99,29,55v4c0,0.553,0.447,1,1,1s1-0.447,1-1v-4  c0-0.01-0.005-0.018-0.005-0.027c1.506-0.059,3.014-0.255,4.509-0.593c0.002,0.009-0.001,0.018,0.002,0.027l1.035,3.863  c0.119,0.447,0.523,0.741,0.965,0.741c0.086,0,0.173-0.011,0.26-0.034c0.533-0.143,0.85-0.691,0.707-1.225l-1.035-3.863  c-0.002-0.009-0.01-0.015-0.012-0.024c1.428-0.446,2.832-1.027,4.199-1.747c0.005,0.01,0.005,0.022,0.011,0.032l2,3.464  c0.186,0.321,0.521,0.5,0.867,0.5c0.17,0,0.342-0.043,0.499-0.134c0.479-0.276,0.643-0.888,0.366-1.366l-2-3.464  c-0.004-0.008-0.012-0.012-0.017-0.019c1.306-0.824,2.51-1.752,3.609-2.765c0.005,0.006,0.007,0.013,0.012,0.019l2.828,2.828  c0.195,0.195,0.451,0.293,0.707,0.293s0.512-0.098,0.707-0.293c0.391-0.391,0.391-1.023,0-1.414l-2.828-2.828  c-0.003-0.003-0.008-0.004-0.011-0.008c1.039-1.125,1.958-2.336,2.761-3.611c0.006,0.004,0.009,0.01,0.016,0.014l3.464,2  c0.157,0.091,0.329,0.134,0.499,0.134c0.346,0,0.682-0.179,0.867-0.5c0.276-0.479,0.112-1.09-0.366-1.366l-3.464-2  c-0.007-0.004-0.015-0.004-0.022-0.008c0.707-1.348,1.29-2.754,1.74-4.201c0.008,0.002,0.014,0.009,0.022,0.011l3.863,1.035  c0.087,0.023,0.174,0.034,0.26,0.034c0.441,0,0.846-0.294,0.965-0.741c0.143-0.533-0.174-1.082-0.707-1.225l-3.863-1.035  c-0.008-0.002-0.016,0-0.025-0.001c0.334-1.478,0.532-2.987,0.594-4.508C54.985,30.996,54.992,31,55,31z M48.187,19.5  c3.521,6.098,3.608,13.239,0.895,19.207l-9.421-5.44c-0.063-0.036-0.129-0.058-0.193-0.087c0.066-0.196,0.136-0.39,0.19-0.592  c0.692-2.579,0.338-5.273-0.998-7.587c-1.444-2.5-3.905-4.212-6.681-4.779C31.986,20.148,32,20.076,32,20V9.105  C38.706,9.758,44.785,13.609,48.187,19.5z M29.996,24c2.139,0,4.131,1.149,5.199,3c0.801,1.388,1.014,3.005,0.6,4.553  c-0.415,1.548-1.407,2.842-2.795,3.643C32.088,35.722,31.052,36,30.004,36c-2.139,0-4.131-1.149-5.199-3  c-0.801-1.388-1.014-3.005-0.6-4.553c0.415-1.548,1.407-2.842,2.795-3.643C27.912,24.278,28.948,24,29.996,24z M19.5,11.813  c2.616-1.51,5.522-2.426,8.5-2.712V20c0,0.075,0.014,0.147,0.022,0.22c-1.055,0.214-2.079,0.579-3.021,1.123  c-2.313,1.334-3.967,3.49-4.658,6.07c-0.518,1.929-0.449,3.923,0.177,5.774c-0.06,0.027-0.122,0.047-0.18,0.081l-9.44,5.45  C6.455,28.993,10.057,17.266,19.5,11.813z M40.5,48.187c-3.193,1.843-6.815,2.818-10.477,2.818c-6.819,0-13.203-3.342-17.117-8.826  l9.434-5.447c0.066-0.038,0.121-0.086,0.181-0.13C24.401,38.724,27.118,40,30.01,40h0.001c1.743,0,3.468-0.465,4.988-1.342  c0.953-0.55,1.786-1.245,2.494-2.046c0.056,0.04,0.106,0.085,0.167,0.12l9.425,5.442C45.393,44.557,43.192,46.632,40.5,48.187z" /></svg>
                                    </div>
                                    <div class="name-area text-link-1">
                                        Message setting
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div id="popupChatDetailSetting" compile-html="dataChatHtml.popupChatDetailSetting" class="app-content-popup"></div>
            <div id="popupChatDetail" compile-html="dataChatHtml.popupChatDetail" class="app-content-popup"></div>
            <div id="optionChatDetail" class="app-confirm-popup" ng-include="'templates/dashboard/chat/popup/optionChatDetail.tpl'"></div>
            <div id="popupChatDetailFile" compile-html="dataChatHtml.popupChatDetailFile" class="app-content-popup"></div>
            <div id="popupFileViewerChat" class="app-content-popup">
                <div class="file-area box-file-viewer-1" on-swipe-left="" on-swipe-right="">
                    <div class="itm" ng-repeat="itm in filesViewer">
                        <div class="description layout-fixed h50px pdL10 pdR5">
                            <div class="w40px clear" ng-click="closeTarget('#popupFileViewerChat'); fileViewerCloseFile('#popupFileViewerChat')">
                                <button type="button" class="popup-back-button bg-transparent pd0-i biger-3-time block-i">
                                    <svg class="block h14px" viewBox="0 0 64 64"> <g> <path d="M28.941,31.786L0.613,60.114c-0.787,0.787-0.787,2.062,0,2.849c0.393,0.394,0.909,0.59,1.424,0.59   c0.516,0,1.031-0.196,1.424-0.59l28.541-28.541l28.541,28.541c0.394,0.394,0.909,0.59,1.424,0.59c0.515,0,1.031-0.196,1.424-0.59   c0.787-0.787,0.787-2.062,0-2.849L35.064,31.786L63.41,3.438c0.787-0.787,0.787-2.062,0-2.849c-0.787-0.786-2.062-0.786-2.848,0   L32.003,29.15L3.441,0.59c-0.787-0.786-2.061-0.786-2.848,0c-0.787,0.787-0.787,2.062,0,2.849L28.941,31.786z" fill="#FFF" /> </g> </svg>
                                </button>
                            </div>
                            <div>
                                <div class="text-name-3">{{itm.name}}</div>
                                <!--<div class="text-date-1 lh1_4-i mgT10">{{itm.url}}</div>-->
                            </div>
                            <div class="w40px clear" ng-click="showTarget('#optionFileDetailChat')">
                                <button class="bg-transparent right">
                                    <svg class="h20px" viewBox="0 0 58 58"> <circle r="7" cy="8" cx="29" style="fill: #FFF; stroke: #000; stroke-width: 2;" /> <circle r="7" cy="50" cx="29" style="fill: #FFF; stroke: #000; stroke-width: 2;" /> <circle r="7" cy="29" cx="29" style="fill: #FFF; stroke: #000; stroke-width: 2;" /> </svg>
                                </button>
                            </div>
                        </div>
                        <div class="view-area" compile-html="fileView(itm.url)"></div>
                    </div>
                    <button class="control btn-prev" type="button" onclick="fileViewer('#popupFileViewerChat', 'prev')">
                        <svg class="block-i h24px" viewBox="0 0 64 64"> <path d="m45.539,63.41c0.394,0.394 0.908,0.59 1.424,0.59s1.031-0.197 1.424-0.59c0.787-0.787 0.787-2.061 0-2.848l-28.328-28.329 28.348-28.347c0.786-0.787 0.786-2.062 0-2.848-0.787-0.787-2.062-0.787-2.849,0l-29.736,29.735c-0.205,0.206-0.384,0.506-0.484,0.778-0.273,0.738-0.092,1.567 0.465,2.124l29.736,29.735z" /> </svg>
                    </button>
                    <button class="control btn-next" type="button" onclick="fileViewer('#popupFileViewerChat', 'next')">
                        <svg class="block-i h24px" viewBox="0 0 64 64"> <path d="M44.152,32.024L15.824,60.353c-0.787,0.787-0.787,2.062,0,2.849c0.394,0.394,0.909,0.59,1.424,0.59   c0.515,0,1.031-0.196,1.424-0.59l29.736-29.736c0.557-0.557,0.718-1.439,0.445-2.177c-0.101-0.272-0.26-0.519-0.464-0.725   L18.652,0.828c-0.787-0.787-2.062-0.787-2.848,0c-0.787,0.787-0.787,2.061,0,2.848L44.152,32.024z" /> </svg>
                    </button>
                </div>
            </div>
            <div id="optionFileDetailChat" class="app-confirm-popup">
                <div class="overlay-area" ng-click="closeTarget('#optionFileDetailChat')"></div>
                <div class="content-area popup-2">
                    <div class="title">
                        <div class="icon">
                            <svg class="h20px" viewBox="0 0 60 60"> <path d="M14,36C8.486,36,4,40.486,4,46s4.486,10,10,10s10-4.486,10-10S19.514,36,14,36z M14,54c-4.411,0-8-3.589-8-8s3.589-8,8-8   s8,3.589,8,8S18.411,54,14,54z" /> <path d="M46,32H14C6.28,32,0,38.28,0,46s6.28,14,14,14h32c7.72,0,14-6.28,14-14S53.72,32,46,32z M46,58H14C7.383,58,2,52.617,2,46   s5.383-12,12-12h32c6.617,0,12,5.383,12,12S52.617,58,46,58z" /> <path d="M14,28h32c7.72,0,14-6.28,14-14S53.72,0,46,0H14C6.28,0,0,6.28,0,14S6.28,28,14,28z M46,4c5.514,0,10,4.486,10,10   s-4.486,10-10,10s-10-4.486-10-10S40.486,4,46,4z" /> </svg>
                        </div>
                        File option
                    </div>
                    <div class="content row-fixed-15 pdB0-i">
                        <ul class="list-item-03" ng-click="closeTarget('#optionFileDetailChat')">
                            <li>
                                <div class="layout-fixed">
                                    <div class="icon-area">
                                        <svg class="h13px" viewBox="0 0 384 384"> <polygon points="234.667,0 234.667,42.667 311.147,42.667 101.44,252.373 131.627,282.56 341.333,72.853 341.333,149.333      384,149.333 384,0    " /> <path d="M341.333,341.333H42.667V42.667H192V0H42.667C19.093,0,0,19.093,0,42.667v298.667C0,364.907,19.093,384,42.667,384     h298.667C364.907,384,384,364.907,384,341.333V192h-42.667V341.333z" /> </svg>
                                    </div>
                                    <div class="name-area text-link-1">
                                        Open on web
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="layout-fixed">
                                    <div class="icon-area">
                                        <svg class="h15px" viewBox="0 0 58 58"> <path d="M21.707,24.293c-0.391-0.391-1.023-0.391-1.414,0s-0.391,1.023,0,1.414l7.999,7.999c0.001,0.001,0.001,0.001,0.002,0.002   L29,34.414l0.706-0.706c0.001-0.001,0.001-0.001,0.002-0.002l7.999-7.999c0.391-0.391,0.391-1.023,0-1.414s-1.023-0.391-1.414,0   L30,30.586V3c0-0.552-0.447-1-1-1s-1,0.448-1,1v27.586L21.707,24.293z" /> <path d="M57.981,32.676L57.53,32h-0.009l-3.583-5.381l-2.421-3.628l0.004-0.002L47.535,17H36v2h10.465l8.679,13H39v7H19v-7H2.856   l8.679-13H22v-2H10.465L0.431,32.031l-0.014,0.001L0,32.655v0.206v0.396v19.359C0,54.482,1.519,56,3.385,56h51.23   C56.481,56,58,54.482,58,52.616V33.239v-0.429l-0.014-0.036L57.981,32.676z" /> </svg>
                                    </div>
                                    <div class="name-area text-link-1">
                                        Download
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </ion-content>
</ion-view>
