!function(){function tinycolor(color,opts){if(color=color?color:"",opts=opts||{},color instanceof tinycolor)return color;if(!(this instanceof tinycolor))return new tinycolor(color,opts);var rgb=inputToRGB(color);this._originalInput=color,this._r=rgb.r,this._g=rgb.g,this._b=rgb.b,this._a=rgb.a,this._roundA=mathRound(100*this._a)/100,this._format=opts.format||rgb.format,this._gradientType=opts.gradientType,this._r<1&&(this._r=mathRound(this._r)),this._g<1&&(this._g=mathRound(this._g)),this._b<1&&(this._b=mathRound(this._b)),this._ok=rgb.ok,this._tc_id=tinyCounter++}function inputToRGB(color){var rgb={r:0,g:0,b:0},a=1,ok=!1,format=!1;return"string"==typeof color&&(color=stringInputToObject(color)),"object"==typeof color&&(color.hasOwnProperty("r")&&color.hasOwnProperty("g")&&color.hasOwnProperty("b")?(rgb=rgbToRgb(color.r,color.g,color.b),ok=!0,format="%"===String(color.r).substr(-1)?"prgb":"rgb"):color.hasOwnProperty("h")&&color.hasOwnProperty("s")&&color.hasOwnProperty("v")?(color.s=convertToPercentage(color.s),color.v=convertToPercentage(color.v),rgb=hsvToRgb(color.h,color.s,color.v),ok=!0,format="hsv"):color.hasOwnProperty("h")&&color.hasOwnProperty("s")&&color.hasOwnProperty("l")&&(color.s=convertToPercentage(color.s),color.l=convertToPercentage(color.l),rgb=hslToRgb(color.h,color.s,color.l),ok=!0,format="hsl"),color.hasOwnProperty("a")&&(a=color.a)),a=boundAlpha(a),{ok:ok,format:color.format||format,r:mathMin(255,mathMax(rgb.r,0)),g:mathMin(255,mathMax(rgb.g,0)),b:mathMin(255,mathMax(rgb.b,0)),a:a}}function rgbToRgb(r,g,b){return{r:255*bound01(r,255),g:255*bound01(g,255),b:255*bound01(b,255)}}function rgbToHsl(r,g,b){r=bound01(r,255),g=bound01(g,255),b=bound01(b,255);var h,s,max=mathMax(r,g,b),min=mathMin(r,g,b),l=(max+min)/2;if(max==min)h=s=0;else{var d=max-min;switch(s=l>.5?d/(2-max-min):d/(max+min),max){case r:h=(g-b)/d+(b>g?6:0);break;case g:h=(b-r)/d+2;break;case b:h=(r-g)/d+4}h/=6}return{h:h,s:s,l:l}}function hslToRgb(h,s,l){function hue2rgb(p,q,t){return 0>t&&(t+=1),t>1&&(t-=1),1/6>t?p+6*(q-p)*t:.5>t?q:2/3>t?p+6*(q-p)*(2/3-t):p}var r,g,b;if(h=bound01(h,360),s=bound01(s,100),l=bound01(l,100),0===s)r=g=b=l;else{var q=.5>l?l*(1+s):l+s-l*s,p=2*l-q;r=hue2rgb(p,q,h+1/3),g=hue2rgb(p,q,h),b=hue2rgb(p,q,h-1/3)}return{r:255*r,g:255*g,b:255*b}}function rgbToHsv(r,g,b){r=bound01(r,255),g=bound01(g,255),b=bound01(b,255);var h,s,max=mathMax(r,g,b),min=mathMin(r,g,b),v=max,d=max-min;if(s=0===max?0:d/max,max==min)h=0;else{switch(max){case r:h=(g-b)/d+(b>g?6:0);break;case g:h=(b-r)/d+2;break;case b:h=(r-g)/d+4}h/=6}return{h:h,s:s,v:v}}function hsvToRgb(h,s,v){h=6*bound01(h,360),s=bound01(s,100),v=bound01(v,100);var i=math.floor(h),f=h-i,p=v*(1-s),q=v*(1-f*s),t=v*(1-(1-f)*s),mod=i%6,r=[v,q,p,p,t,v][mod],g=[t,v,v,q,p,p][mod],b=[p,p,t,v,v,q][mod];return{r:255*r,g:255*g,b:255*b}}function rgbToHex(r,g,b,allow3Char){var hex=[pad2(mathRound(r).toString(16)),pad2(mathRound(g).toString(16)),pad2(mathRound(b).toString(16))];return allow3Char&&hex[0].charAt(0)==hex[0].charAt(1)&&hex[1].charAt(0)==hex[1].charAt(1)&&hex[2].charAt(0)==hex[2].charAt(1)?hex[0].charAt(0)+hex[1].charAt(0)+hex[2].charAt(0):hex.join("")}function rgbaToHex(r,g,b,a){var hex=[pad2(convertDecimalToHex(a)),pad2(mathRound(r).toString(16)),pad2(mathRound(g).toString(16)),pad2(mathRound(b).toString(16))];return hex.join("")}function desaturate(color,amount){amount=0===amount?0:amount||10;var hsl=tinycolor(color).toHsl();return hsl.s-=amount/100,hsl.s=clamp01(hsl.s),tinycolor(hsl)}function saturate(color,amount){amount=0===amount?0:amount||10;var hsl=tinycolor(color).toHsl();return hsl.s+=amount/100,hsl.s=clamp01(hsl.s),tinycolor(hsl)}function greyscale(color){return tinycolor(color).desaturate(100)}function lighten(color,amount){amount=0===amount?0:amount||10;var hsl=tinycolor(color).toHsl();return hsl.l+=amount/100,hsl.l=clamp01(hsl.l),tinycolor(hsl)}function brighten(color,amount){amount=0===amount?0:amount||10;var rgb=tinycolor(color).toRgb();return rgb.r=mathMax(0,mathMin(255,rgb.r-mathRound(255*-(amount/100)))),rgb.g=mathMax(0,mathMin(255,rgb.g-mathRound(255*-(amount/100)))),rgb.b=mathMax(0,mathMin(255,rgb.b-mathRound(255*-(amount/100)))),tinycolor(rgb)}function darken(color,amount){amount=0===amount?0:amount||10;var hsl=tinycolor(color).toHsl();return hsl.l-=amount/100,hsl.l=clamp01(hsl.l),tinycolor(hsl)}function spin(color,amount){var hsl=tinycolor(color).toHsl(),hue=(mathRound(hsl.h)+amount)%360;return hsl.h=0>hue?360+hue:hue,tinycolor(hsl)}function complement(color){var hsl=tinycolor(color).toHsl();return hsl.h=(hsl.h+180)%360,tinycolor(hsl)}function triad(color){var hsl=tinycolor(color).toHsl(),h=hsl.h;return[tinycolor(color),tinycolor({h:(h+120)%360,s:hsl.s,l:hsl.l}),tinycolor({h:(h+240)%360,s:hsl.s,l:hsl.l})]}function tetrad(color){var hsl=tinycolor(color).toHsl(),h=hsl.h;return[tinycolor(color),tinycolor({h:(h+90)%360,s:hsl.s,l:hsl.l}),tinycolor({h:(h+180)%360,s:hsl.s,l:hsl.l}),tinycolor({h:(h+270)%360,s:hsl.s,l:hsl.l})]}function splitcomplement(color){var hsl=tinycolor(color).toHsl(),h=hsl.h;return[tinycolor(color),tinycolor({h:(h+72)%360,s:hsl.s,l:hsl.l}),tinycolor({h:(h+216)%360,s:hsl.s,l:hsl.l})]}function analogous(color,results,slices){results=results||6,slices=slices||30;var hsl=tinycolor(color).toHsl(),part=360/slices,ret=[tinycolor(color)];for(hsl.h=(hsl.h-(part*results>>1)+720)%360;--results;)hsl.h=(hsl.h+part)%360,ret.push(tinycolor(hsl));return ret}function monochromatic(color,results){results=results||6;for(var hsv=tinycolor(color).toHsv(),h=hsv.h,s=hsv.s,v=hsv.v,ret=[],modification=1/results;results--;)ret.push(tinycolor({h:h,s:s,v:v})),v=(v+modification)%1;return ret}function flip(o){var flipped={};for(var i in o)o.hasOwnProperty(i)&&(flipped[o[i]]=i);return flipped}function boundAlpha(a){return a=parseFloat(a),(isNaN(a)||0>a||a>1)&&(a=1),a}function bound01(n,max){isOnePointZero(n)&&(n="100%");var processPercent=isPercentage(n);return n=mathMin(max,mathMax(0,parseFloat(n))),processPercent&&(n=parseInt(n*max,10)/100),math.abs(n-max)<1e-6?1:n%max/parseFloat(max)}function clamp01(val){return mathMin(1,mathMax(0,val))}function parseIntFromHex(val){return parseInt(val,16)}function isOnePointZero(n){return"string"==typeof n&&-1!=n.indexOf(".")&&1===parseFloat(n)}function isPercentage(n){return"string"==typeof n&&-1!=n.indexOf("%")}function pad2(c){return 1==c.length?"0"+c:""+c}function convertToPercentage(n){return 1>=n&&(n=100*n+"%"),n}function convertDecimalToHex(d){return Math.round(255*parseFloat(d)).toString(16)}function convertHexToDecimal(h){return parseIntFromHex(h)/255}function stringInputToObject(color){color=color.replace(trimLeft,"").replace(trimRight,"").toLowerCase();var named=!1;if(names[color])color=names[color],named=!0;else if("transparent"==color)return{r:0,g:0,b:0,a:0,format:"name"};var match;return(match=matchers.rgb.exec(color))?{r:match[1],g:match[2],b:match[3]}:(match=matchers.rgba.exec(color))?{r:match[1],g:match[2],b:match[3],a:match[4]}:(match=matchers.hsl.exec(color))?{h:match[1],s:match[2],l:match[3]}:(match=matchers.hsla.exec(color))?{h:match[1],s:match[2],l:match[3],a:match[4]}:(match=matchers.hsv.exec(color))?{h:match[1],s:match[2],v:match[3]}:(match=matchers.hsva.exec(color))?{h:match[1],s:match[2],v:match[3],a:match[4]}:(match=matchers.hex8.exec(color))?{a:convertHexToDecimal(match[1]),r:parseIntFromHex(match[2]),g:parseIntFromHex(match[3]),b:parseIntFromHex(match[4]),format:named?"name":"hex8"}:(match=matchers.hex6.exec(color))?{r:parseIntFromHex(match[1]),g:parseIntFromHex(match[2]),b:parseIntFromHex(match[3]),format:named?"name":"hex"}:(match=matchers.hex3.exec(color))?{r:parseIntFromHex(match[1]+""+match[1]),g:parseIntFromHex(match[2]+""+match[2]),b:parseIntFromHex(match[3]+""+match[3]),format:named?"name":"hex"}:!1}function validateWCAG2Parms(parms){var level,size;return parms=parms||{level:"AA",size:"small"},level=(parms.level||"AA").toUpperCase(),size=(parms.size||"small").toLowerCase(),"AA"!==level&&"AAA"!==level&&(level="AA"),"small"!==size&&"large"!==size&&(size="small"),{level:level,size:size}}var trimLeft=/^[\s,#]+/,trimRight=/\s+$/,tinyCounter=0,math=Math,mathRound=math.round,mathMin=math.min,mathMax=math.max,mathRandom=math.random;tinycolor.prototype={isDark:function(){return this.getBrightness()<128},isLight:function(){return!this.isDark()},isValid:function(){return this._ok},getOriginalInput:function(){return this._originalInput},getFormat:function(){return this._format},getAlpha:function(){return this._a},getBrightness:function(){var rgb=this.toRgb();return(299*rgb.r+587*rgb.g+114*rgb.b)/1e3},getLuminance:function(){var RsRGB,GsRGB,BsRGB,R,G,B,rgb=this.toRgb();return RsRGB=rgb.r/255,GsRGB=rgb.g/255,BsRGB=rgb.b/255,R=.03928>=RsRGB?RsRGB/12.92:Math.pow((RsRGB+.055)/1.055,2.4),G=.03928>=GsRGB?GsRGB/12.92:Math.pow((GsRGB+.055)/1.055,2.4),B=.03928>=BsRGB?BsRGB/12.92:Math.pow((BsRGB+.055)/1.055,2.4),.2126*R+.7152*G+.0722*B},setAlpha:function(value){return this._a=boundAlpha(value),this._roundA=mathRound(100*this._a)/100,this},toHsv:function(){var hsv=rgbToHsv(this._r,this._g,this._b);return{h:360*hsv.h,s:hsv.s,v:hsv.v,a:this._a}},toHsvString:function(){var hsv=rgbToHsv(this._r,this._g,this._b),h=mathRound(360*hsv.h),s=mathRound(100*hsv.s),v=mathRound(100*hsv.v);return 1==this._a?"hsv("+h+", "+s+"%, "+v+"%)":"hsva("+h+", "+s+"%, "+v+"%, "+this._roundA+")"},toHsl:function(){var hsl=rgbToHsl(this._r,this._g,this._b);return{h:360*hsl.h,s:hsl.s,l:hsl.l,a:this._a}},toHslString:function(){var hsl=rgbToHsl(this._r,this._g,this._b),h=mathRound(360*hsl.h),s=mathRound(100*hsl.s),l=mathRound(100*hsl.l);return 1==this._a?"hsl("+h+", "+s+"%, "+l+"%)":"hsla("+h+", "+s+"%, "+l+"%, "+this._roundA+")"},toHex:function(allow3Char){return rgbToHex(this._r,this._g,this._b,allow3Char)},toHexString:function(allow3Char){return"#"+this.toHex(allow3Char)},toHex8:function(){return rgbaToHex(this._r,this._g,this._b,this._a)},toHex8String:function(){return"#"+this.toHex8()},toRgb:function(){return{r:mathRound(this._r),g:mathRound(this._g),b:mathRound(this._b),a:this._a}},toRgbString:function(){return 1==this._a?"rgb("+mathRound(this._r)+", "+mathRound(this._g)+", "+mathRound(this._b)+")":"rgba("+mathRound(this._r)+", "+mathRound(this._g)+", "+mathRound(this._b)+", "+this._roundA+")"},toPercentageRgb:function(){return{r:mathRound(100*bound01(this._r,255))+"%",g:mathRound(100*bound01(this._g,255))+"%",b:mathRound(100*bound01(this._b,255))+"%",a:this._a}},toPercentageRgbString:function(){return 1==this._a?"rgb("+mathRound(100*bound01(this._r,255))+"%, "+mathRound(100*bound01(this._g,255))+"%, "+mathRound(100*bound01(this._b,255))+"%)":"rgba("+mathRound(100*bound01(this._r,255))+"%, "+mathRound(100*bound01(this._g,255))+"%, "+mathRound(100*bound01(this._b,255))+"%, "+this._roundA+")"},toName:function(){return 0===this._a?"transparent":this._a<1?!1:hexNames[rgbToHex(this._r,this._g,this._b,!0)]||!1},toFilter:function(secondColor){var hex8String="#"+rgbaToHex(this._r,this._g,this._b,this._a),secondHex8String=hex8String,gradientType=this._gradientType?"GradientType = 1, ":"";if(secondColor){var s=tinycolor(secondColor);secondHex8String=s.toHex8String()}return"progid:DXImageTransform.Microsoft.gradient("+gradientType+"startColorstr="+hex8String+",endColorstr="+secondHex8String+")"},toString:function(format){var formatSet=!!format;format=format||this._format;var formattedString=!1,hasAlpha=this._a<1&&this._a>=0,needsAlphaFormat=!formatSet&&hasAlpha&&("hex"===format||"hex6"===format||"hex3"===format||"name"===format);return needsAlphaFormat?"name"===format&&0===this._a?this.toName():this.toRgbString():("rgb"===format&&(formattedString=this.toRgbString()),"prgb"===format&&(formattedString=this.toPercentageRgbString()),("hex"===format||"hex6"===format)&&(formattedString=this.toHexString()),"hex3"===format&&(formattedString=this.toHexString(!0)),"hex8"===format&&(formattedString=this.toHex8String()),"name"===format&&(formattedString=this.toName()),"hsl"===format&&(formattedString=this.toHslString()),"hsv"===format&&(formattedString=this.toHsvString()),formattedString||this.toHexString())},_applyModification:function(fn,args){var color=fn.apply(null,[this].concat([].slice.call(args)));return this._r=color._r,this._g=color._g,this._b=color._b,this.setAlpha(color._a),this},lighten:function(){return this._applyModification(lighten,arguments)},brighten:function(){return this._applyModification(brighten,arguments)},darken:function(){return this._applyModification(darken,arguments)},desaturate:function(){return this._applyModification(desaturate,arguments)},saturate:function(){return this._applyModification(saturate,arguments)},greyscale:function(){return this._applyModification(greyscale,arguments)},spin:function(){return this._applyModification(spin,arguments)},_applyCombination:function(fn,args){return fn.apply(null,[this].concat([].slice.call(args)))},analogous:function(){return this._applyCombination(analogous,arguments)},complement:function(){return this._applyCombination(complement,arguments)},monochromatic:function(){return this._applyCombination(monochromatic,arguments)},splitcomplement:function(){return this._applyCombination(splitcomplement,arguments)},triad:function(){return this._applyCombination(triad,arguments)},tetrad:function(){return this._applyCombination(tetrad,arguments)}},tinycolor.fromRatio=function(color,opts){if("object"==typeof color){var newColor={};for(var i in color)color.hasOwnProperty(i)&&(newColor[i]="a"===i?color[i]:convertToPercentage(color[i]));color=newColor}return tinycolor(color,opts)},tinycolor.equals=function(color1,color2){return color1&&color2?tinycolor(color1).toRgbString()==tinycolor(color2).toRgbString():!1},tinycolor.random=function(){return tinycolor.fromRatio({r:mathRandom(),g:mathRandom(),b:mathRandom()})},tinycolor.mix=function(color1,color2,amount){amount=0===amount?0:amount||50;var w1,rgb1=tinycolor(color1).toRgb(),rgb2=tinycolor(color2).toRgb(),p=amount/100,w=2*p-1,a=rgb2.a-rgb1.a;w1=-1==w*a?w:(w+a)/(1+w*a),w1=(w1+1)/2;var w2=1-w1,rgba={r:rgb2.r*w1+rgb1.r*w2,g:rgb2.g*w1+rgb1.g*w2,b:rgb2.b*w1+rgb1.b*w2,a:rgb2.a*p+rgb1.a*(1-p)};return tinycolor(rgba)},tinycolor.readability=function(color1,color2){var c1=tinycolor(color1),c2=tinycolor(color2);return(Math.max(c1.getLuminance(),c2.getLuminance())+.05)/(Math.min(c1.getLuminance(),c2.getLuminance())+.05)},tinycolor.isReadable=function(color1,color2,wcag2){var wcag2Parms,out,readability=tinycolor.readability(color1,color2);switch(out=!1,wcag2Parms=validateWCAG2Parms(wcag2),wcag2Parms.level+wcag2Parms.size){case"AAsmall":case"AAAlarge":out=readability>=4.5;break;case"AAlarge":out=readability>=3;break;case"AAAsmall":out=readability>=7}return out},tinycolor.mostReadable=function(baseColor,colorList,args){var readability,includeFallbackColors,level,size,bestColor=null,bestScore=0;args=args||{},includeFallbackColors=args.includeFallbackColors,level=args.level,size=args.size;for(var i=0;i<colorList.length;i++)readability=tinycolor.readability(baseColor,colorList[i]),readability>bestScore&&(bestScore=readability,bestColor=tinycolor(colorList[i]));return tinycolor.isReadable(baseColor,bestColor,{level:level,size:size})||!includeFallbackColors?bestColor:(args.includeFallbackColors=!1,tinycolor.mostReadable(baseColor,["#fff","#000"],args))};var names=tinycolor.names={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"0ff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000",blanchedalmond:"ffebcd",blue:"00f",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",burntsienna:"ea7e5d",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"0ff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"f0f",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"789",lightslategrey:"789",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"0f0",limegreen:"32cd32",linen:"faf0e6",magenta:"f0f",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"663399",red:"f00",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"fff",whitesmoke:"f5f5f5",yellow:"ff0",yellowgreen:"9acd32"},hexNames=tinycolor.hexNames=flip(names),matchers=function(){var CSS_INTEGER="[-\\+]?\\d+%?",CSS_NUMBER="[-\\+]?\\d*\\.\\d+%?",CSS_UNIT="(?:"+CSS_NUMBER+")|(?:"+CSS_INTEGER+")",PERMISSIVE_MATCH3="[\\s|\\(]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")\\s*\\)?",PERMISSIVE_MATCH4="[\\s|\\(]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")\\s*\\)?";return{rgb:new RegExp("rgb"+PERMISSIVE_MATCH3),rgba:new RegExp("rgba"+PERMISSIVE_MATCH4),hsl:new RegExp("hsl"+PERMISSIVE_MATCH3),hsla:new RegExp("hsla"+PERMISSIVE_MATCH4),hsv:new RegExp("hsv"+PERMISSIVE_MATCH3),hsva:new RegExp("hsva"+PERMISSIVE_MATCH4),hex3:/^([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex6:/^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,hex8:/^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/}}();"undefined"!=typeof module&&module.exports?module.exports=tinycolor:"function"==typeof define&&define.amd?define(function(){return tinycolor}):window.tinycolor=tinycolor}();var colorPickerTemplates=colorPickerTemplates||{};colorPickerTemplates["modal-template-hsl.html"]=' <ion-modal-view class="color-picker-modal" ng-class="::ui.modalClass">\n    \n    <ion-header-bar ng-class="::ui.headerFooterClass">\n      <h1 class="title">{{::ui.modalTitle}}</h1>\n    </ion-header-bar>\n    \n    <ion-content>\n\n    <div>\n        <div class="item item-body text-center" style="height:200px;" color-box="{{ui.sample}}">\n        <button class="button button-outline" style="margin:auto; margin-top:100px;" color-box="{{ui.sample}}" ng-click="setColor()">{{::ui.okButton}}</button>\n        </div>\n    </div>\n\n    \n\n    <div>\n        \n        \n        <div class="item range range-positive">\n            <i class="icon em1">H</i>\n            <input type="range" ng-model="internalColors.hsl.h" min="0" max="360">\n            <span><input parse-integer type="number" min="0" max="360"  class="em1" ng-model="internalColors.hsl.h"></span>\n        </div>\n        <div class="item range range-positive">\n            <i class="icon em1">S %</i>\n            <input type="range" ng-model="internalColors.hsl.s" min="0" max="100">\n            <span><input parse-integer type="number" min="0" max="100"  class="em1" ng-model="internalColors.hsl.s"></span>\n        </div>\n        <div class="item range range-positive">\n            <i class="icon em1">L %</i>\n            <input type="range" ng-model="internalColors.hsl.l" min="0" max="100">\n            <span><input parse-integer type="number" min="0" max="100"  class="em1" ng-model="internalColors.hsl.l"></span>\n        </div>\n   \n        \n\n    </div>\n\n    \n      \n    </ion-content>\n    <ion-footer-bar ng-class="::ui.headerFooterClass">\n    <button class="button button-stable" ng-click="closeModal()">{{::ui.cancelButton}}</button>\n    <button ng-if="::!ui.hideReset" class="button button-stable" ng-click="unsetColor()">{{::ui.resetButton}}</button>\n    </ion-footer-bar>\n</ion-modal-view>\n';var colorPickerTemplates=colorPickerTemplates||{};colorPickerTemplates["modal-template-hsv.html"]='<ion-modal-view class="color-picker-modal" ng-class="::ui.modalClass">    \n\n    <ion-header-bar ng-class="::ui.headerFooterClass">\n      <h1 class="title">{{::ui.modalTitle}}</h1>\n    </ion-header-bar>\n    <ion-content>\n\n    <div>\n        <div class="item item-body text-center" style="height:200px;" color-box="{{ui.sample}}">\n        <button class="button button-outline" style="margin:auto; margin-top:100px;" color-box="{{ui.sample}}" ng-click="setColor()">{{::ui.okButton}}</button>\n        </div>\n    </div>\n\n    \n    <div>\n        <div class="item range range-positive">\n            <i class="icon em1">H</i>\n            <input type="range" ng-model="internalColors.hsv.h" min="0" max="360">\n                <span><input parse-integer type="number" min="0" max="360"  class="em1" ng-model="internalColors.hsv.h"></span>\n        </div>\n        <div class="item range range-positive">\n            <i class="icon em1">S %</i>\n            <input type="range" ng-model="internalColors.hsv.s" min="0" max="100">\n            <span><input parse-integer type="number" min="0" max="100"  class="em1" ng-model="internalColors.hsv.s"></span>\n        </div>\n        <div class="item range range-positive">\n            <i class="icon em1">V %</i>\n            <input type="range" ng-model="internalColors.hsv.v" min="0" max="100">\n            <span><input parse-integer type="number" min="0" max="100"  class="em1" ng-model="internalColors.hsv.v"></span>\n        </div>\n    </div>\n      \n    </ion-content>\n    <ion-footer-bar ng-class="::ui.headerFooterClass">\n        <button class="button button-stable" ng-click="closeModal()">{{::ui.cancelButton}}</button>\n        <button ng-if="!ui.hideReset" class="button button-stable" ng-click="unsetColor()">{{::ui.resetButton}}</button>\n    </ion-footer-bar>\n  </ion-modal-view>\n';var colorPickerTemplates=colorPickerTemplates||{};colorPickerTemplates["modal-template-name.html"]=' <ion-modal-view class="color-picker-modal" ng-class="::ui.modalClass">\n    <ion-header-bar ng-class="::ui.headerFooterClass">\n      <h1 class="title">{{::ui.modalTitle}}</h1>\n    </ion-header-bar>\n    <ion-content>\n\n    <div ng-if="!ui.shortColorList">\n        <div class="text-center" ng-if="!showList" style="padding-top:40px;">\n            <h4 class="muted">{{::ui.loadListMessage}}</h4>\n            <p>\n                <ion-spinner></ion-spinner>\n            </p>\n        </div>\n        <div class="list" ng-if="showList" class="animate-if">\n            <div class="item item-text-wrap" collection-repeat="col in ui.namedColorsAsList track by $index" color-box="{{col[1]}}" color-box-no-border="true" ng-click="setColor(col[0])">\n            <h2 color-box="{{col[1]}}">{{col[0]}}</h2>\n            <p color-box="{{col[1]}}">{{col[1]}}</p>\n            </div>\n        </div>\n    </div>\n    <div ng-if="ui.shortColorList">\n        <div class="list">\n            <div class="item item-text-wrap" ng-repeat="col in ui.namedColorsAsList track by $index" color-box="{{::col[1]}}" color-box-no-border="true" ng-click="setColor(col[0])">\n            <h2 color-box="{{::col[1]}}">{{::col[0]}}</h2>\n            <p color-box="{{::col[1]}}">{{::col[1]}}</p>\n            </div>\n        </div>\n    </div>\n      \n    </ion-content>\n    <ion-footer-bar ng-class="::ui.headerFooterClass">\n        <button class="button button-stable" ng-click="closeModal()">{{ui.cancelButton}}</button>\n        <button ng-if="::!ui.hideReset" class="button button-stable" ng-click="unsetColor()">{{ui.resetButton}}</button>\n    </ion-footer-bar>\n</ion-modal-view>';var colorPickerTemplates=colorPickerTemplates||{};colorPickerTemplates["modal-template-rgb.html"]=' <ion-modal-view class="color-picker-modal" ng-class="::ui.modalClass">\n    <ion-header-bar class="bar" ng-class="::ui.headerFooterClass">\n      <h1 class="title">{{::ui.modalTitle}}</h1>\n    </ion-header-bar>\n    <ion-content>\n\n    <div>\n        <div class="item item-body text-center" style="height:200px;" color-box="{{ui.sample}}">\n        <button class="button button-outline" style="margin:auto; margin-top:100px;" color-box="{{ui.sample}}" ng-click="setColor()">{{::ui.okButton}}</button>\n        </div>\n    </div>\n\n    <div>\n    \n        <div class="item range range-positive">\n            <i class="icon em1">R</i>\n            <input type="range" ng-model="internalColors.rgb.r" min="0" max="255">\n            <span><input parse-integer type="number" min="0" max="255"  class="em1" ng-model="internalColors.rgb.r"></span>\n        </div>\n        <div class="item range range-positive">\n            <i class="icon em1">G</i>\n            <input type="range" ng-model="internalColors.rgb.g" min="0" max="255">\n            <span><input parse-integer type="number" min="0" max="255"  class="em1" ng-model="internalColors.rgb.g"></span>\n        </div>\n        <div class="item range range-positive">\n            <i class="icon em1">B</i>\n            <input type="range" ng-model="internalColors.rgb.b" min="0" max="255">\n            <span><input parse-integer type="number" min="0" max="255" class="em1" ng-model="internalColors.rgb.b"></span>\n        </div>\n\n\n    </div> \n    \n \n    </ion-content>\n    <ion-footer-bar ng-class="::ui.headerFooterClass">\n        <button class="button button-stable" ng-click="closeModal()">{{::ui.cancelButton}}</button>\n        <button ng-if="::!ui.hideReset" class="button button-stable" ng-click="unsetColor()">{{::ui.resetButton}}</button>\n    </ion-footer-bar>\n  </ion-modal-view>\n',function(){angular.module("ionic-color-picker",[]).directive("parseInteger",[function(){return{restrict:"A",require:"ngModel",priority:1e3,link:function(scope,iElement,iAttrs,modelCtrl){modelCtrl.$formatters.push(function(modelValue){return parseInt(modelValue)})}}}]).directive("colorBox",[function(){return{restrict:"A",scope:!0,link:function(scope,iElement,iAttrs){var pristines={backgroundColor:iElement.css("background-color"),color:iElement.css("color"),borderColor:iElement.css("border-color")},modelMode=iAttrs.modelMode||"hex",strokeColors=iAttrs.availableStrokeColors?iAttrs.availableStrokeColors.split(","):["#ffffff","#000000"],colorNames=iAttrs.namedColors?scope.$eval(iAttrs.namedColors):tinycolor.names,colorNamesInverted={};angular.forEach(colorNames,function(v,k){var v2=0==v.indexOf("#")?v:"#"+v;v2=tinycolor(v2).toHexString(),colorNamesInverted[v2]=k});var tColor,txt;iAttrs.$observe("colorBox",function(nv){if(!nv)return iElement.css("background-color",pristines.backgroundColor),iElement.css("color",pristines.color),void iElement.css("border-color",pristines.borderColor);if("name"==modelMode)nv=colorNames[nv],nv=0==nv.indexOf("#")?nv:"#"+nv,tColor=tinycolor(nv);else if("hex"==modelMode)nv=0==nv.indexOf("#")?nv:"#"+nv,tColor=tinycolor(nv);else try{nv=scope.$eval(nv),tColor=tinycolor.fromRatio(nv)}catch(err){return}txt=tinycolor.mostReadable(tColor,strokeColors).toHexString(),"true"!==iAttrs.colorBoxNoBorder&&iElement.css("border-color",txt),"true"!==iAttrs.colorBoxNoText&&iElement.css("color",txt),iElement.css("background-color",tColor.toHexString())})}}}]).directive("colorPicker",["$ionicModal","$timeout",function($ionicModal,$timeout){return{restrict:"A",require:"ngModel",scope:!0,link:function(scope,iElement,iAttrs,ngModelController){var colorMode=iAttrs.colorMode||"rgb",customColors=void 0!==iAttrs.namedColors,colorNames=iAttrs.namedColors?scope.$eval(iAttrs.namedColors):tinycolor.names,colorNamesInverted={},shortListBreak=iAttrs.shortListBreak?parseInt(iAttrs.shortListBreak):10,modelMode=iAttrs.modelMode||"hex";angular.forEach(colorNames,function(v,k){var v2=0==v.indexOf("#")?v:"#"+v;v2=tinycolor(v2).toHexString(),colorNamesInverted[v2]=k}),scope.internalColors={rgb:{r:0,g:0,b:0},hsl:{h:0,s:0,l:0},hsv:{h:0,s:0,v:0},hex:"#000000"},scope.ui={modalTitle:iAttrs.modalTitle||"Pick a color",okButton:iAttrs.okButton||"OK",hideReset:"true"!==iAttrs.hideReset?!1:!0,resetButton:iAttrs.resetButton||"Reset",cancelButton:iAttrs.cancelButton||"Cancel",loadListMessage:iAttrs.loadListMessage||"Loading",modalClass:iAttrs.modalClass||"",headerFooterClass:iAttrs.headerFooterClass||"bar-stable",mode:colorMode,selectMode:"sliders",namedColors:colorNames,namedColorsAsList:[]};for(var key in scope.ui.namedColors){var k=scope.ui.namedColors[key];k=0==k.indexOf("#")?k:"#"+k,scope.ui.namedColorsAsList.push([key,k])}var shortList=scope.ui.namedColorsAsList.length<shortListBreak;scope.ui.shortColorList=shortList;var getScopeColor=function(c){return"rgb"==colorMode?c.toRgb():"hsl"==colorMode?c.toHsl():"hsv"==colorMode?c.toHsv():void 0};ngModelController.$render=function(){var initial=ngModelController.$viewValue;initial&&(customColors?c=tinycolor(colorNames[initial]):c=tinycolor(initial),scope.internalColors[colorMode]=getScopeColor(c))},$timeout(function(){ngModelController.$render()}),scope.unsetColor=function(){$timeout(function(){ngModelController.$setViewValue(""),scope.modal.hide(),scope.showList=!1})};var setColorTo=function(col,fun){ngModelController.$setViewValue(col[fun]())},setColorToName=function(col){var theCol=colorNamesInverted[col.toHexString()];return theCol?void ngModelController.$setViewValue(colorNamesInverted[col.toHexString()]):void console.error("cannot set color",col)};scope.setColor=function(col){switch(col="name"==colorMode?tinycolor(scope.ui.namedColors[col]):tinycolor(getCurrentColorModel()),modelMode){case"name":setColorToName(col);break;case"rgb":setColorTo(col,"toRgb");break;default:setColorTo(col,"toHexString")}ngModelController.$render(),scope.modal.hide(),scope.showList=!1},scope.closeModal=function(){scope.modal.hide(),scope.showList=!1;var v=ngModelController.$viewValue;v&&(v=tinycolor(v),scope.internalColors[colorMode]=getScopeColor(v))},scope.toggleSelectMode=function(){scope.ui.selectMode="sliders"==scope.ui.selectMode?"form":"sliders"};var tplName="modal-template-"+scope.ui.mode+".html";scope.modal=$ionicModal.fromTemplate(colorPickerTemplates[tplName],{scope:scope}),scope.$on("$destroy",function(){scope.modal.remove()}),iElement.on("click",function(){shortList?(scope.showList=!0,scope.modal.show()):scope.modal.show().then(function(){scope.showList=!0})});var getCurrentColorModel=function(){if("hex"!=colorMode){var out={};return angular.forEach(scope.internalColors[colorMode],function(v,k){out[k]=parseFloat(v)}),out}return scope.internalColors[colorMode]};scope.$watch(function(){return getCurrentColorModel()},function(nv){nv&&(scope.ui.sample=tinycolor(nv).toHexString())},!0)}}}])}();