/*
 * ion-autocomplete 0.3.2
 * Copyright 2016 Danny Povolotski
 * Copyright modifications 2016 Guy Brand
 * https://github.com/guylabs/ion-autocomplete
 */
!function () {
    "use strict";
    angular.module("ion-autocomplete", []).directive("ionAutocomplete", ["$ionicBackdrop", "$ionicScrollDelegate", "$document", "$q", "$parse", "$interpolate", "$ionicPlatform", "$compile", "$templateRequest", function (a, b, c, d, e, f, g, h, i) {
        return {
            require: ["ngModel", "ionAutocomplete"],
            restrict: "A",
            scope: {},
            bindToController: {
                ngModel: "=",
                externalModel: "=",
                templateData: "=",
                itemsMethod: "&",
                itemsClickedMethod: "&",
                itemsRemovedMethod: "&",
                modelToItemMethod: "&",
                cancelButtonClickedMethod: "&",
                placeholder: "@",
                cancelLabel: "@",
                selectItemsLabel: "@",
                selectedItemsLabel: "@"
            },
            controllerAs: "viewModel",
            controller: ["$attrs", "$timeout", "$scope", function (a, b, c) {
                var d = function (a, b) {
                    return a ? a : b
                }, e = this;
                b(function () {
                    e.placeholder = d(e.placeholder, "Click to enter a value..."), e.cancelLabel = d(e.cancelLabel, "Done"), e.selectItemsLabel = d(e.selectItemsLabel, "Select an item..."), e.selectedItemsLabel = d(e.selectedItemsLabel, f("Selected items{{maxSelectedItems ? ' (max. ' + maxSelectedItems + ')' : ''}}:")(e))
                }), this.maxSelectedItems = d(a.maxSelectedItems, void 0), this.templateUrl = d(a.templateUrl, void 0), this.itemsMethodValueKey = d(a.itemsMethodValueKey, void 0), this.itemValueKey = d(a.itemValueKey, void 0), this.itemViewValueKey = d(a.itemViewValueKey, void 0), this.componentId = d(a.componentId, void 0), this.loadingIcon = d(a.loadingIcon, void 0), this.manageExternally = d(a.manageExternally, "false"), this.ngModelOptions = d(c.$eval(a.ngModelOptions), {}), this.showLoadingIcon = !1, this.searchItems = [], this.selectedItems = [], this.searchQuery = void 0, this.isArray = function (a) {
                    return angular.isArray(a)
                }
            }],
            link: function (f, j, k, l) {
                var m = l[0], n = l[1];
                n.randomCssClass = "ion-autocomplete-random-" + Math.floor(1e3 * Math.random() + 1);
                var o = ['<div class="ion-autocomplete-container ' + n.randomCssClass + ' modal" style="display: none;">', '<div class="bar bar-header item-input-inset">', '<label class="item-input-wrapper">', '<i class="icon ion-search placeholder-icon"></i>', '<input type="search" class="ion-autocomplete-search" ng-model="viewModel.searchQuery" ng-model-options="viewModel.ngModelOptions" placeholder="{{viewModel.placeholder}}"/>', "</label>", '<div class="ion-autocomplete-loading-icon" ng-if="viewModel.showLoadingIcon && viewModel.loadingIcon"><ion-spinner icon="{{viewModel.loadingIcon}}"></ion-spinner></div>', '<button class="ion-autocomplete-cancel button button-clear" ng-click="viewModel.cancelClick()">{{viewModel.cancelLabel}}</button>', "</div>", '<ion-content class="has-header">', '<ion-item class="item-divider">{{viewModel.selectedItemsLabel}}</ion-item>', '<ion-item ng-if="viewModel.isArray(viewModel.selectedItems)" ng-repeat="selectedItem in viewModel.selectedItems track by $index" class="item-icon-left item-icon-right item-text-wrap">', '<i class="icon ion-checkmark"></i>', "{{viewModel.getItemValue(selectedItem, viewModel.itemViewValueKey)}}", '<i class="icon ion-trash-a" style="cursor:pointer" ng-click="viewModel.removeItem($index)"></i>', "</ion-item>", '<ion-item ng-if="!viewModel.isArray(viewModel.selectedItems)" class="item-icon-left item-icon-right item-text-wrap">', '<i class="icon ion-checkmark"></i>', "{{viewModel.getItemValue(viewModel.selectedItems, viewModel.itemViewValueKey)}}", '<i class="icon ion-trash-a" style="cursor:pointer" ng-click="viewModel.removeItem(0)"></i>', "</ion-item>", '<ion-item class="item-divider" ng-if="viewModel.searchItems.length > 0">{{viewModel.selectItemsLabel}}</ion-item>', '<ion-item ng-repeat="item in viewModel.searchItems" item-height="55px" item-width="100%" ng-click="viewModel.selectItem(item)" class="item-text-wrap">', "{{viewModel.getItemValue(item, viewModel.itemViewValueKey)}}", "</ion-item>", "</ion-content>", "</div>"].join("");
                d.when().then(function () {
                    return n.templateUrl ? i(n.templateUrl) : o
                }).then(function (i) {
                    var l = h(angular.element(i))(f);
                    c.find("body").append(l), n.getItemValue = function (a, b) {
                        if (angular.isArray(a)) {
                            var c = [];
                            return angular.forEach(a, function (d) {
                                b && angular.isObject(a) ? c.push(e(b)(d)) : c.push(d)
                            }), c
                        }
                        return b && angular.isObject(a) ? e(b)(a) : a
                    }, n.selectItem = function (a) {
                        n.searchQuery = void 0, "1" != n.maxSelectedItems && angular.isArray(n.selectedItems) && n.maxSelectedItems == n.selectedItems.length || (t(n.selectedItems, n.itemValueKey, n.getItemValue(a, n.itemValueKey)) || ("1" == n.maxSelectedItems ? n.selectedItems = a : n.selectedItems = n.selectedItems.concat([a])), m.$setViewValue(n.selectedItems), m.$render(), 1 == n.maxSelectedItems && n.hideModal(), angular.isDefined(k.itemsClickedMethod) && n.itemsClickedMethod({
                            callback: {
                                item: a,
                                selectedItems: angular.isArray(n.selectedItems) ? n.selectedItems.slice() : n.selectedItems,
                                componentId: n.componentId
                            }
                        }))
                    }, n.removeItem = function (a) {
                        if (angular.isArray(n.selectedItems)) {
                            var b = n.selectedItems.splice(a, 1)[0];
                            n.selectedItems = n.selectedItems.slice()
                        } else n.selectedItems = [];
                        m.$setViewValue(n.selectedItems), m.$render(), angular.isDefined(k.itemsRemovedMethod) && n.itemsRemovedMethod({
                            callback: {
                                item: b,
                                selectedItems: angular.isArray(n.selectedItems) ? n.selectedItems.slice() : n.selectedItems,
                                componentId: n.componentId
                            }
                        })
                    }, f.$watch("viewModel.searchQuery", function (a) {
                        n.fetchSearchQuery(a, !1)
                    }), n.fetchSearchQuery = function (a, c) {
                        if (void 0 !== a && angular.isDefined(k.itemsMethod)) {
                            n.showLoadingIcon = !0;
                            var e = {query: a, isInitializing: c};
                            n.componentId && (e = {query: a, isInitializing: c, componentId: n.componentId});
                            var f = d.when(n.itemsMethod(e));
                            f.then(function (a) {
                                a && (a && a.data && (a = a.data), n.searchItems = n.getItemValue(a, n.itemsMethodValueKey), b.resize(), n.showLoadingIcon = !1)
                            }, function (a) {
                                return d.reject(a)
                            })
                        }
                    };
                    var o = !1;
                    n.showModal = function () {
                        if (!o) {
                            a.retain(), angular.element(c[0].querySelector("div.ion-autocomplete-container." + n.randomCssClass)).css("display", "block"), f.$deregisterBackButton = g.registerBackButtonAction(function () {
                                n.hideModal()
                            }, 300);
                            var d = angular.element(c[0].querySelector("div.ion-autocomplete-container." + n.randomCssClass + " input"));
                            d.length > 0 && (d[0].focus(), setTimeout(function () {
                                d[0].focus()
                            }, 0)), b.resize(), o = !0
                        }
                    }, n.hideModal = function () {
                        angular.element(c[0].querySelector("div.ion-autocomplete-container." + n.randomCssClass)).css("display", "none"), n.searchQuery = void 0, a.release(), f.$deregisterBackButton && f.$deregisterBackButton(), o = !1
                    };
                    var p = {moved: !1, startX: 0, startY: 0}, q = function (a) {
                        p.moved = !1, "undefined" != typeof a.originalEvent && (a = a.originalEvent), p.startX = a.touches[0].clientX, p.startY = a.touches[0].clientY
                    }, r = function (a) {
                        "undefined" != typeof a.originalEvent && (a = a.originalEvent), (Math.abs(a.touches[0].clientX - p.startX) > 10 || Math.abs(a.touches[0].clientY - p.startY) > 10) && (p.moved = !0)
                    }, s = function (a) {
                        p.moved || (a.preventDefault(), a.stopPropagation(), n.fetchSearchQuery("", !0), n.showModal())
                    }, t = function (a, b, c) {
                        if (angular.isArray(a))for (var d = 0; d < a.length; d++)if (n.getItemValue(a[d], b) === c)return !0;
                        return !1
                    }, u = function (a) {
                        var b = d.when(n.modelToItemMethod({modelValue: a}));
                        b.then(function (a) {
                            n.selectItem(a)
                        }, function (a) {
                            return d.reject(a)
                        })
                    };
                    "false" == n.manageExternally && (j.bind("touchstart", q), j.bind("touchmove", r), j.bind("touchend click focus", s)), n.cancelClick = function () {
                        n.hideModal(), angular.isDefined(k.cancelButtonClickedMethod) && n.cancelButtonClickedMethod({
                            callback: {
                                selectedItems: angular.isArray(n.selectedItems) ? n.selectedItems.slice() : n.selectedItems,
                                componentId: n.componentId
                            }
                        })
                    }, f.$watch("viewModel.externalModel", function (a) {
                        return angular.isArray(a) && 0 == a.length ? (n.selectedItems = [], m.$setViewValue(n.selectedItems), void m.$render()) : void(a && angular.isDefined(k.modelToItemMethod) && (angular.isArray(a) ? (n.selectedItems = [], angular.forEach(a, function (a) {
                            u(a)
                        })) : u(a)))
                    }), f.$on("$destroy", function () {
                        l.remove()
                    }), m.$render = function () {
                        j.val(n.getItemValue(m.$viewValue, n.itemViewValueKey))
                    }, m.$formatters.push(function (a) {
                        var b = n.getItemValue(a, n.itemViewValueKey);
                        return void 0 == b ? "" : b
                    }), m.$parsers.push(function (a) {
                        return n.getItemValue(a, n.itemValueKey)
                    })
                })
            }
        }
    }])
}();