angular.module('roomsService', []).factory('Rooms', function($http) {
    return {
        getPaging: function(filter) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'roomspaging',
                withCredentials: true,
                data: filter
            });
            // return $http({method:'POST',url:url_server + 'roomspaging',data:filter});
        },
        getSelect: function() {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'rooms/getall',
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'rooms/getall'});
        },
        getSelect2: function(filter) {
            return $http({
                method: 'POST',
                url: url_server + 'rooms/search',
                data: filter
            });
        },
        show: function(id) {
            return $http({
                method: 'GET',
                headers: headers,
                url: url_server + 'rooms/' + id,
                withCredentials: true
            });
            // return $http.get(url_server+ 'rooms/'+id);
        },
        save: function(roomsData) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'rooms',
                withCredentials: true,
                data: roomsData
            });
        },
        update: function(id, roomsData) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'rooms/' + id,
                withCredentials: true,
                data: roomsData
            });
            // return $http.put(url_server + 'rooms/' + id, roomsData, {
            //     headers: headers,
            //     withCredentials: true
            // });
        },
        destroy: function(id) {
            return $http.delete(url_server + 'rooms/' + id, {
                headers: headers,
                withCredentials: true
            });
            // return $http.delete(url_server + 'rooms/' + id);
        }
    };
});