angular.module('ordersService',[]).factory('Orders',function($http){
	return {
		getPaging:function(filter){
			return $http({method:'POST',url:url_server + 'orderspaging',data:filter});
		},
		getSelect:function(){
			return $http({method:'POST',url:url_server + 'orders/getall'});
		},
		getSelect2:function(filter){
			return $http({method:'POST',url:url_server + 'orders/search',data:filter});
		},
		show:function(id){
			return $http.get(url_server+ 'orders/'+id);
		},
		save:function(ordersData){
			return $http({method:'POST',
							url:url_server+'orders',
							data:ordersData});
		},
		update:function(id, ordersData){
			return $http.put(url_server+'orders/'+id,ordersData);
		},
		destroy:function(id){
			return $http.delete(url_server + 'orders/'+id);
		},
		getByAppointment:function(app_id){
			return $http({method:'POST',url:url_server + 'orders/getappid',data:{app_id:app_id}});
		}
	};
});

// ORDERTYPES ***
angular.module('ordertypesService',[]).factory('Ordertypes',function($http){
	return {
		getPaging:function(invoice_id){
			return $http({method:'POST',url:url_server + 'ordertypespaging',data:{invoice_id:invoice_id}});
		},
		getSelect:function(){
			return $http({method:'POST',url:url_server + 'ordertypes/getall'});
		},
		getSelect2:function(filter){
			return $http({method:'POST',url:url_server + 'ordertypes/search',data:filter});
		},
		getDataProduct:function(id, service){
			return $http({method:'POST',url:url_server + 'ordertypes/getDataProduct',data:{id:id, service:service}});
		},
		export_file_pdf:function(order_id, action, mail){
			return $http({method:'POST',url:url_server + 'ordertypes/export_file_pdf',data:{order_id:order_id, action:action, mail:mail}});
		},
		sentDataPayment:function(data){
			return $http({method:'POST',url:url_server + 'ordertypes/braintreeCreate',data:data});
		},
		insertSignature:function(order_id, data){
			return $http({method:'POST',url:url_server + 'ordertypes/insertSignature',data:{order_id:order_id, data:data}});
		},
		getSignature:function(id){
			return $http({method:'POST',url:url_server + 'ordertypes/getSignature',data:{id:id}});
		},
		insertpaymenthistories:function(data,ChargeDate, list_id){
			return $http({method:'POST',url:url_server + 'ordertypes/insertpaymenthistories',data:{list_id:list_id, data:data, ChargeDate:ChargeDate}});
		},
		check_invoice:function(order_id){
			return $http({method:'POST',url:url_server + 'ordertypes/check_invoice',data:{order_id:order_id}});
		},
		show:function(id){
			return $http.get(url_server+ 'ordertypes/'+id);
		},
		save:function(invoiceData,Discount,Subtotal,id,user_id,refund,total,duedate){
			return $http({method:'POST',
							url:url_server+'ordertypes',
							data:{invoiceData:invoiceData, Discount:Discount, Subtotal:Subtotal, id:id, user_id:user_id, refund:refund, total:total,duedate:duedate}});
		},
		update:function(id, ordertypesData){
			return $http.put(url_server+'ordertypes/'+id,ordertypesData);
		},
		destroy:function(id){
			return $http.delete(url_server + 'ordertypes/'+id);
		}
	};
});


// STATUS *****
angular.module('orderstatusesService',[]).factory('Orderstatuses',function($http){
	return {
		getPaging:function(id){
			return $http({method:'POST',url:url_server + 'orderstatusespaging',data:{id:id}});
		},
		getSelect:function(){
			return $http({method:'POST',url:url_server + 'orderstatuses/getall'});
		},
		getSelect2:function(filter){
			return $http({method:'POST',url:url_server + 'orderstatuses/search',data:filter});
		},
		getTypeOfService:function(){
			return $http({method:'POST',url:url_server + 'orderstatuses/getTypeOfService'});
		},
		getRepresentative:function(user_id, estimate_id, customer_id){
			return $http({method:'POST',url:url_server + 'orderstatuses/getRepresentative', data:{user_id:user_id, estimate_id:estimate_id, customer_id:customer_id}});
		},
		opportunitiesExport:function(order_id, name){
			return $http({method:'POST',url:url_server + 'orderstatuses/opportunitiesExport', data:{order_id:order_id, name:name}});
		},
		check_Appointment_customer:function(customer_id, appointment_id, estimate_id){
			return $http({method:'POST',url:url_server + 'orderstatuses/check_Appointment_customer', data:{customer_id:customer_id, appointment_id:appointment_id, estimate_id:estimate_id}});
		},
		getEstimateNumber:function(appointment_id){
			return $http({method:'POST',url:url_server + 'orderstatuses/getEstimateNumber', data:{appointment_id:appointment_id}});
		},
		create_task:function(mail, user_id, appointment_id,action, customer_id, link, order_id){
			return $http({method:'POST',url:url_server + 'orderstatuses/create_task', data:{order_id:order_id, link:link, user_id:user_id, mail:mail, appointment_id:appointment_id, action:action, customer_id:customer_id}});
		},
		updateComment:function(data, id){
			return $http({method:'POST',url:url_server + 'orderstatuses/updateComment', data:{data:data, id:id}});
		},
		getProducttoByname:function(name){
			return $http({method:'POST',url:url_server + 'orderstatuses/getProducttoByname', data:{name:name}});
		},
		saveMeasurements:function(id, product_id, data){
			return $http({method:'POST',url:url_server + 'orderstatuses/saveMeasurements', data:{id:id, product_id:product_id, data:data}});
		},
		show:function(id){
			return $http.get(url_server+ 'orderstatuses/'+id);
		},
		save:function(orderstatusesData){
			return $http({method:'POST',
							url:url_server+'orderstatuses',
							data:orderstatusesData});
		},
		update:function(id, orderstatusesData){
			return $http.put(url_server+'orderstatuses/'+id,orderstatusesData);
		},
		destroy:function(id){
			return $http.delete(url_server + 'orderstatuses/'+id);
		}
	};
});

