function appDashboardMenuToggle(state) {
    menuScope.renderTemplateData();
    setTimeout(function() {
        var $appDashboardMenu = $('.app-dashboard-menu');
        if (state == 'show') {
            $appDashboardMenu.addClass('show');
        } else {
            $appDashboardMenu.removeClass('show');
        }
    }, 1)
};

function openDialog(s) {
    var $popupArea = $('.popup-area');
    var loaded = $(s).hasClass('loaded');
    if (!loaded) {
        $(s).appendTo($popupArea);
        $(s).find('.dismis').click(function() {
            closeDialog(s)
        })
    }
    $popupArea.show();
    $popupArea.find(s).show();
};

function closeDialog(s) {
    var $popupArea = $('.popup-area');
    $popupArea.find(s).hide();
    $popupArea.hide();
};

function appDialogToggle(state, s) {
    var $popupArea = $('.popup-area');
    var loaded = $(s).hasClass('loaded');
    if (!loaded) {
        $(s).appendTo($popupArea);
        $(s).find('.dismis').click(function() {
            appDialogToggle('close', s);
        })
    };
    if (state == "open") {
        $popupArea.addClass('show');
        $popupArea.find(s).addClass('show');
    } else if (state == "close") {
        $popupArea.find(s).removeClass('show');
        $popupArea.removeClass('show');
    } else if (state == "change") {
        $popupArea.find('.popup').removeClass('show');
        $popupArea.find(s).addClass('show');
    }
};

function tableRowSelected(s, types) {
    if (types == 'est') {
        $(s).toggleClass('active').closest('.row-item').siblings().find('> .display').removeClass('active');
    }
    if (types == 'inv') {
        $(s).parent().toggleClass('active').closest('.row-item').siblings().find('> .display').removeClass('active');
    }
};

function googlePlace(formID, addressFieldID) {
    var addressAddEmployeee;
    var componentAddressForm = {
        locality: 'long_name',
        administrative_area_level_1: 'short_name',
        postal_code: 'short_name'
    };
    var form = document.getElementById(formID);
    initAddressAddEmployeee();
    document.getElementById(addressFieldID).onfocus = geolocateAddressAddEmployeee();

    function initAddressAddEmployeee() {
        addressAddEmployeee = new google.maps.places.Autocomplete(
            (document.getElementById(addressFieldID)), {
                types: ['geocode']
            });
        addressAddEmployeee.addListener('place_changed', fillInAddressAddEmployeee);
    };

    function fillInAddressAddEmployeee() {
        var place = addressAddEmployeee.getPlace();
        for (var component in componentAddressForm) {
            form.getElementsByClassName(component)[0].value = '';
            form.getElementsByClassName(component)[0].disabled = false;
        }
        for (var i = 0; i < place.address_components.length; i++) {
            var addressType = place.address_components[i].types[0];
            if (componentAddressForm[addressType]) {
                var val = place.address_components[i][componentAddressForm[addressType]];
                form.getElementsByClassName(addressType)[0].value = val;
            }
        }
    };

    function geolocateAddressAddEmployeee() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function(position) {
                var geolocation = {
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                };
                var circle = new google.maps.Circle({
                    center: geolocation,
                    radius: position.coords.accuracy
                });
                addressAddEmployeee.setBounds(circle.getBounds());
            });
        }
    };
};

function inputAutoGrow(element) {
    $(element).focus(function(event) {
        $(this).removeClass('nowrap');
        $(this).css({
            height: 50
        }).css({
            height: $(this).prop('scrollHeight')
        });
    });
    $(element).keyup(function() {
        $(this).css({
            height: 50
        }).css({
            height: $(this).prop('scrollHeight')
        });
    })
};

// utilities chat head
exitsObject = function($object, $callback) {
    var _values = Object.values($object);
    var _keys = Object.keys($object);
    _.each(_values, function($item, $index) {
        if (!Array.isArray($item)) {
            return $callback(false, $object[_keys[$index]] = (Boolean(Number(String($item))) || Number(String($item)) == 0) //
                ? Number($item) : $object[_keys[$index]]);
        } else {
            return $callback(true, $object[_keys[$index]]);
        }
    });
};
parseOKeyIsNumber = function($object, $within = []) {
    !Array.isArray($object) ? exitsObject($object, function(arg1, arg2) {
        arg1 ? parseOKeyIsNumber(arg2, $within) : '';
    }) : _.each($object, function($item, $index) {
        if ($item === '') {
            return false;
        }
        for (property in $item) {
            if ($within.length > 0 && $within.indexOf(property) != -1) {
                continue;
            }
            if (Boolean(Number(String($item[property]))) || Number(String($item[property])) == 0 && !Array.isArray($item[property])) {
                $item[property] = Number($item[property]);
            } else if (Array.isArray($item[property])) {
                parseOKeyIsNumber($item[property], $within);
            }
        }
        if (Boolean(Number(String($item))) || Number(String($item)) == 0) {
            $object[$index] = Number($item);
        } else if (Array.isArray($object[$index])) {
            parseOKeyIsNumber($object[$index], $within);
        }
    });
    return $object;
};