angular.module('userdetailsService', []).factory('Userdetails', function($http) {
    return {
        getlist_fieldwork: function(user_id) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'userdetails/getlist_fieldwork',
                data: { user_id: user_id },
                withCredentials: true
            });
        },
        save_lisibility: function(user_id, list_fieldwork) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'userdetails/save_lisibility',
                data: { user_id: user_id, list_fieldwork: list_fieldwork },
                withCredentials: true
            });
        },
        changeDefaultListView: function(listview_id, user_id) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'userdetails/changeDefaultListView',
                data: { user_id: user_id, listview_id: listview_id },
                withCredentials: true
            });
        },
        show: function(id) {
            return $http({
                method: 'GET',
                headers: headers,
                url: url_server + 'userdetails/' + id,
                withCredentials: true
            });
        },
        pipusGetPaging: function(filter) {
            return $http({ method: 'POST', url: url_server + 'userdetailpipuspaging', data: filter, withCredentials: true ,headers: headers});
        },
        exportPipus: function(pipus) {
            return $http({ method: 'POST', url: url_server + 'userdetails/exportpipus', data: pipus, withCredentials: true ,headers: headers});
        },
        fileManager: function() {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'fileManager',
                withCredentials: true
            });
        },
        loadUserlogs: function(id) {
            return $http.get(url_server + 'userdetailloadlog/' + id, { withCredentials: true ,headers: headers});
        },
        addIssueLog: function(userdetailsData) {
            return $http({
                method: 'POST',
                url: url_server + 'userdetailsaddlog',
                data: userdetailsData,
                withCredentials: true,
                headers: headers
            });
        },
        updateIssueLog: function(id, userdetailsData) {
            return $http.put(url_server + 'userdetails/updateissuelog/' + id, userdetailsData, { withCredentials: true ,headers: headers});
        },
        deleteLogIssue: function(id) {
            return $http.delete(url_server + 'userslogs/' + id, { withCredentials: true ,headers: headers});
        },
        getDataIssueLogById: function(id) {
            return $http.get(url_server + 'userdetails/getdataissuelog/' + id, { withCredentials: true ,headers: headers});
        },
        getDefaultSchedule: function(user_id) {
            return $http({ method: 'POST', url: url_server + 'userdetails/getDefaultSchedule', data: { user_id: user_id }, withCredentials: true ,headers: headers});
        },
        updateDefaultSchedule: function(data) {
            return $http({ method: 'POST', url: url_server + 'userdetails/updateDefaultSchedule', data: { data: data }, withCredentials: true ,headers: headers});
        },
        getListFile: function(data) {
            return $http({ method: 'POST', url: url_server + 'userdetails/getListFile', data: data, withCredentials: true ,headers: headers});
        },
        executeObject: function(data) {
            return $http({ method: 'POST', url: url_server + 'userdetails/executeObject', data: data, withCredentials: true ,headers: headers});
        }

    };
});
