var page = "users.html";
var userApp = angular.module('userApp', ['menuController', 'ionic','notifiesCtrl' ,'chatApp', 'ivh.treeview', 'ngSanitize','LocationServiceModulues','ngTagsInput','ionic-color-picker'])
.config(['$compileProvider',
    function ($compileProvider) {
        $compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|file|tel|mailto):/);
    }
]).run(['$rootScope',
    function ($rootScope) {
        $rootScope.scoped = {
            format: 'HH:mm:ss'
        };
        $rootScope.vm = {
            datetime: '05/13/2011 6:30 AM'
        }
    }
]);
userApp.run(function ($ionicPlatform, $ionicLoading) {
    $ionicLoading.show({ template: templateLoading });
    $ionicPlatform.ready(function () {
        var devicePlatform = "";
        try { devicePlatform = device.platform; } catch (err) { console.log(err) }
        if (devicePlatform != "iPhone" && devicePlatform != "iOS") {
            // $scope.deviceLoading = "ios";
            isiOs = false;
        } 
        // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
        // for form inputs)
        if (window.cordova && window.cordova.plugins.Keyboard) {
            cordova.plugins.Keyboard.hideKeyboardAccessoryBar(false);
            cordova.plugins.Keyboard.disableScroll(true);
        }
        if (window.StatusBar) {
            // org.apache.cordova.statusbar required
            // StatusBar.styleDefault();
            StatusBar.show();
            StatusBar.backgroundColorByHexString("#327EBB");
            StatusBar.styleLightContent();
            //StatusBar.hide();
            StatusBar.overlaysWebView(false);
        }
    });
});
userApp.config(function ($stateProvider, $urlRouterProvider) {
    $stateProvider
    /*/////////////////////// USERS ///////////////////////////*/
        .state('dashboard', {
            url: '/board',
            abstract: true,
            templateUrl: 'templates/dashboard/general/menu.html',
            controller: 'menuCtrl'
        }).state('dashboard.users', { //form userDetail to user for edit user
            url: '/users',
            views: {
                'menuContent': {
                    templateUrl: 'templates/dashboard/users/users/users.tpl',
                    controller: 'userCtrl'
                }
            }
        }).state('dashboard.notifies', { 
            url: '/notifies',
            views: {
                'notifiesContent': {
                    templateUrl: 'templates/dashboard/notifies/notifies.tpl',
                    controller: 'notifiesCtrl'
                }
            }
        })

    // if none of the above states are matched, use this as the fallback
    $urlRouterProvider.when("/board/notifies", "/dashboard/notifies");
      
    $urlRouterProvider.otherwise('/board/users');
});
