angular.module('appointmentsService', []).factory('Appointments', function($http, $cordovaFileTransfer,$ionicLoading) {

    return {
        getPaging: function(filter) {
            return $http({
                method: 'POST',
                url: url_server + 'appointmentspaging',
                data: filter
            });
        },
        getCriteria:function(){
            return $http.get(url_server+ 'settingsloadcriteria',{headers: headers,withCredentials: true});
        },
        getListToSchedule: function(filter) {

            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'appointments/getlisttochedule',
                data: filter,
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'appointments/getlisttochedule',data:filter});
        },
        getAppoinmentByDay: function(filter) {

            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'appointments/getappoinmentbyday',
                data: filter,
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'appointments/getappoinmentbyday',data:filter});
        },
        checkReloadCalendar: function(filter) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/checkreloadcalendar',
                data: filter
            });
        },
        getSelect: function() {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/getall'
            });
        },
        getSelect2: function(filter) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/search',
                data: filter
            });
        },
        getAppointmentType: function(search) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/getAppointmentType',
                data: {
                    search: search
                }
            });
        },
        searchAppointment: function(filter) {
         return $http({
            method: 'POST',
            headers: headers,
            url: url_server + 'appointments/searchappointment',
            data: filter,
            withCredentials: true
        });
            // return $http({
            //     method: 'POST',
            //     url: url_server + 'appointments/searchappointment',
            //     data: filter
            // });
        },
        checkappointment_id: function(appointment_id) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/checkappointment_id',
                data: {
                    appointment_id: appointment_id
                }
            });
        },
        appointmentshistory: function(id) {
            return $http.get(url_server + 'appointmentshistory/' + id);
        },
        show: function(id) {

            return $http({
                method: 'GET',
                headers: headers,
                url: url_server + 'appointments/' + id,
                withCredentials: true
            });
            // return $http.get(url_server+ 'appointments/'+id);
        },
        getDataHoverAppCell: function(id) {
            return $http.get(url_server + 'appointmentcellhover/' + id);
        },
        viewUnavailable: function(val) {
            return $http.get(url_server + 'appointments/viewunavailable/' + val);
        },
        showDataToSchedule: function(id) {
            //return $http.get(url_server + 'appointments/getdatatoschedule/' + id);
            return $http({
                method: 'GET',
                url: url_server + 'appointments/getdatatoschedule/' + id,
                headers:headers,
                withCredentials: true
            });
        },
        save: function(appointmentsData) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments',
                data: appointmentsData,
                headers:headers,
                withCredentials: true
            });
        },
        getZillow: function(data) {

            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'appointments/zillow',
                data: data,
                withCredentials: true
            });
            // return $http({method:'POST',
            // 				url:url_server+'appointments/zillow',
            // 				data:data});
        },
        update: function(id, appointmentsData) {

            return $http.put(url_server + 'appointments/' + id, appointmentsData, {
                headers: headers,
                withCredentials: true
            });
            // return $http.put(url_server+'appointments/'+id,appointmentsData);
        },
        assignToNewFieldworker: function(id, appointmentsData) {
            return $http.put(url_server + 'appointments/assigntonewfieldworker/' + id, appointmentsData);
        },
        checkInAppoimentGroup: function(id, appointmentsData) {
            return $http.put(url_server + 'appointments/checkinappoimentgroup/' + id, {
                appointmentgroupsId: appointmentsData
            });
        },
        cancelAndRedoAppoiment: function(appoinmentId, currentStatus) {
            return $http.put(url_server+'appointments/cancelandredoappoiment/'+appoinmentId,{currentStatus: currentStatus}, {
                headers:headers, withCredentials: true });
            
            // return $http.put(url_server + 'appointments/cancelandredoappoiment/' + appoinmentId, {
            //     currentStatus: currentStatus
            // });
        },
        checkAppoimentIsPending: function(id) {
            return $http.put(url_server + 'appointments/checkappoimentispending/' + id);
        },
        appointmentCellChange: function(id, appointmentsData) {
            return $http.put(url_server + 'appointments/cellchange/' + id, appointmentsData,{headers: headers,withCredentials: true});
        },
        arrivalConfirm: function(id, appointmentsData) {
            return $http.put(url_server + 'appointments/arrivalconfirm/' + id, appointmentsData);
        },
        destroy: function(id) {
            return $http.delete(url_server + 'appointments/' + id);
        },
        upLoadFileMan: function($oData, $oFile) {    
            // return $http({
            //     method: 'POST',
            //     headers: headers,
            //     url: url_server + 'appointments/upLoadFileMan',
            //     data: {
            //         fields: $oData,
            //         file: $oFile
            //     },
            //     withCredentials: true
            // });
            // return Upload.upload({url: url_server+'appointments/upLoadFileMan', fields: $oData, file: $oFile});
        },
        AddEditWorkingInvoice:function(appointment_id, order_id){
            return $http({method:'POST',
                url:url_server+'appointments/AddEditWorkingInvoice',
                data:{appointment_id:appointment_id, order_id:order_id},
                headers: headers,
                withCredentials: true
            });
        },
        showDowntimeTask: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/showdowntimetask',
                data: data,
                headers: headers,
                withCredentials: true
            });
        },
        replaceNewAddress: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/replacenewaddress',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        updateFlagNote: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/updateflagnote',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        sendMail: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/sendmailtocustomer',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        saveAndLoadOfficeNote: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/saveandloadofficenote',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        saveAndLoadFieldWorkerNote: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/saveandloadfieldworkernote',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        updateAppointmentInfor: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/updateappointmentinfor',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        getAppHistoryDetailByAppId: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/getapphistorydetailbyappid',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        }
        ,
        getAllEstimateInvoiceId: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/getallestimateinvoiceid',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        createPdfOrderByOrderId: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/createpdforderbyorderid',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        }
    };
});
