var page = "scheduleapp.html";
var scheduleApp = angular.module('scheduleApp', ['AppointmentsController', 'menuController', //
    'appointmentsService', 'listviewusersService', 'appointmentstatusesService', 'jobsitesService', //
    'notetasksCtrl', 'notetasksService', 'notetasktypesService', 'ngSanitize', //
    'ivh.treeview', 'doubleTap', 'customersService', 'callaheadsService', //
    'customertypesService', 'flexiblecustomersService', 'flagsService', 'leadsourcesService', 'opportunitiesService', //
    'groupsService', 'tasksService', 'ordertypesService', 'ordersService', 'orderstatusesService', //
    'notifiesCtrl', 
    'soundsService',
    'chatsettingsService',
    'userchatstatusesService','chatApp',
    'checklistController', 'checklistsService', 'servicesService', 'appointmentchecklistsService', 'customerfilesService',//
    'ngTagsInput','LocationServiceModulues'
]);


scheduleApp.run(function ($ionicPlatform, $ionicLoading) {
    $ionicLoading.show({ template: templateLoading });
    $ionicPlatform.ready(function () {
        var devicePlatform = "";
        try { devicePlatform = device.platform; } catch (err) { console.log(err) }
        if (devicePlatform != "iPhone" && devicePlatform != "iOS") {
            // $scope.deviceLoading = "ios";
            isiOs = false;
        }
        // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
        // for form inputs)
        if (window.cordova && window.cordova.plugins.Keyboard) {
            cordova.plugins.Keyboard.hideKeyboardAccessoryBar(false);
            cordova.plugins.Keyboard.disableScroll(true);
        }
        if (window.StatusBar) {
            // org.apache.cordova.statusbar required
            // StatusBar.styleDefault();
            StatusBar.show();
            StatusBar.backgroundColorByHexString("#327EBB");
            StatusBar.styleLightContent();
            //StatusBar.hide();
            StatusBar.overlaysWebView(false);
        }
    });
})

scheduleApp.config(function ($stateProvider, $urlRouterProvider, $sceDelegateProvider) {
    $sceDelegateProvider.resourceUrlWhitelist(['self', url_site + '/']);
    $stateProvider.state('dashboard', {
        url: '/board',
        abstract: true,
        templateUrl: 'templates/dashboard/general/menu.html',
        controller: 'menuCtrl'
    }).state('dashboard.schedule', {
        url: '/schedule',
        views: {
            'menuContent': {
                templateUrl: 'templates/dashboard/schedules/schedule.tpl',
                controller: 'scheduleCtrl'
            }
        }
    })
    $urlRouterProvider.otherwise('/board/schedule');
});
scheduleApp.directive('datetimepickerDirective', function () {
    return {
        restrict: 'AE',
        transclude: true,
        link: function (scope, elm, attr, ngModel) {
            var model = attr.directiveModel;
            scope.$watch(model, function (value) {
                // console.log(value);
                // console.log(arguments);
                elm.datetimepicker('reset');
                elm.datetimepicker('destroy');
                elm.datetimepicker({
                    inline: true,
                    timepicker: false,
                    format: 'YYYY-MM-DD',
                    formatDate: 'YYYY-MM-DD',
                    defaultDate: value,
                    onChangeDateTime: function (dp, $th) {
                        var selectedDay = moment(dp).format('YYYY-MM-DD');
                        scope.loadAppointmentByDay(selectedDay);
                    }
                });
            })
        }
    }
});
// for time
scheduleApp.directive('timeValidate', function ($cordovaToast) {
    return {
        require: "?ngModel",
        restrict: 'A',
        transclude: true,
        link: function (scope, elm, attr, ngModel) {
            var minTime = attr.mintime != undefined ? moment(attr.mintime, 'hh:mmA').format('HH:mm') : '00:00';
            var maxTime = attr.maxtime != undefined ? moment(attr.maxtime, 'hh:mmA').format('HH:mm') : '24:00';
            var target = attr.target;
            var model = attr.ngModel;
            var inputTime = '';
            scope.$watch(model, function (value) {
                if (value == '' || $(target).val() == '') return;
                if (moment(value).isValid()) {
                    inputTime = moment(value).format('hh:mmA');
                    inputTime = moment(inputTime, 'hh:mmA').format('HH:mm');
                } else {
                    inputTime = moment(value, 'hh:mmA').format('HH:mm');
                }
                console.log(minTime, inputTime, maxTime);
                if (inputTime < minTime || inputTime > maxTime) {
                    ngModel.$setViewValue(''); //set data to ng-model ****importart
                    $cordovaToast.showLongTop('The appointment cannot be scheduled outside 6AM - 10PM');
                }
            })
        }
    }
});
// for date
// scheduleApp.directive('dateValidate', function($cordovaToast) {
//     return {
//         require: "?ngModel",
//         restrict: 'A',
//         transclude: true,
//         link: function(scope, elm, attr, ngModel) {
//             var model = attr.dateValidate;
//             scope.$watch(model, function(value) {
//                 // console.log(value);
//                 if (value == '' || value == undefined) return;
//                 if (moment(value).isValid()) {
//                     var endDateValue = moment(value).add(1, 'days').format(conFig.formatDate.toUpperCase());
//                     scope.toDate = endDateValue;
//                 }
//             })
//         }
//     }
// });

