angular.module('paymenthistoriesService', []).factory('Paymenthistories', function($http) {
    return {
        getPaging: function(filter) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'paymenthistoriespaging',
                data: filter,
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'paymenthistoriespaging',data:filter});
        },
        getSelect: function() {
            return $http({ method: 'POST', url: url_server + 'paymenthistories/getall' });
        },
        getSelect2: function(filter) {
            return $http({ method: 'POST', url: url_server + 'paymenthistories/search', data: filter });
        },
        exportPaymenthistories: function(data) {
            return $http({ method: 'POST', url: url_server + 'paymenthistories/exportPaymenthistories', data: data });
        },
        show: function(id) {
            return $http({
                method: 'GET',
                headers: headers,
                url: url_server + 'paymenthistories/' + id,
                withCredentials: true
            });
            // return $http.get(url_server+ 'paymenthistories/'+id);
        },
        save: function(id, data) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'paymenthistories',
                data: { id: id, data: data },
                withCredentials: true
            });
            // return $http({method:'POST',
            // 				url:url_server+'paymenthistories',
            // 				data:{id:id, data:data}});
        },
        update: function(id, paymenthistoriesData) {
            return $http.put(url_server + 'paymenthistories/' + id, paymenthistoriesData, { headers: headers, withCredentials: true });

            // return $http.put(url_server+'paymenthistories/'+id,paymenthistoriesData);
        },
        destroy: function(id) {
            return $http.delete(url_server + 'paymenthistories/' + id, { headers: headers, withCredentials: true });
            // return $http.delete(url_server + 'paymenthistories/' + id);
        },
        filter:function(data){
            return $http({method:'POST',url:url_server + 'paymenthistories/filter',data:data ,withCredentials: true});
        },
        searchPaymentStatus:function(data){
            return $http({method:'POST',url:url_server + 'paymenthistories/searchpaymentstatus',data:data,withCredentials: true});
        },
        getEstimateInvoice:function(data){
            return $http({method:'POST',url:url_server + 'paymenthistories/getestimateinvoice',data:data,withCredentials: true});
        },
        getDataPaymentNoteByOrderId:function(id){
            return $http({
                method: 'GET',
                headers: headers,
                url: url_server+ 'getdatapaymentnotebyorderid/'+id,
                withCredentials: true
            });
        },
        getPaymentStatus:function(){
            return $http({method:'POST',url:url_server + 'paymenthistories/getpaymentstatus',withCredentials: true});
        },
        viewInvoiceEstimateLog:function(id,type){
             return $http({
                method: 'GET',
                headers: headers,
                url: url_server+ 'viewinvoiceestimatelog/'+id+'/'+type,
                withCredentials: true
            });
        },
        savePaymentNote:function(filter){
            return $http({method:'POST',url:url_server + 'paymenthistories/savepaymentnote',data:filter,withCredentials: true});
        }
    };
});
