var page = "map.html";
var mapApp = angular.module('mapApp', ['ionic', 'menuController', 'ngCordova', 'authenticationSvc', 'chatController','notifiesCtrl',
    'authenticationSvc', 'ngSanitize', 'ivh.treeview', 'MapService', 'AppointmentsController', 'appointmentsService', 'appointmentstatusesService',
    'customersService', 'callaheadsService', 'customertypesService', 'flexiblecustomersService', 'jobsitesService', 'listviewusersService', 'flagsService',
    'leadsourcesService', 'opportunitiesService', 'groupsService', 'tasksService', 'ordersService', 'ordertypesService', 'orderstatusesService',
    'checklistController', 'checklistsService', 'customerfilesService', 'appointmentchecklistsService', 'servicesService', 'doubleTap','ngTagsInput',
    'soundsService','chatsettingsService','userchatstatusesService','chatApp']);
mapApp.run(function ($ionicPlatform) {
    $ionicPlatform.ready(function () {
        var devicePlatform = "";
        try {
            devicePlatform = device.platform;
        } catch (err) {
            console.log(err)
        }
        if (devicePlatform != "iPhone" && devicePlatform != "iOS") {
            // $scope.deviceLoading = "ios";
            isiOs = false;
        }
        // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
        // for form inputs)
        if (window.cordova && window.cordova.plugins.Keyboard) {
            cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
            cordova.plugins.Keyboard.disableScroll(true);
        }
        if (window.StatusBar) {
            // org.apache.cordova.statusbar required
            //StatusBar.styleDefault();
            StatusBar.show();
            StatusBar.backgroundColorByHexString("#327EBB");
            StatusBar.styleLightContent();
            //StatusBar.hide();
            StatusBar.overlaysWebView(false);
        }
    });
})

mapApp.config(function ($stateProvider, $urlRouterProvider) {
    $stateProvider

      .state('dashboard', {
          url: '/board',
          abstract: true,
          templateUrl: 'templates/dashboard/general/menu.html',
          controller: 'menuCtrl'
      })

            .state('dashboard.map', {
                url: '/map',
                views: {
                    'menuContent': {
                        templateUrl: 'templates/dashboard/map/map.html',
                        controller: 'mapCtrl'
                    }
                }
            })

    // if none of the above states are matched, use this as the fallback
    $urlRouterProvider.otherwise('/board/map');
});

mapApp.directive('sglclick', ['$parse', function ($parse) {
    return {
        restrict: 'A',
        link: function (scope, element, attr) {
            var fn = $parse(attr['sglclick']);
            var delay = 300, clicks = 0, timer = null;
            element.on('click', function (event) {
                clicks++;  //count clicks
                if (clicks === 1) {
                    timer = setTimeout(function () {
                        scope.$apply(function () {
                            fn(scope, { $event: event });
                        });
                        clicks = 0;             //after action performed, reset counter
                    }, delay);
                } else {
                    clearTimeout(timer);    //prevent single-click action
                    clicks = 0;             //after action performed, reset counter
                }
            });
        }
    };
}])
