angular.module('customersService', []).factory('Customers', function($http) {
  customer_id = 0;
  return {
    getPaging: function(filter) {
      return $http({
        method: 'POST',
        headers: headers,
        url: url_server + 'customerspaging',
        data: filter,
        withCredentials: true
      });
    },
    getSelect: function() {
      return $http({
        method: 'POST',
        headers: headers,
        url: url_server + 'customers/getall',
        withCredentials: true
      });
    },
    getaddress: function() {
      return $http({ method: 'POST', url: url_server + 'customers/getaddress' });
    },
    getReffereds: function(filter) {
      return $http({
        method: 'POST',
        headers: headers,
        url: url_server + 'customers/searchreffered',
        data: filter,
        withCredentials: true
      });
    },
    getcustomer_note: function(id) {
      return $http({ method: 'POST', url: url_server + 'customers/getcustomer_note', data: { id: id }, headers: headers, withCredentials: true });
    },
    edit_customer_note: function(id, note) {
      return $http({ method: 'POST', withCredentials: true, url: url_server + 'customers/edit_customer_note', data: { id: id, note: note }, headers: headers, withCredentials: true });
    },
    getSelect2: function(filter) {
      return $http({ method: 'POST', url: url_server + 'customers/search', data: filter, headers: headers, withCredentials: true });
    },
    show: function(id) {
      return $http({
        method: 'GET',
        headers: headers,
        url: url_server + 'customers/' + id,
        withCredentials: true
      });
      // return $http.get(url_server+ 'customers/'+id);
    },
    getByPhone: function(email) {
      return $http({ method: 'GET', url: url_server + 'customers/getbyphone/' + email, headers: headers, withCredentials: true });
    },
    getById: function(id) {
      return $http({ method: 'GET', url: url_server + 'customers/getbyid/' + id, headers: headers, withCredentials: true });
    },
    showDetail: function(id) {
      return $http({
        method: 'GET',
        headers: headers,
        url: url_server + 'customerdetails/' + id,
        withCredentials: true
      });
      // return $http.get(url_server+ 'customerdetails/'+id);
    },
    loadJobsiteByCustomerId: function(filter) {
      return $http({ method: 'POST', url: url_server + 'customers/loadjobsitebycustomerid', data: filter, headers: headers, withCredentials: true });
    },
    addJobsite: function(filter) {
      return $http({ method: 'POST', url: url_server + 'customers/addjobsite', data: filter, headers: headers, withCredentials: true });
    },
    getJobsiteById: function(id) {
      return $http({
        method: 'GET',
        headers: headers,
        url: url_server + 'customers/getjobsitebyid/' + id,
        withCredentials: true
      });
    },
    updateJobsite: function(data) {
      return $http({ method: 'POST', url: url_server + 'customers/updatejobsite', data: data, headers: headers, withCredentials: true });
    },
    activeAndInactiveJobsite: function(id, status) {
      return $http({
        method: 'PUT',
        url: url_server + 'customers/activeandinactivejobsite/' + id,
        data: { status: status },
        withCredentials: true,
        headers: headers,
      });
    },
    changeJobsite: function(id, customersId) {
      return $http({
        method: 'POST',
        url: url_server + 'customers/changeJobsite',
        data: { id: id, customersId: customersId },
        withCredentials: true,
        headers: headers
      });
    },
    changeJobsiteOnAppHistory: function(id, customersId) {
      // return $http.get(url_server+ 'changeJobsite/'+id, data:{customersId:customersId});
      return $http({
        method: 'POST',
        url: url_server + 'customers/changejobsiteonapphistory',
        data: { id: id, customersId: customersId },
        withCredentials: true,
        headers: headers
      });
    },
    getappointmenthistory: function(id) {
      return $http({
        method: 'GET',
        headers: headers,
        url: url_server + 'getappointmenthistory/' + id,
        withCredentials: true
      });
      // return $http.get(url_server+ 'getappointmenthistory/'+id);
    },
    save: function(customersData) {
      return $http({
        method: 'POST',
        headers: headers,
        url: url_server + 'customers',
        data: customersData,
        withCredentials: true
      });

    },
    exportCustomers: function(data) {
      return $http({
        method: 'POST',
        url: url_server + 'customers/export',
        data: data,
        withCredentials: true,
        headers: headers
      });
    },
    exportfilterCustomers: function(data, curentpage) {
      return $http({
        method: 'POST',
        url: url_server + 'customers/exportfilter',
        data: { data: data, curentpage: curentpage },
        withCredentials: true,
        headers: headers
      });
    },
    update: function(id, customersData) {
      return $http.put(url_server + 'customers/' + id, customersData, {
        headers: headers,
        withCredentials: true
      });

      // return $http.put(url_server+'customers/'+id,customersData);
    },
    getcustomerqueries: function(data) {
      return $http({
        method: 'POST',
        url: url_server + 'customers/getqueries',
        withCredentials: true,
        headers: headers
      });
    },
    activeAndInactiveUser: function(id, status) {
      return $http.put(url_server + 'customers/activeAndInactive/' + id, { status: status }, { withCredentials: true ,headers: headers});
    },
    destroy: function(id) {
      return $http.delete(url_server + 'customers/' + id);
    },

    getCustomerId: function() {
      return customer_id;
    },
    setCustomerId: function(value) {
      customer_id = value;
    },
    getcustomerOpportunityAction: function(filter) {
      return $http({ method: 'POST', url: url_server + 'customers/getcustomerOpportunityAction', headers: headers, data: filter, withCredentials: true });
    },
    makePrimary: function(data) {
      return $http({
        method: 'POST',
        url: url_server + 'customers/makeprimary',
        data: data,
        withCredentials: true,
        headers: headers
      });
    },
    getAppointmentType: function() {
      return $http({ method: 'POST', url: url_server + 'appointmentgroups/getall', withCredentials: true ,headers: headers});
    },
    getCompanyName: function(filter) {
      return $http({ method: 'POST', url: url_server + 'customers/searchcompanyname', data: filter, withCredentials: true,headers: headers });
    },
    filter: function(data) {
      return $http({
        method: 'POST',
        url: url_server + 'customers/filter',
        data: data,
        withCredentials: true,
        headers: headers
      });
    },
    getDataFilterOpportunities: function(filter) {
      return $http({ method: 'POST', url: url_server + 'opportunities/getdatafilteropportunities', data: filter, withCredentials: true ,headers: headers});
    },
    checkAdditionalPhone: function(id, phones) {
      return $http({ method: 'POST', url: url_server + 'customers/checkAdditionalPhone', data: { id: id, phones: phones }, withCredentials: true , headers: headers});
    },
    deleteFlagNote: function(data) {
      return $http({
        method: 'POST',
        url: url_server + 'appointments/deleteflagnote',
        data: data,
        withCredentials: true,
        headers: headers,
      });
    },
    rotateImage: function(filter) {
      return $http({ withCredentials: true, headers: headers, method: 'POST', url: url_server + 'customers/rotateimage', data: filter });
    },
    jobsiteByCustomerId: function(id) {
      return $http({
        method: 'GET',
        headers: headers,
        url: url_server + 'customersjobsite/' + id,
        withCredentials: true
      });
    },
    loadCreditCard: function(data) {
      return $http({
        method: 'POST',
        url: url_server + 'customers/loadcreditcard',
        data: data,
        withCredentials: true,
        headers: headers,
      });
    },
    addCreditCard: function(data) {
      return $http({
        method: 'POST',
        url: url_server + 'customers/addcreditcard',
        data: data,
        withCredentials: true,
        headers: headers,
      });
    },
    getDataCreditCard: function(id) {
      return $http({
        method: 'GET',
        headers: headers,
        url: url_server + 'customers/getdatacreditcard/' + id,
        withCredentials: true
      });
    },
    updateCreditCard: function(data) {
      return $http({
        method: 'POST',
        url: url_server + 'customers/updatecreditcard',
        data: data,
        withCredentials: true,
        headers: headers,
      });
    },
    deleteCreditCard: function(id) {
      return $http({
        method: 'PUT',
        url: url_server + 'customers/deletecreditcard/' + id,
        withCredentials: true,
        headers: headers,
      });
    },
    jobsiteById: function(id) {
      return $http({
        method: 'GET',
        url: url_server + 'jobsitebyid/' + id,
        withCredentials: true,
        headers: headers,
      });
    },
    createInstoreCredit: function(data) {
      return $http({
        method: 'POST',
        url: url_server + 'customers/createInstoreCredit',
        data: data,
        withCredentials: true,
        headers: headers,
      });
    },
    showInstoreCredit: function(id) {
      return $http({
        method: 'GET',
        url: url_server + 'customers/showinstorecredit/' + id,
        withCredentials: true,
        headers: headers,
      });
    },
    updateInstoreCredit: function(id, data) {
      return $http({
        method: 'PUT',
        url: url_server + 'customers/updateinstorecredit/' + id,
        data: data,
        withCredentials: true,
        headers: headers,
      });
    },
    deleteInstoreCredit: function(id) {
      return $http({
        method: 'DELETE',
        url: url_server + 'customers/deleteinstorecredit/' + id,
        withCredentials: true,
        headers: headers,
      });
    }
  }

});

angular.module('customeraddressesService', []).factory('Customeraddresses', function($http) {
  return {
    getPaging: function(filter) {
      return $http({ method: 'POST', url: url_server + 'customeraddressespaging', data: filter });
    },
    getSelect: function() {
      return $http({ method: 'POST', url: url_server + 'customeraddresses/getall' });
    },
    getSelect2: function(filter) {
      return $http({ method: 'POST', url: url_server + 'customeraddresses/search', data: filter });
    },
    show: function(id) {
      return $http.get(url_server + 'customeraddresses/' + id);
    },
    save: function(customeraddressesData) {
      return $http({
        method: 'POST',
        url: url_server + 'customeraddresses',
        data: customeraddressesData
      });
    },
    update: function(id, customeraddressesData) {
      return $http.put(url_server + 'customeraddresses/' + id, customeraddressesData);
    },
    destroy: function(id) {
      return $http.delete(url_server + 'customeraddresses/' + id);
    }
  };
});

angular.module('customertypesService', []).factory('Customertypes', function($http) {
  return {
    getSelect: function() {
      return $http({ method: 'POST', url: url_server + 'customertypes/getall', headers: headers, withCredentials: true });
    }
  };
});
angular.module('customereviewsService', []).factory('Customereviews', function($http) {
  return {
    getPaging: function(filter) {
      return $http({ method: 'POST', url: url_server + 'customereviewspaging', data: filter, withCredentials: true , headers: headers});
    },
    getSelect: function() {
      return $http({ method: 'POST', url: url_server + 'customereviews/getall' });
    },
    getSelect2: function(filter) {
      return $http({ method: 'POST', url: url_server + 'customereviews/search', data: filter });
    },
    show: function(id) {
      return $http.get(url_server + 'customereviews/' + id, { withCredentials: true , headers: headers});
    },
    save: function(customereviewsData) {
      return $http({
        method: 'POST',
        url: url_server + 'customereviews',
        data: customereviewsData,
        withCredentials: true,
        headers: headers
      });
    },
    update: function(id, customereviewsData) {
      return $http.put(url_server + 'customereviews/' + id, customereviewsData, { withCredentials: true , headers: headers});
    },
    destroy: function(id) {
      return $http.delete(url_server + 'customereviews/' + id, { withCredentials: true , headers: headers});
    }
  };
});
angular.module('customerfilesService', []).factory('Customerfiles', function($http) {
  return {
    zipFilesAndDownload: function(data) {
      return $http({
        method: 'POST',
        url: url_server + 'appointments/download',
        data: data,
        withCredentials: true,
        headers: headers
      });
    },
    deleteFile: function(data) {
      return $http({
        method: 'POST',
        url: url_server + 'customerfiles/deletefile',
        data: data,
        withCredentials: true,
        headers: headers
      });
    },
    getNameFile: function(data) {
      return $http({
        method: 'POST',
        url: url_server + 'customerfiles/getnamefile',
        data: data,
        withCredentials: true,
        headers: headers
      });
    },
    reName: function(data) {
      return $http({
        method: 'POST',
        url: url_server + 'customerfiles/rename',
        data: data,
        withCredentials: true,
        headers: headers
      });
    }
  };
});
