<?php global $theme_options;
get_header();

$post = get_post();
setup_postdata($post);
$service = get_post( 100 );
?>
<!-- START BREADCRUMB -->
<div id="breadcrumb" style="background-image: url('<?=get_field( 'background_breadcrumb', $service->ID )['url']?>')">
	<div class="container">
		<div class="mb-4">
			<h2 class="head-after"><?=wp_strip_all_tags( get_the_title() )?></h2>
		</div>
		<nav>
			<ol>
				<li class="breadcrumb-item">
					<a href="<?=get_home_url()?>"><i class="mdi mdi-home"></i> <?=pll_e('page-home')?></a>
				</li>
				<li class="breadcrumb-item">
					<a href="<?=get_permalink($service)?>"><?=wp_strip_all_tags( get_the_title($service) )?></a>
				</li>
				<li class="breadcrumb-item active">
					<?=wp_strip_all_tags( get_the_title() )?>
				</li>
			</ol>
		</nav>
	</div>
</div>
<!-- END BREADCRUMB -->
<!-- START LATEST NEWS -->
<div id="latest-news">
	<div class="container">
		<div class="row">
			<!-- Latest News -->
			<div class="col-lg-9">
				<div class="introl">
					<h5 class="head-after mb-4"><?=get_the_title()?></h5>
					<p><?=get_the_excerpt()?></p>
				</div>
				<div class="content">
					<?=get_the_content()?>
				</div>
			</div>
			<div class="col-lg-3">
				<!-- New Post -->
				<div class="mb-4 new-post">
					<div class="mb-4">
						<h5 class="head-after">
							<?=pll_e('relate-service')?>
						</h5>
					</div>
					<?=latest( 10, 'service', $post->ID)?>
				</div>
			</div>
		</div>
	</div>
</div>
<!-- END LATEST NEWS -->
<!-- START GET SOLUTIONS -->
<?=getSolutions( $post )?>
<!-- END GET SOLUTIONS -->
<!-- START CLIENTS -->
<?=getClients( $post )?>
<!-- END CLIENTS -->

<?php get_footer(); ?>