<?php
global $theme_options;
get_header();

$news = get_post( 231 );
?>

<!-- START BREADCRUMB -->
<div id="breadcrumb" style="background-image: url('<?=get_field( 'background_breadcrumb', $news->ID )['url']?>')">
	<div class="container">
		<div class="mb-4">
			<h2 class="head-after"><?=wp_strip_all_tags( single_tag_title() )?></h2>
		</div>
		<nav>
			<ol>
				<li class="breadcrumb-item">
					<a href="<?=get_home_url()?>"><i class="mdi mdi-home"></i> <?=pll_e('page-home')?></a>
				</li>
				<li class="breadcrumb-item">
					<a href="<?=get_permalink($news)?>"><?=wp_strip_all_tags( get_the_title($news) )?></a>
				</li>
				<li class="breadcrumb-item active">
					<?=wp_strip_all_tags( single_tag_title() )?>
				</li>
			</ol>
		</nav>
	</div>
</div>
<!-- END BREADCRUMB -->
<!-- START LATEST NEWS -->
<div id="latest-news">
	<div class="container">
		<div class="row">
			<!-- Latest News -->
			<div class="col-lg-12">
				<div class="text-center mb-5">
					<h5 class="head-after mb-4"><?=get_field( 'title', $news->ID )?></h5>
					<p style="text-align: center;"><?=get_field( 'sub', $news->ID )?></p>
				</div>
			</div>
			<?php $args = array(
				'post_type'=> 'news',
				'post_status' => 'publish',
				'orderby'    => 'ID',
				'order'    => 'DESC',
				'posts_per_page' => get_option( 'posts_per_page' ),
				'paged' =>  get_query_var( 'paged' ),
				'tag' => get_query_var('tag')
			);
			$result = new WP_Query( $args );
			if ( $result-> have_posts() ) :
			while ( $result->have_posts() ) : $result->the_post(); ?>
			<div class="col-lg-4">
				<div class="news-img">
					<img alt="" class="w-100" src="<?=get_the_post_thumbnail_url()?>"/>
				</div>
				<div class="card p-3">
					<ul>
						<li>
							<a href="#">
								<i class="mdi mdi-account mdi-24px"></i> <?=get_author_name()?>
							</a>
						</li>
						<li>
							<a href="#">
								<i class="mdi mdi-calendar-month-outline mdi-24px"></i> <?=get_the_date()?>
							</a>
						</li>
					</ul>
					<h4>
						<a href="<?=get_post_permalink()?>"><?=get_the_title()?></a>
					</h4>
					<p><?=get_the_excerpt()?></p>
					<div class="news-btn">
						<a class="btn btn-border" href="<?=get_post_permalink()?>"><?=pll_e('view-detail')?></a>
					</div>
				</div>
			</div>
			<?php endwhile;
			endif; ?>
			
			<!-- Pagination -->
			<div class="col-lg-12">
				<div class="pagination-btn text-center mt-4">
					<nav>
						<?=custom_paginate_links( array(
							'base' => str_replace( PHP_INT_MAX, '%#%', esc_url( get_pagenum_link( PHP_INT_MAX ) ) ),
							'total' => $result->max_num_pages,
							'current' => max( 1, get_query_var( 'paged' ) ),
							'prev_next' => true,
							'type' => 'list'
						));?>
					</nav>
				</div>
			</div>
		</div>
	</div>
</div>
<!-- END LATEST NEWS -->
<!-- START GET SOLUTIONS -->
<?=getSolutions( $post )?>
<!-- END GET SOLUTIONS -->
<!-- START CLIENTS -->
<?=getClients( $post )?>
<!-- END CLIENTS -->
			
<?php get_footer(); ?>