<?php
/*
* Template Name: Faq
*/
global $theme_options;
get_header();

$post = get_post();
setup_postdata($post);
?>

<!-- START BREADCRUMB -->
<div id="breadcrumb" style="background-image: url('<?=get_field( 'background_breadcrumb', $post->ID )['url']?>')">
	<div class="container">
		<div class="mb-4">
			<h2 class="head-after"><?=wp_strip_all_tags( get_the_content() )?></h2>
		</div>
		<nav>
			<ol>
				<li class="breadcrumb-item">
					<a href="<?=get_home_url()?>"><i class="mdi mdi-home"></i> <?=pll_e('page-home')?></a>
				</li>
				<li class="breadcrumb-item active">
					<?=wp_strip_all_tags( get_the_title() )?>
				</li>
			</ol>
		</nav>
	</div>
</div>
<!-- END BREADCRUMB -->
<!-- START FAQ -->
<?php $faqs = get_field( 'faqs', $post->ID );
$faqs = count( $faqs ) == 1 ? $faqs[0] : $faqs;
if( is_array( $faqs ) && count( $faqs ) > 0 ) : ?>
<div class="ptb-80">
	<div class="container">
		<div class="row">
			<!-- Faq -->
			<div class="col-lg-12">
				<div class="text-center mb-5">
					<h5 class="head-after mb-4"><?=$faqs['title']?></h5>
				</div>
			</div>
			<?php if( is_array( $faqs['content'] ) && count( $faqs['content'] ) > 0 ) : ?>
			<div class="col-lg-12">
				<div class="mb-4" id="accordion">
					<?php foreach( $faqs['content'] as $k => $v ) : ?>
					<div class="collapse-head">
						<div class="collapse-btn">
							<button aria-expanded="<?=($k == 0 ? 'true' : 'false')?>" class="collapsed" data-target="#content-<?=$k?>" data-toggle="collapse"><?=$v['question']?></button>
						</div>
						<div class="collapse <?=($k == 0 ? 'show' : '')?>" data-parent="#accordion" id="content-<?=$k?>">
							<div>
								<p><?=$v['answer']?></p>
							</div>
						</div>
					</div>
					<?php endforeach; ?>
				</div>
			</div>
			<?php endif; ?>
		</div>
	</div>
</div>
<?php endif; ?>
<!-- END FAQ -->
<!-- START GET SOLUTIONS -->
<?=getSolutions( $post )?>
<!-- END GET SOLUTIONS -->
<!-- START CLIENTS -->
<?=getClients( $post )?>
<!-- END CLIENTS -->

<?php get_footer(); ?>