<?php
/*
* Template Name: Contact
*/
global $theme_options;
get_header();

$post = get_post();
setup_postdata($post);
?>

<!-- START BREADCRUMB -->
<div id="breadcrumb" style="background-image: url('<?=get_field( 'background_breadcrumb', $post->ID )['url']?>')">
	<div class="container">
		<div class="mb-4">
			<h2 class="head-after"><?=wp_strip_all_tags( get_the_content() )?></h2>
		</div>
		<nav>
			<ol>
				<li class="breadcrumb-item">
					<a href="<?=get_home_url()?>"><i class="mdi mdi-home"></i> <?=pll_e('page-home')?></a>
				</li>
				<li class="breadcrumb-item active">
					<?=wp_strip_all_tags( get_the_title() )?>
				</li>
			</ol>
		</nav>
	</div>
</div>
<!-- END BREADCRUMB -->
<?php $what_we_offer = get_field( 'what_we_offer', $post->ID );
$what_we_offer = count( $what_we_offer ) == 1 ? $what_we_offer[0] : $what_we_offer;
if( ! is_null( $what_we_offer ) ) : ?>
<!-- START WHAT WE OFFER -->
<div class="split-section">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<div class="text-center">
					<h5 class="head-after mb-4"><?=$what_we_offer['title']?></h5>
				</div>
			</div>
		</div>
		<?php if( is_array($what_we_offer['content']) && count($what_we_offer['content']) > 0 ) : ?>
		<div class="row"> 
			<?php foreach( $what_we_offer['content'] as $k => $v ) : ?>
			<div class="col-lg-4">
				<div class="card p-3">
					<div class="row d-flex align-items-center">
						<div class="col-sm-3">
							<?=$v['icon']?>
						</div>
						<div class="col-sm-9">
							<div class="pt-4 pb-4">
								<h5><a href="javascript:void(0)"><?=$v['sub_title']?></a></h5>
								<p><?=$v['sub_content']?></p>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php endforeach; ?>
		</div>
		<?php endif; ?>
	</div>
</div>
<!-- END WHAT WE OFFER -->
<?php endif; ?>
<!-- START CONTACT -->
<div class="split-section" style="background: #f1f1f1">
	<div class="container">
		<div class="row">
			<?php $iframe_map = get_field( 'iframe_map', $post->ID );
			if( ! is_null( $iframe_map ) ) : ?>
			<!-- Map -->
			<div class="col-lg-8">
				<div class="mapouter">
					<div class="gmap_canvas">
						<?=$iframe_map?>
					</div>
				</div>
			</div>
			<?php endif; ?>
			<?php $form_contact = get_field( 'form_contact', $post->ID );
			if( ! is_null( $form_contact ) ) : ?>
			<!-- Contact Information -->
			<div class="col-lg-4">
				<?=do_shortcode( $form_contact )?>
			</div>
			<?php endif; ?>
		</div>
	</div>
</div>
<!-- END CONTACT -->
<!-- START CLIENTS -->
<?=getClients( $post )?>
<!-- END CLIENTS -->

<?php get_footer(); ?>