<?php
/*
* Template Name: About
*/
global $theme_options;
get_header();

$post = get_post();
setup_postdata($post);
?>

<!-- START BREADCRUMB -->
<div id="breadcrumb" style="background-image: url('<?=get_field( 'background_breadcrumb', $post->ID )['url']?>')">
	<div class="container">
		<div class="mb-4">
			<h2 class="head-after"><?=wp_strip_all_tags( get_the_content() )?></h2>
		</div>
		<nav>
			<ol>
				<li class="breadcrumb-item">
					<a href="<?=get_home_url()?>"><i class="mdi mdi-home"></i> <?=pll_e('page-home')?></a>
				</li>
				<li class="breadcrumb-item active">
					<?=wp_strip_all_tags( get_the_title() )?>
				</li>
			</ol>
		</nav>
	</div>
</div>
<!-- END BREADCRUMB -->
<!-- START COUNTER -->
<?php if( get_field( 'counter', $post->ID ) ) :
	$counter = get_field( 'counter_'.pll_current_language(), 'options' );
	if( is_array( $counter ) && count( $counter ) > 0 ) : ?>
<div id="counter">
	<div class="container">
		<div class="row">
			<?php foreach( $counter as $k => $v ) : ?>
			<div class="col-lg-3 counter-col">
				<div class="row">
					<div class="col-sm-4"><?=$v['icon']?></div>
					<div class="col-sm-8">
						<div class="count-timer">
							<div>
								<span class="timer" data-speed="10000" data-to="<?=$v['data']?>"></span>
								<i class="mdi mdi-plus mdi-24px"></i>
							</div>
							<p><?=$v['title']?></p>
						</div>
					</div>
				</div>
			</div>
			<?php endforeach; ?>
		</div>
	</div>
</div>
	<?php endif;
endif; ?>
<!-- END COUNTER -->
<!-- START WHO WE ARE -->
<?php $sections = get_field( 'sections', $post->ID );
if( is_array( $sections ) && count( $sections ) > 0 ):
	foreach( $sections as $k => $section ): ?>
<div class="split-section" style="background-color: <?=$section['background']?>" id="<?=$section['id']?>">
	<div class="container">
		<div class="row d-flex align-items-center">
			<div class="col-lg-12">
				<div class="text-center">
					<h5 class="head-after mb-4">
						<?=$section['title']?>
					</h5>
				</div>
			</div>
			<?=$section['content']?>
		</div>
	</div>
</div>
<?php 
	endforeach;
endif; ?>
<!-- END WHO WE ARE -->
<!-- START EXPERT WORKERS -->
<?php if( get_field( 'products', $post->ID ) ) :
	$category_product = get_field( 'category_products_'.pll_current_language(), 'options' );
	$category_product = count($category_product) == 1 ? $category_product[0] : $category_product;
	if( is_array( $category_product ) && count( $category_product ) > 0 ) : ?>
<div id="expert-workers">
	<div class="container">
		<div class="row">
			<!-- Expert Workers -->
			<div class="col-lg-12">
				<div class="text-center mb-5">
					<h5 class="head-after mb-4"><?=$category_product['title']?></h5>
					<p style="text-align: center;"><?=$category_product['sub_title']?></p>
				</div>
			</div>
				<?php foreach($category_product['category'] as $k => $v) :
				$thumb_id = get_woocommerce_term_meta( $v->term_id, 'thumbnail_id', true ); ?>
			<div class="col-lg-3">
				<div class="item">
					<div class="workers-img">
						<img alt="" class="w-100" src="<?=wp_get_attachment_url(  $thumb_id )?>"/>
					</div>
					<div class="">
						<div class="workers-details">
							<h4>
								<a href="<?=get_category_link($v)?>"><?=$v->name?></a>
							</h4>
						</div>
					</div>
				</div>
			</div>
				<?php endforeach; ?>
		</div>
	</div>
</div>
	<?php endif;
endif; ?>
<!-- END EXPERT WORKERS -->
<!-- START GET SOLUTIONS -->
<?=getSolutions( $post )?>
<!-- END GET SOLUTIONS -->
<!-- START CLIENTS -->
<?=getClients( $post )?>
<!-- END CLIENTS -->
	
<?php get_footer(); ?>