<?php global $page, $paged, $theme_options; ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>" />
        <meta content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=no" name="viewport"/>
        <meta content="telephone=no" name="format-detection"/>
        <meta content="yes" name="apple-mobile-web-app-capable"/>
        <meta content="black" name="apple-mobile-web-app-status-bar-style"/>
        <meta content="webkit" name="renderer"/>
        <meta content="IE=Edge" http-equiv="x-ua-compatible"/>
		<link href="<?=$theme_options['favicon']['url']?>" rel="shortcut icon"/>
        <title>
		<?php wp_title( '|', true, 'right' );
		bloginfo( 'name' );
		$site_description = get_bloginfo( 'description', 'display' );
		if ( $site_description && ( is_home() || is_front_page() ) ) {
			echo " | $site_description";
		}
		if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() ) {
			echo esc_html( ' | ' . sprintf( __( 'Page %s', 'twentyten' ), max( $paged, $page ) ) );
		} ?>
        </title>
		<meta content="<?=$site_description?>" name="Keywords"/>
        <meta content="<?=$site_description?>" name="description"/>
        <!-- Bootstrap -->
        <link href="<?=get_template_directory_uri()?>/assets/css/bootstrap.min.css" rel="stylesheet"/>
        <link href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.4.3/css/flag-icon.min.css" rel="stylesheet"/>
        <!-- Main Custom CSS -->
        <link href="<?=get_template_directory_uri()?>/assets/css/style.css" rel="stylesheet"/>
        <!-- Font Awesome Css -->
        <link href="<?=get_template_directory_uri()?>/assets/font/css/materialdesignicons.min.css" rel="stylesheet"/>
        <!-- Theme Responsive Css -->
        <link href="<?=get_template_directory_uri()?>/assets/css/theme-responsive.css" rel="stylesheet"/>
        <!-- Animation Css -->
        <link href="<?=get_template_directory_uri()?>/assets/css/animation.css" rel="stylesheet"/>
        <!-- Select -->
        <link href="<?=get_template_directory_uri()?>/assets/css/bootstrap-select.css" rel="stylesheet"/>
        <!-- Owl Carousel Css -->
        <link href="<?=get_template_directory_uri()?>/assets/css/owl.carousel.css" rel="stylesheet"/>
        <link href="<?=get_template_directory_uri()?>/assets/css/owl.transitions.css" rel="stylesheet"/>
        <!-- Default Color Css -->
        <link href="<?=get_template_directory_uri()?>/assets/css/colors/yellow1.css" id="change-color" rel="stylesheet"/>
        <!-- Google Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Open+Sans:400,600,700" rel="stylesheet"/>
        <link href="https://fonts.googleapis.com/css?family=Roboto:400,500,700,900" rel="stylesheet"/>
        <!-- second Custom CSS -->
        <link href="<?=get_template_directory_uri()?>/assets/css/custom.css" rel="stylesheet"/>
		<?php if ( is_singular() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		wp_head(); ?>
    </head>
    <body id="body-top">
		<!-- START LOADER -->
        <div class="loader">
            <img alt="" src="<?=get_template_directory_uri()?>/assets/images/icons/loader.gif"/>
        </div>
        <!-- END LOADER -->
        <!-- START TOP HEADER -->
        <div id="top-header" class="invisible">
            <div class="container">
                <div class="row d-flex align-items-center">
                    <!-- Left Side -->
                    <div class="col-lg-8">
                        <div class="t-left-side">
                            <ul>
                                <li>
                                    <i class="mdi mdi-phone mdi-24px">
                                    </i>
                                    <a href="tel: <?=$theme_options['phone']?>"><?=$theme_options['phone']?></a>
                                </li>
                                <li>
                                    <i class="mdi mdi-email-open mdi-24px">
                                    </i>
                                    <a href="mailto: <?=$theme_options['email']?>"> <?=$theme_options['email']?></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <!-- Right Side -->
                    <div class="col-lg-4">
                        <div class="t-right-side">
                            <!-- Icons -->
                            <div class="social-icons ml-3">
                                <ul>
                                    <!-- <li><a href="#"><i class="flag-icon flag-icon-vn"></i></a></li> -->
                                    <?php pll_the_languages(array('hide_current'=>1,'show_flags'=>1,'show_names'=>0))?>
                                    <li class="p-0">
                                        <a href="#">
                                            |
                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?=esc_url(wc_get_cart_url())?>">
                                            <i class="mdi mdi-cart">
                                                <span class="badge">
                                                    <?=WC()->cart->get_cart_contents_count()?>
                                                </span>
                                            </i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- END TOP HEADER -->
        <!-- START HEADER -->
        <div id="header" class="invisible">
            <div class="container">
                <!-- Navbar -->
                <nav class="navbar navbar-expand-lg">
                    <a class="navbar-brand" href="<?=get_home_url()?>">
                        <img alt="logo" id="nav-logo" src="<?=$theme_options['logo']['url']?>" title="logo"/>
                    </a>
                    <button aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation" class="navbar-toggler" data-target="#navbarSupportedContent" data-toggle="collapse" type="button">
                        <i class="mdi mdi-menu mdi-24px">
                        </i>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <?php $locations = get_nav_menu_locations();
						$menu = wp_get_nav_menu_object( $locations[ 'menu_primary' ] );
						$menuitems = buildTree( wp_get_nav_menu_items( $menu->term_id, array( 'order' => 'DESC' ) ) );
						?>
						<ul class="navbar-nav ml-auto">
							<?php foreach( $menuitems as $k => $v ) :
								$v->classes_c = empty( $v->classes[0] ) ? 'nav-item' : implode( ' ', $v->classes );
								if( isset( $v->children ) && is_array( $v->children ) ) {
									$parent = 0;
									$html_children = "";
									foreach( $v->children as $k1 => $v1 ) {
										if( $parent == 0 ) {
											$parent = $v1->object_id == get_the_ID() ? $v1->menu_item_parent : 0;
										}
										$active = $v1->object_id == get_the_ID() ? 'active' : '';
										$target = empty( $v1->target ) ? '_self' : $v1->target;
										$title = empty( $v1->description ) ? $v1->title : $v1->description;
										$html_children .= "<a class='dropdown-item {$active}' href='{$v1->url}' target='{$target}' title='{$title}'>{$v1->title}</a>";
									} ?>
								<li class="<?=$v->classes_c?> dropdown <?=$v->object_id == $parent ? 'active' : ''?>">
									<a aria-expanded="false" aria-haspopup="true" class="nav-link dropdown-toggle" data-toggle="dropdown" href="#" role="button">
										<?=$v->title?>
									</a>
									<div class="dropdown-menu animate slideIn" data-animations="fadeInDown">
										<?=$html_children?>
									</div>
								</li>
								<?php } else { ?>
								<li class="<?=$v->classes_c?> <?=$v->object_id == get_the_ID() ? 'active' : ''?>">
									<a class="<?=trim( $v->classes_c ) == 'menu-btn' ? 'btn btn-primary' : 'nav-link'?>" href="<?=$v->url?>" target="<?=empty( $v->target ) ? '_self' : $v->target?>" title="<?=empty( $v->description ) ? $v->title : $v->description?>">
										<?=$v->title?>
									</a>
								</li>
								<?php } ?>
							<?php endforeach; ?>
                        </ul>
                    </div>
                </nav>
            </div>
        </div>
        <!-- END HEADER -->
		<div id="body" class="invisible">