var has_product = false;
jQuery(document).on('ready', function($) {
    "use strict";
    // Slider
    $('#carouselExampleIndicators .carousel-item').css({
        height: $(window).width() / 1920 * 840
    });
    $(window).on('resize', function() {
        $('#carouselExampleIndicators .carousel-item').css({
            height: $(window).width() / 1920 * 840
        });
    });
    // Loader
    $(document).ready(function() {
        $('.loader').fadeOut('slow', function() {
            $(this).remove();
            $('#header').removeClass('invisible');
            $('#body').removeClass('invisible');
            $('#top-header').removeClass('invisible');
        });
        // auto active subnav if mainnav not include sub
        var attr_nav_link = $('.breadcrumb-item').length >= 3 ? $($('.breadcrumb-item')[1]).find('a').attr('href') : '';
        $('.nav-item a').each(function(index) {
            $(this).attr('href') == attr_nav_link ? $(this).closest('li').addClass('active') : '';
        });
    });
    // Header Fixed on Scroll
    $(window).on('scroll', function() {
        if ($(window).scrollTop() > 100) {
            $("#header .out-product").hide();
            $("#header .out-product-list").removeClass('d-none');
            $("#header .out-product-list .navbar-brand").removeClass('invisible');
            $(".product-list-tab").addClass('d-none');
            has_product ? $("#header .container").addClass('mw-100') : '';
            $("#header").addClass('header-fixed');
        } else {
            $("#header .out-product").show();
            $("#header .out-product-list").addClass('d-none');
            $("#header .out-product-list .navbar-brand").addClass('invisible');
            $(".product-list-tab").removeClass('d-none');
            $("#header .container").removeClass('mw-100');
            $("#header").removeClass('header-fixed');
        }
    });
    // Navbar Hover Menu
    $('.dropdown').hover(function() {
        $(this).find('.dropdown-menu').first().stop(true, true).slideDown(150);
        $(this).find('.dropdown-menu').parent('.nav-item.dropdown').addClass("dropdown-active");
    }, function() {
        $(this).find('.dropdown-menu').first().stop(true, true).slideUp(105);
        $(this).find('.dropdown-menu').parent('.nav-item.dropdown').removeClass("dropdown-active");
    });
    // Play Video
    $('.clickplay').on('click', function(event) {
        var index = $(this).attr('index-data');
        console.log(index);
        var vi = $("#videoinput-" + index).val();
        $("#vidframe-" + index).attr('src', vi);
        $('#video_' + index).on('hidden.bs.modal', function(e) {
            $("#vidframe-" + index).attr('src', '');
            $(this).unbind();
        })
        event.preventDefault();
    });
    // Carousels
    if ($('div').hasClass('owl-carousel')) {
        // Customer Says Carousel
        $('#customer-carousel').owlCarousel({
            items: 2,
            lazyLoad: !0,
            autoPlay: 3000,
            itemsDesktop: 1,
        });
        // Our Clients Carousel
        $('#clients-carousel').owlCarousel({
            items: 6,
            lazyLoad: !0,
            autoPlay: 3000,
            itemsDesktop: 1,
        });
        // product-detail-carousel
        $('#product-detail-carousel').owlCarousel({
            items: 1,
            lazyLoad: !0,
            autoPlay: false,
            itemsDesktop: 1,
        });
        $('#product-other-carousel').owlCarousel({
            items: 6,
            lazyLoad: !0,
            autoPlay: 3000,
            itemsDesktop: 1,
        });
    };
    // Activate Isotope
    $(window).on('load', function() {
        var $container = $('.portfolio-items').isotope({
            itemSelector: '.item',
            masonry: {
                columnWidth: '.col-lg-4'
            }
        });
    });
    // Bind Filter Button Click
    var filters = $('.filters-group ul li');
    filters.on('click', function() {
        filters.removeClass('active');
        $(this).addClass('active');
        var filterValue = $(this).attr('data-filter');
        // Use filter if matches value
        $('.portfolio-items').isotope({
            filter: filterValue
        });
    });
    // Scroll to Back to Top Btn Show
    $(window).on('scroll', function() {
        if ($(window).scrollTop() > 400) {
            $(".backto-top-btn").addClass('backto-top-blk');
        } else {
            $(".backto-top-btn").removeClass('backto-top-blk');
        }
    });
    // Smooth Scrolling Using jQuery Easing
    $(".backto-top-btn a[href^='#']").on('click', function(e) {
        var target = $(this.hash);
        target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
        if (target.length) {
            $('html, body').animate({
                scrollTop: (target.offset().top - 72)
            }, 1000, "easeInOutExpo");
            return false;
        }
    });
    /*
        Smooth scroll functionality for anchor links (animates the scroll
        rather than a sudden jump in the page)
    */
    $('.js-anchor-link').click(function(e) {
        e.preventDefault();
        var target = $($(this).attr('href'));
        if (target.length) {
            var scrollTo = target.offset().top;
            $('body, html').animate({
                scrollTop: scrollTo + 'px'
            }, 800);
        }
    });
    // sync-product-tab
    var waiting_click = false;
    var autoClickTab = function($container, $href) {
        $($container).each(function(index, item) {
            if ($(this).find('a').attr('href') == $href) {
                waiting_click = true;
                $(this).find('a').trigger("click");
            }
        });
    };
    $('#top_icon_nav .sync-product-tab').click(function(e) {
        if (waiting_click) {
            return;
        }
        autoClickTab('#navbarSupportedtab .sync-product-tab', $(this).find('a').attr('href'));
        waiting_click = false;
    });
    $('#navbarSupportedtab .sync-product-tab').click(function(e) {
        if (waiting_click) {
            return;
        }
        autoClickTab('#top_icon_nav .sync-product-tab', $(this).find('a').attr('href'));
        waiting_click = false;
    });
}(jQuery)); // End jQuery