<div class="app-header bg-header-1">
    <div class="layout-fixed full-h text-center">
        <div class="full-h v-bottom-i pdB15">
            <div class="app-content-header bg-header-1">
                <div class="text-name-header-1 nowrap pdLR40"> {{ detailCustomerData.first_name }} {{ detailCustomerData.last_name }}</div>
                <div class="layout-fixed mgT10">
                    <div class="text-title-header-1 nowrap pdL40">File by appointment</div>
                    <div class="w40px clear" ng-if="viewDownload">
                        <button class="bg-transparent left biger-3-time" ng-click="downloadFile('upload/customers/'+ detailCustomerData.id +'/appointment/'+ dataAppointmentHistoryFileItem.id +'/appointment'+dataAppointmentHistoryFileItem.id+'.zip')" ng-if="dataAppointmentHistoryFileItem.files.length > 0">
                            <svg class="h24px clr-symbol-clickable" viewBox="0 0 482.14 482.14"> <path d="M302.614,0H108.967C80.676,0,57.651,23.026,57.651,51.315v379.509c0,28.289,23.025,51.316,51.316,51.316h264.221   c28.274,0,51.301-23.026,51.301-51.316V121.449L302.614,0z M373.188,450.698H108.967c-10.954,0-19.875-8.905-19.875-19.874V51.315   c0-10.953,8.921-19.858,19.875-19.858l24.728-0.022v22.732c0,4.437,3.594,8.031,8.03,8.031h30.298v33.616h-30.298   c-4.436,0-8.03,3.594-8.03,8.03v17.558c0,4.437,3.594,8.028,8.03,8.028h30.298v33.617h-30.298c-4.436,0-8.03,3.594-8.03,8.03   v17.558c0,4.437,3.594,8.028,8.03,8.028h30.298v25.588c0,4.437,3.594,8.029,8.031,8.029h44.302c4.428,0,8.022-3.593,8.022-8.029   v-17.557c0-4.436-3.594-8.031-8.022-8.031H194.05v-33.616h30.307c4.428,0,8.022-3.593,8.022-8.029v-17.557   c0-4.436-3.594-8.031-8.022-8.031H194.05V95.814h30.307c4.428,0,8.022-3.593,8.022-8.029V70.229c0-4.437-3.594-8.03-8.022-8.03   H194.05V31.37l96.807-0.101v67.217c0,19.653,15.934,35.604,35.587,35.604l65.862-0.188l0.741,296.924   C393.046,441.793,384.143,450.698,373.188,450.698z" /> <path d="M202.196,301.778v-41.087c0-4.429-3.592-8.021-8.021-8.021H171.89c-4.429,0-8.022,3.593-8.022,8.021v41.079l-12.395,36.415   c-3.468,10.149-1.804,21.425,4.445,30.164c6.249,8.723,16.382,13.933,27.114,13.933c10.734,0,20.868-5.21,27.117-13.933   c6.249-8.739,7.911-20.015,4.444-30.156L202.196,301.778z M197.019,358.957c-6.43,8.999-21.544,8.999-27.975,0   c-3.223-4.508-4.081-10.323-2.3-15.563l4.16-12.214h24.255l4.161,12.222C201.102,348.634,200.241,354.449,197.019,358.957z" /> </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <button class="popup-back-button bg-transparent pd0-i biger-3-time" type="button" ng-click="closeTarget('#popupScheduleDetailFileManagementDetailOfHistory')"></button>
</div>
<div class="app-content">
    <div class="app-content-inner content-pd">
        <ion-scroll class="scroll-area" direction="y" has-bouncing="false" overflow-scroll="false" delegate-handle="scrollPopupScheduleDetailFileManagementDetailOfHistory" on-scroll="scrollContent('scrollPopupScheduleDetailFileManagementDetailOfHistory')">
            <div class="except-app-create-button">
                <div class="box-files" ng-show="filetypeAppointment=='All' || filetypeAppointment=='Photo'">
                    <div class="box-setting-4 no-saperator">
                        <div class="title">Captured photos</div>
                    </div>
                    <ul class="lst-file">
                        <li class="box-setting-4" ng-repeat="appointmentfilesItem in dataAppointmentHistoryFileItem.files" ng-if="sortFiletypeAppointment(appointmentfilesItem.extension) =='Photo'" data-item="{{appointmentfilesItem}}">
                            <div class="content content-in">
                                <div class="itm row-one-content">
                                    <div class="layout-fixed">
                                        <div class="v-top-i" ng-click="viewDownload ? fileFolderViewerSchedule($event): '' ">
                                            <div class="name clr-clickable first-capitalize">{{ appointmentfilesItem.name }}</div>
                                        </div>
                                        <div class="w40px clear v-top-i relative">
                                            <button class="bg-transparent right biger-3-time" onclick="openQuickOption(this)">
                                                <svg class="h16px clr-symbol-clickable" viewBox="0 0 512 512"> <circle r="61.793" cy="256" cx="61.793" fill="#1075BB" /> <circle r="61.793" cy="256" cx="450.207" fill="#1075BB" /> <circle r="61.793" cy="256" cx="256" fill="#1075BB" /> </svg>
                                            </button>
                                            <div class="quick-popup box-popup-1 display-top-right mgT20" onclick="closeQuickOption(this)">
                                                <div class="popup-content w150px">
                                                    <ul class="list-item-03">
                                                        <li ng-if="appointmentfilesItem.path==null && viewDownload" ng-click="downloadFile('upload/customers/'+ detailCustomerData.id +'/appointment/'+ dataAppointmentHistoryFileItem.id +'/'+ appointmentfilesItem.name)">
                                                            <div class="layout-fixed">
                                                                <div class="icon-area">
                                                                    <svg class="h15px" viewBox="0 0 58 58"> <path d="M21.707,24.293c-0.391-0.391-1.023-0.391-1.414,0s-0.391,1.023,0,1.414l7.999,7.999c0.001,0.001,0.001,0.001,0.002,0.002   L29,34.414l0.706-0.706c0.001-0.001,0.001-0.001,0.002-0.002l7.999-7.999c0.391-0.391,0.391-1.023,0-1.414s-1.023-0.391-1.414,0   L30,30.586V3c0-0.552-0.447-1-1-1s-1,0.448-1,1v27.586L21.707,24.293z" /> <path d="M57.981,32.676L57.53,32h-0.009l-3.583-5.381l-2.421-3.628l0.004-0.002L47.535,17H36v2h10.465l8.679,13H39v7H19v-7H2.856   l8.679-13H22v-2H10.465L0.431,32.031l-0.014,0.001L0,32.655v0.206v0.396v19.359C0,54.482,1.519,56,3.385,56h51.23   C56.481,56,58,54.482,58,52.616V33.239v-0.429l-0.014-0.036L57.981,32.676z" /> </svg>
                                                                </div>
                                                                <div class="name-area text-link-1">
                                                                    Download
                                                                </div>
                                                            </div>
                                                        </li>
                                                        <li ng-if="appointmentfilesItem.path!=null && viewDownload" ng-click="downloadFile(appointmentfilesItem.path)">
                                                            <div class="layout-fixed">
                                                                <div class="icon-area">
                                                                    <svg class="h15px" viewBox="0 0 58 58"> <path d="M21.707,24.293c-0.391-0.391-1.023-0.391-1.414,0s-0.391,1.023,0,1.414l7.999,7.999c0.001,0.001,0.001,0.001,0.002,0.002   L29,34.414l0.706-0.706c0.001-0.001,0.001-0.001,0.002-0.002l7.999-7.999c0.391-0.391,0.391-1.023,0-1.414s-1.023-0.391-1.414,0   L30,30.586V3c0-0.552-0.447-1-1-1s-1,0.448-1,1v27.586L21.707,24.293z" /> <path d="M57.981,32.676L57.53,32h-0.009l-3.583-5.381l-2.421-3.628l0.004-0.002L47.535,17H36v2h10.465l8.679,13H39v7H19v-7H2.856   l8.679-13H22v-2H10.465L0.431,32.031l-0.014,0.001L0,32.655v0.206v0.396v19.359C0,54.482,1.519,56,3.385,56h51.23   C56.481,56,58,54.482,58,52.616V33.239v-0.429l-0.014-0.036L57.981,32.676z" /> </svg>
                                                                </div>
                                                                <div class="name-area text-link-1">
                                                                    Download
                                                                </div>
                                                            </div>
                                                        </li>
                                                        <li ng-click="openByGetTemplate('popupScheduleDetailFileManagementName') ; getNameFile(appointmentfilesItem.id)" ng-if="renameDelete">
                                                            <div class="layout-fixed">
                                                                <div class="icon-area">
                                                                    <svg class="h15px" viewBox="0 0 285 285"> <path d="M216.818,271.424H26.821V81.427h61.713c3.748,0,6.788-3.04,6.788-6.788V13.576h121.496v29.246    c0.3-0.037,0.591-0.115,0.903-0.127c1.753-0.068,5.165,0.019,9.708,1.237c0.909,0.235,1.917,0.572,2.965,0.934V6.788    c0-3.748-3.04-6.788-6.788-6.788H87.894c-1.8,0-3.532,0.714-4.803,1.985l-67.86,67.861c-1.271,1.271-1.985,2.993-1.985,4.793    v203.583c0,3.741,3.04,6.778,6.788,6.778h203.573c3.748,0,6.788-3.037,6.788-6.778V173.01c-3.68,3.612-8.554,5.592-13.576,5.765    L216.818,271.424L216.818,271.424z" fill="#FFF" /> <path d="M267.485,46.164c-4.305-4.305-7.768-4.289-8.139-4.268c-0.52,0.016-1.015,0.235-1.379,0.597l-15.422,15.422    c2.242,1.395,4.704,3.278,7.301,5.875c2.61,2.61,4.49,5.068,5.888,7.308L271.14,55.68c0.377-0.371,0.587-0.857,0.612-1.376    C271.771,53.917,271.783,50.469,267.485,46.164z" fill="#FFF" /> <path d="M254.571,110.462l-7.465,7.465l-4.966-4.96l13.347-13.347c1.15-1.15,1.831-2.703,1.905-4.323    c0.049-1.206,0.111-12.088-13.421-25.621c-13.529-13.539-24.412-13.467-25.621-13.427c-1.63,0.081-3.17,0.761-4.32,1.911    L98.851,173.325c-0.708,0.705-1.252,1.584-1.565,2.549l-16.124,48.372c-0.779,2.338-0.173,4.917,1.581,6.673    c1.735,1.744,4.32,2.345,6.655,1.565l48.384-16.131c0.959-0.321,1.818-0.865,2.533-1.552l97.032-97.035l4.958,4.96l-30.996,30.986    c-2.65,2.66-2.65,6.946,0,9.605c1.33,1.33,3.062,1.985,4.802,1.985c1.732,0,3.473-0.655,4.793-1.985l43.267-43.263    c2.647-2.647,2.647-6.939,0-9.593C261.517,107.809,257.218,107.809,254.571,110.462z" fill="#FFF" /> </svg>
                                                                </div>
                                                                <div class="name-area text-link-1">
                                                                    Rename
                                                                </div>
                                                            </div>
                                                        </li>
                                                        <li ng-click="confirmDeleteFile(appointmentfilesItem)" ng-if="renameDelete">
                                                            <div class="layout-fixed">
                                                                <div class="icon-area">
                                                                    <svg class="h16px" viewBox="0 0 59 59"> <path d="M52.5,6H38.456c-0.11-1.25-0.495-3.358-1.813-4.711C35.809,0.434,34.751,0,33.499,0H23.5c-1.252,0-2.31,0.434-3.144,1.289   C19.038,2.642,18.653,4.75,18.543,6H6.5c-0.552,0-1,0.447-1,1s0.448,1,1,1h46c0.552,0,1-0.447,1-1S53.052,6,52.5,6z M20.553,6   c0.112-1.048,0.435-2.496,1.24-3.319C22.24,2.223,22.799,2,23.5,2h9.999c0.701,0,1.26,0.223,1.708,0.681   c0.805,0.823,1.128,2.271,1.24,3.319H20.553z" /> <path d="M10.456,54.021C10.493,55.743,11.565,59,15.364,59h28.272c3.799,0,4.871-3.257,4.907-4.958L50.376,10H8.624L10.456,54.021z    M17.5,42h24c0.552,0,1,0.447,1,1s-0.448,1-1,1h-24c-0.552,0-1-0.447-1-1S16.948,42,17.5,42z M17.5,47h24c0.552,0,1,0.447,1,1   s-0.448,1-1,1h-24c-0.552,0-1-0.447-1-1S16.948,47,17.5,47z M17.5,52h24c0.552,0,1,0.447,1,1s-0.448,1-1,1h-24   c-0.552,0-1-0.447-1-1S16.948,52,17.5,52z" /> </svg>
                                                                </div>
                                                                <div class="name-area text-link-1">
                                                                    Delete
                                                                </div>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="popup-overlay"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="layout-fixed mgT10">
                                        <div class="w80px clear v-bottom-i" ng-click="viewDownload ? fileFolderViewerSchedule($event): '' ">
                                            <div class="box-image-thumnail-3 rounded w60px">
                                                <a class="image-outer" href="javascript:void(0)">
                                                    <img ng-if="appointmentfilesItem.path!=null" ng-src="{{showImagePhone(appointmentfilesItem.path)}}" ng-click="bindRotateEvent(appointmentfilesItem)" id="thumd-{{appointmentfilesItem.id}}"/>
                                                    <img ng-if="appointmentfilesItem.path==null" ng-src="{{showImagePhone('upload/customers/'+detailCustomerData.id +'/appointment/'+dataAppointmentHistoryFileItem.id+'/'+ appointmentfilesItem.name)}}" ng-click="viewDownload ? cordovaBrowser(showImagePhone('upload/customers/'+detailCustomerData.id +'/appointment/'+dataAppointmentHistoryFileItem.id+'/'+ appointmentfilesItem.name)) : '' " />
                                                </a>
                                            </div>
                                        </div>
                                        <div class="v-bottom-i">
                                            <div class="text-name-2">{{ sizeName(appointmentfilesItem.size) }}</div>
                                            <div class="layout-fixed mgT8">
                                                <div>
                                                    <div class="layout-fixed w-auto-i baseline">
                                                        <div class="text-name-2 text-none-transform-i">Upload time:</div>
                                                        <div class="text-date-1 lowercase pdL3 ng-binding">{{ appointmentfilesItem.created_date | date:flongDate}}</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="text mgT8-i">{{ appointmentfilesItem.description }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="box-files" ng-show="filetypeAppointment=='All' || filetypeAppointment=='PDFs'">
                    <div class="box-setting-4 no-saperator">
                        <div class="title">Pdf files</div>
                    </div>
                    <ul class="lst-file">
                        <li class="box-setting-4" ng-repeat="appointmentfilesItem in dataAppointmentHistoryFileItem.files" ng-if="sortFiletypeAppointment(appointmentfilesItem.extension) =='PDFs'" data-item="{{appointmentfilesItem}}">
                            <div class="content content-in">
                                <div class="itm row-one-content">
                                    <div class="layout-fixed">
                                        <div class="v-top-i" ng-click="viewDownload ? fileFolderViewerSchedule($event) : '' ">
                                            <div class="name clr-clickable first-capitalize">{{ appointmentfilesItem.name }}</div>
                                        </div>
                                        <div class="w40px clear v-top-i relative">
                                            <button class="bg-transparent right biger-3-time" onclick="openQuickOption(this)">
                                                <svg class="h16px clr-symbol-clickable" viewBox="0 0 512 512"> <circle r="61.793" cy="256" cx="61.793" fill="#1075BB" /> <circle r="61.793" cy="256" cx="450.207" fill="#1075BB" /> <circle r="61.793" cy="256" cx="256" fill="#1075BB" /> </svg>
                                            </button>
                                            <div class="quick-popup box-popup-1 display-top-right mgT20" onclick="closeQuickOption(this)">
                                                <div class="popup-content w150px">
                                                    <ul class="list-item-03">
                                                        <li ng-if="appointmentfilesItem.path==null && viewDownload" ng-click="downloadFile('upload/customers/'+ detailCustomerData.id +'/appointment/'+ dataAppointmentHistoryFileItem.id +'/'+ appointmentfilesItem.name)">
                                                            <div class="layout-fixed">
                                                                <div class="icon-area">
                                                                    <svg class="h15px" viewBox="0 0 58 58"> <path d="M21.707,24.293c-0.391-0.391-1.023-0.391-1.414,0s-0.391,1.023,0,1.414l7.999,7.999c0.001,0.001,0.001,0.001,0.002,0.002   L29,34.414l0.706-0.706c0.001-0.001,0.001-0.001,0.002-0.002l7.999-7.999c0.391-0.391,0.391-1.023,0-1.414s-1.023-0.391-1.414,0   L30,30.586V3c0-0.552-0.447-1-1-1s-1,0.448-1,1v27.586L21.707,24.293z" /> <path d="M57.981,32.676L57.53,32h-0.009l-3.583-5.381l-2.421-3.628l0.004-0.002L47.535,17H36v2h10.465l8.679,13H39v7H19v-7H2.856   l8.679-13H22v-2H10.465L0.431,32.031l-0.014,0.001L0,32.655v0.206v0.396v19.359C0,54.482,1.519,56,3.385,56h51.23   C56.481,56,58,54.482,58,52.616V33.239v-0.429l-0.014-0.036L57.981,32.676z" /> </svg>
                                                                </div>
                                                                <div class="name-area text-link-1">
                                                                    Download
                                                                </div>
                                                            </div>
                                                        </li>
                                                        <li ng-if="appointmentfilesItem.path!=null && viewDownload" ng-click="downloadFile(appointmentfilesItem.path)">
                                                            <div class="layout-fixed">
                                                                <div class="icon-area">
                                                                    <svg class="h15px" viewBox="0 0 58 58"> <path d="M21.707,24.293c-0.391-0.391-1.023-0.391-1.414,0s-0.391,1.023,0,1.414l7.999,7.999c0.001,0.001,0.001,0.001,0.002,0.002   L29,34.414l0.706-0.706c0.001-0.001,0.001-0.001,0.002-0.002l7.999-7.999c0.391-0.391,0.391-1.023,0-1.414s-1.023-0.391-1.414,0   L30,30.586V3c0-0.552-0.447-1-1-1s-1,0.448-1,1v27.586L21.707,24.293z" /> <path d="M57.981,32.676L57.53,32h-0.009l-3.583-5.381l-2.421-3.628l0.004-0.002L47.535,17H36v2h10.465l8.679,13H39v7H19v-7H2.856   l8.679-13H22v-2H10.465L0.431,32.031l-0.014,0.001L0,32.655v0.206v0.396v19.359C0,54.482,1.519,56,3.385,56h51.23   C56.481,56,58,54.482,58,52.616V33.239v-0.429l-0.014-0.036L57.981,32.676z" /> </svg>
                                                                </div>
                                                                <div class="name-area text-link-1">
                                                                    Download
                                                                </div>
                                                            </div>
                                                        </li>
                                                        <li ng-click="openByGetTemplate('popupScheduleDetailFileManagementName') ; getNameFile(appointmentfilesItem.id)" ng-if="renameDelete">
                                                            <div class="layout-fixed">
                                                                <div class="icon-area">
                                                                    <svg class="h15px" viewBox="0 0 285 285"> <path d="M216.818,271.424H26.821V81.427h61.713c3.748,0,6.788-3.04,6.788-6.788V13.576h121.496v29.246    c0.3-0.037,0.591-0.115,0.903-0.127c1.753-0.068,5.165,0.019,9.708,1.237c0.909,0.235,1.917,0.572,2.965,0.934V6.788    c0-3.748-3.04-6.788-6.788-6.788H87.894c-1.8,0-3.532,0.714-4.803,1.985l-67.86,67.861c-1.271,1.271-1.985,2.993-1.985,4.793    v203.583c0,3.741,3.04,6.778,6.788,6.778h203.573c3.748,0,6.788-3.037,6.788-6.778V173.01c-3.68,3.612-8.554,5.592-13.576,5.765    L216.818,271.424L216.818,271.424z" fill="#FFF" /> <path d="M267.485,46.164c-4.305-4.305-7.768-4.289-8.139-4.268c-0.52,0.016-1.015,0.235-1.379,0.597l-15.422,15.422    c2.242,1.395,4.704,3.278,7.301,5.875c2.61,2.61,4.49,5.068,5.888,7.308L271.14,55.68c0.377-0.371,0.587-0.857,0.612-1.376    C271.771,53.917,271.783,50.469,267.485,46.164z" fill="#FFF" /> <path d="M254.571,110.462l-7.465,7.465l-4.966-4.96l13.347-13.347c1.15-1.15,1.831-2.703,1.905-4.323    c0.049-1.206,0.111-12.088-13.421-25.621c-13.529-13.539-24.412-13.467-25.621-13.427c-1.63,0.081-3.17,0.761-4.32,1.911    L98.851,173.325c-0.708,0.705-1.252,1.584-1.565,2.549l-16.124,48.372c-0.779,2.338-0.173,4.917,1.581,6.673    c1.735,1.744,4.32,2.345,6.655,1.565l48.384-16.131c0.959-0.321,1.818-0.865,2.533-1.552l97.032-97.035l4.958,4.96l-30.996,30.986    c-2.65,2.66-2.65,6.946,0,9.605c1.33,1.33,3.062,1.985,4.802,1.985c1.732,0,3.473-0.655,4.793-1.985l43.267-43.263    c2.647-2.647,2.647-6.939,0-9.593C261.517,107.809,257.218,107.809,254.571,110.462z" fill="#FFF" /> </svg>
                                                                </div>
                                                                <div class="name-area text-link-1">
                                                                    Rename
                                                                </div>
                                                            </div>
                                                        </li>
                                                        <li ng-click="confirmDeleteFile(appointmentfilesItem)" ng-if="renameDelete" >
                                                            <div class="layout-fixed">
                                                                <div class="icon-area">
                                                                    <svg class="h16px" viewBox="0 0 59 59"> <path d="M52.5,6H38.456c-0.11-1.25-0.495-3.358-1.813-4.711C35.809,0.434,34.751,0,33.499,0H23.5c-1.252,0-2.31,0.434-3.144,1.289   C19.038,2.642,18.653,4.75,18.543,6H6.5c-0.552,0-1,0.447-1,1s0.448,1,1,1h46c0.552,0,1-0.447,1-1S53.052,6,52.5,6z M20.553,6   c0.112-1.048,0.435-2.496,1.24-3.319C22.24,2.223,22.799,2,23.5,2h9.999c0.701,0,1.26,0.223,1.708,0.681   c0.805,0.823,1.128,2.271,1.24,3.319H20.553z" /> <path d="M10.456,54.021C10.493,55.743,11.565,59,15.364,59h28.272c3.799,0,4.871-3.257,4.907-4.958L50.376,10H8.624L10.456,54.021z    M17.5,42h24c0.552,0,1,0.447,1,1s-0.448,1-1,1h-24c-0.552,0-1-0.447-1-1S16.948,42,17.5,42z M17.5,47h24c0.552,0,1,0.447,1,1   s-0.448,1-1,1h-24c-0.552,0-1-0.447-1-1S16.948,47,17.5,47z M17.5,52h24c0.552,0,1,0.447,1,1s-0.448,1-1,1h-24   c-0.552,0-1-0.447-1-1S16.948,52,17.5,52z" /> </svg>
                                                                </div>
                                                                <div class="name-area text-link-1">
                                                                    Delete
                                                                </div>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="popup-overlay"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="layout-fixed mgT10">
                                        <div class="w80px clear v-bottom-i pdB5" ng-click=" viewDownload ? fileFolderViewerSchedule($event): '' ">
                                            <svg class="block h40px" viewBox="0 0 56 56"> <g> <path style="fill:#E9E9E0;" d="M36.985,0H7.963C7.155,0,6.5,0.655,6.5,1.926V55c0,0.345,0.655,1,1.463,1h40.074   c0.808,0,1.463-0.655,1.463-1V12.978c0-0.696-0.093-0.92-0.257-1.085L37.607,0.257C37.442,0.093,37.218,0,36.985,0z" /> <polygon style="fill:#D9D7CA;" points="37.5,0.151 37.5,12 49.349,12  " /> <path style="fill:#CC4B4C;" d="M19.514,33.324L19.514,33.324c-0.348,0-0.682-0.113-0.967-0.326   c-1.041-0.781-1.181-1.65-1.115-2.242c0.182-1.628,2.195-3.332,5.985-5.068c1.504-3.296,2.935-7.357,3.788-10.75   c-0.998-2.172-1.968-4.99-1.261-6.643c0.248-0.579,0.557-1.023,1.134-1.215c0.228-0.076,0.804-0.172,1.016-0.172   c0.504,0,0.947,0.649,1.261,1.049c0.295,0.376,0.964,1.173-0.373,6.802c1.348,2.784,3.258,5.62,5.088,7.562   c1.311-0.237,2.439-0.358,3.358-0.358c1.566,0,2.515,0.365,2.902,1.117c0.32,0.622,0.189,1.349-0.39,2.16   c-0.557,0.779-1.325,1.191-2.22,1.191c-1.216,0-2.632-0.768-4.211-2.285c-2.837,0.593-6.15,1.651-8.828,2.822   c-0.836,1.774-1.637,3.203-2.383,4.251C21.273,32.654,20.389,33.324,19.514,33.324z M22.176,28.198   c-2.137,1.201-3.008,2.188-3.071,2.744c-0.01,0.092-0.037,0.334,0.431,0.692C19.685,31.587,20.555,31.19,22.176,28.198z    M35.813,23.756c0.815,0.627,1.014,0.944,1.547,0.944c0.234,0,0.901-0.01,1.21-0.441c0.149-0.209,0.207-0.343,0.23-0.415   c-0.123-0.065-0.286-0.197-1.175-0.197C37.12,23.648,36.485,23.67,35.813,23.756z M28.343,17.174   c-0.715,2.474-1.659,5.145-2.674,7.564c2.09-0.811,4.362-1.519,6.496-2.02C30.815,21.15,29.466,19.192,28.343,17.174z    M27.736,8.712c-0.098,0.033-1.33,1.757,0.096,3.216C28.781,9.813,27.779,8.698,27.736,8.712z" /> <path style="fill:#CC4B4C;" d="M48.037,56H7.963C7.155,56,6.5,55.345,6.5,54.537V39h43v15.537C49.5,55.345,48.845,56,48.037,56z" /> <g> <path style="fill:#FFFFFF;" d="M17.385,53h-1.641V42.924h2.898c0.428,0,0.852,0.068,1.271,0.205    c0.419,0.137,0.795,0.342,1.128,0.615c0.333,0.273,0.602,0.604,0.807,0.991s0.308,0.822,0.308,1.306    c0,0.511-0.087,0.973-0.26,1.388c-0.173,0.415-0.415,0.764-0.725,1.046c-0.31,0.282-0.684,0.501-1.121,0.656    s-0.921,0.232-1.449,0.232h-1.217V53z M17.385,44.168v3.992h1.504c0.2,0,0.398-0.034,0.595-0.103    c0.196-0.068,0.376-0.18,0.54-0.335c0.164-0.155,0.296-0.371,0.396-0.649c0.1-0.278,0.15-0.622,0.15-1.032    c0-0.164-0.023-0.354-0.068-0.567c-0.046-0.214-0.139-0.419-0.28-0.615c-0.142-0.196-0.34-0.36-0.595-0.492    c-0.255-0.132-0.593-0.198-1.012-0.198H17.385z" /> <path style="fill:#FFFFFF;" d="M32.219,47.682c0,0.829-0.089,1.538-0.267,2.126s-0.403,1.08-0.677,1.477s-0.581,0.709-0.923,0.937    s-0.672,0.398-0.991,0.513c-0.319,0.114-0.611,0.187-0.875,0.219C28.222,52.984,28.026,53,27.898,53h-3.814V42.924h3.035    c0.848,0,1.593,0.135,2.235,0.403s1.176,0.627,1.6,1.073s0.74,0.955,0.95,1.524C32.114,46.494,32.219,47.08,32.219,47.682z     M27.352,51.797c1.112,0,1.914-0.355,2.406-1.066s0.738-1.741,0.738-3.09c0-0.419-0.05-0.834-0.15-1.244    c-0.101-0.41-0.294-0.781-0.581-1.114s-0.677-0.602-1.169-0.807s-1.13-0.308-1.914-0.308h-0.957v7.629H27.352z" /> <path style="fill:#FFFFFF;" d="M36.266,44.168v3.172h4.211v1.121h-4.211V53h-1.668V42.924H40.9v1.244H36.266z" /> </g> </g> </svg>
                                        </div>
                                        <div class="v-bottom-i">
                                            <div class="text-name-2">{{ sizeName(appointmentfilesItem.size) }}</div>
                                            <div class="layout-fixed mgT8">
                                                <div>
                                                    <div class="layout-fixed w-auto-i baseline">
                                                        <div class="text-name-2 text-none-transform-i">Upload time:</div>
                                                        <div class="text-date-1 lowercase pdL3 ng-binding">{{ appointmentfilesItem.created_date | date:flongDate }}</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="text mgT8-i">{{ appointmentfilesItem.description }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="box-files" ng-show="filetypeAppointment=='All' || filetypeAppointment=='Other'">
                    <div class="box-setting-4 no-saperator">
                        <div class="title">Other files</div>
                    </div>
                    <ul class="lst-file">
                        <li class="box-setting-4" ng-repeat="appointmentfilesItem in dataAppointmentHistoryFileItem.files" ng-if="sortFiletypeAppointment(appointmentfilesItem.extension) =='Other'" data-item="{{appointmentfilesItem}}">
                            <div class="content content-in">
                                <div class="itm row-one-content">
                                    <div class="layout-fixed">
                                        <div class="v-top-i" ng-click="viewDownload ? fileFolderViewerSchedule($event) : '' ">
                                            <div class="name clr-black first-capitalize">{{ appointmentfilesItem.name }}</div>
                                        </div>
                                        <div class="w40px clear v-top-i relative">
                                            <button class="bg-transparent right biger-3-time" onclick="openQuickOption(this)">
                                                <svg class="h16px clr-symbol-clickable" viewBox="0 0 512 512"> <circle r="61.793" cy="256" cx="61.793" fill="#1075BB" /> <circle r="61.793" cy="256" cx="450.207" fill="#1075BB" /> <circle r="61.793" cy="256" cx="256" fill="#1075BB" /> </svg>
                                            </button>
                                            <div class="quick-popup box-popup-1 display-top-right mgT20" onclick="closeQuickOption(this)">
                                                <div class="popup-content w150px">
                                                    <ul class="list-item-03">
                                                        <li ng-if="appointmentfilesItem.path==null && viewDownload" ng-click="downloadFile('upload/customers/'+ detailCustomerData.id +'/appointment/'+ dataAppointmentHistoryFileItem.id +'/'+ appointmentfilesItem.name)">
                                                            <div class="layout-fixed">
                                                                <div class="icon-area">
                                                                    <svg class="h15px" viewBox="0 0 58 58"> <path d="M21.707,24.293c-0.391-0.391-1.023-0.391-1.414,0s-0.391,1.023,0,1.414l7.999,7.999c0.001,0.001,0.001,0.001,0.002,0.002   L29,34.414l0.706-0.706c0.001-0.001,0.001-0.001,0.002-0.002l7.999-7.999c0.391-0.391,0.391-1.023,0-1.414s-1.023-0.391-1.414,0   L30,30.586V3c0-0.552-0.447-1-1-1s-1,0.448-1,1v27.586L21.707,24.293z" /> <path d="M57.981,32.676L57.53,32h-0.009l-3.583-5.381l-2.421-3.628l0.004-0.002L47.535,17H36v2h10.465l8.679,13H39v7H19v-7H2.856   l8.679-13H22v-2H10.465L0.431,32.031l-0.014,0.001L0,32.655v0.206v0.396v19.359C0,54.482,1.519,56,3.385,56h51.23   C56.481,56,58,54.482,58,52.616V33.239v-0.429l-0.014-0.036L57.981,32.676z" /> </svg>
                                                                </div>
                                                                <div class="name-area text-link-1">
                                                                    Download
                                                                </div>
                                                            </div>
                                                        </li>
                                                        <li ng-if="appointmentfilesItem.path!=null && viewDownload" ng-click="downloadFile(appointmentfilesItem.path)">
                                                            <div class="layout-fixed">
                                                                <div class="icon-area">
                                                                    <svg class="h15px" viewBox="0 0 58 58"> <path d="M21.707,24.293c-0.391-0.391-1.023-0.391-1.414,0s-0.391,1.023,0,1.414l7.999,7.999c0.001,0.001,0.001,0.001,0.002,0.002   L29,34.414l0.706-0.706c0.001-0.001,0.001-0.001,0.002-0.002l7.999-7.999c0.391-0.391,0.391-1.023,0-1.414s-1.023-0.391-1.414,0   L30,30.586V3c0-0.552-0.447-1-1-1s-1,0.448-1,1v27.586L21.707,24.293z" /> <path d="M57.981,32.676L57.53,32h-0.009l-3.583-5.381l-2.421-3.628l0.004-0.002L47.535,17H36v2h10.465l8.679,13H39v7H19v-7H2.856   l8.679-13H22v-2H10.465L0.431,32.031l-0.014,0.001L0,32.655v0.206v0.396v19.359C0,54.482,1.519,56,3.385,56h51.23   C56.481,56,58,54.482,58,52.616V33.239v-0.429l-0.014-0.036L57.981,32.676z" /> </svg>
                                                                </div>
                                                                <div class="name-area text-link-1">
                                                                    Download
                                                                </div>
                                                            </div>
                                                        </li>
                                                        <li ng-click="openByGetTemplate('popupScheduleDetailFileManagementName') ; getNameFile(appointmentfilesItem.id)" ng-if="renameDelete">
                                                            <div class="layout-fixed">
                                                                <div class="icon-area">
                                                                    <svg class="h15px" viewBox="0 0 285 285"> <path d="M216.818,271.424H26.821V81.427h61.713c3.748,0,6.788-3.04,6.788-6.788V13.576h121.496v29.246    c0.3-0.037,0.591-0.115,0.903-0.127c1.753-0.068,5.165,0.019,9.708,1.237c0.909,0.235,1.917,0.572,2.965,0.934V6.788    c0-3.748-3.04-6.788-6.788-6.788H87.894c-1.8,0-3.532,0.714-4.803,1.985l-67.86,67.861c-1.271,1.271-1.985,2.993-1.985,4.793    v203.583c0,3.741,3.04,6.778,6.788,6.778h203.573c3.748,0,6.788-3.037,6.788-6.778V173.01c-3.68,3.612-8.554,5.592-13.576,5.765    L216.818,271.424L216.818,271.424z" fill="#FFF" /> <path d="M267.485,46.164c-4.305-4.305-7.768-4.289-8.139-4.268c-0.52,0.016-1.015,0.235-1.379,0.597l-15.422,15.422    c2.242,1.395,4.704,3.278,7.301,5.875c2.61,2.61,4.49,5.068,5.888,7.308L271.14,55.68c0.377-0.371,0.587-0.857,0.612-1.376    C271.771,53.917,271.783,50.469,267.485,46.164z" fill="#FFF" /> <path d="M254.571,110.462l-7.465,7.465l-4.966-4.96l13.347-13.347c1.15-1.15,1.831-2.703,1.905-4.323    c0.049-1.206,0.111-12.088-13.421-25.621c-13.529-13.539-24.412-13.467-25.621-13.427c-1.63,0.081-3.17,0.761-4.32,1.911    L98.851,173.325c-0.708,0.705-1.252,1.584-1.565,2.549l-16.124,48.372c-0.779,2.338-0.173,4.917,1.581,6.673    c1.735,1.744,4.32,2.345,6.655,1.565l48.384-16.131c0.959-0.321,1.818-0.865,2.533-1.552l97.032-97.035l4.958,4.96l-30.996,30.986    c-2.65,2.66-2.65,6.946,0,9.605c1.33,1.33,3.062,1.985,4.802,1.985c1.732,0,3.473-0.655,4.793-1.985l43.267-43.263    c2.647-2.647,2.647-6.939,0-9.593C261.517,107.809,257.218,107.809,254.571,110.462z" fill="#FFF" /> </svg>
                                                                </div>
                                                                <div class="name-area text-link-1">
                                                                    Rename
                                                                </div>
                                                            </div>
                                                        </li>
                                                        <li ng-click="confirmDeleteFile(appointmentfilesItem)" ng-if="renameDelete">
                                                            <div class="layout-fixed">
                                                                <div class="icon-area">
                                                                    <svg class="h16px" viewBox="0 0 59 59"> <path d="M52.5,6H38.456c-0.11-1.25-0.495-3.358-1.813-4.711C35.809,0.434,34.751,0,33.499,0H23.5c-1.252,0-2.31,0.434-3.144,1.289   C19.038,2.642,18.653,4.75,18.543,6H6.5c-0.552,0-1,0.447-1,1s0.448,1,1,1h46c0.552,0,1-0.447,1-1S53.052,6,52.5,6z M20.553,6   c0.112-1.048,0.435-2.496,1.24-3.319C22.24,2.223,22.799,2,23.5,2h9.999c0.701,0,1.26,0.223,1.708,0.681   c0.805,0.823,1.128,2.271,1.24,3.319H20.553z" /> <path d="M10.456,54.021C10.493,55.743,11.565,59,15.364,59h28.272c3.799,0,4.871-3.257,4.907-4.958L50.376,10H8.624L10.456,54.021z    M17.5,42h24c0.552,0,1,0.447,1,1s-0.448,1-1,1h-24c-0.552,0-1-0.447-1-1S16.948,42,17.5,42z M17.5,47h24c0.552,0,1,0.447,1,1   s-0.448,1-1,1h-24c-0.552,0-1-0.447-1-1S16.948,47,17.5,47z M17.5,52h24c0.552,0,1,0.447,1,1s-0.448,1-1,1h-24   c-0.552,0-1-0.447-1-1S16.948,52,17.5,52z" /> </svg>
                                                                </div>
                                                                <div class="name-area text-link-1">
                                                                    Delete
                                                                </div>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="popup-overlay"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="layout-fixed mgT10">
                                        <div class="w80px clear v-bottom-i pdB5" ng-click=" viewDownload ? fileFolderViewerSchedule($event) : '' ">
                                            <!--ng-if="appointmentfilesItem.path==null" ng-click="cordovaBrowser(showImagePhone('upload/customers/'+ detailCustomerData.id +'/appointment/'+ dataAppointmentHistoryFileItem.id +'/'+ appointmentfilesItem.name))"-->
                                            <!--ng-if="appointmentfilesItem.path!=null" ng-click="cordovaBrowser(showImagePhone(appointmentfilesItem.path))"-->
                                            <svg class="block h40px" viewBox="0 0 56 56"> <path d="M36.985,0H7.963C7.155,0,6.5,0.655,6.5,1.926V55c0,0.345,0.655,1,1.463,1h40.074   c0.808,0,1.463-0.655,1.463-1V12.978c0-0.696-0.093-0.92-0.257-1.085L37.607,0.257C37.442,0.093,37.218,0,36.985,0z" style="fill:#E9E9E0;" /> <polygon points="37.5,0.151 37.5,12 49.349,12  " style="fill:#D9D7CA;" /> </svg>
                                        </div>
                                        <div class="v-bottom-i">
                                            <div class="text-name-2">{{ sizeName(appointmentfilesItem.size) }}</div>
                                            <div class="layout-fixed mgT8">
                                                <div>
                                                    <div class="layout-fixed w-auto-i baseline">
                                                        <div class="text-name-2 text-none-transform-i">Upload time:</div>
                                                        <div class="text-date-1 lowercase pdL3 ng-binding">{{ appointmentfilesItem.created_date | date:flongDate }}</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="text mgT8-i">{{ appointmentfilesItem.description }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>



                <div class="box-files" ng-show="filetypeAppointment=='All' || filetypeAppointment=='url'">
                    <div class="box-setting-4 no-saperator">
                        <div class="title">Url<div class="right" ng-click="openFormAddUrl('customer')">Add New</div></div>
                    </div>
                    
                    <ul class="lst-file">
                        <li class="box-setting-4" ng-repeat="appointmentfilesItem in dataAppointmentHistoryFileItem.files" ng-if="sortFiletypeAppointment(appointmentfilesItem.extension) =='url'" data-item="{{appointmentfilesItem}}">
                            <div class="content content-in">
                                <div class="itm row-one-content">
                                    <div class="layout-fixed">
                                        <div class="v-top-i">
                                            <a class="name clr-blue first-capitalize" ng-click="openUrl(appointmentfilesItem.path)">{{ appointmentfilesItem.path }}</a>
                                        </div>
                                        <div class="w40px clear v-top-i relative">
                                            <button class="bg-transparent right biger-3-time" onclick="openQuickOption(this)">
                                                <svg class="h16px clr-symbol-clickable" viewBox="0 0 512 512"> <circle r="61.793" cy="256" cx="61.793" fill="#1075BB" /> <circle r="61.793" cy="256" cx="450.207" fill="#1075BB" /> <circle r="61.793" cy="256" cx="256" fill="#1075BB" /> </svg>
                                            </button>
                                            <div class="quick-popup box-popup-1 display-top-right mgT20" onclick="closeQuickOption(this)">
                                                <div class="popup-content w150px">
                                                    <ul class="list-item-03">
                                                        <li ng-click="confirmDeleteFile(appointmentfilesItem)" ng-if="renameDelete">
                                                            <div class="layout-fixed">
                                                                <div class="icon-area">
                                                                    <svg class="h16px" viewBox="0 0 59 59"> <path d="M52.5,6H38.456c-0.11-1.25-0.495-3.358-1.813-4.711C35.809,0.434,34.751,0,33.499,0H23.5c-1.252,0-2.31,0.434-3.144,1.289   C19.038,2.642,18.653,4.75,18.543,6H6.5c-0.552,0-1,0.447-1,1s0.448,1,1,1h46c0.552,0,1-0.447,1-1S53.052,6,52.5,6z M20.553,6   c0.112-1.048,0.435-2.496,1.24-3.319C22.24,2.223,22.799,2,23.5,2h9.999c0.701,0,1.26,0.223,1.708,0.681   c0.805,0.823,1.128,2.271,1.24,3.319H20.553z" /> <path d="M10.456,54.021C10.493,55.743,11.565,59,15.364,59h28.272c3.799,0,4.871-3.257,4.907-4.958L50.376,10H8.624L10.456,54.021z    M17.5,42h24c0.552,0,1,0.447,1,1s-0.448,1-1,1h-24c-0.552,0-1-0.447-1-1S16.948,42,17.5,42z M17.5,47h24c0.552,0,1,0.447,1,1   s-0.448,1-1,1h-24c-0.552,0-1-0.447-1-1S16.948,47,17.5,47z M17.5,52h24c0.552,0,1,0.447,1,1s-0.448,1-1,1h-24   c-0.552,0-1-0.447-1-1S16.948,52,17.5,52z" /> </svg>
                                                                </div>
                                                                <div class="name-area text-link-1">
                                                                    Delete
                                                                </div>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <div class="popup-overlay"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="layout-fixed mgT10">
                                        <div class="w80px clear v-bottom-i pdB5" ng-click=" viewDownload ? fileFolderViewerSchedule($event) : '' ">
                                            <svg version="1.1" class="block h40px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                            viewBox="0 0 482.8 482.8" style="enable-background:new 0 0 482.8 482.8;" xml:space="preserve" fill="#216191">
                                            <g>
                                                <g>
                                                    <path d="M255.2,209.3c-5.3,5.3-5.3,13.8,0,19.1c21.9,21.9,21.9,57.5,0,79.4l-115,115c-21.9,21.9-57.5,21.9-79.4,0l-17.3-17.3
                                                    c-21.9-21.9-21.9-57.5,0-79.4l115-115c5.3-5.3,5.3-13.8,0-19.1s-13.8-5.3-19.1,0l-115,115C8.7,322.7,0,343.6,0,365.8
                                                    c0,22.2,8.6,43.1,24.4,58.8l17.3,17.3c16.2,16.2,37.5,24.3,58.8,24.3s42.6-8.1,58.8-24.3l115-115c32.4-32.4,32.4-85.2,0-117.6
                                                    C269.1,204,260.5,204,255.2,209.3z"/>
                                                    <path d="M458.5,58.2l-17.3-17.3c-32.4-32.4-85.2-32.4-117.6,0l-115,115c-32.4,32.4-32.4,85.2,0,117.6c5.3,5.3,13.8,5.3,19.1,0
                                                    s5.3-13.8,0-19.1c-21.9-21.9-21.9-57.5,0-79.4l115-115c21.9-21.9,57.5-21.9,79.4,0l17.3,17.3c21.9,21.9,21.9,57.5,0,79.4l-115,115
                                                    c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4s6.9-1.3,9.5-4l115-115c15.7-15.7,24.4-36.6,24.4-58.8
                                                    C482.8,94.8,474.2,73.9,458.5,58.2z"/>
                                                </g>
                                            </g>
                                        </svg>
                                    </div>
                                    <div class="v-bottom-i">
                                        <div class="text-name-2">{{ appointmentfilesItem.created_name }}</div>
                                        <div class="layout-fixed mgT8">
                                            <div>
                                                <div class="layout-fixed w-auto-i baseline">
                                                    <div class="text-name-2 text-none-transform-i">Upload time:</div>
                                                    <div class="text-date-1 lowercase pdL3 ng-binding">{{ appointmentfilesItem.created_date | date:flongDate }}</div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text mgT8-i">{{ appointmentfilesItem.description }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </ion-scroll>
</div>
</div>
<div class="app-create-button show">
    <button class="button-attach-1 pd0-i w50px h50px" type="button" ng-click="openPopupAddFile(dataAppointmentHistoryFileItem.id)"></button>
</div>
