<div class="app-header bg-header-1">
    <div class="layout-fixed full-h text-center">
        <div class="full-h v-bottom-i pdB15">
            <div class="app-content-header bg-header-1">
                <div class="text-title-header-1 nowrap mgT10">Add Payment to Multiple Invoices</div>
            </div>
        </div>
    </div>
    <button class="popup-back-button bg-transparent pd0-i biger-3-time" type="button" ng-click="closeTarget('#popupAddPaymentMulti')"></button>
</div>
<form class="app-content" id="formAddPaymentMulti" name="formAddPaymentMulti" novalidate="" ng-submit="validateFormSplitPayment(formAddPaymentMulti)">
    <button type="submit" id="submitFormSplitPayment" style="display:none;">submit</button>
    <div class="app-content-inner content-pd">
        <ion-scroll class="scroll-area" direction="y" has-bouncing="false" overflow-scroll="false" delegate-handle="scrollPopupSplitPayment" on-scroll="scrollContent('scrollPopupSplitPayment')">

            <div class="box-setting-4 form-field-container">
                <div class="content content-in">
                    <div class="itm">
                        <label class="label-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.payment_type.$invalid }">Payment Type</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.payment_type.$invalid }" ng-click="focusHandle($event)">
                                    <input type="text" class="h32px" placeholder="" value="{{Input_value.payment_type}}" ng-init="Input_value.payment_type = 'Select Payment Type'">
                                    <div class="sign-r clear">
                                        <button class="bg-transparent full-h right pdR10" type="button">
                                            <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                        </button>
                                    </div>
                                    <select class="field-overlay" name="payment_type" ng-change="changePaymentType(payment_type)" ng-model="payment_type" required="">
                                        <option value="">Select Payment Type</option>
                                        <option value="Cash">Cash</option>
                                        <option value="Check">Check</option>
                                        <option value="CC Manual">CC Manual</option>
                                        <option value="Wells Fargo Plan">Wells Fargo Plan</option>
                                        <option value="Credit Memo">Credit Memo</option>
                                        <option value="Manager Credit">Manager Credit</option>
                                        <option value="In Store Credit">In Store Credit</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="itm" ng-if="payment_type=='Cash'">
                        <label class="label-form-field-1">Amount</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.cash_amount.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" ng-model="Cash.Amount"  class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="cash_amount" ng-change="calculatePayment()">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="itm" ng-if="payment_type=='Check'" >
                        <label class="label-form-field-1">Amount</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.check_amount.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" ng-model="Check.Amount"  name="check_amount" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required ng-change="calculatePayment()">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="payment_type=='Check'" >
                        <label class="label-form-field-1">Authorization #</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.check_authorization.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text"  name="check_authorization" ng-model="Check.Authorization" class="h32px" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="payment_type=='Check'" >
                        <label class="label-form-field-1">Check #</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.check_check.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text"  name="check_check" ng-model="Check.Check" class="h32px" required>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="itm" ng-if="payment_type=='CC Manual'">
                        <div class="layout-fixed input-1-group">
                            <div>
                                <label class="label-form-field-1">First Name</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.CC_Manual_first_name.$invalid  }" ng-click="focusHandle($event)">
                                            <input class="h32px" name="CC_Manual_first_name" value="" placeholder="" type="text" ng-model="CC_Manual.first_name" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label class="label-form-field-1">Last Name</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.CC_Manual_last_name.$invalid  }" ng-click="focusHandle($event)">
                                            <input class="h32px" name="CC_Manual_last_name" value="" placeholder="" type="text" ng-model="CC_Manual.last_name" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="payment_type=='CC Manual'">
                        <label class="label-form-field-1">Address</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.CC_Manual_street.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" class="h32px" name="CC_Manual_street" value="" placeholder="" ng-model="CC_Manual.street" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="payment_type=='CC Manual'">
                        <div class="layout-fixed input-1-group">
                            <div class="layout-w-1:2">
                                <label class="label-form-field-1">City</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.CC_Manual_city.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" name="CC_Manual_city" value="" placeholder="" ng-model="CC_Manual.city" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label class="label-form-field-1">State</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.CC_Manual_state.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" name="CC_Manual_state" value="" placeholder="" ng-model="CC_Manual.state" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label class="label-form-field-1">Zip code</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.CC_Manual_zipcode.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="ft-fifth h32px" value="" placeholder="" ng-model="CC_Manual.zipcode" name="CC_Manual_zipcode" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="payment_type=='CC Manual'">
                        <div class="layout-fixed">
                            <div>
                                <label class="label-form-field-1">Credit card type</label>
                                <div class="text pdL5 mgT5 logs">
                                    Please input card number
                                    <a id="CC_ManualScanBtn">
                                        <svg  viewBox="0 0 512 512" class="h30px"> <circle style="fill:#F5EB07;" cx="256" cy="256" r="256"/> <path style="fill:#F1592F;" d="M38.484,27.88h435.032c13.192,0,23.884,10.44,23.884,23.316v272.916 c0,12.876-10.696,23.316-23.884,23.316H38.484c-13.192,0-23.884-10.44-23.884-23.316V51.196C14.6,38.32,25.292,27.88,38.484,27.88z"/> <circle style="fill:#70B1E1;" cx="89.392" cy="100.64" r="42.656"/> <circle style="fill:#F5EA07;" cx="143.056" cy="100.64" r="42.656"/> <g> <rect x="14.6" y="261.88" style="fill:#FDFEFF;" width="482.8" height="39.068"/> <path style="fill:#FDFEFF;" d="M458.236,117.88h-134.8c-2.716,0-4.94-2.224-4.94-4.94s2.224-4.94,4.94-4.94h134.8 C464.764,107.996,464.764,117.88,458.236,117.88z"/> <path style="fill:#FDFEFF;" d="M463.18,140.244c0,2.716-2.224,4.94-4.94,4.94h-134.8c-2.716,0-4.94-2.224-4.94-4.94 c0-6.852-3.688-4.94,139.74-4.94C460.956,135.304,463.18,137.528,463.18,140.244z"/> <path style="fill:#FDFEFF;" d="M323.44,80.688h93.628c2.716,0,4.94,2.18,4.94,4.94c0,6.8-0.492,4.94-98.568,4.94 C316.936,90.572,316.884,80.688,323.44,80.688z"/> </g> <path style="fill:#4D5BA5;" d="M455.72,447.052l-2.336,1.452l-41.42-58.968l1.684-1.048c3.624-2.252,4.724-6.972,2.472-10.596 c-2.244-3.608-6.988-4.712-10.596-2.472l-1.716,1.068L390.756,355.5l-27.248,16.924l13.048,20.988l-1.716,1.064 c-3.584,2.228-4.74,6.908-2.476,10.62c2.244,3.608,6.988,4.712,10.596,2.472l1.684-1.048l34.616,63.22l-2.364,1.472 c-1.648,1.004-2.704,2.604-3.112,4.356c-0.404,1.728-0.164,3.628,0.872,5.26c2.016,3.276,6.332,4.28,9.612,2.24l38.836-24.128 c1.624-1.012,2.704-2.604,3.112-4.352s0.144-3.656-0.864-5.284C463.312,446.044,458.996,445.036,455.72,447.052z"/> <path style="fill:#F1592F;" d="M413.864,247.616c-2.048-11.676-9.084-20.824-15.084-30.696 c-6.788-11.168-10.148-19.564-22.708-25.368c-12.132-5.608-26.976-9.248-40.088-11.412c-26.924-4.444-57.648,4.236-80,19.708 c-1.164,0.804-2.32,1.44-3.468,1.952c-4.08,5.776-8.832,12.088-14.908,15.796c-1.812,6-3.636,11.992-4.8,17.968 c-3.496,17.928-6.548,39.112-2.048,57c1.62,6.436,1.4,14.86,3.836,20.912c2.232,5.544,6.956,10.076,9.544,15.572 c3.216,6.84,3.868,15.672,9.508,21.16c4.86,4.728,13.372,6.472,19.656,8.248c8.88,2.504,13.068,9.184,13.628,16.28h77.852 c1.404-5.988,5.372-11.456,12.5-14.188c9.116-3.492,18.64-25.704,22.5-33.04c7.108-13.5,12.424-26.86,14.012-42.128 C415.052,273.32,415.976,259.66,413.864,247.616z"/> <g> <path style="fill:#D64331;" d="M229.048,268.74c1.072-2.244,1.94-4.644,2.908-6.632c2.192-4.388,1.784-9.284,1.784-14.128 c0-3.876-0.764-7.5-1.072-11.272c-0.012-0.116-0.004-0.208-0.012-0.32c-2.024,10.48-3.828,22.008-4.084,33.332 C228.732,269.392,228.9,269.072,229.048,268.74z"/> <path style="fill:#D64331;" d="M255.988,199.844c-1.164,0.804-2.32,1.44-3.468,1.952c-3.444,4.876-7.368,10.124-12.156,13.888 c0.268-0.08,0.464-0.176,0.772-0.248c1.02-0.204,3.468-0.104,4.284-0.716c1.684-1.324,0.764-3.776,3.06-5 c3.368-1.836,9.588,1.48,13.056,1.732c5,0.356,10.048-2.96,12.6-7.04c2.784-4.384,3.856-10.304,3.592-16.344 C269.964,191.3,262.604,195.264,255.988,199.844z"/> </g> <path style="fill:#FDFEFF;" d="M228.612,268.74c-0.248,8.196,0.26,16.304,2.152,23.824c2.14,8.508,0.848,16.524,5.716,24.584 h168.368c4.516-10.096,7.768-20.404,8.952-31.772c0.556-5.324,1.024-10.964,1.22-16.636L228.612,268.74L228.612,268.74z"/> <path style="fill:#70B1E1;" d="M262.036,178.848c-52.856,32.864-69.056,102.336-36.192,155.188 c32.864,52.856,102.336,69.056,155.188,36.192c52.844-32.856,69.056-102.336,36.192-155.188 C384.36,162.184,314.876,145.992,262.036,178.848z M368.78,350.52c-41.968,26.096-97.156,13.224-123.24-28.728 c-26.096-41.968-13.216-97.14,28.752-123.236c41.952-26.084,97.12-13.22,123.212,28.744 C423.588,269.252,410.732,324.432,368.78,350.52z"/> </svg>
                                    </a>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="payment_type=='CC Manual'">
                        <label class="label-form-field-1">Credit Card #</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_card_number.$invalid.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" class="h32px" value="" placeholder="" ng-model="CC_Manual.card_number" name="card_number" required id="CC_Manual_card_number" ng-change="requiredAmount(CC_Manual.card_number, 'CC_Manual_cart')">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="payment_type=='CC Manual'">
                        <div class="layout-fixed input-1-group">
                            <div>
                                <label class="label-form-field-1">Expn Date - Month</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.CC_Manual_month_cc.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" ng-model="Input_value.CC_Manual_month_cc" placeholder="" required>
                                            <div class="sign-r clear">
                                                <button class="bg-transparent full-h right pdR10" type="button">
                                                    <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                                </button>
                                            </div>
                                            <select ng-model="CC_Manual.month_cc" class="field-overlay" ng-change="set_month(CC_Manual.month_cc,'manual')"
                                            ng-options="item.value as item.name for item in monthNames| orderBy:['value']" required name="CC_Manual_month_cc">
                                            <option value="">-----</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div>
                            <label class="label-form-field-1">Expn Date - Year</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.CC_Manual_year_cc.$invalid  }" ng-click="focusHandle($event)">
                                        <input type="text" class="h32px" ng-model="CC_Manual.year_cc" placeholder="" required  name="year">
                                        <div class="sign-r clear">
                                            <button class="bg-transparent full-h right pdR10" type="button">
                                                <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                            </button>
                                        </div>
                                        <select name="CC_Manual_year_cc" ng-model="CC_Manual.year_cc" class="field-overlay" ng-options="item as item for item in yearName" required ng-disabled="checkbox.use_credit_card_check == 1">
                                            <option value="">-----</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="layout-w-1:4">
                            <label class="label-form-field-1">CVV2 (Code)</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.CVV2_Code.$invalid  }" ng-click="focusHandle($event)">
                                        <input type="text" class="h32px" name="CVV2_Code" value="" placeholder="" ng-change="requiredcvv(CC_Manual.CVV2_Code, 'CC_Manual')" ng-model="CC_Manual.CVV2_Code" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="itm" ng-if="payment_type=='CC Manual'">
                    <label class="label-form-field-1">Amount</label>
                    <div class="layout-fixed">
                        <div>
                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.CC_Manual_Amount.$invalid  }" ng-click="focusHandle($event)">
                                <input type="text" ng-model="CC_Manual.Amount"  name="CC_Manual_Amount" awnum num-sep="." num-int=18 num-fract=2 required ng-trim=false class="h32px" ng-change="calculatePayment()">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="itm" ng-if="payment_type=='Wells Fargo Plan'">
                    <label class="label-form-field-1">Authorization #</label>
                    <div class="layout-fixed">
                        <div>
                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.wellfargoflan_authorization.$invalid  }" ng-click="focusHandle($event)">
                                <input type="text"  name="wellfargoflan_authorization" ng-model="WellFargoPlan.authorization_number" class="h32px" required class="full-w" onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')" maxlength="10">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="itm" ng-if="payment_type=='Wells Fargo Plan'">
                    <label class="label-form-field-1">Amount:</label>
                    <div class="layout-fixed">
                        <div>
                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.wellfargoflan_amount.$invalid  }" ng-click="focusHandle($event)">
                                <input type="text" ng-model="WellFargoPlan.authorization_amount"  class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="wellfargoflan_amount" ng-change="calculatePayment()">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="itm" ng-if="payment_type=='Wells Fargo Plan'">
                    <label class="label-form-field-1">Credit Term Plan #:</label>
                    <div class="layout-fixed">
                        <div>
                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.credit_term_plan_number.$invalid }" ng-click="focusHandle($event)">
                                <input type="text" placeholder="" value="{{WellFargoPlan.credit_term_plan_number}}" name="credit_term_plan_number" class="h32px" onkeyup="CheckNumber(this, '0123456789.')">
                                <div class="sign-r clear">
                                    <button class="bg-transparent full-h right pdR10" type="button">
                                        <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                    </button>
                                </div>
                                <select class="field-overlay" ng-model="WellFargoPlan.credit_term_plan_number" name="" ng-options="item.label as item.value for item in credittermplans">
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="itm" ng-if="payment_type=='Wells Fargo Plan'">
                    <div class="layout-fixed">
                        <div>
                            <div class="layout-fixed">
                                <div class="w25px">
                                    <svg class="h15px clr-symbol" viewBox="0 0 55 55"> <path fill="#b1c7d7" d="M55,27.5C55,12.337,42.663,0,27.5,0S0,12.337,0,27.5c0,8.009,3.444,15.228,8.926,20.258l-0.026,0.023l0.892,0.752  c0.058,0.049,0.121,0.089,0.179,0.137c0.474,0.393,0.965,0.766,1.465,1.127c0.162,0.117,0.324,0.234,0.489,0.348  c0.534,0.368,1.082,0.717,1.642,1.048c0.122,0.072,0.245,0.142,0.368,0.212c0.613,0.349,1.239,0.678,1.88,0.98  c0.047,0.022,0.095,0.042,0.142,0.064c2.089,0.971,4.319,1.684,6.651,2.105c0.061,0.011,0.122,0.022,0.184,0.033  c0.724,0.125,1.456,0.225,2.197,0.292c0.09,0.008,0.18,0.013,0.271,0.021C25.998,54.961,26.744,55,27.5,55  c0.749,0,1.488-0.039,2.222-0.098c0.093-0.008,0.186-0.013,0.279-0.021c0.735-0.067,1.461-0.164,2.178-0.287  c0.062-0.011,0.125-0.022,0.187-0.034c2.297-0.412,4.495-1.109,6.557-2.055c0.076-0.035,0.153-0.068,0.229-0.104  c0.617-0.29,1.22-0.603,1.811-0.936c0.147-0.083,0.293-0.167,0.439-0.253c0.538-0.317,1.067-0.648,1.581-1  c0.185-0.126,0.366-0.259,0.549-0.391c0.439-0.316,0.87-0.642,1.289-0.983c0.093-0.075,0.193-0.14,0.284-0.217l0.915-0.764  l-0.027-0.023C51.523,42.802,55,35.55,55,27.5z M2,27.5C2,13.439,13.439,2,27.5,2S53,13.439,53,27.5  c0,7.577-3.325,14.389-8.589,19.063c-0.294-0.203-0.59-0.385-0.893-0.537l-8.467-4.233c-0.76-0.38-1.232-1.144-1.232-1.993v-2.957  c0.196-0.242,0.403-0.516,0.617-0.817c1.096-1.548,1.975-3.27,2.616-5.123c1.267-0.602,2.085-1.864,2.085-3.289v-3.545  c0-0.867-0.318-1.708-0.887-2.369v-4.667c0.052-0.52,0.236-3.448-1.883-5.864C34.524,9.065,31.541,8,27.5,8  s-7.024,1.065-8.867,3.168c-2.119,2.416-1.935,5.346-1.883,5.864v4.667c-0.568,0.661-0.887,1.502-0.887,2.369v3.545  c0,1.101,0.494,2.128,1.34,2.821c0.81,3.173,2.477,5.575,3.093,6.389v2.894c0,0.816-0.445,1.566-1.162,1.958l-7.907,4.313  c-0.252,0.137-0.502,0.297-0.752,0.476C5.276,41.792,2,35.022,2,27.5z" /> </svg>
                                </div>
                                <div class="text">{{usercredentials.username}}</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="itm" ng-if="payment_type=='Wells Fargo Plan'">
                    <div class="layout-fixed">
                        <div>
                            <div class="layout-fixed">
                                <div class="w25px">
                                    <svg class="h15px clr-symbol" viewBox="0 0 60 60"> <path d="M22,27h15c0.553,0,1-0.448,1-1V14c0-0.552-0.447-1-1-1h-2v-2.5C35,7.467,32.532,5,29.5,5S24,7.467,24,10.5V13h-2   c-0.553,0-1,0.448-1,1v12C21,26.552,21.447,27,22,27z M26,10.5C26,8.57,27.57,7,29.5,7S33,8.57,33,10.5V13h-7V10.5z" fill="#FFFFFF" /> <path d="M49,33H11C4.935,33,0,37.935,0,44s4.935,11,11,11h38c6.065,0,11-4.935,11-11S55.065,33,49,33z M16.447,42.895l-2.928,1.464   L15.8,47.4c0.332,0.442,0.242,1.069-0.2,1.4c-0.18,0.135-0.39,0.2-0.599,0.2c-0.305,0-0.604-0.138-0.801-0.4L12,45.667L9.8,48.6   C9.604,48.862,9.304,49,8.999,49C8.79,49,8.58,48.935,8.4,48.8c-0.442-0.331-0.532-0.958-0.2-1.4l2.281-3.041l-2.928-1.464   c-0.494-0.247-0.694-0.848-0.447-1.342c0.248-0.494,0.849-0.695,1.342-0.447L11,42.382V39c0-0.552,0.447-1,1-1s1,0.448,1,1v3.382   l2.553-1.276c0.494-0.248,1.094-0.046,1.342,0.447C17.142,42.047,16.941,42.647,16.447,42.895z M28.447,42.895l-2.928,1.464   L27.8,47.4c0.332,0.442,0.242,1.069-0.2,1.4c-0.18,0.135-0.39,0.2-0.599,0.2c-0.305,0-0.604-0.138-0.801-0.4L24,45.667L21.8,48.6   c-0.196,0.262-0.496,0.4-0.801,0.4c-0.209,0-0.419-0.065-0.599-0.2c-0.442-0.331-0.532-0.958-0.2-1.4l2.281-3.041l-2.928-1.464   c-0.494-0.247-0.694-0.848-0.447-1.342c0.248-0.494,0.849-0.695,1.342-0.447L23,42.382V39c0-0.552,0.447-1,1-1s1,0.448,1,1v3.382   l2.553-1.276c0.494-0.248,1.095-0.046,1.342,0.447C29.142,42.047,28.941,42.647,28.447,42.895z M40.447,42.895l-2.928,1.464   L39.8,47.4c0.332,0.442,0.242,1.069-0.2,1.4c-0.18,0.135-0.39,0.2-0.599,0.2c-0.305,0-0.604-0.138-0.801-0.4L36,45.667L33.8,48.6   c-0.196,0.262-0.496,0.4-0.801,0.4c-0.209,0-0.419-0.065-0.599-0.2c-0.442-0.331-0.532-0.958-0.2-1.4l2.281-3.041l-2.928-1.464   c-0.494-0.247-0.694-0.848-0.447-1.342c0.248-0.494,0.847-0.695,1.342-0.447L35,42.382V39c0-0.552,0.447-1,1-1s1,0.448,1,1v3.382   l2.553-1.276c0.494-0.248,1.094-0.046,1.342,0.447C41.142,42.047,40.941,42.647,40.447,42.895z M52.447,42.895l-2.928,1.464   L51.8,47.4c0.332,0.442,0.242,1.069-0.2,1.4c-0.18,0.135-0.39,0.2-0.599,0.2c-0.305,0-0.604-0.138-0.801-0.4L48,45.667L45.8,48.6   c-0.196,0.262-0.496,0.4-0.801,0.4c-0.209,0-0.419-0.065-0.599-0.2c-0.442-0.331-0.532-0.958-0.2-1.4l2.281-3.041l-2.928-1.464   c-0.494-0.247-0.694-0.848-0.447-1.342c0.248-0.494,0.847-0.695,1.342-0.447L47,42.382V39c0-0.552,0.447-1,1-1s1,0.448,1,1v3.382   l2.553-1.276c0.494-0.248,1.094-0.046,1.342,0.447C53.142,42.047,52.941,42.647,52.447,42.895z" fill="#FFFFFF" /> </svg>
                                </div>
                                <div class="text">{{usercredentials.password}}</div>
                            </div>
                        </div>
                    </div>
                </div>






                <div class="itm" ng-if="payment_type=='Credit Memo'">
                    <label class="label-form-field-1">Amount:</label>
                    <div class="layout-fixed">
                        <div>
                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.creditmemo_amount.$invalid  }" ng-click="focusHandle($event)">
                                <input type="text" ng-model="Credit_Memo.Amount"  class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="creditmemo_amount" ng-change="calculatePayment()">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="itm" ng-if="payment_type=='Credit Memo'">
                    <label class="label-form-field-1">Note:</label>
                    <div class="layout-fixed">
                        <div>
                            <div class="input-form-field-1" ng-click="focusHandle($event)">
                                <textarea type="text" ng-model="Credit_Memo.note" class="h80px">  
                                </textarea>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="itm" ng-if="payment_type=='Manager Credit'">
                    <label class="label-form-field-1">Amount:</label>
                    <div class="layout-fixed">
                        <div>
                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.managercredit_amount.$invalid  }" ng-click="focusHandle($event)">
                                <input type="text" ng-model="Manager_Credit.Amount"  class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="managercredit_amount" ng-change="calculatePayment()">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="itm" ng-if="payment_type=='Manager Credit'">
                    <label class="label-form-field-1">Note:</label>
                    <div class="layout-fixed">
                        <div>
                            <div class="input-form-field-1" ng-click="focusHandle($event)">
                                <textarea type="text" ng-model="Manager_Credit.note" class="h80px">  
                                </textarea>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="itm" ng-if="payment_type=='In Store Credit'">
                    <label class="label-form-field-1"></label>
                    <div class="layout-fixed">
                        <div>
                            <span class="heading2 ft-secondary fz15-i inlineb max-w pdT5 pdL10 bold clr-blue">Available In Store Credit: ${{total_instore_credit | number : 2}}</span>
                        </div>
                    </div>
                </div>


                <div class="itm" ng-if="payment_type=='In Store Credit'">
                    <label class="label-form-field-1">Amount:</label>
                    <div class="layout-fixed">
                        <div>
                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.instorecredit_amount.$invalid  }" ng-click="focusHandle($event)">
                                <input type="text" ng-model="Instore_Credit.Amount" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="instorecredit_amount" ng-change="calculatePayment()">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="itm">
                    <label class="label-form-field-1"></label>
                    <div class="layout-fixed">
                        <div>
                            <span class="heading2 ft-secondary fz15-i inlineb max-w pdT5 pdL10 bold clr-blue">Payment Allocation:</span>
                        </div>
                        <button class="button-form-field-3 h40px" style="background-color: #178DD1" ng-click="TotalBill(2)" type="button">
                            <div class="clr-white">
                                50%
                            </div>
                        </button>
                        <button class="button-form-field-3 h40px" ng-if="show100percent" style="background-color: #178DD1" ng-click="TotalBill(1)" type="button">
                            <div class="clr-white">
                                100%
                            </div>
                        </button>
                    </div>
                </div>
                <div class="itm">
                    <label class="label-form-field-1">Amount remaining:</label>
                    <div class="layout-fixed">
                        <div>
                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formAddPaymentMulti.amount_remaining.$invalid  }" ng-click="focusHandle($event)">
                                <input type="text" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="amount_remaining" ng-model="amount_remaining">
                            </div>
                        </div>
                    </div>
                </div>
                <ul class="lst-order stripe-1 except-app-tab-switch">
                    <li class="box-setting-4 overhidden" ng-repeat="item in InvoiceCanBePaidChecked">
                        <div class="content content-in">
                            <div class="itm row-one-content">
                                <div class="layout-fixed">
                                    <div class="name clr-clickable uppercase" ng-if="item.ordertype_id == '5' " ng-click="goToInvoiceDetails(item.id,item.invoice_no)">{{item.invoice_no}}</div>
                                    <div class="name clr-clickable uppercase" ng-if="item.ordertype_id == '6' " ng-click="goToSaleorderDetails(item.id,item.invoice_no)">{{item.invoice_no}}</div>
                                </div>
                                <div class="layout-fixed mgT10">
                                    <div class="v-top-i">
                                        <div class="layout-fixed">
                                            <div class="v-top-i">
                                                <div class="text-title-4">Sales Person</div>
                                                <div class="text">{{item.addoder}}</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="v-top-i">
                                        <div class="layout-fixed">
                                            <div class="v-top-i">
                                                <div class="text-title-4">INV Date</div>
                                                <div class="text">{{item.sales_date}}</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="v-top-i">
                                        <div class="layout-fixed">
                                            <div class="v-top-i">
                                                <div class="text-title-4">Amount Due</div>
                                                <div class="text baseline"><span class="ft-primary">$</span>{{item.balanceDue | number : 2}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="v-top-i">
                                        <div class="layout-fixed">
                                            <div class="v-top-i">
                                                <div class="text-title-4">Remaining Balance</div>
                                                <div class="text baseline"><span class="ft-primary">$</span>{{item.remaining_balance | number : 2}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="v-top-i">
                                        <div class="layout-fixed">
                                            <div class="v-top-i">
                                                <div class="text baseline">
                                                    <div class="input-form-field-1" ng-class="{ 'has-errors' : !item.amount_applied > 0  }" ng-click="focusHandle($event)">
                                                        <input type="text" ng-model="item.amount_applied"  class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="amount_applied-{{$index}}" placeholder="Amount Applied" ng-change="changePaymentAmount($index,item.amount_applied)">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </ion-scroll>
    </div>
</form>
<div class="app-control">
    <div class="layout-fixed full-h pdT2">
        <div class="full-h">
            <button class="button-form-field-1 darkgray position-left full" type="button" ng-click="resetSplitPayment() ; closeTarget('#popupAddPaymentMulti'); openByGetTemplate('popupSplitPayment')">
                Back
            </button>
        </div>
        <div class="full-h">
            <button class="button-form-field-1 position-right full" onclick="getElementById('submitFormSplitPayment').click()" type="button">
                Apply Payment
            </button>
        </div>
    </div>
</div>

