<div class="app-header bg-header-1">
    <div class="layout-fixed full-h text-center">
        <div class="full-h">
            <div class="app-content-header bg-header-1">
                <div class="layout-fixed pdL80">
                    <div class="text-title-header-1 nowrap">{{invoice_no}} - ${{total}}</div>
                    <div class="w80px clear pdR5">
                        <div class="appointment-job-status layout-fixed w-auto-i right" style="background: {{ jobstatusCurrent_Inv.bgcolor}}" ng-if="redirectFromAppointment_Inv">
                            <div class="pdL10 nowrap">{{ jobstatusCurrent_Inv.name }}</div>
                            <div class="w0px v-bottom-i clear">
                                <svg class="block h10px right clr-symbol-clickable" viewBox="0 0 16 16"> <path fill="#FFF" d="M16 16h-16l16-16z" /> </svg>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="text-name-header-1 nowrap pdLR40 mgT5">
                    <div>{{setCustomerName(dataInfoCustomer.company_name,dataInfoCustomer.first_name,dataInfoCustomer.last_name)}}</div>
                </div>
            </div>
        </div>
    </div>
    <button class="popup-back-button bg-transparent pd0-i biger-3-time" type="button" ng-click="closeTarget('#popupOrderInvoiceDetailAddPayment')">
    </button>
</div>
<div class="box-setting-4 bg-header-1 no-saperator app-query-time">
    <div class="bg-overlay-1 pdTB15">
        <div class="layout-fixed pdLR10">
            <div>
                <button class="button-form-field-3 h40px" ng-click="showPaymentHistory()">
                    <div class="text-link-3" ng-class="{unlink:listpayment_histories.length < 1}">
                        Balance Due -
                        <span ng-if="(total - payment_amount == 0) || totalend == 0">PAID in FULL</span>
                        <span ng-if="totalend != 0">${{totalend}}</span>
                        <span ng-if="total - payment_amount != 0 && check_payment_plan != 0">PAYMENT PLAN</span>
                    </div>
                </button>
            </div>
            <div class="w60px clear">
                <button type="button" class="button-field-1 blue w40px h40px block-i right" ng-click="openByGetTemplate('popupOrderInvoiceDetail50PercentTotalBill') ; TotalBill()">
                    <svg class="h40px" viewBox="0 0 512 512"> <g> <path d="M161.307,245.122c4.092,0,7.899,0.676,11.42,2.026c3.519,1.351,6.548,3.254,9.087,5.71   c2.536,2.456,4.522,5.404,5.955,8.841c1.431,3.439,2.149,7.245,2.149,11.42c0,4.421-0.798,8.433-2.394,12.035   c-1.596,3.602-3.828,6.693-6.693,9.271c-2.866,2.579-6.264,4.583-10.193,6.017c-3.93,1.431-8.187,2.149-12.771,2.149   c-6.386,0-12.095-1.351-17.131-4.053c-5.034-2.701-8.862-6.386-11.481-11.051l9.455-9.824c2.291,3.193,5.159,5.732,8.596,7.614   c3.439,1.883,7,2.825,10.684,2.825c4.42,0,8.044-1.332,10.868-3.991c2.825-2.66,4.236-6.201,4.236-10.623   c0-4.255-1.332-7.694-3.99-10.315c-2.662-2.619-6.038-3.93-10.131-3.93c-2.701,0-5.219,0.614-7.553,1.842   c-2.333,1.228-4.196,2.907-5.587,5.035h-14.368c0-0.245,0.163-1.167,0.491-2.764c0.326-1.596,0.737-3.641,1.229-6.14   c0.491-2.497,1.022-5.28,1.596-8.351c0.571-3.07,1.185-6.201,1.841-9.394c1.474-7.531,3.111-15.964,4.912-25.297h42.98v14.981   h-31.069l-3.561,19.525c0.982-1.063,2.435-1.922,4.36-2.579C156.168,245.451,158.522,245.122,161.307,245.122z" style="fill:#FFF;" /> <path d="M277.893,257.018c0,24.667-15.292,44.617-37.697,44.617c-23.36,0-37.696-20.853-37.696-44.617   c0-25.015,15.514-44.764,37.696-44.764C261.917,212.254,277.893,231.676,277.893,257.018z M261.4,257.018   c0-14.924-7.03-29.745-21.204-29.745c-14.466,0-21.499,14.537-21.499,29.745c0,15.172,7.012,29.598,21.499,29.598   C254.114,286.616,261.4,272.501,261.4,257.018z" style="fill:#FFF;" /> <path d="M315.666,246.183c-12.115,0-21.189-8.995-21.189-19.518c0-10.794,9.421-19.391,21.189-19.391   c11.384,0,21.188,8.279,21.188,19.391C336.853,237.341,327.567,246.183,315.666,246.183z M301.669,293.696l69.599-86.164   l7.833,6.934l-69.599,86.164L301.669,293.696z M315.666,237.58c4.474,0,9.118-4.497,9.118-10.915   c0-5.627-3.797-10.787-9.118-10.787c-4.465,0-9.117,4.531-9.117,10.787C306.549,232.4,310.424,237.58,315.666,237.58z    M365.234,301.015c-11.611,0-21.188-8.426-21.188-19.391c0-10.456,9.016-19.519,21.188-19.519c11.187,0,21.189,7.984,21.189,19.519   C386.422,293.443,376.048,301.015,365.234,301.015z M365.234,292.412c4.448,0,9.117-4.492,9.117-10.787   c0-5.419-3.746-10.915-9.117-10.915c-4.46,0-9.117,4.483-9.117,10.915C356.117,287.254,359.91,292.412,365.234,292.412z" style="fill:#FFF;" /> </g> </svg>
                </button>
            </div>
            <div class="w60px clear">
                <button ng-click="opencaculator()" class="button-field-1 blue w40px h40px block-i right" type="button">
                    <svg class="h20px clr-white" viewBox="0 0 487.001 487.001"> <path d="M400.49,0H86.505C68.611,0,54.052,14.559,54.052,32.453v422.099c0,17.892,14.559,32.449,32.453,32.449H400.49   c17.898,0,32.459-14.557,32.459-32.449V32.453C432.949,14.559,418.388,0,400.49,0z M100.019,77.677   c0-13.351,10.822-24.174,24.178-24.174h238.607c13.359,0,24.178,10.823,24.178,24.174v35.737c0,13.355-10.818,24.177-24.178,24.177   H124.197c-13.355,0-24.178-10.821-24.178-24.177V77.677z M197.494,412.168c4.945,4.947,4.945,12.968-0.002,17.916   c-2.473,2.473-5.715,3.71-8.957,3.71c-3.242,0-6.484-1.237-8.957-3.711l-22.373-22.375l-22.373,22.375   c-2.475,2.474-5.717,3.711-8.959,3.711c-3.242,0-6.482-1.237-8.955-3.71c-4.949-4.948-4.949-12.969-0.002-17.916l22.373-22.375   l-22.373-22.375c-4.947-4.947-4.947-12.968,0.002-17.916c4.947-4.945,12.967-4.946,17.914,0.001l22.373,22.374l22.373-22.374   c4.947-4.947,12.967-4.947,17.914-0.001c4.947,4.948,4.947,12.969,0.002,17.916l-22.375,22.375L197.494,412.168z M201.511,257.592   h-31.639v31.643c0,6.996-5.672,12.668-12.668,12.668c-6.996,0-12.668-5.672-12.668-12.668v-31.643h-31.639   c-6.996,0-12.668-5.672-12.668-12.668s5.672-12.668,12.668-12.668h31.639v-31.643c0-6.995,5.672-12.667,12.668-12.667   c6.996,0,12.668,5.672,12.668,12.667v31.643h31.639c6.996,0,12.668,5.672,12.668,12.668S208.507,257.592,201.511,257.592z    M295.646,436.645c-3.242,0-6.484-1.236-8.957-3.71c-4.949-4.947-4.949-12.968,0-17.915l62.66-62.666   c4.945-4.947,12.967-4.947,17.914-0.001c4.949,4.947,4.949,12.969,0,17.916l-62.66,62.665   C302.13,435.407,298.888,436.645,295.646,436.645z M280.634,358.448c0-8.561,6.934-15.507,15.506-15.507   c8.561,0,15.506,6.945,15.506,15.507c0,8.566-6.945,15.504-15.506,15.504C287.568,373.952,280.634,367.015,280.634,358.448z    M364.142,436.619c-8.563,0-15.506-6.943-15.506-15.506c0-8.565,6.943-15.507,15.506-15.507c8.572,0,15.506,6.941,15.506,15.507   C379.648,429.676,372.714,436.619,364.142,436.619z M374.449,257.592h-88.613c-6.998,0-12.67-5.672-12.67-12.668   s5.672-12.668,12.67-12.668h88.613c6.996,0,12.668,5.672,12.668,12.668S381.445,257.592,374.449,257.592z" /> </svg>
                </button>
            </div>
        </div>
    </div>
</div>
<form class="app-content" id="formPaymentAdd" name="formPaymentAdd" novalidate="" ng-submit="validateForm(formPaymentAdd, 'payment', 'scrollPaymentAdd')">
    <div class="app-content-inner content-pd">
        <button id="submitFormPaymentAdd" style="display:none;" type="submit">Submit</button>
        <ion-scroll class="scroll-area" direction="y" has-bouncing="false" overflow-scroll="false" delegate-handle="scrollPaymentAdd">
            <div class="except-app-create-button">
                <div id="list-payment-history" class="box-setting-4 bg-search-filter-1 form-field-container no-saperator" style="display:none;">
                    <div class="pd10">
                        <div class="text-title-5">Payment history</div>
                        <div>
                            <div class="bg-search-filter-2 pd10 mgT10" ng-repeat="item in listpayment_child">
                                <div class="text-date-1">{{item.date}}</div>
                                <div ng-repeat="payment in item.payment">
                                    <div class="layout-fixed">
                                        <div class="text-date-1">{{formatTimePayment(payment.charge_date)}}</div>
                                        <div class="w100px clear" ng-if="payment.showSignature">
                                            <button type="button" class="bg-transparent right biger-3-time" ng-click="getsignature(payment.id,true)" ng-if="payment.showSignature">
                                                <svg class="h20px clr-symbol-clickable" viewBox="0 0 25.588 25.588"> <path d="M18.724,9.903l3.855,1.416l-3.206,8.729c-0.3,0.821-1.927,3.39-3.06,3.914l-0.275,0.75   c-0.07,0.19-0.25,0.309-0.441,0.309c-0.054,0-0.108-0.01-0.162-0.029c-0.243-0.09-0.369-0.359-0.279-0.604l0.26-0.709   c-0.575-1.117-0.146-4.361,0.106-5.047L18.724,9.903z M24.303,0.667c-1.06-0.388-2.301,0.414-2.656,1.383l-2.322,6.326l3.854,1.414   l2.319-6.325C25.79,2.673,25.365,1.056,24.303,0.667z M17.328,9.576c0.108,0.04,0.219,0.059,0.327,0.059   c0.382,0,0.741-0.234,0.882-0.614l2.45-6.608c0.181-0.487-0.068-1.028-0.555-1.208c-0.491-0.178-1.028,0.068-1.209,0.555   l-2.45,6.608C16.592,8.855,16.841,9.396,17.328,9.576z M13.384,21.967c-0.253-0.239-0.568-0.537-1.078-0.764   c-0.42-0.187-0.829-0.196-1.128-0.203c-0.031,0-0.067-0.001-0.103-0.002c-0.187-0.512-0.566-0.834-1.135-0.96   c-0.753-0.159-1.354,0.196-1.771,0.47c0.037-0.21,0.098-0.46,0.143-0.64c0.144-0.58,0.292-1.18,0.182-1.742   c-0.087-0.444-0.462-0.774-0.914-0.806c-1.165-0.065-2.117,0.562-2.956,1.129c-0.881,0.595-1.446,0.95-2.008,0.749   c-0.686-0.244-0.755-2.101-0.425-3.755c0.295-1.49,0.844-4.264,2.251-5.524c0.474-0.424,1.16-0.883,1.724-0.66   c0.663,0.26,1.211,1.352,1.333,2.653c0.051,0.549,0.53,0.952,1.089,0.902c0.55-0.051,0.954-0.539,0.902-1.089   c-0.198-2.12-1.192-3.778-2.593-4.329C6.058,7.07,4.724,6.982,3.107,8.429c-1.759,1.575-2.409,4.246-2.88,6.625   c-0.236,1.188-0.811,5.13,1.717,6.029c1.54,0.549,2.791-0.298,3.796-0.976c0.184-0.124,0.365-0.246,0.541-0.355   c-0.167,0.725-0.271,1.501,0.167,2.155c0.653,0.982,1.576,1.089,2.742,0.321c0.045-0.029,0.097-0.063,0.146-0.097   c0.108,0.226,0.299,0.475,0.646,0.645c0.42,0.206,0.84,0.216,1.146,0.224c0.131,0.003,0.31,0.007,0.364,0.031   c0.188,0.083,0.299,0.185,0.515,0.389c0.162,0.153,0.333,0.312,0.55,0.476c0.18,0.135,0.39,0.199,0.598,0.199   c0.304,0,0.605-0.139,0.801-0.4c0.331-0.442,0.241-1.069-0.201-1.4C13.61,22.183,13.495,22.072,13.384,21.967z"></path> </svg>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="layout-fixed mgT10">
                                        <div class="v-top-i">
                                            <div class="text-name-3">Type</div>
                                            <div class="text-title-3 mgT3">{{payment.method}}</div>
                                        </div>
                                        <div class="v-top-i">
                                            <div class="text-name-3">Account</div>
                                            <div class="text-title-3 mgT3">$ {{payment.amount}}</div>
                                        </div>
                                        <div class="w100px clear" ng-click="selectPayment(payment.id)" ng-hide="hideTranferPayment()">
                                            <button class="button-function-2 blue w30px h30px block-i right">
                                                <svg class="h18px clr-symbol" viewBox="0 0 490 490"> <path d="M244.95,386c77.8,0,141-63.1,141-141c0-77.8-63.1-141-141-141c-40.6,0-77.2,17.2-102.9,44.6    c-23.6,25.2-38.1,59.1-38.1,96.3C103.95,322.9,167.15,386,244.95,386z M195.75,300.8c1.3-4.6,2.5-9.3,4-13.8c1.7-5.3,3.1-6,8-3.4    c8.4,4.4,17.2,6.8,26.5,8c6,0.7,11.9,0.1,17.4-2.3c10.4-4.5,12-16.5,3.2-23.8c-3-2.5-6.4-4.3-9.9-5.8c-9.1-4-18.6-7-27.1-12.2    c-13.9-8.3-22.8-19.8-21.7-36.7c1.2-19.2,12-31.1,29.6-37.5c7.2-2.6,7.3-2.5,7.3-10.1c0-2.6,0-5.1,0-7.7c0.1-5.7,1.1-6.7,6.8-6.9    c1.8-0.1,3.5,0,5.3,0c12.1,0,12.1,0,12.2,12.1c0,8.6,0,8.6,8.6,9.9c6.5,1,12.8,2.9,18.8,5.6c3.3,1.5,4.6,3.8,3.6,7.3    c-1.5,5.2-2.9,10.5-4.6,15.7c-1.6,4.9-3.1,5.6-7.8,3.3c-9.5-4.6-19.4-6.5-29.8-5.9c-2.7,0.1-5.4,0.5-8,1.6    c-9,3.9-10.5,13.9-2.8,20.1c3.9,3.1,8.3,5.4,12.9,7.3c8,3.3,16,6.5,23.6,10.7c24.2,13.4,30.7,43.7,13.7,64.4    c-6.2,7.5-14.2,12.5-23.5,15.1c-4.1,1.1-5.9,3.3-5.7,7.5c0.2,4.2,0,8.3,0,12.5c0,3.7-1.9,5.7-5.6,5.8c-4.5,0.1-9,0.1-13.4,0    c-3.9-0.1-5.8-2.3-5.8-6.1c0-3-0.1-6.1-0.1-9.1c-0.1-6.7-0.3-7-6.7-8c-8.3-1.3-16.4-3.2-23.9-6.9    C194.65,308.5,194.05,307,195.75,300.8z" /> <path d="M397.65,397.8c-81.4,81.4-212.1,84.1-296.8,8.3h27.2v-29h-57.2h-0.7h-19.3v19.6v0.4v57.2h29v-28.1    c46.6,42.5,105.8,63.8,165,63.8c62.8,0,125.5-23.9,173.3-71.7l10.3-10.3l-20.5-20.5L397.65,397.8z" /> <path d="M410.05,35.7v28.1C363.45,21.3,304.25,0,245.05,0c-62.8,0-125.5,23.9-173.3,71.7l-10.2,10.2l20.5,20.5l10.3-10.3    c81.4-81.4,212.1-84.1,296.8-8.3h-27.2v29h57.2h0.7h19.3V93.2v-0.4V35.7H410.05z" /> </svg>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="layout-fixed mgT10">
                                        <div class="v-top-i" ng-if="payment.cardnumber.length > 0">
                                            <div class="text-name-3">Card number</div>
                                            <div class="text-title-3 mgT3">{{payment.cardnumber}}</div>
                                        </div>
                                        <div class="v-top-i" ng-if="payment.method == 'Check'">
                                            <div class="text-name-3">Authorization #</div>
                                            <div class="text-title-3 mgT3">{{payment.authorization}}</div>
                                        </div>
                                        <div class="v-top-i" ng-if="payment.method == 'Check'">
                                            <div class="text-name-3">Check #</div>
                                            <div class="text-title-3 mgT3">{{payment.check}}</div>
                                        </div>
                                        <div class="v-top-i" ng-if="payment.method == 'Payment Plan'">
                                            <div class="text-name-3">Charge Date</div>
                                            <div class="text-title-3 mgT3">{{payment.charge_date}}</div>
                                        </div>
                                        <div class="v-top-i" ng-if="payment.method == 'Wells Fargo Plan'">
                                            <div class="text-name-3">Authorization #</div>
                                            <div class="text-title-3 mgT3">{{payment.authorization_number}}</div>
                                        </div>
                                        <div class="v-top-i" ng-if="payment.method == 'Wells Fargo Plan'">
                                            <div class="text-name-3">Credit Term Plan</div>
                                            <div class="text-title-3 mgT3">{{payment.credit_term_plan_number}}</div>
                                        </div>
                                        <div class="w100px clear"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="stripe-2">
                    <div class="box-setting-4">
                        <div class="content content-in">
                            <div class="itm no-saperator" ng-class="{ 'open' : checkbox.Cash_check }">
                                <div class="layout-fixed">
                                    <div class="pdB5">
                                        <label class="label-form-field-2" ng-class="{'clr-black':listpayment_histories.length==0}">Cash</label>
                                        <!--Class "clr-black" neu chua co payment-->
                                    </div>
                                    <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                        <div class="checkedbox-toggle-1 block-i right">
                                            <input type="checkbox" ng-model="checkbox.Cash_check" ng-true-value="1" ng-false-value="0"><i></i><span></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="itm" ng-if="checkbox.Cash_check">
                                <label class="label-form-field-1">Amount</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.cash_amount.$invalid  }" ng-click="focusHandle($event)">
                                            <input id="cash_amount" type="text" ng-model="Cash.Amount" placeholder="" value="" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="cash_amount">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="box-setting-4">
                        <div class="content content-in">
                            <div class="itm no-saperator" ng-class="{ 'open' : checkbox.Check_check }">
                                <div class="layout-fixed">
                                    <div class="pdB5">
                                        <label class="label-form-field-2">Check</label>
                                    </div>
                                    <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                        <div class="checkedbox-toggle-1 block-i right">
                                            <input type="checkbox" ng-model="checkbox.Check_check" ng-true-value="1" ng-false-value="0"><i></i><span></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="itm" ng-if="checkbox.Check_check">
                                <label class="label-form-field-1">Amount</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.check_amount.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" ng-model="Check.Amount" placeholder="" value="" name="check_amount" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required id="check_amount">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="itm" ng-if="checkbox.Check_check">
                                <label class="label-form-field-1">Authorization #</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.check_authorization.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" placeholder="" value="" name="check_authorization" ng-model="Check.Authorization" class="h32px" required id="check_authorization">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="itm" ng-if="checkbox.Check_check">
                                <label class="label-form-field-1">Check #</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.check_check.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" placeholder="" value="" name="check_check" id="check_check" ng-model="Check.Check" class="h32px" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="box-setting-4">
                        <div class="content content-in autoScanManual">
                            <div class="itm no-saperator" ng-class="{ 'open' : checkbox.CC_Manual_check }">
                                <div class="layout-fixed">
                                    <div class="pdB5">
                                        <label class="label-form-field-2">CC manual</label>
                                    </div>
                                    <div class="pdB5" ng-show="checkbox.CC_Manual_check == 1 && creditcard_info">
                                        <div class="layout-fixed">
                                            <label class="label-form-field-2">Used Stored Card Info</label>
                                            <div class="checkedbox-toggle-1 block-i">
                                                <input type="checkbox" ng-model="checkbox.use_credit_card_check" ng-true-value="1" ng-false-value="0" name="" ng-click="checkUseCreditCard(checkbox.use_credit_card_check)"><i></i><span></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                        <div class="checkedbox-toggle-1 block-i right">
                                            <input type="checkbox" ng-model="checkbox.CC_Manual_check" ng-true-value="1" ng-false-value="0" name="" onclick="addEventScan('CC_ManualScanBtn', 'autoScanManual')"><i></i><span></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="itm" ng-if="checkbox.CC_Manual_check">
                                <div class="layout-fixed input-1-group">
                                    <div>
                                        <label class="label-form-field-1">First Name</label>
                                        <div class="layout-fixed">
                                            <div>
                                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_first_name.$invalid  }" ng-click="focusHandle($event)">
                                                    <input class="h32px" name="CC_Manual_first_name" value="" placeholder="" type="text" ng-model="CC_Manual.first_name" required id="CC_Manual_first_name">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div>
                                        <label class="label-form-field-1">Last Name</label>
                                        <div class="layout-fixed">
                                            <div>
                                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_last_name.$invalid  }" ng-click="focusHandle($event)">
                                                    <input class="h32px" name="CC_Manual_last_name" value="" placeholder="" type="text" ng-model="CC_Manual.last_name" required id="CC_Manual_last_name">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="itm" ng-if="checkbox.CC_Manual_check">
                                <label class="label-form-field-1">Address</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_street.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" name="CC_Manual_street" value="" placeholder="" ng-model="CC_Manual.street" required id="CC_Manual_street">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="itm" ng-if="checkbox.CC_Manual_check">
                                <div class="layout-fixed input-1-group">
                                    <div class="layout-w-1:2">
                                        <label class="label-form-field-1">City</label>
                                        <div class="layout-fixed">
                                            <div>
                                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_city.$invalid  }" ng-click="focusHandle($event)">
                                                    <input type="text" class="h32px" name="CC_Manual_city" value="" placeholder="" ng-model="CC_Manual.city" required id="CC_Manual_city">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div>
                                        <label class="label-form-field-1">State</label>
                                        <div class="layout-fixed">
                                            <div>
                                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_state.$invalid  }" ng-click="focusHandle($event)">
                                                    <input type="text" class="h32px" name="CC_Manual_state" value="" placeholder="" ng-model="CC_Manual.state" required id="CC_Manual_state">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div>
                                        <label class="label-form-field-1">Zip code</label>
                                        <div class="layout-fixed">
                                            <div>
                                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_zipcode.$invalid  }" ng-click="focusHandle($event)">
                                                    <input type="text" class="ft-fifth h32px" value="" placeholder="" ng-model="CC_Manual.zipcode" name="CC_Manual_zipcode" required id="CC_Manual_zipcode">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="itm" ng-if="checkbox.CC_Manual_check">
                                <input type="hidden" id="required_CC_Manual" placeholder="" value="0" name="">
                                <div class="layout-fixed">
                                    <div>
                                        <label class="label-form-field-1">Credit card type</label>
                                        <div class="text pdL5 mgT5 logs">
                                            Please input card number
                                            <a id="CC_ManualScanBtn">
                                                <svg  viewBox="0 0 512 512" class="h30px"> <circle style="fill:#F5EB07;" cx="256" cy="256" r="256"/> <path style="fill:#F1592F;" d="M38.484,27.88h435.032c13.192,0,23.884,10.44,23.884,23.316v272.916 c0,12.876-10.696,23.316-23.884,23.316H38.484c-13.192,0-23.884-10.44-23.884-23.316V51.196C14.6,38.32,25.292,27.88,38.484,27.88z"/> <circle style="fill:#70B1E1;" cx="89.392" cy="100.64" r="42.656"/> <circle style="fill:#F5EA07;" cx="143.056" cy="100.64" r="42.656"/> <g> <rect x="14.6" y="261.88" style="fill:#FDFEFF;" width="482.8" height="39.068"/> <path style="fill:#FDFEFF;" d="M458.236,117.88h-134.8c-2.716,0-4.94-2.224-4.94-4.94s2.224-4.94,4.94-4.94h134.8 C464.764,107.996,464.764,117.88,458.236,117.88z"/> <path style="fill:#FDFEFF;" d="M463.18,140.244c0,2.716-2.224,4.94-4.94,4.94h-134.8c-2.716,0-4.94-2.224-4.94-4.94 c0-6.852-3.688-4.94,139.74-4.94C460.956,135.304,463.18,137.528,463.18,140.244z"/> <path style="fill:#FDFEFF;" d="M323.44,80.688h93.628c2.716,0,4.94,2.18,4.94,4.94c0,6.8-0.492,4.94-98.568,4.94 C316.936,90.572,316.884,80.688,323.44,80.688z"/> </g> <path style="fill:#4D5BA5;" d="M455.72,447.052l-2.336,1.452l-41.42-58.968l1.684-1.048c3.624-2.252,4.724-6.972,2.472-10.596 c-2.244-3.608-6.988-4.712-10.596-2.472l-1.716,1.068L390.756,355.5l-27.248,16.924l13.048,20.988l-1.716,1.064 c-3.584,2.228-4.74,6.908-2.476,10.62c2.244,3.608,6.988,4.712,10.596,2.472l1.684-1.048l34.616,63.22l-2.364,1.472 c-1.648,1.004-2.704,2.604-3.112,4.356c-0.404,1.728-0.164,3.628,0.872,5.26c2.016,3.276,6.332,4.28,9.612,2.24l38.836-24.128 c1.624-1.012,2.704-2.604,3.112-4.352s0.144-3.656-0.864-5.284C463.312,446.044,458.996,445.036,455.72,447.052z"/> <path style="fill:#F1592F;" d="M413.864,247.616c-2.048-11.676-9.084-20.824-15.084-30.696 c-6.788-11.168-10.148-19.564-22.708-25.368c-12.132-5.608-26.976-9.248-40.088-11.412c-26.924-4.444-57.648,4.236-80,19.708 c-1.164,0.804-2.32,1.44-3.468,1.952c-4.08,5.776-8.832,12.088-14.908,15.796c-1.812,6-3.636,11.992-4.8,17.968 c-3.496,17.928-6.548,39.112-2.048,57c1.62,6.436,1.4,14.86,3.836,20.912c2.232,5.544,6.956,10.076,9.544,15.572 c3.216,6.84,3.868,15.672,9.508,21.16c4.86,4.728,13.372,6.472,19.656,8.248c8.88,2.504,13.068,9.184,13.628,16.28h77.852 c1.404-5.988,5.372-11.456,12.5-14.188c9.116-3.492,18.64-25.704,22.5-33.04c7.108-13.5,12.424-26.86,14.012-42.128 C415.052,273.32,415.976,259.66,413.864,247.616z"/> <g> <path style="fill:#D64331;" d="M229.048,268.74c1.072-2.244,1.94-4.644,2.908-6.632c2.192-4.388,1.784-9.284,1.784-14.128 c0-3.876-0.764-7.5-1.072-11.272c-0.012-0.116-0.004-0.208-0.012-0.32c-2.024,10.48-3.828,22.008-4.084,33.332 C228.732,269.392,228.9,269.072,229.048,268.74z"/> <path style="fill:#D64331;" d="M255.988,199.844c-1.164,0.804-2.32,1.44-3.468,1.952c-3.444,4.876-7.368,10.124-12.156,13.888 c0.268-0.08,0.464-0.176,0.772-0.248c1.02-0.204,3.468-0.104,4.284-0.716c1.684-1.324,0.764-3.776,3.06-5 c3.368-1.836,9.588,1.48,13.056,1.732c5,0.356,10.048-2.96,12.6-7.04c2.784-4.384,3.856-10.304,3.592-16.344 C269.964,191.3,262.604,195.264,255.988,199.844z"/> </g> <path style="fill:#FDFEFF;" d="M228.612,268.74c-0.248,8.196,0.26,16.304,2.152,23.824c2.14,8.508,0.848,16.524,5.716,24.584 h168.368c4.516-10.096,7.768-20.404,8.952-31.772c0.556-5.324,1.024-10.964,1.22-16.636L228.612,268.74L228.612,268.74z"/> <path style="fill:#70B1E1;" d="M262.036,178.848c-52.856,32.864-69.056,102.336-36.192,155.188 c32.864,52.856,102.336,69.056,155.188,36.192c52.844-32.856,69.056-102.336,36.192-155.188 C384.36,162.184,314.876,145.992,262.036,178.848z M368.78,350.52c-41.968,26.096-97.156,13.224-123.24-28.728 c-26.096-41.968-13.216-97.14,28.752-123.236c41.952-26.084,97.12-13.22,123.212,28.744 C423.588,269.252,410.732,324.432,368.78,350.52z"/> </svg>
                                            </a>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="itm" ng-if="checkbox.CC_Manual_check">
                                <label class="label-form-field-1">Credit Card #</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_card_number.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" value="" placeholder="" ng-model="CC_Manual.card_number" name="card_number" required id="CC_Manual_card_number" ng-change="requiredAmount(CC_Manual.card_number, 'CC_Manual_cart')">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="itm" ng-if="checkbox.CC_Manual_check">
                                <div class="layout-fixed input-1-group">
                                    <div>
                                        <label class="label-form-field-1">Expn Date - Month</label>
                                        <div class="layout-fixed">
                                            <div>
                                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_month_cc.$invalid  }" ng-click="focusHandle($event)">
                                                    <input type="text" class="h32px" id="CC_Manual_month_cc" name="month" ng-model="Input_value.CC_Manual_month_cc" placeholder="" required>
                                                    <div class="sign-r clear">
                                                        <button class="bg-transparent full-h right pdR10" type="button">
                                                            <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                                        </button>
                                                    </div>
                                                    <select name="month" ng-model="CC_Manual.month_cc" class="field-overlay" ng-change="set_month(CC_Manual.month_cc,'manual')"
                                                    ng-options="item.value as item.name for item in monthNames| orderBy:['value']" required ng-disabled="checkbox.use_credit_card_check == 1">
                                                    <option value="">-----</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div>
                                    <label class="label-form-field-1">Expn Date - Year</label>
                                    <div class="layout-fixed">
                                        <div>
                                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_year_cc.$invalid  }" ng-click="focusHandle($event)">
                                                <input type="text" class="h32px" ng-model="CC_Manual.year_cc" placeholder="" required id="CC_Manual_year_cc"  name="year">
                                                <div class="sign-r clear">
                                                    <button class="bg-transparent full-h right pdR10" type="button">
                                                        <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                                    </button>
                                                </div>
                                                <select name="year" ng-model="CC_Manual.year_cc" class="field-overlay" ng-options="item as item for item in yearName" required ng-disabled="checkbox.use_credit_card_check == 1">
                                                    <option value="">-----</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="layout-w-1:4">
                                    <label class="label-form-field-1">CVV2 (Code)</label>
                                    <div class="layout-fixed">
                                        <div>
                                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_CVV2_Code.$invalid  }" ng-click="focusHandle($event)">
                                                <input type="text" class="h32px" name="CVV2_Code" value="" placeholder="" ng-change="requiredcvv(CC_Manual.CVV2_Code, 'CC_Manual')" ng-model="CC_Manual.CVV2_Code" required id="CC_Manual_CVV2_Code">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.CC_Manual_check">
                            <label class="label-form-field-1">Amount</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_Amount.$invalid  }" ng-click="focusHandle($event)">
                                        <input type="text" ng-model="CC_Manual.Amount" placeholder="" value="" name="CC_Manual_Amount" awnum num-sep="." num-int=18 num-fract=2 required id="CC_Manual_Amount" ng-trim=false class="h32px">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="itm" ng-if="!creditcard_info && checkbox.CC_Manual_check">
                            <div class="layout-fixed">
                                <label class="label-form-field-2 w100px">Add this card</label>
                                <div class="checkedbox-toggle-1 block-i left">
                                    <input type="checkbox" ng-model="checkbox.add_this_card" ng-true-value="1" ng-false-value="0" name="" ng-change="showWarning(checkbox.add_this_card)"><i></i><span></span>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="creditcard_info && !checkbox.use_credit_card_check && checkbox.CC_Manual_check">
                            <div class="layout-fixed">
                                <label class="label-form-field-2 w100px">Update this card</label>
                                <div class="checkedbox-toggle-1 block-i left">
                                    <input type="checkbox" ng-model="checkbox.update_this_card" ng-true-value="1" ng-false-value="0" name="" ng-change="showWarning(checkbox.update_this_card)"><i></i><span></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- <div class="box-setting-4">
                    <div class="content content-in">
                        <div class="itm no-saperator" ng-class="{ 'open' : checkbox.Prepaid_check }">
                            <div class="layout-fixed">
                                <div class="pdB5">
                                    <label class="label-form-field-2">Prepaid</label>
                                </div>
                                <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                    <div class="checkedbox-toggle-1 block-i right">
                                        <input type="checkbox" ng-model="checkbox.Prepaid_check" ng-true-value="1" ng-false-value="0"><i></i><span></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Prepaid_check">
                            <label class="label-form-field-1">Amount</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.prepaid_amount.$invalid  }" ng-click="focusHandle($event)">
                                        <input type="text" ng-model="Prepaid.Amount" placeholder="" value="" name="prepaid_amount" awnum num-sep="." num-int=18 num-fract=2 required id="prepaid_amount" ng-trim=false class="h32px">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> -->
                <!-- <div class="box-setting-4">
                    <div class="content content-in autoScanPayment_Plan">
                        <div class="itm no-saperator" ng-class="{ 'open' : checkbox.Payment_Plan_check }">
                            <div class="layout-fixed">
                                <div class="pdB5">
                                    <label class="label-form-field-2">Payment plan</label>
                                </div>
                                <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                    <div class="checkedbox-toggle-1 block-i right">
                                        <input type="checkbox" ng-model="checkbox.Payment_Plan_check" ng-true-value="1" ng-false-value="0" onclick="addEventScan('Payment_PlanScanBtn', 'autoScanPayment_Plan')"><i></i><span></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Payment_Plan_check">
                            <div class="layout-fixed input-1-group">
                                <div>
                                    <label class="label-form-field-1">First Name</label>
                                    <div class="layout-fixed">
                                        <div>
                                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_first_name.$invalid  }" ng-click="focusHandle($event)">
                                                <input type="text" placeholder="" value="" name="Payment_Plan_first_name" ng-model="Payment_Plan.first_name" class="h32px" required id="Payment_Plan_first_name">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div>
                                    <label class="label-form-field-1">Last Name</label>
                                    <div class="layout-fixed">
                                        <div>
                                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_last_name.$invalid  }" ng-click="focusHandle($event)">
                                                <input class="h32px" name="Payment_Plan_last_name" value="" placeholder="" type="text" ng-model="Payment_Plan.last_name" required id="Payment_Plan_last_name">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Payment_Plan_check">
                            <label class="label-form-field-1">Address</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_street.$invalid  }" ng-click="focusHandle($event)">
                                        <input type="text" class="h32px" name="Payment_Plan_street" value="" placeholder="" ng-model="Payment_Plan.street" required id="Payment_Plan_street">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Payment_Plan_check">
                            <div class="layout-fixed input-1-group">
                                <div class="layout-w-1:2">
                                    <label class="label-form-field-1">City</label>
                                    <div class="layout-fixed">
                                        <div>
                                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_city.$invalid  }" ng-click="focusHandle($event)">
                                                <input type="text" class="h32px" name="Payment_Plan_city" value="" placeholder="" ng-model="Payment_Plan.city" required id="Payment_Plan_city">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div>
                                    <label class="label-form-field-1">State</label>
                                    <div class="layout-fixed">
                                        <div>
                                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_state.$invalid  }" ng-click="focusHandle($event)">
                                                <input type="text" class="h32px" name="Payment_Plan_state" value="" placeholder="" ng-model="Payment_Plan.state" required id="Payment_Plan_state">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div>
                                    <label class="label-form-field-1">Zip code</label>
                                    <div class="layout-fixed">
                                        <div>
                                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_zipcode.$invalid  }" ng-click="focusHandle($event)">
                                                <input type="text" class="ft-fifth h32px" value="" placeholder="" ng-model="Payment_Plan.zipcode" name="Payment_Plan_zipcode" required id="Payment_Plan_zipcode">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Payment_Plan_check">
                            <input type="hidden" id="required_Payment_Plan" placeholder="" value="0" name="">
                            <div class="layout-fixed">
                                <div>
                                    <label class="label-form-field-1">Credit card type</label>
                                    <div class="text pdL5 mgT5 pplogs">Please input card number
                                        <a id="Payment_PlanScanBtn">
                                            <svg  viewBox="0 0 512 512" class="h30px"> <circle style="fill:#F5EB07;" cx="256" cy="256" r="256"/> <path style="fill:#F1592F;" d="M38.484,27.88h435.032c13.192,0,23.884,10.44,23.884,23.316v272.916 c0,12.876-10.696,23.316-23.884,23.316H38.484c-13.192,0-23.884-10.44-23.884-23.316V51.196C14.6,38.32,25.292,27.88,38.484,27.88z"/> <circle style="fill:#70B1E1;" cx="89.392" cy="100.64" r="42.656"/> <circle style="fill:#F5EA07;" cx="143.056" cy="100.64" r="42.656"/> <g> <rect x="14.6" y="261.88" style="fill:#FDFEFF;" width="482.8" height="39.068"/> <path style="fill:#FDFEFF;" d="M458.236,117.88h-134.8c-2.716,0-4.94-2.224-4.94-4.94s2.224-4.94,4.94-4.94h134.8 C464.764,107.996,464.764,117.88,458.236,117.88z"/> <path style="fill:#FDFEFF;" d="M463.18,140.244c0,2.716-2.224,4.94-4.94,4.94h-134.8c-2.716,0-4.94-2.224-4.94-4.94 c0-6.852-3.688-4.94,139.74-4.94C460.956,135.304,463.18,137.528,463.18,140.244z"/> <path style="fill:#FDFEFF;" d="M323.44,80.688h93.628c2.716,0,4.94,2.18,4.94,4.94c0,6.8-0.492,4.94-98.568,4.94 C316.936,90.572,316.884,80.688,323.44,80.688z"/> </g> <path style="fill:#4D5BA5;" d="M455.72,447.052l-2.336,1.452l-41.42-58.968l1.684-1.048c3.624-2.252,4.724-6.972,2.472-10.596 c-2.244-3.608-6.988-4.712-10.596-2.472l-1.716,1.068L390.756,355.5l-27.248,16.924l13.048,20.988l-1.716,1.064 c-3.584,2.228-4.74,6.908-2.476,10.62c2.244,3.608,6.988,4.712,10.596,2.472l1.684-1.048l34.616,63.22l-2.364,1.472 c-1.648,1.004-2.704,2.604-3.112,4.356c-0.404,1.728-0.164,3.628,0.872,5.26c2.016,3.276,6.332,4.28,9.612,2.24l38.836-24.128 c1.624-1.012,2.704-2.604,3.112-4.352s0.144-3.656-0.864-5.284C463.312,446.044,458.996,445.036,455.72,447.052z"/> <path style="fill:#F1592F;" d="M413.864,247.616c-2.048-11.676-9.084-20.824-15.084-30.696 c-6.788-11.168-10.148-19.564-22.708-25.368c-12.132-5.608-26.976-9.248-40.088-11.412c-26.924-4.444-57.648,4.236-80,19.708 c-1.164,0.804-2.32,1.44-3.468,1.952c-4.08,5.776-8.832,12.088-14.908,15.796c-1.812,6-3.636,11.992-4.8,17.968 c-3.496,17.928-6.548,39.112-2.048,57c1.62,6.436,1.4,14.86,3.836,20.912c2.232,5.544,6.956,10.076,9.544,15.572 c3.216,6.84,3.868,15.672,9.508,21.16c4.86,4.728,13.372,6.472,19.656,8.248c8.88,2.504,13.068,9.184,13.628,16.28h77.852 c1.404-5.988,5.372-11.456,12.5-14.188c9.116-3.492,18.64-25.704,22.5-33.04c7.108-13.5,12.424-26.86,14.012-42.128 C415.052,273.32,415.976,259.66,413.864,247.616z"/> <g> <path style="fill:#D64331;" d="M229.048,268.74c1.072-2.244,1.94-4.644,2.908-6.632c2.192-4.388,1.784-9.284,1.784-14.128 c0-3.876-0.764-7.5-1.072-11.272c-0.012-0.116-0.004-0.208-0.012-0.32c-2.024,10.48-3.828,22.008-4.084,33.332 C228.732,269.392,228.9,269.072,229.048,268.74z"/> <path style="fill:#D64331;" d="M255.988,199.844c-1.164,0.804-2.32,1.44-3.468,1.952c-3.444,4.876-7.368,10.124-12.156,13.888 c0.268-0.08,0.464-0.176,0.772-0.248c1.02-0.204,3.468-0.104,4.284-0.716c1.684-1.324,0.764-3.776,3.06-5 c3.368-1.836,9.588,1.48,13.056,1.732c5,0.356,10.048-2.96,12.6-7.04c2.784-4.384,3.856-10.304,3.592-16.344 C269.964,191.3,262.604,195.264,255.988,199.844z"/> </g> <path style="fill:#FDFEFF;" d="M228.612,268.74c-0.248,8.196,0.26,16.304,2.152,23.824c2.14,8.508,0.848,16.524,5.716,24.584 h168.368c4.516-10.096,7.768-20.404,8.952-31.772c0.556-5.324,1.024-10.964,1.22-16.636L228.612,268.74L228.612,268.74z"/> <path style="fill:#70B1E1;" d="M262.036,178.848c-52.856,32.864-69.056,102.336-36.192,155.188 c32.864,52.856,102.336,69.056,155.188,36.192c52.844-32.856,69.056-102.336,36.192-155.188 C384.36,162.184,314.876,145.992,262.036,178.848z M368.78,350.52c-41.968,26.096-97.156,13.224-123.24-28.728 c-26.096-41.968-13.216-97.14,28.752-123.236c41.952-26.084,97.12-13.22,123.212,28.744 C423.588,269.252,410.732,324.432,368.78,350.52z"/> </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Payment_Plan_check">
                            <label class="label-form-field-1">Credit Card #</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_Card_Number.$invalid  }" ng-click="focusHandle($event)">
                                        <input type="text" id="Payment_Plan_Card_Number" ng-change="requiredAmount(Payment_Plan.Card_Number, 'Payment_Plan')" ng-model="Payment_Plan.Card_Number" placeholder="" value="" name="card_number" class="h32px" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Payment_Plan_check">
                            <div class="layout-fixed input-1-group">
                                <div>
                                    <label class="label-form-field-1">Expn Date - Month</label>
                                    <div class="layout-fixed">
                                        <div>
                                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_month.$invalid  }" ng-click="focusHandle($event)">
                                                <input type="text" class="h32px" id="Payment_Plan_month" ng-model="Input_value.Payment_Plan_month" placeholder="" name="month">
                                                <div class="sign-r clear">
                                                    <button class="bg-transparent full-h right pdR10" type="button">
                                                        <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                                    </button>
                                                </div>
                                                <select name="month" ng-model="Payment_Plan.month" class="field-overlay" required ng-change="set_month(Payment_Plan.month,'plan')" ng-options="item.value as item.name for item in monthNames| orderBy:['value']">
                                                    <option value="">-----</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div>
                                    <label class="label-form-field-1">Expn Date - Year</label>
                                    <div class="layout-fixed">
                                        <div>
                                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_year.$invalid  }" ng-click="focusHandle($event)">
                                                <input type="text" class="h32px" id="Payment_Plan_year" placeholder="" name="year" ng-model="Payment_Plan.year">
                                                <div class="sign-r clear">
                                                    <button class="bg-transparent full-h right pdR10" type="button">
                                                        <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                                    </button>
                                                </div>
                                                <select name="year" ng-model="Payment_Plan.year" class="field-overlay" ng-options="item as item for item in yearName" required>
                                                    <option value="">-----</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="layout-w-1:4">
                                    <label class="label-form-field-1">CVV2 (Code)</label>
                                    <div class="layout-fixed">
                                        <div>
                                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CVV2_Code.$invalid  }" ng-click="focusHandle($event)">
                                                <input type="text" ng-change="requiredcvv(Payment_Plan.CVV2_Codes, 'Payment_Plan')" ng-model="Payment_Plan.CVV2_Codes" placeholder="" value="" name="CVV2_Code" class="h32px" required="" id="Payment_Plan_CVV2_Codes">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Payment_Plan_check" ng-click="resizeScroll('scrollPaymentAdd')">
                            <div class="layout-fixed input-1-group" ng-repeat="item in ChargeDate">
                                <div>
                                    <label class="label-form-field-1">Amount</label>
                                    <div class="layout-fixed">
                                        <div>
                                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.date_amount{{$inde}}.$invalid  }" ng-click="focusHandle($event)">
                                                <input type="text" placeholder="" ng-model="item.amount" value="" name="date_amount{{$inde}}" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required id="date_amount{{$inde}}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div>
                                    <div class="layout-fixed">
                                        <div>
                                            <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.ChargeDate{{$index}}.$invalid  }" ng-click="focusHandle($event)">
                                                <input type="text" placeholder="Charge date" name="" class="h32px pdR35-i" id="ChargeDate{{$index}}" value="{{item.ChargeDate| date: 'MM/dd/yyyy'}}">
                                                <div class="field-overlay datetime" date="" ion-datetime-picker="" name="ChargeDate{{$index}}" ng-model="item.ChargeDate" required>
                                                    {{item.ChargeDate| date: 'MM/dd/yyyy'}}
                                                </div>
                                                <div class="sign-r clear" ng-click="addRowChargeDate('Payment_Plan', Payment_Plan_check)" ng-if="$index == 0">
                                                    <button class="bg-transparent full-h right pdR8" type="button">
                                                        <svg viewBox="0 0 53 53" class="h20px"> <polygon style="fill:#B1C7D7;" points="7,8.5 47,8.5 47,0.5 0,0.5 0,45.5 7,45.5 " /> <rect x="7" y="8.5" style="fill:#1075BB;" width="46" height="44" /> <line style="fill:none;stroke:#FFF;stroke-width:3;stroke-linecap:round;stroke-miterlimit:10;" x1="30" y1="19.5" x2="30" y2="41.5" /> <line style="fill:none;stroke:#FFF;stroke-width:3;stroke-linecap:round;stroke-miterlimit:10;" x1="41" y1="30.5" x2="19" y2="30.5" /> </svg>
                                                    </button>
                                                </div>
                                                <div class="sign-r clear" ng-click="removeItemChargeDate($index)" ng-if="$index != 0">
                                                    <button class="bg-transparent full-h right pdR10" type="button">
                                                        <svg viewBox="0 0 64 64" class="h16px"> <g> <path fill="#D75A4A" d="M28.941,31.786L0.613,60.114c-0.787,0.787-0.787,2.062,0,2.849c0.393,0.394,0.909,0.59,1.424,0.59   c0.516,0,1.031-0.196,1.424-0.59l28.541-28.541l28.541,28.541c0.394,0.394,0.909,0.59,1.424,0.59c0.515,0,1.031-0.196,1.424-0.59   c0.787-0.787,0.787-2.062,0-2.849L35.064,31.786L63.41,3.438c0.787-0.787,0.787-2.062,0-2.849c-0.787-0.786-2.062-0.786-2.848,0   L32.003,29.15L3.441,0.59c-0.787-0.786-2.061-0.786-2.848,0c-0.787,0.787-0.787,2.062,0,2.849L28.941,31.786z" /> </g> </svg>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> -->
                <div class="box-setting-4">
                    <div class="content content-in">
                        <div class="itm no-saperator" ng-class="{ 'open' : checkbox.Wells_Fargo_Plan }">
                            <div class="layout-fixed">
                                <div class="pdB5">
                                    <label class="label-form-field-2">Wells fargo plan</label>
                                </div>
                                <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                    <div class="checkedbox-toggle-1 block-i right">
                                        <input type="checkbox" ng-model="checkbox.Wells_Fargo_Plan" ng-true-value="1" ng-false-value="0"><i></i><span></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Wells_Fargo_Plan">
                            <label class="label-form-field-1">Authorization #</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.wellfargoflan_authorization.$invalid  }" ng-click="focusHandle($event)">
                                        <input type="text" placeholder="" value="" name="wellfargoflan_authorization" ng-model="WellFargoPlan.authorization_number" class="h32px" required id="wellfargoflan_authorization" class="full-w" onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')" maxlength="10">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Wells_Fargo_Plan">
                            <label class="label-form-field-1">Amount:</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.wellfargoflan_amount.$invalid  }" ng-click="focusHandle($event)">
                                        <input id="wellfargoflan_amount" type="text" ng-model="WellFargoPlan.authorization_amount" placeholder="" value="" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="wellfargoflan_amount">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Wells_Fargo_Plan">
                            <label class="label-form-field-1">Credit Term Plan #:</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.credit_term_plan_number.$invalid }" ng-click="focusHandle($event)">
                                        <input type="text" placeholder="" value="{{WellFargoPlan.credit_term_plan_number}}" name="credit_term_plan_number" class="h32px" onkeyup="CheckNumber(this, '0123456789.')">
                                        <div class="sign-r clear">
                                            <button class="bg-transparent full-h right pdR10" type="button">
                                                <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                            </button>
                                        </div>
                                        <select class="field-overlay" ng-model="WellFargoPlan.credit_term_plan_number" name="" ng-options="item.label as item.value for item in credittermplans">
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Wells_Fargo_Plan">
                            <div class="layout-fixed">
                                <div>
                                    <div class="layout-fixed">
                                        <div class="w25px">
                                            <svg class="h15px clr-symbol" viewBox="0 0 55 55"> <path fill="#b1c7d7" d="M55,27.5C55,12.337,42.663,0,27.5,0S0,12.337,0,27.5c0,8.009,3.444,15.228,8.926,20.258l-0.026,0.023l0.892,0.752  c0.058,0.049,0.121,0.089,0.179,0.137c0.474,0.393,0.965,0.766,1.465,1.127c0.162,0.117,0.324,0.234,0.489,0.348  c0.534,0.368,1.082,0.717,1.642,1.048c0.122,0.072,0.245,0.142,0.368,0.212c0.613,0.349,1.239,0.678,1.88,0.98  c0.047,0.022,0.095,0.042,0.142,0.064c2.089,0.971,4.319,1.684,6.651,2.105c0.061,0.011,0.122,0.022,0.184,0.033  c0.724,0.125,1.456,0.225,2.197,0.292c0.09,0.008,0.18,0.013,0.271,0.021C25.998,54.961,26.744,55,27.5,55  c0.749,0,1.488-0.039,2.222-0.098c0.093-0.008,0.186-0.013,0.279-0.021c0.735-0.067,1.461-0.164,2.178-0.287  c0.062-0.011,0.125-0.022,0.187-0.034c2.297-0.412,4.495-1.109,6.557-2.055c0.076-0.035,0.153-0.068,0.229-0.104  c0.617-0.29,1.22-0.603,1.811-0.936c0.147-0.083,0.293-0.167,0.439-0.253c0.538-0.317,1.067-0.648,1.581-1  c0.185-0.126,0.366-0.259,0.549-0.391c0.439-0.316,0.87-0.642,1.289-0.983c0.093-0.075,0.193-0.14,0.284-0.217l0.915-0.764  l-0.027-0.023C51.523,42.802,55,35.55,55,27.5z M2,27.5C2,13.439,13.439,2,27.5,2S53,13.439,53,27.5  c0,7.577-3.325,14.389-8.589,19.063c-0.294-0.203-0.59-0.385-0.893-0.537l-8.467-4.233c-0.76-0.38-1.232-1.144-1.232-1.993v-2.957  c0.196-0.242,0.403-0.516,0.617-0.817c1.096-1.548,1.975-3.27,2.616-5.123c1.267-0.602,2.085-1.864,2.085-3.289v-3.545  c0-0.867-0.318-1.708-0.887-2.369v-4.667c0.052-0.52,0.236-3.448-1.883-5.864C34.524,9.065,31.541,8,27.5,8  s-7.024,1.065-8.867,3.168c-2.119,2.416-1.935,5.346-1.883,5.864v4.667c-0.568,0.661-0.887,1.502-0.887,2.369v3.545  c0,1.101,0.494,2.128,1.34,2.821c0.81,3.173,2.477,5.575,3.093,6.389v2.894c0,0.816-0.445,1.566-1.162,1.958l-7.907,4.313  c-0.252,0.137-0.502,0.297-0.752,0.476C5.276,41.792,2,35.022,2,27.5z" /> </svg>
                                        </div>
                                        <div class="text">{{usercredentials.username}}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Wells_Fargo_Plan">
                            <div class="layout-fixed">
                                <div>
                                    <div class="layout-fixed">
                                        <div class="w25px">
                                            <svg class="h15px clr-symbol" viewBox="0 0 60 60"> <path d="M22,27h15c0.553,0,1-0.448,1-1V14c0-0.552-0.447-1-1-1h-2v-2.5C35,7.467,32.532,5,29.5,5S24,7.467,24,10.5V13h-2   c-0.553,0-1,0.448-1,1v12C21,26.552,21.447,27,22,27z M26,10.5C26,8.57,27.57,7,29.5,7S33,8.57,33,10.5V13h-7V10.5z" fill="#FFFFFF" /> <path d="M49,33H11C4.935,33,0,37.935,0,44s4.935,11,11,11h38c6.065,0,11-4.935,11-11S55.065,33,49,33z M16.447,42.895l-2.928,1.464   L15.8,47.4c0.332,0.442,0.242,1.069-0.2,1.4c-0.18,0.135-0.39,0.2-0.599,0.2c-0.305,0-0.604-0.138-0.801-0.4L12,45.667L9.8,48.6   C9.604,48.862,9.304,49,8.999,49C8.79,49,8.58,48.935,8.4,48.8c-0.442-0.331-0.532-0.958-0.2-1.4l2.281-3.041l-2.928-1.464   c-0.494-0.247-0.694-0.848-0.447-1.342c0.248-0.494,0.849-0.695,1.342-0.447L11,42.382V39c0-0.552,0.447-1,1-1s1,0.448,1,1v3.382   l2.553-1.276c0.494-0.248,1.094-0.046,1.342,0.447C17.142,42.047,16.941,42.647,16.447,42.895z M28.447,42.895l-2.928,1.464   L27.8,47.4c0.332,0.442,0.242,1.069-0.2,1.4c-0.18,0.135-0.39,0.2-0.599,0.2c-0.305,0-0.604-0.138-0.801-0.4L24,45.667L21.8,48.6   c-0.196,0.262-0.496,0.4-0.801,0.4c-0.209,0-0.419-0.065-0.599-0.2c-0.442-0.331-0.532-0.958-0.2-1.4l2.281-3.041l-2.928-1.464   c-0.494-0.247-0.694-0.848-0.447-1.342c0.248-0.494,0.849-0.695,1.342-0.447L23,42.382V39c0-0.552,0.447-1,1-1s1,0.448,1,1v3.382   l2.553-1.276c0.494-0.248,1.095-0.046,1.342,0.447C29.142,42.047,28.941,42.647,28.447,42.895z M40.447,42.895l-2.928,1.464   L39.8,47.4c0.332,0.442,0.242,1.069-0.2,1.4c-0.18,0.135-0.39,0.2-0.599,0.2c-0.305,0-0.604-0.138-0.801-0.4L36,45.667L33.8,48.6   c-0.196,0.262-0.496,0.4-0.801,0.4c-0.209,0-0.419-0.065-0.599-0.2c-0.442-0.331-0.532-0.958-0.2-1.4l2.281-3.041l-2.928-1.464   c-0.494-0.247-0.694-0.848-0.447-1.342c0.248-0.494,0.847-0.695,1.342-0.447L35,42.382V39c0-0.552,0.447-1,1-1s1,0.448,1,1v3.382   l2.553-1.276c0.494-0.248,1.094-0.046,1.342,0.447C41.142,42.047,40.941,42.647,40.447,42.895z M52.447,42.895l-2.928,1.464   L51.8,47.4c0.332,0.442,0.242,1.069-0.2,1.4c-0.18,0.135-0.39,0.2-0.599,0.2c-0.305,0-0.604-0.138-0.801-0.4L48,45.667L45.8,48.6   c-0.196,0.262-0.496,0.4-0.801,0.4c-0.209,0-0.419-0.065-0.599-0.2c-0.442-0.331-0.532-0.958-0.2-1.4l2.281-3.041l-2.928-1.464   c-0.494-0.247-0.694-0.848-0.447-1.342c0.248-0.494,0.847-0.695,1.342-0.447L47,42.382V39c0-0.552,0.447-1,1-1s1,0.448,1,1v3.382   l2.553-1.276c0.494-0.248,1.094-0.046,1.342,0.447C53.142,42.047,52.941,42.647,52.447,42.895z" fill="#FFFFFF" /> </svg>
                                        </div>
                                        <div class="text">{{usercredentials.password}}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="box-setting-4">
                    <div class="content content-in">
                        <div class="itm no-saperator" ng-class="{ 'open' : checkbox.Credit_Memo_check }">
                            <div class="layout-fixed">
                                <div class="pdB5">
                                    <label class="label-form-field-2">Credit Memo</label>
                                </div>
                                <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                    <div class="checkedbox-toggle-1 block-i right">
                                        <input type="checkbox" ng-model="checkbox.Credit_Memo_check" ng-true-value="1" ng-false-value="0"><i></i><span></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Credit_Memo_check">
                            <label class="label-form-field-1">Amount:</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.creditmemo_amount.$invalid  }" ng-click="focusHandle($event)">
                                        <input type="text" ng-model="Credit_Memo.Amount" placeholder="" value="" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="creditmemo_amount">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Credit_Memo_check">
                            <label class="label-form-field-1">Note:</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-click="focusHandle($event)">
                                        <textarea type="text" ng-model="Credit_Memo.note" class="h80px">  
                                        </textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="box-setting-4">
                    <div class="content content-in">
                        <div class="itm no-saperator" ng-class="{ 'open' : checkbox.Manager_Credit_check }">
                            <div class="layout-fixed">
                                <div class="pdB5">
                                    <label class="label-form-field-2">Manager Credit</label>
                                </div>
                                <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                    <div class="checkedbox-toggle-1 block-i right">
                                        <input type="checkbox" ng-model="checkbox.Manager_Credit_check" ng-true-value="1" ng-false-value="0"><i></i><span></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Manager_Credit_check">
                            <label class="label-form-field-1">Amount:</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.managercredit_amount.$invalid  }" ng-click="focusHandle($event)">
                                        <input type="text" ng-model="Manager_Credit.Amount" placeholder="" value="" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="managercredit_amount">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Manager_Credit_check">
                            <label class="label-form-field-1">Note:</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-click="focusHandle($event)">
                                        <textarea type="text" ng-model="Manager_Credit.note" class="h80px">  
                                        </textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="box-setting-4" ng-if="total_instore_credit > 0">
                    <div class="content content-in">
                        <div class="itm no-saperator" ng-class="{ 'open' : checkbox.Instore_Credit_check }">
                            <div class="layout-fixed">
                                <div class="pdB5">
                                    <label class="label-form-field-2">In Store Credit</label>
                                </div>
                                <div class="center">
                                    <label class="label-form-field-2">Available In Store Credit: ${{total_instore_credit | number : 2}}</label>
                                </div>
                                <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                    <div class="checkedbox-toggle-1 block-i right">
                                        <input type="checkbox" ng-model="checkbox.Instore_Credit_check" ng-true-value="1" ng-false-value="0"><i></i><span></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="itm" ng-if="checkbox.Instore_Credit_check">
                            <label class="label-form-field-1">Amount:</label>
                            <div class="layout-fixed">
                                <div>
                                    <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.instorecredit_amount.$invalid  }" ng-click="focusHandle($event)">
                                        <input type="text" ng-model="Instore_Credit.Amount" placeholder="" value="" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="instorecredit_amount" ng-change="checkInstoreCredit(Instore_Credit.Amount)">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </ion-scroll>
</div>
</form>
<div class="app-create-button show">
    <button class="button-save-1 pd0-i w50px h50px" type="button" onclick="getElementById('submitFormPaymentAdd').click()"></button>
</div>