<div class="app-header bg-header-1">
    <div class="layout-fixed full-h text-center">
        <div class="full-h v-bottom-i pdB15">
            <div class="app-content-header bg-header-1">
                <div class="text-name-header-1 nowrap pdLR40">{{invoice_no}}</div>
                <div class="text-title-header-1 nowrap mgT5">Add payment</div>
            </div>
        </div>
    </div>
    <button type="button" class="popup-back-button bg-transparent pd0-i biger-3-time" ng-click="closeTarget('#popupOrderInvoiceAddPayment')">
        <svg class="h20px" viewBox="0 0 129 129"> <path fill="#FFFFFF" d="m88.6,121.3c0.8,0.8 1.8,1.2 2.9,1.2s2.1-0.4 2.9-1.2c1.6-1.6 1.6-4.2 0-5.8l-51-51 51-51c1.6-1.6 1.6-4.2 0-5.8s-4.2-1.6-5.8,0l-54,53.9c-1.6,1.6-1.6,4.2 0,5.8l54,53.9z" /> </svg>
    </button>
</div>
<div class="box-setting-4 no-saperator bg-header-1 pdT5">
    <div class="bg-overlay-1 pdT15 pdB10">
        <div class="layout-fixed pdL15 pdR10">
            <div>
                <div class="text-name-3 baseline">50% of Total Bill: </div>
                <div class="text-title-3 mgT5" ng-bind-html="bill.replace('$','<span class=\'fz10 pdR2\'>$</span>')"></div>
            </div>
            <div class="w60px">
                <button class="button-field-1 white outline w40px h40px block-i center" type="button" ng-click="TotalBill()">
                    <svg class="h20px clr-symbol-clickable" viewBox="0 0 487.001 487.001"> <path d="M400.49,0H86.505C68.611,0,54.052,14.559,54.052,32.453v422.099c0,17.892,14.559,32.449,32.453,32.449H400.49   c17.898,0,32.459-14.557,32.459-32.449V32.453C432.949,14.559,418.388,0,400.49,0z M100.019,77.677   c0-13.351,10.822-24.174,24.178-24.174h238.607c13.359,0,24.178,10.823,24.178,24.174v35.737c0,13.355-10.818,24.177-24.178,24.177   H124.197c-13.355,0-24.178-10.821-24.178-24.177V77.677z M197.494,412.168c4.945,4.947,4.945,12.968-0.002,17.916   c-2.473,2.473-5.715,3.71-8.957,3.71c-3.242,0-6.484-1.237-8.957-3.711l-22.373-22.375l-22.373,22.375   c-2.475,2.474-5.717,3.711-8.959,3.711c-3.242,0-6.482-1.237-8.955-3.71c-4.949-4.948-4.949-12.969-0.002-17.916l22.373-22.375   l-22.373-22.375c-4.947-4.947-4.947-12.968,0.002-17.916c4.947-4.945,12.967-4.946,17.914,0.001l22.373,22.374l22.373-22.374   c4.947-4.947,12.967-4.947,17.914-0.001c4.947,4.948,4.947,12.969,0.002,17.916l-22.375,22.375L197.494,412.168z M201.511,257.592   h-31.639v31.643c0,6.996-5.672,12.668-12.668,12.668c-6.996,0-12.668-5.672-12.668-12.668v-31.643h-31.639   c-6.996,0-12.668-5.672-12.668-12.668s5.672-12.668,12.668-12.668h31.639v-31.643c0-6.995,5.672-12.667,12.668-12.667   c6.996,0,12.668,5.672,12.668,12.667v31.643h31.639c6.996,0,12.668,5.672,12.668,12.668S208.507,257.592,201.511,257.592z    M295.646,436.645c-3.242,0-6.484-1.236-8.957-3.71c-4.949-4.947-4.949-12.968,0-17.915l62.66-62.666   c4.945-4.947,12.967-4.947,17.914-0.001c4.949,4.947,4.949,12.969,0,17.916l-62.66,62.665   C302.13,435.407,298.888,436.645,295.646,436.645z M280.634,358.448c0-8.561,6.934-15.507,15.506-15.507   c8.561,0,15.506,6.945,15.506,15.507c0,8.566-6.945,15.504-15.506,15.504C287.568,373.952,280.634,367.015,280.634,358.448z    M364.142,436.619c-8.563,0-15.506-6.943-15.506-15.506c0-8.565,6.943-15.507,15.506-15.507c8.572,0,15.506,6.941,15.506,15.507   C379.648,429.676,372.714,436.619,364.142,436.619z M374.449,257.592h-88.613c-6.998,0-12.67-5.672-12.67-12.668   s5.672-12.668,12.67-12.668h88.613c6.996,0,12.668,5.672,12.668,12.668S381.445,257.592,374.449,257.592z" /> </svg>
                </button>
            </div>
        </div>
    </div>
</div>
<form class="app-content" id="formPaymentAdd" name="formPaymentAdd" novalidate="" ng-submit="validateForm(formPaymentAdd, 'payment', 'scrollPaymentAdd')">
    <div class="app-content-inner content-pd">
        <button id="submitFormPaymentAdd" style="display:none;" type="submit">Submit</button>
        <ion-scroll class="scroll-area" direction="y" has-bouncing="false" overflow-scroll="false" delegate-handle="scrollPaymentAdd" on-scroll="scrollContent('scrollPaymentAdd')">
            <div class="box-setting-4">
                <div class="content content-in">
                    <div class="itm no-saperator">
                        <div class="layout-fixed">
                            <div class="pdB5">
                                <label class="label-form-field-1 normal">Cash</label>
                            </div>
                            <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                <div class="checkedbox-toggle-1 block-i right">
                                    <input type="checkbox" ng-model="checkbox.Cash_check" ng-true-value="1" ng-false-value="0"><i></i><span></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Cash_check">
                        <label class="label-form-field-1">Amount</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.cash_amount.$invalid  }" ng-click="focusHandle($event)">
                                    <input id="cash_amount" type="text" ng-model="Cash.Amount" placeholder="" value="" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="cash_amount">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="box-setting-4">
                <div class="content content-in">
                    <div class="itm no-saperator">
                        <div class="layout-fixed">
                            <div class="pdB5">
                                <label class="label-form-field-1 normal">Check</label>
                            </div>
                            <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                <div class="checkedbox-toggle-1 block-i right">
                                    <input type="checkbox" ng-model="checkbox.Check_check" ng-true-value="1" ng-false-value="0"><i></i><span></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Check_check">
                        <label class="label-form-field-1">Amount</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.check_amount.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" ng-model="Check.Amount" placeholder="" value="" name="check_amount" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required id="check_amount">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Check_check">
                        <label class="label-form-field-1">Authorization #</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.check_authorization.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" placeholder="" value="" name="check_authorization" ng-model="Check.Authorization" class="h32px" required id="check_authorization">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Check_check">
                        <label class="label-form-field-1">Check #</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.check_check.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" placeholder="" value="" name="check_check" id="check_check" ng-model="Check.Check" class="h32px" required>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="box-setting-4">
                <div class="content content-in">
                    <div class="itm no-saperator">
                        <div class="layout-fixed">
                            <div class="pdB5">
                                <label class="label-form-field-1 normal">CC manual</label>
                            </div>
                            <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                <div class="checkedbox-toggle-1 block-i right">
                                    <input type="checkbox" ng-model="checkbox.CC_Manual_check" ng-true-value="1" ng-false-value="0" name=""><i></i><span></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.CC_Manual_check">
                        <div class="layout-fixed input-1-group">
                            <div>
                                <label class="label-form-field-1">First Name</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_first_name.$invalid  }" ng-click="focusHandle($event)">
                                            <input class="h32px" name="CC_Manual_first_name" value="" placeholder="" type="text" ng-model="CC_Manual.first_name" required id="CC_Manual_first_name">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label class="label-form-field-1">Last Name</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_last_name.$invalid  }" ng-click="focusHandle($event)">
                                            <input class="h32px" name="CC_Manual_last_name" value="" placeholder="" type="text" ng-model="CC_Manual.last_name" required id="CC_Manual_last_name">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.CC_Manual_check">
                        <label class="label-form-field-1">Address</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_street.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" class="h32px" name="CC_Manual_street" value="" placeholder="" ng-model="CC_Manual.street" required id="CC_Manual_street">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.CC_Manual_check">
                        <div class="layout-fixed input-1-group">
                            <div class="layout-w-1:2">
                                <label class="label-form-field-1">City</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_city.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" name="CC_Manual_city" value="" placeholder="" ng-model="CC_Manual.city" required id="CC_Manual_city">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label class="label-form-field-1">State</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_state.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" name="CC_Manual_state" value="" placeholder="" ng-model="CC_Manual.state" required id="CC_Manual_state">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label class="label-form-field-1">Zip code</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_zipcode.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="ft-fifth h32px" value="" placeholder="" ng-model="CC_Manual.zipcode" name="CC_Manual_zipcode" required id="CC_Manual_zipcode">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.CC_Manual_check">
                        <input type="hidden" id="required_CC_Manual" placeholder="" value="0" name="">
                        <div class="layout-fixed">
                            <div>
                                <label class="label-form-field-1">Credit card type</label>
                                <div class="text pdL5 mgT5 logs">Please input card number</div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.CC_Manual_check">
                        <label class="label-form-field-1">Credit Card #</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_card_number.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" class="h32px" value="" placeholder="" ng-model="CC_Manual.card_number" name="CC_Manual_card_number" required id="CC_Manual_card_number" ng-change="requiredAmount(CC_Manual.card_number, 'CC_Manual_cart')">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.CC_Manual_check">
                        <div class="layout-fixed input-1-group">
                            <div>
                                <label class="label-form-field-1">Expn Date - Month</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_month_cc.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" id="CC_Manual_month_cc" value="{{Input_value.CC_Manual_month_cc}}" placeholder="" required>
                                            <div class="sign-r clear">
                                                <button class="bg-transparent full-h right pdR10" type="button">
                                                    <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                                </button>
                                            </div>
                                            <select name="CC_Manual_month_cc" ng-model="CC_Manual.month_cc" class="field-overlay" ng-change="setValueCC_Manual_month_cc(CC_Manual.month_cc)"
                                                    ng-options="item.value as item.name for item in monthNames| orderBy:['value']" required>
                                                <option value="">-----</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label class="label-form-field-1">Expn Date - Year</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_year_cc.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" value="{{CC_Manual.year_cc}}" placeholder="" required id="CC_Manual_year_cc">
                                            <div class="sign-r clear">
                                                <button class="bg-transparent full-h right pdR10" type="button">
                                                    <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                                </button>
                                            </div>
                                            <select name="CC_Manual_year_cc" ng-model="CC_Manual.year_cc" class="field-overlay" ng-options="item as item for item in yearName" required>
                                                <option value="">-----</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="layout-w-1:4">
                                <label class="label-form-field-1">CVV2 (Code)</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_CVV2_Code.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" name="CC_Manual_CVV2_Code" value="" placeholder="" ng-change="requiredcvv(CC_Manual.CVV2_Code, 'CC_Manual')" ng-model="CC_Manual.CVV2_Code" required id="CC_Manual_CVV2_Code">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.CC_Manual_check">
                        <label class="label-form-field-1">Amount</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.CC_Manual_Amount.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" ng-model="CC_Manual.Amount" placeholder="" value="" name="CC_Manual_Amount" awnum num-sep="." num-int=18 num-fract=2 required id="CC_Manual_Amount" ng-trim=false class="h32px">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="box-setting-4">
                <div class="content content-in">
                    <div class="itm no-saperator">
                        <div class="layout-fixed">
                            <div class="pdB5">
                                <label class="label-form-field-1 normal">Prepaid</label>
                            </div>
                            <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                <div class="checkedbox-toggle-1 block-i right">
                                    <input type="checkbox" ng-model="checkbox.Prepaid_check" ng-true-value="1" ng-false-value="0"><i></i><span></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Prepaid_check">
                        <label class="label-form-field-1">Amount</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.prepaid_amount.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" ng-model="Prepaid.Amount" placeholder="" value="" name="prepaid_amount" awnum num-sep="." num-int=18 num-fract=2 required id="prepaid_amount" ng-trim=false class="h32px">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="box-setting-4">
                <div class="content content-in">
                    <div class="itm no-saperator">
                        <div class="layout-fixed">
                            <div class="pdB5">
                                <label class="label-form-field-1 normal">Payment plan</label>
                            </div>
                            <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                <div class="checkedbox-toggle-1 block-i right">
                                    <input type="checkbox" ng-model="checkbox.Payment_Plan_check" ng-true-value="1" ng-false-value="0"><i></i><span></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Payment_Plan_check">
                        <div class="layout-fixed input-1-group">
                            <div>
                                <label class="label-form-field-1">First Name</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_first_name.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" placeholder="" value="" name="Payment_Plan_first_name" ng-model="Payment_Plan.first_name" class="h32px" required id="Payment_Plan_first_name">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label class="label-form-field-1">Last Name</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_last_name.$invalid  }" ng-click="focusHandle($event)">
                                            <input class="h32px" name="Payment_Plan_last_name" value="" placeholder="" type="text" ng-model="Payment_Plan.last_name" required id="Payment_Plan_last_name">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Payment_Plan_check">
                        <label class="label-form-field-1">Address</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_street.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" class="h32px" name="Payment_Plan_street" value="" placeholder="" ng-model="Payment_Plan.street" required id="Payment_Plan_street">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Payment_Plan_check">
                        <div class="layout-fixed input-1-group">
                            <div class="layout-w-1:2">
                                <label class="label-form-field-1">City</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_city.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" name="Payment_Plan_city" value="" placeholder="" ng-model="Payment_Plan.city" required id="Payment_Plan_city">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label class="label-form-field-1">State</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_state.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" name="Payment_Plan_state" value="" placeholder="" ng-model="Payment_Plan.state" required id="Payment_Plan_state">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label class="label-form-field-1">Zip code</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_zipcode.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="ft-fifth h32px" value="" placeholder="" ng-model="Payment_Plan.zipcode" name="Payment_Plan_zipcode" required id="Payment_Plan_zipcode">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Payment_Plan_check">
                        <input type="hidden" id="required_Payment_Plan" placeholder="" value="0" name="">
                        <div class="layout-fixed">
                            <div>
                                <label class="label-form-field-1">Credit card type</label>
                                <div class="text pdL5 mgT5 pplogs">Please input card number</div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Payment_Plan_check">
                        <label class="label-form-field-1">Credit Card #</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_Card_Number.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" id="Payment_Plan_Card_Number" ng-change="requiredAmount(Payment_Plan.Card_Number, 'Payment_Plan')" ng-model="Payment_Plan.Card_Number" placeholder="" value="" name="Payment_Plan_Card_Number" class="h32px" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Payment_Plan_check">
                        <div class="layout-fixed input-1-group">
                            <div>
                                <label class="label-form-field-1">Expn Date - Month</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_month.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" id="Payment_Plan_month" value="{{Input_value.CC_Manual_month_cc}}" placeholder="">
                                            <div class="sign-r clear">
                                                <button class="bg-transparent full-h right pdR10" type="button">
                                                    <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                                </button>
                                            </div>
                                            <select name="Payment_Plan_month" ng-model="Payment_Plan.month" class="field-overlay" required ng-change="setValueCC_Manual_month_cc(Payment_Plan.month)">
                                                <option value="">-----</option>
                                                <option value="{{item.value}}" ng-repeat="item in monthNames">{{item.name}}</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label class="label-form-field-1">Expn Date - Year</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_year.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" class="h32px" id="Payment_Plan_year" value="{{Payment_Plan.year}}" placeholder="">
                                            <div class="sign-r clear">
                                                <button class="bg-transparent full-h right pdR10" type="button">
                                                    <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                                </button>
                                            </div>
                                            <select name="Payment_Plan_year" ng-model="Payment_Plan.year" class="field-overlay" required>
                                                <option value="">-----</option>
                                                <option value="{{item}}" ng-repeat="item in yearName">{{item}}</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="layout-w-1:4">
                                <label class="label-form-field-1">CVV2 (Code)</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.Payment_Plan_CVV2_Codes.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" ng-change="requiredcvv(Payment_Plan.CVV2_Codes, 'Payment_Plan')" ng-model="Payment_Plan.CVV2_Codes" placeholder="" value="" name="Payment_Plan_CVV2_Codes" class="h32px" required="" id="Payment_Plan_CVV2_Codes">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Payment_Plan_check" ng-click="resizeScroll('scrollPaymentAdd')">
                        <div class="layout-fixed input-1-detail" ng-repeat="item in ChargeDate">
                            <div>
                                <label class="label-form-field-1">Amount</label>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.date_amount{{$inde}}.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" placeholder="" ng-model="item.amount" value="" name="date_amount{{$inde}}" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required id="date_amount{{$inde}}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <div class="layout-fixed">
                                    <div>
                                        <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.ChargeDate{{$index}}.$invalid  }" ng-click="focusHandle($event)">
                                            <input type="text" placeholder="Charge date" name="" class="h32px pdR35-i" id="ChargeDate{{$index}}" value="{{item.ChargeDate| date: 'MM/dd/yyyy'}}">
                                            <div class="field-overlay datetime" date="" ion-datetime-picker="" name="ChargeDate{{$index}}" ng-model="item.ChargeDate" required>
                                                {{item.ChargeDate| date: 'MM/dd/yyyy'}}
                                            </div>
                                            <div class="sign-r clear" ng-click="addRowChargeDate('Payment_Plan', Payment_Plan_check)" ng-if="$index == 0">
                                                <button class="bg-transparent full-h right pdR8" type="button">
                                                    <svg viewBox="0 0 53 53" class="h20px"> <polygon style="fill:#B1C7D7;" points="7,8.5 47,8.5 47,0.5 0,0.5 0,45.5 7,45.5 " /> <rect x="7" y="8.5" style="fill:#1075BB;" width="46" height="44" /> <line style="fill:none;stroke:#FFF;stroke-width:3;stroke-linecap:round;stroke-miterlimit:10;" x1="30" y1="19.5" x2="30" y2="41.5" /> <line style="fill:none;stroke:#FFF;stroke-width:3;stroke-linecap:round;stroke-miterlimit:10;" x1="41" y1="30.5" x2="19" y2="30.5" /> </svg>
                                                </button>
                                            </div>
                                            <div class="sign-r clear" ng-click="removeItemChargeDate($index)" ng-if="$index != 0">
                                                <button class="bg-transparent full-h right pdR10" type="button">
                                                    <svg viewBox="0 0 64 64" class="h16px"> <g> <path fill="#D75A4A" d="M28.941,31.786L0.613,60.114c-0.787,0.787-0.787,2.062,0,2.849c0.393,0.394,0.909,0.59,1.424,0.59   c0.516,0,1.031-0.196,1.424-0.59l28.541-28.541l28.541,28.541c0.394,0.394,0.909,0.59,1.424,0.59c0.515,0,1.031-0.196,1.424-0.59   c0.787-0.787,0.787-2.062,0-2.849L35.064,31.786L63.41,3.438c0.787-0.787,0.787-2.062,0-2.849c-0.787-0.786-2.062-0.786-2.848,0   L32.003,29.15L3.441,0.59c-0.787-0.786-2.061-0.786-2.848,0c-0.787,0.787-0.787,2.062,0,2.849L28.941,31.786z" /> </g> </svg>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="box-setting-4">
                <div class="content content-in">
                    <div class="itm no-saperator">
                        <div class="layout-fixed">
                            <div class="pdB5">
                                <label class="label-form-field-1 normal">Wells fargo plan</label>
                            </div>
                            <div class="w60px clear" ng-click="resizeScroll('scrollPaymentAdd')">
                                <div class="checkedbox-toggle-1 block-i right">
                                    <input type="checkbox" ng-model="checkbox.Wells_Fargo_Plan" ng-true-value="1" ng-false-value="0"><i></i><span></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="itm" ng-if="checkbox.Wells_Fargo_Plan">
                        <label class="label-form-field-1">Authorization #</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.wellfargoflan_authorization.$invalid  }" ng-click="focusHandle($event)">
                                    <input type="text" placeholder="" value="" name="wellfargoflan_authorization" ng-model="WellFargoPlan.authorization_number" class="h32px" required id="wellfargoflan_authorization" class="full-w" onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')" maxlength="10" >
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Wells_Fargo_Plan">
                        <label class="label-form-field-1">Amount:</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.wellfargoflan_amount.$invalid  }" ng-click="focusHandle($event)">
                                    <input id="wellfargoflan_amount" type="text" ng-model="WellFargoPlan.authorization_amount" placeholder="" value="" class="h32px" ng-trim=false awnum num-sep="." num-int=18 num-fract=2 required name="wellfargoflan_amount">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Wells_Fargo_Plan">
                        <label class="label-form-field-1">Credit Term Plan #:</label>
                        <div class="layout-fixed">
                            <div>
                                <div class="input-form-field-1" ng-class="{ 'has-errors' : formPaymentAdd.credit_term_plan_number.$invalid }" ng-click="focusHandle($event)">
                                    <input type="text" placeholder="" value="{{WellFargoPlan.credit_term_plan_number}}" name="credit_term_plan_number" class="h32px" onkeyup="CheckNumber(this, '0123456789.')">
                                    <div class="sign-r clear">
                                        <button class="bg-transparent full-h right pdR10" type="button">
                                            <svg class="h17px clr-symbol-clickable" viewBox="0 0 63.215 63.215"> <g> <g> <path fill="#1075BB" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                        </button>
                                    </div>
                                    <select class="field-overlay" ng-model="WellFargoPlan.credit_term_plan_number" name="" ng-options="item.label as item.value for item in credittermplans">
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Wells_Fargo_Plan">
                        <div class="layout-fixed">
                            <div>
                                <div class="layout-fixed">
                                    <div class="w25px">
                                        <svg class="h15px clr-symbol" viewBox="0 0 55 55"> <path fill="#b1c7d7" d="M55,27.5C55,12.337,42.663,0,27.5,0S0,12.337,0,27.5c0,8.009,3.444,15.228,8.926,20.258l-0.026,0.023l0.892,0.752  c0.058,0.049,0.121,0.089,0.179,0.137c0.474,0.393,0.965,0.766,1.465,1.127c0.162,0.117,0.324,0.234,0.489,0.348  c0.534,0.368,1.082,0.717,1.642,1.048c0.122,0.072,0.245,0.142,0.368,0.212c0.613,0.349,1.239,0.678,1.88,0.98  c0.047,0.022,0.095,0.042,0.142,0.064c2.089,0.971,4.319,1.684,6.651,2.105c0.061,0.011,0.122,0.022,0.184,0.033  c0.724,0.125,1.456,0.225,2.197,0.292c0.09,0.008,0.18,0.013,0.271,0.021C25.998,54.961,26.744,55,27.5,55  c0.749,0,1.488-0.039,2.222-0.098c0.093-0.008,0.186-0.013,0.279-0.021c0.735-0.067,1.461-0.164,2.178-0.287  c0.062-0.011,0.125-0.022,0.187-0.034c2.297-0.412,4.495-1.109,6.557-2.055c0.076-0.035,0.153-0.068,0.229-0.104  c0.617-0.29,1.22-0.603,1.811-0.936c0.147-0.083,0.293-0.167,0.439-0.253c0.538-0.317,1.067-0.648,1.581-1  c0.185-0.126,0.366-0.259,0.549-0.391c0.439-0.316,0.87-0.642,1.289-0.983c0.093-0.075,0.193-0.14,0.284-0.217l0.915-0.764  l-0.027-0.023C51.523,42.802,55,35.55,55,27.5z M2,27.5C2,13.439,13.439,2,27.5,2S53,13.439,53,27.5  c0,7.577-3.325,14.389-8.589,19.063c-0.294-0.203-0.59-0.385-0.893-0.537l-8.467-4.233c-0.76-0.38-1.232-1.144-1.232-1.993v-2.957  c0.196-0.242,0.403-0.516,0.617-0.817c1.096-1.548,1.975-3.27,2.616-5.123c1.267-0.602,2.085-1.864,2.085-3.289v-3.545  c0-0.867-0.318-1.708-0.887-2.369v-4.667c0.052-0.52,0.236-3.448-1.883-5.864C34.524,9.065,31.541,8,27.5,8  s-7.024,1.065-8.867,3.168c-2.119,2.416-1.935,5.346-1.883,5.864v4.667c-0.568,0.661-0.887,1.502-0.887,2.369v3.545  c0,1.101,0.494,2.128,1.34,2.821c0.81,3.173,2.477,5.575,3.093,6.389v2.894c0,0.816-0.445,1.566-1.162,1.958l-7.907,4.313  c-0.252,0.137-0.502,0.297-0.752,0.476C5.276,41.792,2,35.022,2,27.5z" /> </svg>
                                    </div>
                                    <div class="text">{{usercredentials.username}}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="itm" ng-if="checkbox.Wells_Fargo_Plan">
                        <div class="layout-fixed">
                            <div>
                                <div class="layout-fixed">
                                    <div class="w25px">
                                        <svg class="h15px clr-symbol" viewBox="0 0 60 60"> <path d="M22,27h15c0.553,0,1-0.448,1-1V14c0-0.552-0.447-1-1-1h-2v-2.5C35,7.467,32.532,5,29.5,5S24,7.467,24,10.5V13h-2   c-0.553,0-1,0.448-1,1v12C21,26.552,21.447,27,22,27z M26,10.5C26,8.57,27.57,7,29.5,7S33,8.57,33,10.5V13h-7V10.5z" fill="#FFFFFF" /> <path d="M49,33H11C4.935,33,0,37.935,0,44s4.935,11,11,11h38c6.065,0,11-4.935,11-11S55.065,33,49,33z M16.447,42.895l-2.928,1.464   L15.8,47.4c0.332,0.442,0.242,1.069-0.2,1.4c-0.18,0.135-0.39,0.2-0.599,0.2c-0.305,0-0.604-0.138-0.801-0.4L12,45.667L9.8,48.6   C9.604,48.862,9.304,49,8.999,49C8.79,49,8.58,48.935,8.4,48.8c-0.442-0.331-0.532-0.958-0.2-1.4l2.281-3.041l-2.928-1.464   c-0.494-0.247-0.694-0.848-0.447-1.342c0.248-0.494,0.849-0.695,1.342-0.447L11,42.382V39c0-0.552,0.447-1,1-1s1,0.448,1,1v3.382   l2.553-1.276c0.494-0.248,1.094-0.046,1.342,0.447C17.142,42.047,16.941,42.647,16.447,42.895z M28.447,42.895l-2.928,1.464   L27.8,47.4c0.332,0.442,0.242,1.069-0.2,1.4c-0.18,0.135-0.39,0.2-0.599,0.2c-0.305,0-0.604-0.138-0.801-0.4L24,45.667L21.8,48.6   c-0.196,0.262-0.496,0.4-0.801,0.4c-0.209,0-0.419-0.065-0.599-0.2c-0.442-0.331-0.532-0.958-0.2-1.4l2.281-3.041l-2.928-1.464   c-0.494-0.247-0.694-0.848-0.447-1.342c0.248-0.494,0.849-0.695,1.342-0.447L23,42.382V39c0-0.552,0.447-1,1-1s1,0.448,1,1v3.382   l2.553-1.276c0.494-0.248,1.095-0.046,1.342,0.447C29.142,42.047,28.941,42.647,28.447,42.895z M40.447,42.895l-2.928,1.464   L39.8,47.4c0.332,0.442,0.242,1.069-0.2,1.4c-0.18,0.135-0.39,0.2-0.599,0.2c-0.305,0-0.604-0.138-0.801-0.4L36,45.667L33.8,48.6   c-0.196,0.262-0.496,0.4-0.801,0.4c-0.209,0-0.419-0.065-0.599-0.2c-0.442-0.331-0.532-0.958-0.2-1.4l2.281-3.041l-2.928-1.464   c-0.494-0.247-0.694-0.848-0.447-1.342c0.248-0.494,0.847-0.695,1.342-0.447L35,42.382V39c0-0.552,0.447-1,1-1s1,0.448,1,1v3.382   l2.553-1.276c0.494-0.248,1.094-0.046,1.342,0.447C41.142,42.047,40.941,42.647,40.447,42.895z M52.447,42.895l-2.928,1.464   L51.8,47.4c0.332,0.442,0.242,1.069-0.2,1.4c-0.18,0.135-0.39,0.2-0.599,0.2c-0.305,0-0.604-0.138-0.801-0.4L48,45.667L45.8,48.6   c-0.196,0.262-0.496,0.4-0.801,0.4c-0.209,0-0.419-0.065-0.599-0.2c-0.442-0.331-0.532-0.958-0.2-1.4l2.281-3.041l-2.928-1.464   c-0.494-0.247-0.694-0.848-0.447-1.342c0.248-0.494,0.847-0.695,1.342-0.447L47,42.382V39c0-0.552,0.447-1,1-1s1,0.448,1,1v3.382   l2.553-1.276c0.494-0.248,1.094-0.046,1.342,0.447C53.142,42.047,52.941,42.647,52.447,42.895z" fill="#FFFFFF" /> </svg>
                                    </div>
                                    <div class="text">{{usercredentials.password}}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </ion-scroll>
    </div>
</form>
<div class="app-control">
    <div class="layout-fixed full-h pdT2">
        <div class="w42px full-h relative">
            <button class="bg-transparent pd0-i full text-left pdL10-i" type="button" onclick="openQuickOption(this)">
                <svg class="h20px" viewBox="0 0 460.713 460.713"> <g> <rect y="115.356" width="302" height="30" fill="#FFFFFF" /> <polygon points="335.786,202.231 398.25,264.694 460.713,202.232  " fill="#FFFFFF" /> <rect y="315.356" width="302" height="30" fill="#FFFFFF" /> <rect y="215.356" width="302" height="30" fill="#FFFFFF" /> </g> </svg>
            </button>
            <div class="quick-popup box-popup-1 display-bottom-left mgB55" onclick="closeQuickOption(this)">
                <div class="popup-content w140px">
                    <ul class="list-item-03">
                        <li ng-click="opencaculator()">
                            <div class="layout-fixed">
                                <div class="icon-area">
                                    <svg class="h15px" viewBox="0 0 26 26"> <path style="fill:#030104;" d="M20,0H6C4.344,0,3,1.344,3,3v20c0,1.656,1.344,3,3,3h14c1.656,0,3-1.344,3-3V3   C23,1.344,21.656,0,20,0z M21,8c0,0.551-0.449,1-1,1H6C5.449,9,5,8.551,5,8V3c0-0.551,0.449-1,1-1h14c0.551,0,1,0.449,1,1V8z M9,13   c0,0.551-0.449,1-1,1H6c-0.551,0-1-0.449-1-1v-1c0-0.551,0.449-1,1-1h2c0.551,0,1,0.449,1,1V13z M15,13c0,0.551-0.449,1-1,1h-2   c-0.551,0-1-0.449-1-1v-1c0-0.551,0.449-1,1-1h2c0.551,0,1,0.449,1,1V13z M21,13c0,0.551-0.449,1-1,1h-2c-0.551,0-1-0.449-1-1v-1   c0-0.551,0.449-1,1-1h2c0.551,0,1,0.449,1,1V13z M9,18c0,0.551-0.449,1-1,1H6c-0.551,0-1-0.449-1-1v-1c0-0.551,0.449-1,1-1h2   c0.551,0,1,0.449,1,1V18z M15,18c0,0.551-0.449,1-1,1h-2c-0.551,0-1-0.449-1-1v-1c0-0.551,0.449-1,1-1h2c0.551,0,1,0.449,1,1V18z    M21,18c0,0.551-0.449,1-1,1h-2c-0.551,0-1-0.449-1-1v-1c0-0.551,0.449-1,1-1h2c0.551,0,1,0.449,1,1V18z M9,23c0,0.551-0.449,1-1,1   H6c-0.551,0-1-0.449-1-1v-1c0-0.551,0.449-1,1-1h2c0.551,0,1,0.449,1,1V23z M15,23c0,0.551-0.449,1-1,1h-2c-0.551,0-1-0.449-1-1v-1   c0-0.551,0.449-1,1-1h2c0.551,0,1,0.449,1,1V23z M21,23c0,0.551-0.449,1-1,1h-2c-0.551,0-1-0.449-1-1v-1c0-0.551,0.449-1,1-1h2   c0.551,0,1,0.449,1,1V23z" /> <path style="fill:#030104;" d="M19,4v3h-2V4H19 M19,3h-2c-0.551,0-1,0.449-1,1v3c0,0.551,0.449,1,1,1h2c0.551,0,1-0.449,1-1V4     C20,3.449,19.551,3,19,3L19,3z" /> </svg>
                                </div>
                                <div class="name-area text-link-1">
                                    Calculator
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="popup-overlay"></div>
            </div>
        </div>
        <div class="full-h">
            <button class="button-form-field-1 darkgray position-left full" type="button" ng-click="closeTarget('#popupOrderInvoiceAddPayment');">
                Cancel
            </button>
        </div>
        <div class="full-h">
            <button class="button-form-field-1 position-right full" onclick="getElementById('submitFormPaymentAdd').click()" type="button">
                <svg class="icon h14px" viewBox="0 0 28.91 28.91"> <path style="fill:#030104;" d="M4.594,11.533c0,0-3.091,12.141-4.2,16.889l5.937-8.125c-0.539-1.199-0.214-3.018,0.729-4.049   c1.266-1.383,3.52-1.383,4.904-0.117s1.479,3.414,0.213,4.797c-0.959,1.053-2.733,1.477-3.989,1.008L0.771,28.91l15.646-6.059   l6.287-9.42l-8.229-7.705L4.594,11.533z" /> <polygon style="fill:#030104;" points="20.669,0 16.153,4.193 24.241,11.988 28.515,7.555  " /> </svg>
                Add
            </button>
        </div>
    </div>
</div>