<div class="app-header">
    <div class="setting-header layout-fixed h50px">
        <div class="w40px clear pdL10" ng-click="closeTarget('#orderInvoiceDetailTable')">
            <button class="bg-transparent left" style="transform: rotate(-10deg)">
                <svg class="h22px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 63.336 63.336" style="enable-background:new 0 0 63.336 63.336;" xml:space="preserve"> <g> <g> <path d="M14.924,34.879l30.822,27.938c0.383,0.348,0.864,0.519,1.344,0.519c0.545,0,1.087-0.222,1.482-0.657    c0.741-0.818,0.68-2.083-0.139-2.824l-29.642-26.87L45.66,3.342c0.742-0.818,0.68-2.083-0.139-2.824    c-0.817-0.742-2.082-0.679-2.824,0.139L14.758,31.48c-0.439,0.485-0.59,1.126-0.475,1.723    C14.224,33.811,14.436,34.438,14.924,34.879z" fill="#FFFFFF" /> </g> </g> </svg>
            </button>
        </div>
        <div class="clear pdL10">
            <div class="app-title-name left full-w">
                <div class="name ft-fourth bold fz22 lh1 clr-black uppercase nowrap">Invoice Detail - {{invoice_no}}</div>
                <div class="sname fz16 clr-white mgT5 nowrap">Invoice Item Information</div>
            </div>
        </div>
       <!--  <div class="w30px clear pdR5">
            <button class="link--setting bg-transparent right">
                <svg class="h24px" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 58 58" style="enable-background:new 0 0 58 58;" xml:space="preserve"> <circle style="fill: #FFF; stroke: #7ab0dc; stroke-width: 2;" cx="29" cy="8" r="7" /> <circle style="fill: #FFF; stroke: #7ab0dc; stroke-width: 2;" cx="29" cy="50" r="7" /> <circle style="fill: #FFF; stroke: #7ab0dc; stroke-width: 2;" cx="29" cy="29" r="7" /> </svg>
            </button>
        </div> -->
    </div>
</div>
<div class="content">
    
        <div class="sort-area">
            <div class="layout-fixed pdTB10 pdLR10">
                <!-- <div onclick="appDialogToggle('open', '#invoicePopupSearchType')">
                    <div class="layout-fixed w-auto-i">
                        <div class="fz17 clr-white pdT5 nowrap">
                            Repair Parts
                        </div>
                        <div class="w25px clear v-bottom-i text-right pdB2">
                            <svg class="h14px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 386.257 386.257" style="enable-background:new 0 0 386.257 386.257;" xml:space="preserve"> <polygon points="0,96.879 193.129,289.379 386.257,96.879 " fill="#424A60" /> </svg>
                        </div>
                    </div>
                </div> -->
                <div class="w30px text-right">
                    <button class="dismis button-field-1 white w34px h34px"  ng-click="refreshform()">
                        <svg class="h16px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 491.86 491.86" xml:space="preserve"> <g> <g> <path d="M465.167,211.614H280.245V26.691c0-8.424-11.439-26.69-34.316-26.69s-34.316,18.267-34.316,26.69v184.924H26.69    C18.267,211.614,0,223.053,0,245.929s18.267,34.316,26.69,34.316h184.924v184.924c0,8.422,11.438,26.69,34.316,26.69    s34.316-18.268,34.316-26.69V280.245H465.17c8.422,0,26.69-11.438,26.69-34.316S473.59,211.614,465.167,211.614z" style="fill:#3D90C8" /> </g> </g> </svg>
                    </button>
                </div>
                <div class="w5px text-right">
                    <button class="button-field-1 white w34px h34px relative mgR5" ng-click="openAutocomplete('ion-autocomplete-invoice')">
                        <svg class="h20px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 60 60" style="enable-background:new 0 0 60 60;" xml:space="preserve"> <g> <path d="M60,4.293c0-2.206-1.794-4-4-4H4c-2.206,0-4,1.794-4,4c0,1.859,1.28,3.411,3,3.858v3.142c0-0.553,0.448-1,1-1h2   c0.552,0,1,0.447,1,1s-0.448,1-1,1H4c-0.552,0-1-0.447-1-1v45.414l3-3l6,6l6-6l6,6l6-6l6,6l6-6l6,6l6-6l3,3V11.293   c0,0.553-0.448,1-1,1h-2c-0.552,0-1-0.447-1-1s0.448-1,1-1h2c0.552,0,1,0.447,1,1V8.151C58.72,7.704,60,6.152,60,4.293z M31,33.293   c0.552,0,1,0.447,1,1s-0.448,1-1,1h-2c-0.552,0-1-0.447-1-1s0.448-1,1-1H31z M29,27.293c0-0.271,0.11-0.521,0.29-0.71   c0.38-0.37,1.05-0.37,1.42,0c0.18,0.189,0.29,0.439,0.29,0.71c0,0.27-0.11,0.52-0.29,0.71c-0.19,0.18-0.45,0.29-0.71,0.29   c-0.26,0-0.52-0.11-0.71-0.29C29.11,27.813,29,27.563,29,27.293z M29,21.293c-0.552,0-1-0.447-1-1s0.448-1,1-1h15   c0.552,0,1,0.447,1,1s-0.448,1-1,1H29z M30.846,11.293c0-0.553,0.448-1,1-1h3.692c0.552,0,1,0.447,1,1s-0.448,1-1,1h-3.692   C31.294,12.293,30.846,11.846,30.846,11.293z M38.231,11.293c0-0.553,0.448-1,1-1h3.692c0.552,0,1,0.447,1,1s-0.448,1-1,1h-3.692   C38.679,12.293,38.231,11.846,38.231,11.293z M8.692,11.293c0-0.553,0.448-1,1-1h3.692c0.552,0,1,0.447,1,1s-0.448,1-1,1H9.692   C9.14,12.293,8.692,11.846,8.692,11.293z M20,27.293c-0.552,0-1-0.447-1-1c0-1.302-0.839-2.402-2-2.816v5.438l2.229,1.734   c0.777,0.604,1.281,1.511,1.383,2.488c0.1,0.957-0.182,1.882-0.793,2.605c-0.734,0.867-1.728,1.446-2.819,1.668v0.882   c0,0.553-0.448,1-1,1s-1-0.447-1-1v-0.878c-2.279-0.465-4-2.484-4-4.899c0-0.553,0.448-1,1-1s1,0.447,1,1   c0,1.302,0.839,2.402,2,2.816v-5.438l-2.229-1.734c-0.777-0.604-1.282-1.513-1.383-2.491c-0.1-0.956,0.183-1.881,0.794-2.603   c0.733-0.867,1.728-1.446,2.818-1.668v-1.104c0-0.553,0.448-1,1-1s1,0.447,1,1v1.101c2.279,0.465,4,2.484,4,4.899   C21,26.846,20.552,27.293,20,27.293z M20.77,12.293h-3.692c-0.552,0-1-0.447-1-1s0.448-1,1-1h3.692c0.552,0,1,0.447,1,1   S21.322,12.293,20.77,12.293z M23.461,11.293c0-0.553,0.448-1,1-1h3.692c0.552,0,1,0.447,1,1s-0.448,1-1,1h-3.692   C23.909,12.293,23.461,11.846,23.461,11.293z M44,42.293H29c-0.552,0-1-0.447-1-1s0.448-1,1-1h15c0.552,0,1,0.447,1,1   S44.552,42.293,44,42.293z M34,34.293c0-0.26,0.11-0.521,0.29-0.71c0.38-0.37,1.05-0.37,1.42,0c0.18,0.18,0.29,0.439,0.29,0.71   c0,0.27-0.11,0.52-0.29,0.71c-0.19,0.18-0.45,0.29-0.71,0.29c-0.26,0-0.52-0.11-0.71-0.29C34.11,34.813,34,34.553,34,34.293z    M49.71,42.003c-0.19,0.18-0.45,0.29-0.71,0.29c-0.26,0-0.52-0.11-0.71-0.29c-0.18-0.19-0.29-0.45-0.29-0.71   c0-0.271,0.11-0.521,0.29-0.71c0.38-0.37,1.04-0.37,1.42,0c0.18,0.189,0.29,0.439,0.29,0.71C50,41.553,49.89,41.813,49.71,42.003z    M49,35.293H39c-0.552,0-1-0.447-1-1s0.448-1,1-1h10c0.552,0,1,0.447,1,1S49.552,35.293,49,35.293z M49,28.293H34   c-0.552,0-1-0.447-1-1s0.448-1,1-1h15c0.552,0,1,0.447,1,1S49.552,28.293,49,28.293z M49.71,21.003c-0.19,0.18-0.44,0.29-0.71,0.29   c-0.26,0-0.52-0.11-0.71-0.29c-0.18-0.19-0.29-0.45-0.29-0.71c0-0.271,0.11-0.521,0.29-0.71c0.37-0.37,1.05-0.37,1.42,0   c0.18,0.189,0.29,0.45,0.29,0.71S49.89,20.813,49.71,21.003z M50.308,12.293h-3.692c-0.552,0-1-0.447-1-1s0.448-1,1-1h3.692   c0.552,0,1,0.447,1,1S50.86,12.293,50.308,12.293z M57,6.024V3.293H3v2.731C2.403,5.679,2,5.032,2,4.293c0-1.103,0.897-2,2-2h52   c1.103,0,2,0.897,2,2C58,5.032,57.597,5.679,57,6.024z" fill="#81B4DE" /> <path d="M13.377,25.461c0.046,0.439,0.272,0.848,0.622,1.12L15,27.36v-3.877c-0.494,0.176-0.944,0.464-1.292,0.875   C13.452,24.66,13.334,25.052,13.377,25.461z" fill="#81B4DE" /> <path d="M17,35.326c0.494-0.176,0.944-0.464,1.292-0.875c0.256-0.303,0.374-0.695,0.331-1.105   c-0.046-0.438-0.272-0.847-0.622-1.118L17,31.449V35.326z" fill="#81B4DE" /> </g> </svg>
                        <svg style="position: absolute; height: 14px; left: 16px; top: 7px;" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 491.86 491.86" xml:space="preserve"> <g> <g> <path d="M465.167,211.614H280.245V26.691c0-8.424-11.439-26.69-34.316-26.69s-34.316,18.267-34.316,26.69v184.924H26.69    C18.267,211.614,0,223.053,0,245.929s18.267,34.316,26.69,34.316h184.924v184.924c0,8.422,11.438,26.69,34.316,26.69    s34.316-18.268,34.316-26.69V280.245H465.17c8.422,0,26.69-11.438,26.69-34.316S473.59,211.614,465.167,211.614z" style="fill:#424A60" /> </g> </g> </svg>
                    </button>
                </div>
            </div>
        </div>
        <div class="sort-table clear">
            <div class="layout-fixed w-auto-i right pdT15 pdB10 pdLR10">
                <div class="">
                    <div class="layout-fixed w-auto-i">
                        <div class="ft-fourth fz12 bold clr-bluegray uppercase pdT2 pdR3">Sold</div>
                        <div class="clear">
                            <div class="checked-1 lightblue small">
                                <input type="checkbox"  ng-model="sold_all.value" ng-click="checkAll_event('sold_All')" ng-true-value="1" ng-false-value="0" name="ckMark" />
                                <i></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="pdL40">
                    <div class="layout-fixed w-auto-i">
                        <div class="ft-fourth fz12 bold clr-bluegray uppercase pdT2 pdR3">Installed</div>
                        <div class="clear">
                            <div class="checked-1 lightblue small">
                                <input type="checkbox" ng-model="installed_all.value"  ng-click="checkAll_event('installed_All')" ng-true-value="1" ng-false-value="0" name="ckMark" />
                                <i></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="pdL40">
                    <div class="layout-fixed w-auto-i">
                        <div class="ft-fourth fz12 bold clr-bluegray uppercase pdT2 pdR3">Declined</div>
                        <div class="clear">
                            <div class="checked-1 lightblue small">
                                <input type="checkbox"  ng-model="declined_all.value" ng-click="checkAll_event('declined_All')" ng-true-value="1" ng-false-value="0" name="ckMark" />
                                <i></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <ion-scroll  direction="y"  has-bouncing="true" overflow-scroll="false" class="prevent-scroll"
                     style="height: calc(100vh - 150px) !important;width: 100%" delegate-handle="scrollInvoiceDetail">
        <ul class="invoice-item-lst">
            <li class="itm" ng-repeat="item in invoiceData">
                <div class="layout-fixed">
                    <div class="v-top-i">
                        <div class="name">
                            <div class="layout-fixed pdLR10">
                                <div class="pdT10 pdB5">
                                    <div ng-if="!item.Measurements">{{item.name}}</div>
                                    <a ng-if="item.Measurements" dataDisable="{{item.disable}}" class="editMeasurements" productName="{{item.name}}" productId="{{item.id}}" Measurementsdata='{{item.Measurements}}'>{{item.name}}</a>
                                </div>
                                <div class="w50px clear" ng-click="editInvoice(item.id,$index,item.item_id)">
                                    <svg class="h16px right" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 60 60" style="enable-background:new 0 0 60 60;" xml:space="preserve"> <g> <path d="M8,22c-4.411,0-8,3.589-8,8s3.589,8,8,8s8-3.589,8-8S12.411,22,8,22z" fill="#3D90C8" /> <path d="M52,22c-4.411,0-8,3.589-8,8s3.589,8,8,8s8-3.589,8-8S56.411,22,52,22z" fill="#3D90C8" /> <path d="M30,22c-4.411,0-8,3.589-8,8s3.589,8,8,8s8-3.589,8-8S34.411,22,30,22z" fill="#3D90C8" /> </g> </svg>
                                </div>
                            </div>
                        </div>
                        <div class="layout-fixed pdTB10">
                            <div>
                                <div class="layout-fixed pdLR10">
                                    <div class="">
                                        <div class="baseline">
                                            <span class="fz14 clr-gray">Class: </span>
                                            <span class="fz16 bold clr-darkblue">{{item.Product_Class_name}}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="layout-fixed pdB10">
                            <div>
                                <div class="layout-fixed pdLR10">
                                    <div class="w120px">
                                        <div class="fz14 clr-gray">Created Date</div>
                                        <div class="ft-fourth fz16 bold clr-darktear mgT5">{{item.created_date}}</div>
                                    </div>
                                    <div class="v-top-i">
                                        <div class="fz14 clr-gray">Quantity</div>
                                        <div class="ft-fourth fz16 bold clr-darktear mgT5">{{item.quantity}}</div>
                                    </div>
                                    <div class="v-top-i">
                                        <div class="fz14 clr-gray pdL5">Warranty</div>
                                        <div class="ft-fourth fz16 bold clr-darktear mgT5">{{item.warranty_name}}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="layout-fixed pdB10">
                            <div>
                                <div class="layout-fixed pdLR10">
                                    <div class="v-top-i w120px">
                                        <div class="fz14 clr-gray">Item Price</div>
                                        <div class="ft-fourth fz16 bold clr-black mgT5">$ {{item.price}}</div>
                                    </div>
                                    <div class="v-top-i">
                                        <div class="fz14 clr-gray">Extended Price</div>
                                        <div class="ft-fourth fz16 bold clr-black mgT5">$ {{item.Extended_Price}}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="layout-fixed pdB10">
                            <div>
                                <div class="layout-fixed pdLR10">
                                    <div class="w120px">
                                        <div class="fz14 clr-gray">MD</div>
                                        <input class="h39px bold" name="" value="" placeholder="" type="text" ng-model="item.Extended"
                                            onkeyup="checkFloat(this)" ng-change="change_MD(item.Extended, item.product_id)">
                                        <!-- <div class="ft-fourth fz16 bold clr-darktear mgT5">{{item.Extended}} %</div> -->
                                    </div>
                                    <div class="v-top-i">
                                        <div class="fz14 clr-gray">Sold</div>
                                        <div class="mgT5">
                                            <div class="checked-1 lightblue small">
                                                <input type="checkbox" ng-hide="item.declined == 1 || item.disable == 1" ng-model="item.sold" ng-true-value="1" ng-false-value="0" ng-click="change_price(invoiceData)" name="ckMark" />
                                                <i></i>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="v-top-i">
                                        <div class="fz14 clr-gray">Installed</div>
                                        <div class="mgT5">
                                            <div class="checked-1 lightblue small">
                                                <input type="checkbox" ng-hide="item.sold == 0 || item.disable == 1" ng-model="item.installed" ng-true-value="1" ng-false-value="0" ng-click="change_price(invoiceData)" name="ckMark" />
                                                <i></i>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="v-top-i">
                                        <div class="fz14 clr-gray">Declined</div>
                                        <div class="mgT5">
                                            <div class="checked-1 lightblue small">
                                                <input type="checkbox" ng-hide="item.sold == 1 || item.disable == 1" ng-model="item.declined" ng-true-value="1" ng-false-value="0" ng-click="change_price(invoiceData)" name="ckMark" />
                                                <i></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </li>
        </ul>
        <div class="total-area pdLR8">
            <div class="bg-lightblue-2 rounded-10 pdT20 pdB10 mgB10">
                <div class="layout-fixed pdLR10 mgB5">
                    <div class="w12px pdB5">
                        <svg class="h8px" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 430.122 430.123" style="enable-background:new 0 0 430.122 430.123;" xml:space="preserve"> <g> <path id="Ning" d="M369.924,290.526c0-16.475,13.479-29.837,30.103-29.837c16.634,0,30.094,13.362,30.094,29.837   s-13.46,29.837-30.094,29.837C383.412,320.363,369.924,307,369.924,290.526z M400.026,166.927c16.634,0,30.094-13.361,30.094-29.83   c0-16.472-13.46-29.836-30.094-29.836c-16.624,0-30.103,13.364-30.103,29.836C369.924,153.566,383.412,166.927,400.026,166.927z    M285.926,173.146c0,16.477,13.46,29.832,30.098,29.832c16.62,0,30.099-13.354,30.099-29.832c0-16.473-13.479-29.837-30.099-29.837   C299.386,143.305,285.926,156.669,285.926,173.146z M136.689,370.455c-16.622,0-30.098,13.356-30.098,29.832   c0,16.475,13.477,29.836,30.098,29.836s30.098-13.361,30.098-29.836C166.787,383.811,153.306,370.455,136.689,370.455z    M255.813,143.305c16.629,0,30.112-13.362,30.112-29.834c0-16.475-13.479-29.832-30.112-29.832   c-16.619,0-30.093,13.357-30.093,29.832C225.721,129.943,239.199,143.305,255.813,143.305z M316.023,225.355   c-16.629,0-30.098,13.361-30.098,29.832c0,16.475,13.46,29.832,30.098,29.832c16.62,0,30.099-13.357,30.099-29.832   C346.122,238.716,332.644,225.355,316.023,225.355z M174.315,285.028c-16.622,0-30.098,13.357-30.098,29.832   s13.477,29.832,30.098,29.832s30.098-13.357,30.098-29.832S190.932,285.028,174.315,285.028z M293.08,370.455   c-16.619,0-30.098,13.356-30.098,29.832c0,16.475,13.479,29.836,30.098,29.836c16.62,0,30.099-13.361,30.099-29.836   C323.179,383.811,309.7,370.455,293.08,370.455z M293.08,59.671c16.62,0,30.099-13.362,30.099-29.834   C323.179,13.362,309.7,0,293.08,0c-16.619,0-30.098,13.362-30.098,29.837C262.982,46.309,276.461,59.671,293.08,59.671z    M114.117,285.028c16.622,0,30.1-13.362,30.1-29.832c0-16.475-13.479-29.841-30.1-29.841s-30.089,13.366-30.089,29.841   C84.028,271.666,97.495,285.028,114.117,285.028z M30.1,166.927c16.622,0,30.101-13.361,30.101-29.83   c0-16.472-13.479-29.836-30.101-29.836c-16.622,0-30.098,13.364-30.098,29.836C0.002,153.566,13.478,166.927,30.1,166.927z    M30.1,320.363c16.622,0,30.101-13.362,30.101-29.837S46.722,260.689,30.1,260.689c-16.622,0-30.098,13.362-30.098,29.837   S13.478,320.363,30.1,320.363z M114.117,202.978c16.622,0,30.1-13.354,30.1-29.832c0-16.473-13.479-29.837-30.1-29.837   s-30.089,13.364-30.089,29.837C84.028,189.624,97.495,202.978,114.117,202.978z M255.813,344.692   c16.629,0,30.112-13.357,30.112-29.832s-13.479-29.832-30.112-29.832c-16.619,0-30.093,13.357-30.093,29.832   S239.199,344.692,255.813,344.692z M144.217,113.471c0,16.473,13.477,29.834,30.098,29.834s30.098-13.362,30.098-29.834   c0-16.475-13.477-29.832-30.098-29.832S144.217,96.996,144.217,113.471z M136.689,59.671c16.622,0,30.098-13.362,30.098-29.834   c-0.005-16.475-13.481-29.832-30.098-29.832s-30.098,13.362-30.098,29.836C106.591,46.309,120.067,59.671,136.689,59.671z" style="fill: #4f7697" /> </g> </svg>
                    </div>
                    <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase">Subtotal</div>
                    <div class="text-right pdR5">
                        <div class="ft-fourth fz17 bold clr-darkblue">$ {{Subtotal}}</div>
                    </div>
                </div>
                <div class="separator-b-2 blue circle-right mgTB15 mgL22 mgR10" ></div>
                <div class="layout-fixed pdLR10 mgB5" ng-if="Discount > 0">
                    <div class="w12px pdB5">
                        <svg class="h8px" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 430.122 430.123" style="enable-background:new 0 0 430.122 430.123;" xml:space="preserve"> <g> <path id="Ning" d="M369.924,290.526c0-16.475,13.479-29.837,30.103-29.837c16.634,0,30.094,13.362,30.094,29.837   s-13.46,29.837-30.094,29.837C383.412,320.363,369.924,307,369.924,290.526z M400.026,166.927c16.634,0,30.094-13.361,30.094-29.83   c0-16.472-13.46-29.836-30.094-29.836c-16.624,0-30.103,13.364-30.103,29.836C369.924,153.566,383.412,166.927,400.026,166.927z    M285.926,173.146c0,16.477,13.46,29.832,30.098,29.832c16.62,0,30.099-13.354,30.099-29.832c0-16.473-13.479-29.837-30.099-29.837   C299.386,143.305,285.926,156.669,285.926,173.146z M136.689,370.455c-16.622,0-30.098,13.356-30.098,29.832   c0,16.475,13.477,29.836,30.098,29.836s30.098-13.361,30.098-29.836C166.787,383.811,153.306,370.455,136.689,370.455z    M255.813,143.305c16.629,0,30.112-13.362,30.112-29.834c0-16.475-13.479-29.832-30.112-29.832   c-16.619,0-30.093,13.357-30.093,29.832C225.721,129.943,239.199,143.305,255.813,143.305z M316.023,225.355   c-16.629,0-30.098,13.361-30.098,29.832c0,16.475,13.46,29.832,30.098,29.832c16.62,0,30.099-13.357,30.099-29.832   C346.122,238.716,332.644,225.355,316.023,225.355z M174.315,285.028c-16.622,0-30.098,13.357-30.098,29.832   s13.477,29.832,30.098,29.832s30.098-13.357,30.098-29.832S190.932,285.028,174.315,285.028z M293.08,370.455   c-16.619,0-30.098,13.356-30.098,29.832c0,16.475,13.479,29.836,30.098,29.836c16.62,0,30.099-13.361,30.099-29.836   C323.179,383.811,309.7,370.455,293.08,370.455z M293.08,59.671c16.62,0,30.099-13.362,30.099-29.834   C323.179,13.362,309.7,0,293.08,0c-16.619,0-30.098,13.362-30.098,29.837C262.982,46.309,276.461,59.671,293.08,59.671z    M114.117,285.028c16.622,0,30.1-13.362,30.1-29.832c0-16.475-13.479-29.841-30.1-29.841s-30.089,13.366-30.089,29.841   C84.028,271.666,97.495,285.028,114.117,285.028z M30.1,166.927c16.622,0,30.101-13.361,30.101-29.83   c0-16.472-13.479-29.836-30.101-29.836c-16.622,0-30.098,13.364-30.098,29.836C0.002,153.566,13.478,166.927,30.1,166.927z    M30.1,320.363c16.622,0,30.101-13.362,30.101-29.837S46.722,260.689,30.1,260.689c-16.622,0-30.098,13.362-30.098,29.837   S13.478,320.363,30.1,320.363z M114.117,202.978c16.622,0,30.1-13.354,30.1-29.832c0-16.473-13.479-29.837-30.1-29.837   s-30.089,13.364-30.089,29.837C84.028,189.624,97.495,202.978,114.117,202.978z M255.813,344.692   c16.629,0,30.112-13.357,30.112-29.832s-13.479-29.832-30.112-29.832c-16.619,0-30.093,13.357-30.093,29.832   S239.199,344.692,255.813,344.692z M144.217,113.471c0,16.473,13.477,29.834,30.098,29.834s30.098-13.362,30.098-29.834   c0-16.475-13.477-29.832-30.098-29.832S144.217,96.996,144.217,113.471z M136.689,59.671c16.622,0,30.098-13.362,30.098-29.834   c-0.005-16.475-13.481-29.832-30.098-29.832s-30.098,13.362-30.098,29.836C106.591,46.309,120.067,59.671,136.689,59.671z" style="fill: #4f7697" /> </g> </svg>
                    </div>
                    <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase">Discount</div>
                    <div class="text-right pdR5">
                        <div class="ft-fourth fz17 bold clr-darkblue">$ {{Discount}}</div>
                    </div>
                </div>
                <div class="separator-b-2 blue circle-right mgTB15 mgL22 mgR10" ng-if="Discount > 0"></div>
                <div class="layout-fixed pdLR10 mgB10">
                    <div class="w12px pdB5">
                        <svg class="h8px" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 430.122 430.123" style="enable-background:new 0 0 430.122 430.123;" xml:space="preserve"> <g> <path id="Ning" d="M369.924,290.526c0-16.475,13.479-29.837,30.103-29.837c16.634,0,30.094,13.362,30.094,29.837   s-13.46,29.837-30.094,29.837C383.412,320.363,369.924,307,369.924,290.526z M400.026,166.927c16.634,0,30.094-13.361,30.094-29.83   c0-16.472-13.46-29.836-30.094-29.836c-16.624,0-30.103,13.364-30.103,29.836C369.924,153.566,383.412,166.927,400.026,166.927z    M285.926,173.146c0,16.477,13.46,29.832,30.098,29.832c16.62,0,30.099-13.354,30.099-29.832c0-16.473-13.479-29.837-30.099-29.837   C299.386,143.305,285.926,156.669,285.926,173.146z M136.689,370.455c-16.622,0-30.098,13.356-30.098,29.832   c0,16.475,13.477,29.836,30.098,29.836s30.098-13.361,30.098-29.836C166.787,383.811,153.306,370.455,136.689,370.455z    M255.813,143.305c16.629,0,30.112-13.362,30.112-29.834c0-16.475-13.479-29.832-30.112-29.832   c-16.619,0-30.093,13.357-30.093,29.832C225.721,129.943,239.199,143.305,255.813,143.305z M316.023,225.355   c-16.629,0-30.098,13.361-30.098,29.832c0,16.475,13.46,29.832,30.098,29.832c16.62,0,30.099-13.357,30.099-29.832   C346.122,238.716,332.644,225.355,316.023,225.355z M174.315,285.028c-16.622,0-30.098,13.357-30.098,29.832   s13.477,29.832,30.098,29.832s30.098-13.357,30.098-29.832S190.932,285.028,174.315,285.028z M293.08,370.455   c-16.619,0-30.098,13.356-30.098,29.832c0,16.475,13.479,29.836,30.098,29.836c16.62,0,30.099-13.361,30.099-29.836   C323.179,383.811,309.7,370.455,293.08,370.455z M293.08,59.671c16.62,0,30.099-13.362,30.099-29.834   C323.179,13.362,309.7,0,293.08,0c-16.619,0-30.098,13.362-30.098,29.837C262.982,46.309,276.461,59.671,293.08,59.671z    M114.117,285.028c16.622,0,30.1-13.362,30.1-29.832c0-16.475-13.479-29.841-30.1-29.841s-30.089,13.366-30.089,29.841   C84.028,271.666,97.495,285.028,114.117,285.028z M30.1,166.927c16.622,0,30.101-13.361,30.101-29.83   c0-16.472-13.479-29.836-30.101-29.836c-16.622,0-30.098,13.364-30.098,29.836C0.002,153.566,13.478,166.927,30.1,166.927z    M30.1,320.363c16.622,0,30.101-13.362,30.101-29.837S46.722,260.689,30.1,260.689c-16.622,0-30.098,13.362-30.098,29.837   S13.478,320.363,30.1,320.363z M114.117,202.978c16.622,0,30.1-13.354,30.1-29.832c0-16.473-13.479-29.837-30.1-29.837   s-30.089,13.364-30.089,29.837C84.028,189.624,97.495,202.978,114.117,202.978z M255.813,344.692   c16.629,0,30.112-13.357,30.112-29.832s-13.479-29.832-30.112-29.832c-16.619,0-30.093,13.357-30.093,29.832   S239.199,344.692,255.813,344.692z M144.217,113.471c0,16.473,13.477,29.834,30.098,29.834s30.098-13.362,30.098-29.834   c0-16.475-13.477-29.832-30.098-29.832S144.217,96.996,144.217,113.471z M136.689,59.671c16.622,0,30.098-13.362,30.098-29.834   c-0.005-16.475-13.481-29.832-30.098-29.832s-30.098,13.362-30.098,29.836C106.591,46.309,120.067,59.671,136.689,59.671z" style="fill: #4f7697" /> </g> </svg>
                    </div>
                    <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase">Refund</div>
                    <div>
                        <div class="input-field-2 rounded-30-i">
                            <input style="border-radius: 30px" class="text-right" type="text" ng-model="refund.value" ng-change="change_price(invoiceData)" />
                        </div>
                    </div>
                </div>
                <div class="separator-b-2 blue circle-right mgTB15 mgL22 mgR10"></div>
                <div class="layout-fixed pdLR10 mgB5">
                    <div class="w12px pdB5">
                        <svg class="h8px" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 430.122 430.123" style="enable-background:new 0 0 430.122 430.123;" xml:space="preserve"> <g> <path id="Ning" d="M369.924,290.526c0-16.475,13.479-29.837,30.103-29.837c16.634,0,30.094,13.362,30.094,29.837   s-13.46,29.837-30.094,29.837C383.412,320.363,369.924,307,369.924,290.526z M400.026,166.927c16.634,0,30.094-13.361,30.094-29.83   c0-16.472-13.46-29.836-30.094-29.836c-16.624,0-30.103,13.364-30.103,29.836C369.924,153.566,383.412,166.927,400.026,166.927z    M285.926,173.146c0,16.477,13.46,29.832,30.098,29.832c16.62,0,30.099-13.354,30.099-29.832c0-16.473-13.479-29.837-30.099-29.837   C299.386,143.305,285.926,156.669,285.926,173.146z M136.689,370.455c-16.622,0-30.098,13.356-30.098,29.832   c0,16.475,13.477,29.836,30.098,29.836s30.098-13.361,30.098-29.836C166.787,383.811,153.306,370.455,136.689,370.455z    M255.813,143.305c16.629,0,30.112-13.362,30.112-29.834c0-16.475-13.479-29.832-30.112-29.832   c-16.619,0-30.093,13.357-30.093,29.832C225.721,129.943,239.199,143.305,255.813,143.305z M316.023,225.355   c-16.629,0-30.098,13.361-30.098,29.832c0,16.475,13.46,29.832,30.098,29.832c16.62,0,30.099-13.357,30.099-29.832   C346.122,238.716,332.644,225.355,316.023,225.355z M174.315,285.028c-16.622,0-30.098,13.357-30.098,29.832   s13.477,29.832,30.098,29.832s30.098-13.357,30.098-29.832S190.932,285.028,174.315,285.028z M293.08,370.455   c-16.619,0-30.098,13.356-30.098,29.832c0,16.475,13.479,29.836,30.098,29.836c16.62,0,30.099-13.361,30.099-29.836   C323.179,383.811,309.7,370.455,293.08,370.455z M293.08,59.671c16.62,0,30.099-13.362,30.099-29.834   C323.179,13.362,309.7,0,293.08,0c-16.619,0-30.098,13.362-30.098,29.837C262.982,46.309,276.461,59.671,293.08,59.671z    M114.117,285.028c16.622,0,30.1-13.362,30.1-29.832c0-16.475-13.479-29.841-30.1-29.841s-30.089,13.366-30.089,29.841   C84.028,271.666,97.495,285.028,114.117,285.028z M30.1,166.927c16.622,0,30.101-13.361,30.101-29.83   c0-16.472-13.479-29.836-30.101-29.836c-16.622,0-30.098,13.364-30.098,29.836C0.002,153.566,13.478,166.927,30.1,166.927z    M30.1,320.363c16.622,0,30.101-13.362,30.101-29.837S46.722,260.689,30.1,260.689c-16.622,0-30.098,13.362-30.098,29.837   S13.478,320.363,30.1,320.363z M114.117,202.978c16.622,0,30.1-13.354,30.1-29.832c0-16.473-13.479-29.837-30.1-29.837   s-30.089,13.364-30.089,29.837C84.028,189.624,97.495,202.978,114.117,202.978z M255.813,344.692   c16.629,0,30.112-13.357,30.112-29.832s-13.479-29.832-30.112-29.832c-16.619,0-30.093,13.357-30.093,29.832   S239.199,344.692,255.813,344.692z M144.217,113.471c0,16.473,13.477,29.834,30.098,29.834s30.098-13.362,30.098-29.834   c0-16.475-13.477-29.832-30.098-29.832S144.217,96.996,144.217,113.471z M136.689,59.671c16.622,0,30.098-13.362,30.098-29.834   c-0.005-16.475-13.481-29.832-30.098-29.832s-30.098,13.362-30.098,29.836C106.591,46.309,120.067,59.671,136.689,59.671z" style="fill: #4f7697" /> </g> </svg>
                    </div>
                    <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase">Coupon</div>
                    <div>
                        <div class="input-field-2 rounded-30-i">
                            <input class="ft-fourth h39px bold rounded-30-i" name="" value="{{Input_value.couponData}}" placeholder="Select Coupon" type="text">
                                <div class="sign-r clear">
                                    <button class="bg-transparent h30px right pdR10">
                                        <svg class="h18px mgB10" xml:space="preserve" style="enable-background:new 0 0 63.215 63.215;" viewBox="0 0 63.215 63.215" y="0px" x="0px" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg"> <g> <g> <path fill="#034274" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                    </button>
                                </div>

                                <select name="" ng-model="couponData" class="field-overlay" ng-change="change_coupon(couponData)" ng-options="item.id as item.name for item in coupon">
                                    <option value="" >Select Coupon</option>
                                </select>
                        </div>
                    </div>
                </div>
                <div class="separator-b-2 blue circle-right mgTB15 mgL22 mgR10"></div>
                <div class="layout-fixed pdLR10 mgB5">
                    <div class="w12px pdB5">
                        <svg class="h8px" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 430.122 430.123" style="enable-background:new 0 0 430.122 430.123;" xml:space="preserve"> <g> <path id="Ning" d="M369.924,290.526c0-16.475,13.479-29.837,30.103-29.837c16.634,0,30.094,13.362,30.094,29.837   s-13.46,29.837-30.094,29.837C383.412,320.363,369.924,307,369.924,290.526z M400.026,166.927c16.634,0,30.094-13.361,30.094-29.83   c0-16.472-13.46-29.836-30.094-29.836c-16.624,0-30.103,13.364-30.103,29.836C369.924,153.566,383.412,166.927,400.026,166.927z    M285.926,173.146c0,16.477,13.46,29.832,30.098,29.832c16.62,0,30.099-13.354,30.099-29.832c0-16.473-13.479-29.837-30.099-29.837   C299.386,143.305,285.926,156.669,285.926,173.146z M136.689,370.455c-16.622,0-30.098,13.356-30.098,29.832   c0,16.475,13.477,29.836,30.098,29.836s30.098-13.361,30.098-29.836C166.787,383.811,153.306,370.455,136.689,370.455z    M255.813,143.305c16.629,0,30.112-13.362,30.112-29.834c0-16.475-13.479-29.832-30.112-29.832   c-16.619,0-30.093,13.357-30.093,29.832C225.721,129.943,239.199,143.305,255.813,143.305z M316.023,225.355   c-16.629,0-30.098,13.361-30.098,29.832c0,16.475,13.46,29.832,30.098,29.832c16.62,0,30.099-13.357,30.099-29.832   C346.122,238.716,332.644,225.355,316.023,225.355z M174.315,285.028c-16.622,0-30.098,13.357-30.098,29.832   s13.477,29.832,30.098,29.832s30.098-13.357,30.098-29.832S190.932,285.028,174.315,285.028z M293.08,370.455   c-16.619,0-30.098,13.356-30.098,29.832c0,16.475,13.479,29.836,30.098,29.836c16.62,0,30.099-13.361,30.099-29.836   C323.179,383.811,309.7,370.455,293.08,370.455z M293.08,59.671c16.62,0,30.099-13.362,30.099-29.834   C323.179,13.362,309.7,0,293.08,0c-16.619,0-30.098,13.362-30.098,29.837C262.982,46.309,276.461,59.671,293.08,59.671z    M114.117,285.028c16.622,0,30.1-13.362,30.1-29.832c0-16.475-13.479-29.841-30.1-29.841s-30.089,13.366-30.089,29.841   C84.028,271.666,97.495,285.028,114.117,285.028z M30.1,166.927c16.622,0,30.101-13.361,30.101-29.83   c0-16.472-13.479-29.836-30.101-29.836c-16.622,0-30.098,13.364-30.098,29.836C0.002,153.566,13.478,166.927,30.1,166.927z    M30.1,320.363c16.622,0,30.101-13.362,30.101-29.837S46.722,260.689,30.1,260.689c-16.622,0-30.098,13.362-30.098,29.837   S13.478,320.363,30.1,320.363z M114.117,202.978c16.622,0,30.1-13.354,30.1-29.832c0-16.473-13.479-29.837-30.1-29.837   s-30.089,13.364-30.089,29.837C84.028,189.624,97.495,202.978,114.117,202.978z M255.813,344.692   c16.629,0,30.112-13.357,30.112-29.832s-13.479-29.832-30.112-29.832c-16.619,0-30.093,13.357-30.093,29.832   S239.199,344.692,255.813,344.692z M144.217,113.471c0,16.473,13.477,29.834,30.098,29.834s30.098-13.362,30.098-29.834   c0-16.475-13.477-29.832-30.098-29.832S144.217,96.996,144.217,113.471z M136.689,59.671c16.622,0,30.098-13.362,30.098-29.834   c-0.005-16.475-13.481-29.832-30.098-29.832s-30.098,13.362-30.098,29.836C106.591,46.309,120.067,59.671,136.689,59.671z" style="fill: #4f7697" /> </g> </svg>
                    </div>
                    <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase">Total</div>
                    <div class="text-right pdR5">
                        <div class="ft-fourth fz17 bold clr-darkblue">$ {{total}}</div>
                    </div>
                </div>
                <!-- -->

            </div>
            <div class="bg-lightblue-2 rounded-10 pdT15 pdB10 mgB10">
                <div class="layout-fixed pdLR10 pdB10">
                    <div class="w12px pdB5">
                        <svg class="h8px" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 430.122 430.123" style="enable-background:new 0 0 430.122 430.123;" xml:space="preserve"> <g> <path id="Ning" d="M369.924,290.526c0-16.475,13.479-29.837,30.103-29.837c16.634,0,30.094,13.362,30.094,29.837   s-13.46,29.837-30.094,29.837C383.412,320.363,369.924,307,369.924,290.526z M400.026,166.927c16.634,0,30.094-13.361,30.094-29.83   c0-16.472-13.46-29.836-30.094-29.836c-16.624,0-30.103,13.364-30.103,29.836C369.924,153.566,383.412,166.927,400.026,166.927z    M285.926,173.146c0,16.477,13.46,29.832,30.098,29.832c16.62,0,30.099-13.354,30.099-29.832c0-16.473-13.479-29.837-30.099-29.837   C299.386,143.305,285.926,156.669,285.926,173.146z M136.689,370.455c-16.622,0-30.098,13.356-30.098,29.832   c0,16.475,13.477,29.836,30.098,29.836s30.098-13.361,30.098-29.836C166.787,383.811,153.306,370.455,136.689,370.455z    M255.813,143.305c16.629,0,30.112-13.362,30.112-29.834c0-16.475-13.479-29.832-30.112-29.832   c-16.619,0-30.093,13.357-30.093,29.832C225.721,129.943,239.199,143.305,255.813,143.305z M316.023,225.355   c-16.629,0-30.098,13.361-30.098,29.832c0,16.475,13.46,29.832,30.098,29.832c16.62,0,30.099-13.357,30.099-29.832   C346.122,238.716,332.644,225.355,316.023,225.355z M174.315,285.028c-16.622,0-30.098,13.357-30.098,29.832   s13.477,29.832,30.098,29.832s30.098-13.357,30.098-29.832S190.932,285.028,174.315,285.028z M293.08,370.455   c-16.619,0-30.098,13.356-30.098,29.832c0,16.475,13.479,29.836,30.098,29.836c16.62,0,30.099-13.361,30.099-29.836   C323.179,383.811,309.7,370.455,293.08,370.455z M293.08,59.671c16.62,0,30.099-13.362,30.099-29.834   C323.179,13.362,309.7,0,293.08,0c-16.619,0-30.098,13.362-30.098,29.837C262.982,46.309,276.461,59.671,293.08,59.671z    M114.117,285.028c16.622,0,30.1-13.362,30.1-29.832c0-16.475-13.479-29.841-30.1-29.841s-30.089,13.366-30.089,29.841   C84.028,271.666,97.495,285.028,114.117,285.028z M30.1,166.927c16.622,0,30.101-13.361,30.101-29.83   c0-16.472-13.479-29.836-30.101-29.836c-16.622,0-30.098,13.364-30.098,29.836C0.002,153.566,13.478,166.927,30.1,166.927z    M30.1,320.363c16.622,0,30.101-13.362,30.101-29.837S46.722,260.689,30.1,260.689c-16.622,0-30.098,13.362-30.098,29.837   S13.478,320.363,30.1,320.363z M114.117,202.978c16.622,0,30.1-13.354,30.1-29.832c0-16.473-13.479-29.837-30.1-29.837   s-30.089,13.364-30.089,29.837C84.028,189.624,97.495,202.978,114.117,202.978z M255.813,344.692   c16.629,0,30.112-13.357,30.112-29.832s-13.479-29.832-30.112-29.832c-16.619,0-30.093,13.357-30.093,29.832   S239.199,344.692,255.813,344.692z M144.217,113.471c0,16.473,13.477,29.834,30.098,29.834s30.098-13.362,30.098-29.834   c0-16.475-13.477-29.832-30.098-29.832S144.217,96.996,144.217,113.471z M136.689,59.671c16.622,0,30.098-13.362,30.098-29.834   c-0.005-16.475-13.481-29.832-30.098-29.832s-30.098,13.362-30.098,29.836C106.591,46.309,120.067,59.671,136.689,59.671z" style="fill: #4f7697" /> </g> </svg>
                    </div>
                    <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase">Payment Info</div>
                    <div class="">
                        <div class="input-field-2 rounded-30-i">
                            <input class="ft-fourth h39px bold rounded-30-i" name="" value="{{Input_value.signature}}" placeholder="" type="text">
                                <div class="sign-r clear">
                                    <button class="bg-transparent h30px right pdR10">
                                        <svg class="h18px mgB10" xml:space="preserve" style="enable-background:new 0 0 63.215 63.215;" viewBox="0 0 63.215 63.215" y="0px" x="0px" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg"> <g> <g> <path fill="#034274" d="M59.807,15.717L31.491,43.791L3.419,15.475c-0.777-0.785-2.044-0.789-2.828-0.012c-0.784,0.777-0.789,2.044-0.012,2.827    l29.194,29.448c0.365,0.368,0.835,0.563,1.312,0.589c0.139,0.008,0.278-0.001,0.415-0.021c0.054,0.008,0.106,0.021,0.16,0.022    c0.544,0.029,1.099-0.162,1.515-0.576l29.447-29.196c0.785-0.777,0.79-2.043,0.012-2.828    C61.856,14.943,60.59,14.939,59.807,15.717z" /> </g> </g> </svg>
                                    </button>
                                </div>  
                                <select name="" ng-model="signature_id" class="field-overlay" ng-change="getsignature(signature_id)" ng-options="item.id as item.created_date for item in listpayment_histories">
                                    <option value="" ng-if="listpayment_histories.length == 0">-------------</option>
                                </select>
                        </div>
                    </div>
                </div>
                <div class="separator-b-2 blue circle-right mgTB15 mgL22 mgR10"></div> 
                <div ng-repeat="payment in listpayment_child" >
                    <div class="layout-fixed pdLR10 mgB5">
                        <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase" ng-if="payment.method != 'Payment Plan' && payment.method != 'CC Manual'">{{payment.method}}</div>
                        <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase" ng-if="payment.cardtype.length > 0">{{payment.cardtype}}</div>
                        <div class="text-right pdR5 right">
                            <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase" ng-if="payment.cardnumber.length > 0">{{payment.cardnumber}}</div>
                            <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase" ng-if="payment.method == 'Check'">Aut#:{{payment.authorization}} - Check#:{{payment.check}}</div>
                        </div>
                    </div>
                    <div class="layout-fixed pdLR10 mgB5">
                        <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase" ng-if="payment.method == 'Payment Plan'">{{payment.charge_date}}</div>
                        <div class="text-right pdR5 right" style="margin-top:{{(payment.method=='Cash') ? '-20px':''}}">
                            <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase" > $ {{payment.amount}}</div>
                        </div>
                    </div>
                    <div class="separator-b-2 blue circle-right mgTB15 mgL22 mgR10 right" style="width: 150px"></div>
                    <div style="clear:both"></div>
                </div>

            </div>
            <div class="bg-lightblue-2 rounded-10 pdT15 pdB10 mgB10">
                <div class="layout-fixed pdLR10 mgB5">
                    <div class="w12px pdB5">
                        <svg class="h8px" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 430.122 430.123" style="enable-background:new 0 0 430.122 430.123;" xml:space="preserve"> <g> <path id="Ning" d="M369.924,290.526c0-16.475,13.479-29.837,30.103-29.837c16.634,0,30.094,13.362,30.094,29.837   s-13.46,29.837-30.094,29.837C383.412,320.363,369.924,307,369.924,290.526z M400.026,166.927c16.634,0,30.094-13.361,30.094-29.83   c0-16.472-13.46-29.836-30.094-29.836c-16.624,0-30.103,13.364-30.103,29.836C369.924,153.566,383.412,166.927,400.026,166.927z    M285.926,173.146c0,16.477,13.46,29.832,30.098,29.832c16.62,0,30.099-13.354,30.099-29.832c0-16.473-13.479-29.837-30.099-29.837   C299.386,143.305,285.926,156.669,285.926,173.146z M136.689,370.455c-16.622,0-30.098,13.356-30.098,29.832   c0,16.475,13.477,29.836,30.098,29.836s30.098-13.361,30.098-29.836C166.787,383.811,153.306,370.455,136.689,370.455z    M255.813,143.305c16.629,0,30.112-13.362,30.112-29.834c0-16.475-13.479-29.832-30.112-29.832   c-16.619,0-30.093,13.357-30.093,29.832C225.721,129.943,239.199,143.305,255.813,143.305z M316.023,225.355   c-16.629,0-30.098,13.361-30.098,29.832c0,16.475,13.46,29.832,30.098,29.832c16.62,0,30.099-13.357,30.099-29.832   C346.122,238.716,332.644,225.355,316.023,225.355z M174.315,285.028c-16.622,0-30.098,13.357-30.098,29.832   s13.477,29.832,30.098,29.832s30.098-13.357,30.098-29.832S190.932,285.028,174.315,285.028z M293.08,370.455   c-16.619,0-30.098,13.356-30.098,29.832c0,16.475,13.479,29.836,30.098,29.836c16.62,0,30.099-13.361,30.099-29.836   C323.179,383.811,309.7,370.455,293.08,370.455z M293.08,59.671c16.62,0,30.099-13.362,30.099-29.834   C323.179,13.362,309.7,0,293.08,0c-16.619,0-30.098,13.362-30.098,29.837C262.982,46.309,276.461,59.671,293.08,59.671z    M114.117,285.028c16.622,0,30.1-13.362,30.1-29.832c0-16.475-13.479-29.841-30.1-29.841s-30.089,13.366-30.089,29.841   C84.028,271.666,97.495,285.028,114.117,285.028z M30.1,166.927c16.622,0,30.101-13.361,30.101-29.83   c0-16.472-13.479-29.836-30.101-29.836c-16.622,0-30.098,13.364-30.098,29.836C0.002,153.566,13.478,166.927,30.1,166.927z    M30.1,320.363c16.622,0,30.101-13.362,30.101-29.837S46.722,260.689,30.1,260.689c-16.622,0-30.098,13.362-30.098,29.837   S13.478,320.363,30.1,320.363z M114.117,202.978c16.622,0,30.1-13.354,30.1-29.832c0-16.473-13.479-29.837-30.1-29.837   s-30.089,13.364-30.089,29.837C84.028,189.624,97.495,202.978,114.117,202.978z M255.813,344.692   c16.629,0,30.112-13.357,30.112-29.832s-13.479-29.832-30.112-29.832c-16.619,0-30.093,13.357-30.093,29.832   S239.199,344.692,255.813,344.692z M144.217,113.471c0,16.473,13.477,29.834,30.098,29.834s30.098-13.362,30.098-29.834   c0-16.475-13.477-29.832-30.098-29.832S144.217,96.996,144.217,113.471z M136.689,59.671c16.622,0,30.098-13.362,30.098-29.834   c-0.005-16.475-13.481-29.832-30.098-29.832s-30.098,13.362-30.098,29.836C106.591,46.309,120.067,59.671,136.689,59.671z" style="fill: #4f7697" /> </g> </svg>
                    </div>
                    <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase">Due Date</div>
                    <div class="text-right pdR5">
                        <div class="ft-fourth fz17 bold clr-darkblue">
                            <div class="button-field-1 white w34px h34px relative mgR5 datetime" date="" ion-datetime-picker=""  ng-model="duedate.value">
                                <svg class="h20px" xml:space="preserve" style="margin:6px;enable-background:new 0 0 59 59;" viewBox="0 0 59 59" y="0px" x="0px" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg" version="1.1"> <rect height="47" width="58" style="fill:#81B4DE;" y="12" x="0.5" /> <g> <path d="M33.013,1.508l-1.066,1.693c5.821,3.664,16.971,9.621,17.083,9.681l0.941-1.764   C49.859,11.059,38.772,5.135,33.013,1.508z" style="fill:#81B4DE;" /> <path d="M9.029,11.118l0.941,1.764c0.112-0.06,11.262-6.017,17.083-9.681l-1.066-1.693   C20.228,5.134,9.141,11.059,9.029,11.118z" style="fill:#81B4DE;" /> </g> <g> <circle r="1" cy="28" cx="22.5" style="fill:#D4E7F7;" /> <circle r="1" cy="28" cx="29.5" style="fill:#D4E7F7;" /> <circle r="1" cy="28" cx="36.5" style="fill:#FFF;" /> <circle r="1" cy="28" cx="43.5" style="fill:#FFF;" /> <circle r="1" cy="28" cx="50.5" style="fill:#FFF;" /> <circle r="1" cy="36" cx="8.5" style="fill:#81B4DE;" /> <circle r="1" cy="36" cx="15.5" style="fill:#1075BB;" /> <circle r="1" cy="28" cx="8.5" style="fill:#D4E7F7;" /> <circle r="1" cy="28" cx="15.5" style="fill:#D4E7F7;" /> <circle r="1" cy="36" cx="22.5" style="fill:#FFF;" /> <circle r="1" cy="36" cx="29.5" style="fill:#FFF;" /> <circle r="1" cy="36" cx="36.5" style="fill:#FFF;" /> <circle r="1" cy="36" cx="43.5" style="fill:#FFF;" /> <circle r="1" cy="36" cx="50.5" style="fill:#FFF;" /> <circle r="1" cy="43" cx="8.5" style="fill:#81B4DE;" /> <circle r="1" cy="43" cx="15.5" style="fill:#1075BB;" /> <circle r="1" cy="43" cx="22.5" style="fill:#FFF;" /> <circle r="1" cy="43" cx="29.5" style="fill:#FFF;" /> <circle r="1" cy="43" cx="36.5" style="fill:#FFF;" /> <circle r="1" cy="43" cx="43.5" style="fill:#FFF;" /> <circle r="1" cy="43" cx="50.5" style="fill:#FFF;" /> <circle r="1" cy="51" cx="43.5" style="fill:#D4E7F7;" /> <circle r="1" cy="51" cx="50.5" style="fill:#D4E7F7;" /> <circle r="1" cy="51" cx="8.5" style="fill:#81B4DE;" /> <circle r="1" cy="51" cx="15.5" style="fill:#1075BB;" /> <circle r="1" cy="51" cx="22.5" style="fill:#FFF;" /> <circle r="1" cy="51" cx="29.5" style="fill:#FFF;" /> <circle r="1" cy="51" cx="36.5" style="fill:#FFF;" /> </g> <circle r="4" cy="5" cx="29.5" style="fill:#1075BB;stroke:#FFF;stroke-width:2;stroke-linejoin:round;stroke-miterlimit:10;" /> <rect height="7" width="58" style="fill: #D4E7F7;" y="12" x="0.5" /> </svg>
                            </div>
                            {{duedate.value | date: 'MM/dd/yyyy'}}
                        </div>
                    </div>
                </div>
                <div class="separator-b-2 blue mgTB15 mgLR10"></div>
                <div class="layout-fixed pdLR10">
                    <div class="w12px pdB5">
                        <svg class="h8px" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 430.122 430.123" style="enable-background:new 0 0 430.122 430.123;" xml:space="preserve"> <g> <path id="Ning" d="M369.924,290.526c0-16.475,13.479-29.837,30.103-29.837c16.634,0,30.094,13.362,30.094,29.837   s-13.46,29.837-30.094,29.837C383.412,320.363,369.924,307,369.924,290.526z M400.026,166.927c16.634,0,30.094-13.361,30.094-29.83   c0-16.472-13.46-29.836-30.094-29.836c-16.624,0-30.103,13.364-30.103,29.836C369.924,153.566,383.412,166.927,400.026,166.927z    M285.926,173.146c0,16.477,13.46,29.832,30.098,29.832c16.62,0,30.099-13.354,30.099-29.832c0-16.473-13.479-29.837-30.099-29.837   C299.386,143.305,285.926,156.669,285.926,173.146z M136.689,370.455c-16.622,0-30.098,13.356-30.098,29.832   c0,16.475,13.477,29.836,30.098,29.836s30.098-13.361,30.098-29.836C166.787,383.811,153.306,370.455,136.689,370.455z    M255.813,143.305c16.629,0,30.112-13.362,30.112-29.834c0-16.475-13.479-29.832-30.112-29.832   c-16.619,0-30.093,13.357-30.093,29.832C225.721,129.943,239.199,143.305,255.813,143.305z M316.023,225.355   c-16.629,0-30.098,13.361-30.098,29.832c0,16.475,13.46,29.832,30.098,29.832c16.62,0,30.099-13.357,30.099-29.832   C346.122,238.716,332.644,225.355,316.023,225.355z M174.315,285.028c-16.622,0-30.098,13.357-30.098,29.832   s13.477,29.832,30.098,29.832s30.098-13.357,30.098-29.832S190.932,285.028,174.315,285.028z M293.08,370.455   c-16.619,0-30.098,13.356-30.098,29.832c0,16.475,13.479,29.836,30.098,29.836c16.62,0,30.099-13.361,30.099-29.836   C323.179,383.811,309.7,370.455,293.08,370.455z M293.08,59.671c16.62,0,30.099-13.362,30.099-29.834   C323.179,13.362,309.7,0,293.08,0c-16.619,0-30.098,13.362-30.098,29.837C262.982,46.309,276.461,59.671,293.08,59.671z    M114.117,285.028c16.622,0,30.1-13.362,30.1-29.832c0-16.475-13.479-29.841-30.1-29.841s-30.089,13.366-30.089,29.841   C84.028,271.666,97.495,285.028,114.117,285.028z M30.1,166.927c16.622,0,30.101-13.361,30.101-29.83   c0-16.472-13.479-29.836-30.101-29.836c-16.622,0-30.098,13.364-30.098,29.836C0.002,153.566,13.478,166.927,30.1,166.927z    M30.1,320.363c16.622,0,30.101-13.362,30.101-29.837S46.722,260.689,30.1,260.689c-16.622,0-30.098,13.362-30.098,29.837   S13.478,320.363,30.1,320.363z M114.117,202.978c16.622,0,30.1-13.354,30.1-29.832c0-16.473-13.479-29.837-30.1-29.837   s-30.089,13.364-30.089,29.837C84.028,189.624,97.495,202.978,114.117,202.978z M255.813,344.692   c16.629,0,30.112-13.357,30.112-29.832s-13.479-29.832-30.112-29.832c-16.619,0-30.093,13.357-30.093,29.832   S239.199,344.692,255.813,344.692z M144.217,113.471c0,16.473,13.477,29.834,30.098,29.834s30.098-13.362,30.098-29.834   c0-16.475-13.477-29.832-30.098-29.832S144.217,96.996,144.217,113.471z M136.689,59.671c16.622,0,30.098-13.362,30.098-29.834   c-0.005-16.475-13.481-29.832-30.098-29.832s-30.098,13.362-30.098,29.836C106.591,46.309,120.067,59.671,136.689,59.671z" style="fill: #4f7697" /> </g> </svg>
                    </div>
                    <div class="w120px ft-fourth fz12 bold clr-darkblue uppercase">Balance Due</div>
                    <div class="text-right pdR5">
                        <div  class="ft-fourth fz17 bold clr-darkblue" ng-if="totalend == 0">PAID in FULL</div>
                        <div  class="ft-fourth fz17 bold clr-darkblue" ng-if="totalend != 0 && check_payment_plan == 0">${{totalend}}</div>
                        <div  class="ft-fourth fz17 bold clr-darkblue" ng-if="totalend != 0 && check_payment_plan != 0">PAYMENT PLAN</div>
                    </div>
                </div>
            </div>
            <div class="bg-lightblue-3 rounded-10 pdT20 pdB10">
                <div class="layout-fixed pdLR10 mgB5">
                    <div class="w12px pdB5">
                        <svg class="h8px" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 430.122 430.123" style="enable-background:new 0 0 430.122 430.123;" xml:space="preserve"> <g> <path id="Ning" d="M369.924,290.526c0-16.475,13.479-29.837,30.103-29.837c16.634,0,30.094,13.362,30.094,29.837   s-13.46,29.837-30.094,29.837C383.412,320.363,369.924,307,369.924,290.526z M400.026,166.927c16.634,0,30.094-13.361,30.094-29.83   c0-16.472-13.46-29.836-30.094-29.836c-16.624,0-30.103,13.364-30.103,29.836C369.924,153.566,383.412,166.927,400.026,166.927z    M285.926,173.146c0,16.477,13.46,29.832,30.098,29.832c16.62,0,30.099-13.354,30.099-29.832c0-16.473-13.479-29.837-30.099-29.837   C299.386,143.305,285.926,156.669,285.926,173.146z M136.689,370.455c-16.622,0-30.098,13.356-30.098,29.832   c0,16.475,13.477,29.836,30.098,29.836s30.098-13.361,30.098-29.836C166.787,383.811,153.306,370.455,136.689,370.455z    M255.813,143.305c16.629,0,30.112-13.362,30.112-29.834c0-16.475-13.479-29.832-30.112-29.832   c-16.619,0-30.093,13.357-30.093,29.832C225.721,129.943,239.199,143.305,255.813,143.305z M316.023,225.355   c-16.629,0-30.098,13.361-30.098,29.832c0,16.475,13.46,29.832,30.098,29.832c16.62,0,30.099-13.357,30.099-29.832   C346.122,238.716,332.644,225.355,316.023,225.355z M174.315,285.028c-16.622,0-30.098,13.357-30.098,29.832   s13.477,29.832,30.098,29.832s30.098-13.357,30.098-29.832S190.932,285.028,174.315,285.028z M293.08,370.455   c-16.619,0-30.098,13.356-30.098,29.832c0,16.475,13.479,29.836,30.098,29.836c16.62,0,30.099-13.361,30.099-29.836   C323.179,383.811,309.7,370.455,293.08,370.455z M293.08,59.671c16.62,0,30.099-13.362,30.099-29.834   C323.179,13.362,309.7,0,293.08,0c-16.619,0-30.098,13.362-30.098,29.837C262.982,46.309,276.461,59.671,293.08,59.671z    M114.117,285.028c16.622,0,30.1-13.362,30.1-29.832c0-16.475-13.479-29.841-30.1-29.841s-30.089,13.366-30.089,29.841   C84.028,271.666,97.495,285.028,114.117,285.028z M30.1,166.927c16.622,0,30.101-13.361,30.101-29.83   c0-16.472-13.479-29.836-30.101-29.836c-16.622,0-30.098,13.364-30.098,29.836C0.002,153.566,13.478,166.927,30.1,166.927z    M30.1,320.363c16.622,0,30.101-13.362,30.101-29.837S46.722,260.689,30.1,260.689c-16.622,0-30.098,13.362-30.098,29.837   S13.478,320.363,30.1,320.363z M114.117,202.978c16.622,0,30.1-13.354,30.1-29.832c0-16.473-13.479-29.837-30.1-29.837   s-30.089,13.364-30.089,29.837C84.028,189.624,97.495,202.978,114.117,202.978z M255.813,344.692   c16.629,0,30.112-13.357,30.112-29.832s-13.479-29.832-30.112-29.832c-16.619,0-30.093,13.357-30.093,29.832   S239.199,344.692,255.813,344.692z M144.217,113.471c0,16.473,13.477,29.834,30.098,29.834s30.098-13.362,30.098-29.834   c0-16.475-13.477-29.832-30.098-29.832S144.217,96.996,144.217,113.471z M136.689,59.671c16.622,0,30.098-13.362,30.098-29.834   c-0.005-16.475-13.481-29.832-30.098-29.832s-30.098,13.362-30.098,29.836C106.591,46.309,120.067,59.671,136.689,59.671z" style="fill: #4f7697" /> </g> </svg>
                    </div>
                    <div class="ft-fourth fz12 bold clr-darkblue uppercase">Client Signature</div>
                </div>
                <div id="signaturePaymentShow" class="text-center"></div>
            </div>
        </div>
        </ion-scroll>
</div>
<div class="control ">
    <div class="layout-fixed full-h pdR10">
        <button class="link-order-invoice-detail-option button-field-1 w60px h60px right">
            <svg class="h26px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 297.613 297.613" style="enable-background:new 0 0 297.613 297.613;" xml:space="preserve"> <g> <circle cx="148.302" cy="14.83" r="14.83" fill="#FFFFFF" /> <circle cx="192.343" cy="59.769" r="14.83" fill="#FFFFFF" /> <circle cx="15.279" cy="147.852" r="14.83" fill="#FFFFFF" /> <circle cx="59.32" cy="147.852" r="14.83" fill="#FFFFFF" /> <circle cx="104.261" cy="147.852" r="14.83" fill="#FFFFFF" /> <circle cx="148.302" cy="147.852" r="14.83" fill="#FFFFFF" /> <circle cx="192.343" cy="147.852" r="14.83" fill="#FFFFFF" /> <circle cx="192.343" cy="236.887" r="14.83" fill="#FFFFFF" /> <circle cx="238.238" cy="103.81" r="14.83" fill="#FFFFFF" /> <circle cx="238.238" cy="147.852" r="14.83" fill="#FFFFFF" /> <circle cx="238.238" cy="192.79" r="14.831" fill="#FFFFFF" /> <circle cx="148.302" cy="282.782" r="14.831" fill="#FFFFFF" /> <circle cx="282.334" cy="147.852" r="14.83" fill="#FFFFFF" /> </g> </svg>
        </button>
        <div class="order-invoice-detail-option box-setting-2 w300px bottom-right mgR5 mgB10">
            <div class="pdTB10 pdLR10">
                <div class="layout-fixed pdTB10 text-left">
                    <div class="clear">
                        <span class="fz17 bold clr-darkblue">Add Payment</span>
                    </div>
                    <div class="w100px text-right ">
                        <button class="button-field-1 white w38px h38px" ng-click="openByGetTemplate('invoicePaymentTermsConditions')" type="button">
                            <svg class="h22px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" viewBox="0 0 226.216 226.216" enable-background="new 0 0 226.216 226.216"> <g> <path d="m217.515,104.407h-95.707v-95.706c0-5.22-3.48-8.701-8.701-8.701s-8.701,3.48-8.701,8.701v95.707h-95.705c-5.22,0-8.701,3.48-8.701,8.701s3.48,8.701 8.701,8.701h95.707v95.707c0,5.22 3.48,8.701 8.701,8.701s8.701-3.48 8.701-8.701v-95.707h95.707c5.22,0 8.701-3.48 8.701-8.701s-3.483-8.702-8.703-8.702z" fill="#033964" /> </g> </svg>
                        </button>
                    </div>
                </div>
                <div class="separator-b-2 lightblue circle-right mgLR5 mgTB5"></div>
                <div class="layout-fixed pdTB10 text-left">
                    <div class="">
                        <button class="button-field-1 w46px h46px mgR15" onclick="appDialogToggle('open', '#invoiceDetailTableAddComment')">
                            <svg class="h20px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 20.582 20.582" style="enable-background:new 0 0 20.582 20.582;" xml:space="preserve"> <g> <path d="M0.201,8.994c-0.249,5.212,3.774,9.634,8.984,9.884c1.491,0.071,2.918-0.212,4.198-0.768l7.008,2.472l-1.968-7.691   c0.365-0.932,0.596-1.941,0.647-2.996c0.244-5.212-3.774-9.636-8.987-9.884C4.877-0.238,0.45,3.782,0.201,8.994z M16.036,9.749   c-0.038,0.797-0.228,1.552-0.527,2.244l1.036,3.476l0,0v0.006l0.092,0.309c0,0,0.002-0.004,0.002-0.005l0.363,1.136l-1.489-0.457   l0,0l-3.186-1.203c-0.911,0.421-1.927,0.641-2.996,0.587c-3.536-0.168-6.262-3.169-6.093-6.703   c0.169-3.535,3.167-6.263,6.705-6.095C13.476,3.213,16.204,6.214,16.036,9.749z" fill="#FFFFFF" /> </g> </svg>
                        </button>
                        <button class="button-field-1 w46px h46px" onclick="appDialogToggle('close', '#estimateDetailTableSentTo');appDialogToggle('open', '#invoiceDetailTableSentTo')">
                            <svg class="h22px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 24.1 24.1" style="enable-background:new 0 0 24.1 24.1;" xml:space="preserve"> <g> <g> <g> <polygon points="16.947,1.008 5.019,1.008 0,5.498 0,23.092 13.706,23.092 13.706,21.512 1.777,21.512      1.777,7.218 6.926,7.218 6.926,2.588 15.169,2.588 15.169,7.412 16.947,7.412    " fill="#FFFFFF" /> <polygon points="7.71,17.67 15.938,17.67 15.938,22.473 24.1,16.222 15.938,9.968 15.938,14.774      7.71,14.774    " fill="#FFFFFF" /> </g> </g> </g> </svg>
                        </button>
                    </div>
                    <div class="w100px text-right">
                        <button class="button-field-1 blue w60px h60px" ng-click="Save_Invoice()">
                            <svg class="h24px" xml:space="preserve" style="enable-background:new 0 0 293.333 293.333;" viewBox="0 0 293.333 293.333" y="0px" x="0px" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg" version="1.1"> <g> <path d="M268.095,5.714H6.468C2.896,5.714,0,8.611,0,12.183V281.15c0,3.573,2.896,6.468,6.468,6.468h268.968   c3.572,0,6.468-2.896,6.468-6.468V19.524L268.095,5.714z" style="fill:#09518C ;" /> <path d="M279.523,5.714H17.897c-3.572,0-6.468,2.896-6.468,6.469V281.15c0,3.573,2.896,6.468,6.468,6.468   h268.968c3.572,0,6.468-2.896,6.468-6.468V19.524L279.523,5.714z" style="fill:#034274;" /> <rect height="89.523" width="201.065" style="fill:#09518C ;" y="5.714" x="46.554" /> <path d="M120.952,5.714v89.523h126.667V5.714H120.952z M231.428,80.583h-36.19V20.369h36.19V80.583z" style="fill:#FFF;" /> <rect height="140.952" width="211.655" style="fill:#FFF;" y="146.667" x="46.554" /> <rect height="20" width="211.655" style="fill:#09518C ;" y="146.667" x="46.554" /> </g> </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
