<div class="title">
    Contact Information
    <div class="more-overlay no-item-more right biger-3-time pdT3 pdR3" onclick="toggleExpand(this)" ng-click="resizeScroll('scrollCustomerDetail')">
        <button class="more-icon bg-transparent pd0-i block" type="button">
            <svg class="h14px clr-symbol-clickable" viewBox="0 0 458.852 458.852"> <path d="M0,115.086l229.426,228.679l229.426-228.679H0z M72.594,145.086h313.664L229.426,301.408L72.594,145.086z" /> </svg>
        </button>
        <button class="less-icon bg-transparent pd0-i block" type="button">
            <svg class="h14px clr-symbol-clickable" viewBox="0 0 458.852 458.852"> <path d="M0,115.086l229.426,228.679l229.426-228.679H0z M72.594" /> </svg>
        </button>
    </div>
</div>
<div class="content">
    <div class="itm">
        <div class="layout-fixed">
            <div class="w20px v-top-i lh1">
                <svg class="h12px clr-symbol" viewBox="0 0 43.028 43.028"> <path d="M39.561,33.971l-0.145,0.174c-4.774,5.728-11.133,8.884-17.902,8.884c-6.77,0-13.128-3.155-17.903-8.884l-0.144-0.174   l0.034-0.223c0.922-6.014,4.064-10.845,8.847-13.606l0.34-0.196l0.271,0.284c2.259,2.37,5.297,3.674,8.554,3.674   s6.295-1.305,8.554-3.674l0.271-0.284l0.34,0.196c4.783,2.761,7.925,7.592,8.848,13.606L39.561,33.971z M21.514,21.489   c5.924,0,10.744-4.82,10.744-10.744C32.258,4.821,27.438,0,21.514,0S10.77,4.821,10.77,10.744S15.59,21.489,21.514,21.489z" fill="#b1c7d7" /> </svg>
            </div>
            <div class="v-top-i">
                <div class="text-title-4">First name</div>
                <div class="text">{{customerDetail.first_name}}</div>
            </div>
            <div class="v-top-i">
                <div class="text-title-4">Last name</div>
                <div class="text">{{customerDetail.last_name}}</div>
            </div>
        </div>
    </div>
    <div class="itm">
        <div class="layout-fixed">
            <div class="w20px v-top-i lh1">
                <svg class="h14px clr-symbol" viewBox="0 0 572.426 572.426"> <path d="M368.8,184.672c27.518,0,49.906-22.389,49.906-49.907c0-27.52-22.388-49.909-49.906-49.909    c-27.512,0-49.895,22.39-49.895,49.909C318.906,162.283,341.288,184.672,368.8,184.672z" /> <path d="M569.241,309.187l-35.982-35.982c-2.054-2.054-4.792-3.185-7.712-3.185c-2.919,0-5.658,1.131-7.712,3.185l-10.524,10.524    c-0.432-0.505-0.878-0.999-1.352-1.474c-4.825-4.826-11.334-7.484-18.327-7.485l-17.057-23.258    c-4.539-6.191-12.204-14.811-17.831-20.052l-35.153-32.736c-2.522-2.349-7.544-5.664-13.351-5.664c0,0-61.263,0-61.593,0    c-8.06,0-15.304,4.477-18.905,11.683l-25.67,51.361c-1.891,3.783-6.592,10.518-9.491,13.597l-18.164,19.297    c-3.867,4.108-5.902,9.476-5.731,15.114c0.17,5.639,2.527,10.873,6.634,14.738c3.932,3.702,9.071,5.741,14.472,5.741    c5.801,0,11.407-2.421,15.381-6.642l18.163-19.297c5.697-6.052,12.798-16.226,16.517-23.665l3.819-7.642    c0,0,5.346,30.242,6.863,40.329c0.076,0.502,0.1,1.112,0.088,1.25l-5.925,66.5c-0.64,7.188-0.944,18.461-0.692,25.664    l2.367,67.785c0.421,12.051,10.19,21.49,22.241,21.49c0.26,0,0.523-0.004,0.79-0.013c12.27-0.431,21.905-10.762,21.477-23.032    l-2.367-67.785c-0.188-5.38,0.066-14.799,0.544-20.156l3.972-44.581h8.382l12.227,51.081c1.786,7.461,5.444,18.385,8.509,25.41    l25.759,59.053c3.544,8.121,11.56,13.369,20.421,13.369c0.202,0,0.404-0.003,0.606-0.009c2.856-0.078,5.644-0.701,8.286-1.853    c5.452-2.378,9.651-6.737,11.824-12.273c2.173-5.537,2.061-11.588-0.317-17.04l-25.76-59.055    c-2.026-4.645-4.838-13.041-6.018-17.969L430.518,269.21c2.299,2.586,4.507,5.248,5.997,7.279l17.14,23.374    c1.488,2.028,3.316,3.751,5.374,5.11c0.357,6.4,2.947,12.285,7.439,16.774c0.474,0.474,0.968,0.92,1.472,1.351l-10.524,10.524    c-2.054,2.054-3.185,4.792-3.185,7.712c0,2.92,1.131,5.658,3.185,7.712l35.983,35.984c2.054,2.054,4.793,3.185,7.712,3.185    s5.658-1.131,7.712-3.185l60.418-60.42c2.054-2.054,3.185-4.792,3.185-7.712C572.426,313.979,571.294,311.241,569.241,309.187z     M475.629,312.585c-1.211-1.21-2.135-2.642-2.759-4.216c3.719-0.38,7.247-1.724,10.304-3.967    c4.549-3.336,7.527-8.243,8.384-13.819c0.113-0.735,0.182-1.47,0.219-2.203c1.895,0.609,3.613,1.631,5.02,3.038    c0.478,0.478,0.897,0.999,1.286,1.539l-20.915,20.914C476.626,313.482,476.106,313.062,475.629,312.585z" /> <path d="M255.161,359.058h-11.2V122.663c0-5.959-4.848-10.807-10.807-10.807h-29.355V92.868c0-5.959-4.848-10.807-10.807-10.807   H72.507c-5.959,0-10.807,4.848-10.807,10.807v18.988H32.345c-5.959,0-10.807,4.848-10.807,10.807v236.395h-11.2   c-5.7,0-10.338,4.638-10.338,10.338v35.449c0,5.7,4.638,10.338,10.338,10.338h244.823c5.7,0,10.338-4.638,10.338-10.338v-35.449   C265.499,363.695,260.861,359.058,255.161,359.058z M91.549,314.547c0,1.65-1.35,3-3,3h-39.25c-1.65,0-3-1.35-3-3v-39.25   c0-1.65,1.35-3,3-3h39.25c1.65,0,3,1.35,3,3V314.547z M91.549,251.881c0,1.65-1.35,3-3,3h-39.25c-1.65,0-3-1.35-3-3v-39.25   c0-1.65,1.35-3,3-3h39.25c1.65,0,3,1.35,3,3V251.881z M91.549,188.548c0,1.65-1.35,3-3,3h-39.25c-1.65,0-3-1.35-3-3v-39.25   c0-1.65,1.35-3,3-3h39.25c1.65,0,3,1.35,3,3V188.548z M155.374,367.548c0,1.65-1.35,3-3,3h-39.25c-1.65,0-3-1.35-3-3v-92.251   c0-1.65,1.35-3,3-3h39.25c1.65,0,3,1.35,3,3V367.548z M155.374,251.881c0,1.65-1.35,3-3,3h-39.25c-1.65,0-3-1.35-3-3v-39.25   c0-1.65,1.35-3,3-3h39.25c1.65,0,3,1.35,3,3V251.881z M155.374,188.548c0,1.65-1.35,3-3,3h-39.25c-1.65,0-3-1.35-3-3v-39.25   c0-1.65,1.35-3,3-3h39.25c1.65,0,3,1.35,3,3V188.548z M219.374,314.547c0,1.65-1.35,3-3,3h-39.25c-1.65,0-3-1.35-3-3v-39.25   c0-1.65,1.35-3,3-3h39.25c1.65,0,3,1.35,3,3V314.547z M219.374,251.881c0,1.65-1.35,3-3,3h-39.25c-1.65,0-3-1.35-3-3v-39.25   c0-1.65,1.35-3,3-3h39.25c1.65,0,3,1.35,3,3V251.881z M219.374,188.548c0,1.65-1.35,3-3,3h-39.25c-1.65,0-3-1.35-3-3v-39.25   c0-1.65,1.35-3,3-3h39.25c1.65,0,3,1.35,3,3V188.548z" /> </svg>
            </div>
            <div class="v-top-i">
                <div class="text-title-4">Company name</div>
                <div class="text">{{customerDetail.company_name}}</div>
            </div>
        </div>
    </div>
    <div class="itm item-expandable">
        <div class="layout-fixed">
            <div class="w20px v-top-i lh1">
                <svg class="h12px clr-symbol" viewBox="0 0 203.613 203.613"> <path fill="#b1c7d7" d="M59.316,32.273v139.066c0,16.279-12.65,29.523-28.2,29.523h-2.915C12.651,200.863,0,187.619,0,171.339V32.273  C0,15.995,12.651,2.75,28.201,2.75h2.915C46.666,2.75,59.316,15.995,59.316,32.273z M203.613,41.203v119.467  c0,12.789-10.405,23.194-23.195,23.194H74.415c-2.762,0-5-2.238-5-5V24.749c0-2.762,2.238-5,5-5h107.743  C193.988,19.749,203.613,29.373,203.613,41.203z M110.59,150.696c0-3.531-2.862-6.393-6.393-6.393c-3.531,0-6.393,2.862-6.393,6.393  s2.862,6.393,6.393,6.393C107.728,157.089,110.59,154.227,110.59,150.696z M110.59,121.954c0-3.531-2.862-6.393-6.393-6.393  c-3.531,0-6.393,2.862-6.393,6.393c0,3.531,2.862,6.393,6.393,6.393C107.728,128.347,110.59,125.485,110.59,121.954z M110.59,93.212  c0-3.531-2.862-6.393-6.393-6.393c-3.531,0-6.393,2.862-6.393,6.393c0,3.531,2.862,6.393,6.393,6.393  C107.728,99.605,110.59,96.743,110.59,93.212z M142.968,150.696c0-3.531-2.862-6.393-6.393-6.393c-3.531,0-6.393,2.862-6.393,6.393  s2.862,6.393,6.393,6.393C140.106,157.089,142.968,154.227,142.968,150.696z M142.968,121.954c0-3.531-2.862-6.393-6.393-6.393  c-3.531,0-6.393,2.862-6.393,6.393c0,3.531,2.862,6.393,6.393,6.393C140.106,128.347,142.968,125.485,142.968,121.954z   M142.968,93.212c0-3.531-2.862-6.393-6.393-6.393c-3.531,0-6.393,2.862-6.393,6.393c0,3.531,2.862,6.393,6.393,6.393  C140.106,99.605,142.968,96.743,142.968,93.212z M175.346,150.696c0-3.531-2.862-6.393-6.393-6.393  c-3.531,0-6.393,2.862-6.393,6.393s2.862,6.393,6.393,6.393C172.484,157.089,175.346,154.227,175.346,150.696z M175.346,121.954  c0-3.531-2.862-6.393-6.393-6.393c-3.531,0-6.393,2.862-6.393,6.393c0,3.531,2.862,6.393,6.393,6.393  C172.484,128.347,175.346,125.485,175.346,121.954z M175.346,93.212c0-3.531-2.862-6.393-6.393-6.393  c-3.531,0-6.393,2.862-6.393,6.393c0,3.531,2.862,6.393,6.393,6.393C172.484,99.605,175.346,96.743,175.346,93.212z M187.017,47.521  c0-5.812-4.729-10.54-10.54-10.54H91.011c-2.762,0-5,2.238-5,5v19.097c0,2.762,2.238,5,5,5h91.006c2.762,0,5-2.238,5-5V47.521z" /> </svg>
            </div>
            <div class="v-top-i">
                <div class="text-title-4">Primary phone number<span class="clr-bluegray uppercase" ng-if="customerDetail.phone_detail != null"> - {{customerDetail.phone_detail}}</span></div>
                <div class="text" ng-bind-html="customerDetail.phone_number.replace('(','<span class=\'ft-symbol\'>(</span>').replace(')','<span class=\'ft-symbol\'>)</span>')"></div>
            </div>
            <div class="w60px clear pdR5">
                <button class="button-function-2 green w30px h30px right" ng-click="callNumber(customerDetail.phone_number)">
                    <svg class="h16px" viewBox="0 0 202.918 202.918"> <path d="M185.815,168.463c-0.641,2.686-3.338,4.348-6.023,3.703c-2.687-0.641-4.345-3.338-3.703-6.023  c2.783-11.662,1.322-21.9-3.907-27.386c-3.482-3.652-8.442-4.899-14.737-3.716c-12.512,2.359-20.484,13.166-29.716,25.68  c-7.73,10.477-16.491,22.352-29.351,30.305c-12.503,7.732-26.774,11.893-40.589,11.893c-1.304,0-2.602-0.036-3.895-0.111  c-15.025-0.866-27.414-6.857-33.988-16.438c-8.301-12.096-3.537-24.684,2.934-33.277l-5.057-6.758  c-3.798-5.074-2.803-12.353,2.218-16.223l32.649-25.162c2.058-1.587,4.518-2.426,7.113-2.426c3.659,0,7.151,1.748,9.342,4.675  l12.042,16.092c9.594-4.324,20.569-11.658,32.472-23.738c12.029-12.207,19.245-23.423,23.482-33.092l-16.074-12.388  c-5.022-3.87-6.017-11.148-2.218-16.224l24.825-33.175C145.825,1.748,149.317,0,152.976,0c2.596,0,5.055,0.839,7.114,2.426  l18.787,14.479c0.024,0.019,0.042,0.043,0.066,0.062c0.145,0.118,0.275,0.249,0.405,0.382c0.117,0.117,0.235,0.23,0.338,0.356  c0.07,0.086,0.128,0.179,0.191,0.27c0.136,0.191,0.265,0.384,0.371,0.589c0.024,0.048,0.043,0.098,0.066,0.146  c0.125,0.261,0.229,0.528,0.307,0.804c0.002,0.006,0.005,0.012,0.007,0.018c0.475,1.748,10.961,43.469-45.93,101.204  c-40.888,41.493-73.748,47.69-89.697,47.69c-0.001,0-0.001,0-0.002,0c-6.224-0.001-9.797-0.948-10.184-1.057  c-0.011-0.003-0.02-0.009-0.03-0.012c-0.264-0.077-0.515-0.179-0.761-0.298c-0.07-0.033-0.143-0.061-0.211-0.098  c-0.185-0.1-0.357-0.218-0.528-0.341c-0.109-0.077-0.22-0.15-0.322-0.235c-0.117-0.099-0.223-0.211-0.331-0.321  c-0.132-0.133-0.261-0.265-0.377-0.411c-0.023-0.03-0.053-0.052-0.075-0.082l-3.043-4.067c-3.37,5.259-5.698,12.339-0.986,19.204  c9.55,13.914,39.363,17.646,64.967,1.809c11.218-6.937,19.019-17.511,26.564-27.736c10.047-13.618,19.537-26.481,35.909-29.568  c9.564-1.803,18.026,0.555,23.829,6.643C186.998,139.806,189.389,153.49,185.815,168.463z" fill="#FFFFFF" /> </svg>
                </button>
            </div>
        </div>
    </div>
    <div class="itm item-expandable" ng-if="customerDetail.additionalPhone.length">
        <div class="layout-fixed">
            <div class="w20px v-top-i lh1">
                <svg class="h12px clr-symbol" viewBox="0 0 612.001 612"> <path d="M588.074,199.311c-11.954-12.377-25.671-16.74-35.288-18.225c-8.256-62.36-15.939-94.828-275.988-94.828   C16.75,86.258,0,125.46,0,193.498v11.605c0,18.411,14.925,33.336,33.336,33.336h83.427c18.411,0,33.336-14.925,33.336-33.336   v-11.605c0-52.705,80.699-54.319,126.698-54.319c45.998,0,126.697,1.614,126.697,54.319v11.605   c0,18.411,14.926,33.336,33.337,33.336h83.427c18.411,0,33.337-14.925,33.337-33.336v-4.464c6.146,1.51,13.907,4.794,20.776,11.905   c16.747,17.347,22.305,50.861,16.068,96.927c-10.815,79.816-42.181,108.325-75.585,117.813v-13.886   c0-14.097-3.524-28.05-10.668-40.242c-33.336-57.053-80.674-107.677-140.823-152.301v-33.717c0-2.619-2.143-4.762-4.762-4.762   h-49.481c-2.667,0-4.762,2.143-4.762,4.762v33.527h-56.481v-33.527c0-2.619-2.143-4.762-4.762-4.762h-49.529   c-2.62,0-4.762,2.143-4.762,4.762v33.527C128.581,265.384,81.195,316.007,47.81,373.156c-7.144,12.192-10.668,26.146-10.668,40.242   v31.384c0,44.72,36.242,80.961,80.961,80.961h315.793c44.018,0,79.744-35.135,80.855-78.884   c53.54-12.54,83.912-56.224,94.562-134.831C616.467,259.232,609.318,221.31,588.074,199.311z M358.727,414.231l-31.774-11.313   c3.371-6.792,5.314-14.421,5.314-22.522c0-28.003-22.716-50.72-50.767-50.72c-28.003,0-50.767,22.717-50.767,50.72   c0,28.051,22.764,50.768,50.767,50.768c10.371,0,20.003-3.121,28.037-8.453l17.429,28.648   c-13.129,8.43-28.707,13.379-45.465,13.379c-46.576,0-84.294-37.766-84.294-84.341c0-46.529,37.718-84.294,84.294-84.294   c46.576,0,84.342,37.766,84.342,84.294C365.842,392.437,363.275,403.867,358.727,414.231z" /> </svg>
            </div>
            <div class="v-top-i">
                <div class="text-title-4">Additional phone number - <span class="clr-bluegray uppercase" ng-if="customerDetail.additionalPhone[0].phone_detail != null">{{customerDetail.additionalPhone[0].phone_detail}}</span></div>
                <div class="text baseline">
                    <span ng-bind-html="customerDetail.additionalPhone[0].phone.replace('(','<span class=\'ft-symbol\'>(</span>').replace(')','<span class=\'ft-symbol\'>)</span>')"></span>
                    <span class="text-link-1 mgL10" ng-click="openByGetTemplate('customerPopupPhoneAdditionalMore')" ng-if="customerDetail.additionalPhone.length>1">[{{customerDetail.additionalPhone.length - 1 }} more]</span>
                </div>
            </div>
            <div class="w60px clear pdR5">
                <button class="button-function-2 green w30px h30px right" ng-click="callNumber(customerDetail.additionalPhone[0].phone)">
                    <svg class="h16px" viewBox="0 0 202.918 202.918"> <path d="M185.815,168.463c-0.641,2.686-3.338,4.348-6.023,3.703c-2.687-0.641-4.345-3.338-3.703-6.023  c2.783-11.662,1.322-21.9-3.907-27.386c-3.482-3.652-8.442-4.899-14.737-3.716c-12.512,2.359-20.484,13.166-29.716,25.68  c-7.73,10.477-16.491,22.352-29.351,30.305c-12.503,7.732-26.774,11.893-40.589,11.893c-1.304,0-2.602-0.036-3.895-0.111  c-15.025-0.866-27.414-6.857-33.988-16.438c-8.301-12.096-3.537-24.684,2.934-33.277l-5.057-6.758  c-3.798-5.074-2.803-12.353,2.218-16.223l32.649-25.162c2.058-1.587,4.518-2.426,7.113-2.426c3.659,0,7.151,1.748,9.342,4.675  l12.042,16.092c9.594-4.324,20.569-11.658,32.472-23.738c12.029-12.207,19.245-23.423,23.482-33.092l-16.074-12.388  c-5.022-3.87-6.017-11.148-2.218-16.224l24.825-33.175C145.825,1.748,149.317,0,152.976,0c2.596,0,5.055,0.839,7.114,2.426  l18.787,14.479c0.024,0.019,0.042,0.043,0.066,0.062c0.145,0.118,0.275,0.249,0.405,0.382c0.117,0.117,0.235,0.23,0.338,0.356  c0.07,0.086,0.128,0.179,0.191,0.27c0.136,0.191,0.265,0.384,0.371,0.589c0.024,0.048,0.043,0.098,0.066,0.146  c0.125,0.261,0.229,0.528,0.307,0.804c0.002,0.006,0.005,0.012,0.007,0.018c0.475,1.748,10.961,43.469-45.93,101.204  c-40.888,41.493-73.748,47.69-89.697,47.69c-0.001,0-0.001,0-0.002,0c-6.224-0.001-9.797-0.948-10.184-1.057  c-0.011-0.003-0.02-0.009-0.03-0.012c-0.264-0.077-0.515-0.179-0.761-0.298c-0.07-0.033-0.143-0.061-0.211-0.098  c-0.185-0.1-0.357-0.218-0.528-0.341c-0.109-0.077-0.22-0.15-0.322-0.235c-0.117-0.099-0.223-0.211-0.331-0.321  c-0.132-0.133-0.261-0.265-0.377-0.411c-0.023-0.03-0.053-0.052-0.075-0.082l-3.043-4.067c-3.37,5.259-5.698,12.339-0.986,19.204  c9.55,13.914,39.363,17.646,64.967,1.809c11.218-6.937,19.019-17.511,26.564-27.736c10.047-13.618,19.537-26.481,35.909-29.568  c9.564-1.803,18.026,0.555,23.829,6.643C186.998,139.806,189.389,153.49,185.815,168.463z" fill="#FFFFFF" /> </svg>
                </button>
            </div>
        </div>
    </div>
    <div class="itm item-expandable">
        <div class="layout-fixed">
            <div class="w20px v-top-i text">
                <svg class="h12px clr-symbol" viewBox="0 0 512 512"> <path fill="#b1c7d7" d="M461.913,72.348H50.087c-25.934,0-47.304,19.812-49.864,45.078l221.496,221.496c17.809,17.809,49.753,18.81,69.677-1.113    l220.383-220.383C509.217,92.16,487.847,72.348,461.913,72.348z" /> <path fill="#b1c7d7" d="M315,361.413c-15.783,15.793-36.848,24.489-59.304,24.489c-21.75,0-42.739-8.51-57.587-23.37L0,164.433v225.132    c0,27.604,22.484,50.087,50.087,50.087h411.826c27.603,0,50.087-22.483,50.087-50.087V164.431L315,361.413z" /> </svg>
            </div>
            <div class="v-top-i">
                <div class="text-title-4">Email</div>
                <div class="text">
                    <a class="text" href="mailto:{{customerDetail.email}}">
                        <div class="first-capitalize">{{customerDetail.email}}<span class="clr-bluegray uppercase" ng-if="customerDetail.phone_detail != null"> - {{customerDetail.email_detail}}</span></div>
                    </a>
                    <span class="text-link-1 mgL10" ng-click="openByGetTemplate('customerPopupEmailAdditionalMore')" ng-if="customerDetail.additionalEmail.length">{{customerDetail.additionalEmail.length}} more</span>
                </div>
            </div>
            <div class="w60px clear pdR5">
                <a href="mailto:{{customerDetail.email}}">
                    <button class="button-function-2 blue w30px h30px right">
                        <svg class="h20px" viewBox="0 0 191.614 191.614"> <polygon points="191.614,45.206 81.708,45.206 136.659,80.929   " /> <polygon points="81.708,50.705 81.708,93.137 139.064,93.137 139.064,116.65 191.614,116.65 191.614,50.705 136.659,86.427   " /> <polygon points="60.462,102.992 60.462,146.408 132.829,146.408 132.829,102.992 96.647,126.509   " /> <polygon points="96.647,122.886 132.829,99.376 60.462,99.376   " /> <rect y="118.733" width="48.655" height="3.117" /> <rect x="6.235" y="91.429" width="47.992" height="3.118" /> <rect y="64.125" width="72.933" height="3.118" /> </svg>
                    </button>
                </a>
            </div>
        </div>
    </div>
    <div class="itm">
        <div class="layout-fixed">
            <div class="w20px v-top-i text">
                <svg class="h12px clr-symbol" viewBox="0 0 97.713 97.713"> <g> <path fill="#b1c7d7" d="M48.855,0C29.021,0,12.883,16.138,12.883,35.974c0,5.174,1.059,10.114,3.146,14.684   c8.994,19.681,26.238,40.46,31.31,46.359c0.38,0.441,0.934,0.695,1.517,0.695s1.137-0.254,1.517-0.695   c5.07-5.898,22.314-26.676,31.311-46.359c2.088-4.57,3.146-9.51,3.146-14.684C84.828,16.138,68.69,0,48.855,0z M48.855,54.659   c-10.303,0-18.686-8.383-18.686-18.686c0-10.304,8.383-18.687,18.686-18.687s18.686,8.383,18.686,18.687   C67.542,46.276,59.159,54.659,48.855,54.659z" /> </g> </svg>
            </div>
            <div class="v-top-i">
                <div class="text-title-4">Address</div>
                <div class="text">{{customerDetail.street}}</div>
            </div>
            <div class="w60px clear pdR5">
                <button class="button-function-2 blue w30px h30px right" ng-click="openGoogleMap(customerDetail.street)">
                    <svg class="h18px clr-symbol" viewBox="0 0 31.645 31.645"> <path d="M10.768,25.369c-0.034-0.022-0.602-0.533-0.74.715c-0.138-0.182-0.404-0.23-0.543-0.303    c-0.14-0.073-1.064-0.377-1.286-0.219c-0.219,0.157-0.521,0.254-0.638,0c-0.115-0.256-0.173-0.292-0.335-0.328    c-0.162-0.036-0.081-0.23-0.092-0.4c-0.013-0.171-0.105-0.352-0.221-0.23c-0.116,0.122-0.51,0.437-0.567,0.277    c-0.058-0.156-0.337-0.812,0.081-0.934c0.416-0.121,0.764-0.049,0.869,0.06c0.104,0.109,0.184,0.413,0.313,0.376    c0.128-0.037,0.058-0.268,0.104-0.461c0.046-0.192,0.349-0.448,0.486-0.715c0.139-0.268,0.162-0.425,0.335-0.499    c0.176-0.072,0.268-0.169,0.43-0.291c0.163-0.122,0.416-0.229,0.511-0.292c0.093-0.062,0.509-0.267,0.647-0.23    c0.139,0.037,0.231-0.013,0.116-0.219c-0.116-0.206-0.266-0.825-0.486-1.104c-0.22-0.279-0.244-0.354-0.348-0.619    c-0.104-0.268-0.221-0.498-0.302-0.316c-0.081,0.183-0.254,0.426-0.347,0.194c-0.092-0.23-0.081-0.219-0.197-0.328    c-0.115-0.108-0.209-0.134-0.37-0.182c-0.162-0.049-0.324,0.012-0.313,0.17C7.883,18.22,7.72,18.5,7.826,18.706    c0.104,0.207,0.197,0.426,0.057,0.498c-0.138,0.072,0,0.511-0.138,0.497c-0.139-0.011-0.208,0.014-0.208-0.146    c0-0.157,0.069-0.4-0.187-0.4c-0.254,0-0.405-0.133-0.59-0.267c-0.186-0.133-0.336-0.062-0.29-0.364    c0.046-0.304-0.022-0.413,0.185-0.583c0.209-0.169,0.256-0.267,0.406-0.194c0.151,0.073,0.254,0.073,0.349-0.012    c0.092-0.085,0.265-0.049,0.265-0.158c0-0.108-0.197-0.108-0.173-0.29c0.022-0.184,0.116-0.086,0.15-0.39    c0.034-0.303-0.22-0.764-0.475-0.704c-0.256,0.062-0.648,0.413-0.729,0.255c-0.082-0.158-0.244-0.085-0.557,0.024    s-1.61-0.109-1.702-0.219c0,0-0.221-0.157-0.337-0.072c-0.115,0.085-0.579,0.048-0.718,0.024c-0.14-0.024-0.267,0.157-0.439,0.098    c-0.176-0.062-0.789-0.183-0.927-0.28c-0.141-0.097-0.35-0.097-0.44-0.145c-0.093-0.05-0.43-0.073-0.498,0.023    c-0.069,0.097-0.324,0.268-0.452,0.388c-0.127,0.122-0.276,0.099-0.15,0.354c0.127,0.254-0.324,0.413-0.209,0.691    c0.115,0.277-0.023,1.03,0.44,1.177c0.464,0.146,0.846,0.23,1.112,0.013c0.268-0.219,0.673-0.219,0.8,0.024    c0.127,0.242,0.197,0.606,0.613,0.812C3.4,19.568,3.76,20.163,3.737,20.43c-0.022,0.267,0.013,1.152,0.439,1.663    c0.43,0.51,0.87,1.433,0.903,1.214c0.035-0.219,0.035-0.438,0.129-0.28c0.091,0.159,0.335,0.645,0.729,0.729    c0.395,0.085,0.592,0.108,0.741,0.256c0.15,0.145,0.279,0.229,0.44,0.303c0.162,0.073,0.556,0.292,0.637,0.438    c0.082,0.146,0.047,0.34-0.035,0.559c-0.08,0.219-0.173,0.437-0.058,0.644c0.117,0.206,0.36,0.802,0.558,0.935    c0.197,0.134,0.392,0.352,0.346,0.656c-0.046,0.301-0.266,1.6-0.243,1.892c0.024,0.29-0.265,1.249-0.034,1.638    c0.231,0.389,0.627,0.511,0.8,0.46c0.173-0.047,0.035-0.06-0.047-0.242c-0.081-0.183-0.07-0.413,0.023-0.582    c0.094-0.171,0.094-0.268,0.047-0.462c-0.047-0.193-0.023-0.304,0.092-0.448c0.117-0.146,0.603-0.534,0.754-0.704    c0.149-0.17,1.101-1.336,1.228-1.434c0.127-0.097,0.416-0.327,0.51-0.69c0.093-0.364,0.428-1.08,0.197-1.264    C11.66,25.528,10.803,25.394,10.768,25.369z" /> <path d="M13.084,15.125c0.066-0.128,0.226-0.451,0.312-0.628h-3.67c0.044,0.195,0.203,0.918,0.173,1.211    c-0.035,0.341,0.07,0.22,0.162,0.354c0.093,0.133,0.07,0.34,0.012,0.497c-0.059,0.158-0.093,0.51,0.094,0.923    c0.184,0.413,0.404,0.934,0.589,0.959c0.187,0.024,0.14,0.291,0.268,0.194c0.127-0.099,0.149-0.315,0.255-0.631    c0.104-0.315,0.104-0.547,0.371-0.704c0.267-0.158,1.007-0.667,1.169-0.851c0.163-0.182,0.348-0.255,0.29-0.569    C13.049,15.563,12.992,15.308,13.084,15.125z" /> <path d="M31.153,16.558c-0.139-0.097-0.972-0.764-1.332-0.679c-0.357,0.085-0.996-0.195-1.1-0.256    c-0.104-0.061-0.96-0.323-1.412-0.34c-0.225-0.008-1.17-0.218-1.565-0.387c-0.394-0.17-0.729-1.007-1.481-0.874    c-0.097,0.018-1.007,0.146-1.239,0.353c-0.23,0.207-0.336,0.448-0.463,0.497c-0.127,0.049-0.498,0.024-0.498,0.207    c0,0.182,0.128,0.741-0.022,0.631c-0.151-0.109-0.302-0.364-0.37-0.17c-0.069,0.195-0.188,0.304-0.256,0.23    c-0.068-0.072-0.419,0-0.464,0.122c-0.046,0.122-0.498,0.399-0.693,0.438c-0.197,0.036-0.279,0.134-0.383,0.183    c-0.104,0.048-0.893,0.413-1.042,0.278c-0.151-0.133-0.197-0.048-0.29-0.023c0,0-0.278-0.049-0.451-0.268    c-0.175-0.218-0.209-0.146-0.406-0.352c-0.196-0.206-0.243-0.412-0.44-0.327c-0.195,0.084-1.029,0.946-1.354,1.334    c-0.323,0.39-0.903,0.789-0.614,1.068c0.291,0.279,0.44,0.243,0.476,0.399c0.036,0.157,0.07,0.328,0.116,0.39    c0.046,0.061,0.324,0.278,0.463-0.013c0.141-0.292,0.162-0.497,0.325-0.448c0.162,0.048,0.196,0.158,0.114,0.376    c-0.081,0.219-0.138,0.558-0.416,0.546c-0.278-0.012-0.578-0.183-0.673-0.146c-0.092,0.036-0.148,0.121-0.254,0.206    c-0.104,0.085-0.429,0.485-0.649,0.546c-0.219,0.062-0.485,0.012-0.335,0.193s0.37,0.583,0.162,0.571    c-0.208-0.013-0.556-0.048-0.579,0.158c-0.023,0.205-0.115,0.327-0.069,0.473c0.046,0.146,0.197,0.425,0.381,0.328    c0.188-0.099,0.546-0.194,0.638-0.413c0.093-0.219,0.198-0.46,0.429-0.449c0.231,0.012,0.788,0.316,0.753,0.425    c-0.035,0.109-0.15,0.364-0.011,0.279c0.138-0.085,0.254-0.182,0.335-0.218c0.081-0.037,0.187,0.122,0.22,0.182    c0.035,0.062,0.267,0.182,0.313-0.013c0.047-0.194,0.093-0.047,0.23,0.013c0.141,0.062,0.557,0.109,0.613,0.158    c0.06,0.048,0.187,0.194,0.024,0.388c-0.162,0.194-0.349,0.269-0.614,0.122c-0.267-0.146-0.557,0.122-0.856-0.024    c-0.302-0.146-0.163-0.352-0.522-0.497c-0.357-0.146-1.169,0.035-1.425,0.108c-0.255,0.072-0.266,0.098-0.37,0.218    c-0.104,0.122-0.787,0.91-0.787,1.359s0.254,1.664,1.076,1.542c0.823-0.122,1.321-0.049,1.229,0.193    c-0.094,0.244-0.046,0.304,0.104,0.583c0.15,0.278,0.499,2.136,0.556,2.438c0.059,0.305-0.045,0.692,0.337,0.631    c0.383-0.06,0.788-0.156,0.949-0.509c0.163-0.352,0.187-0.752,0.395-0.958c0.209-0.207,0.464-0.207,0.486-0.498    c0.022-0.292-0.058-0.982,0.081-1.142c0.139-0.157,0.787-0.886,0.856-1.177c0.07-0.291,0.162-0.364-0.104-0.364    c-0.266,0-0.718-0.036-0.847-0.279c-0.126-0.243-0.428-0.704-0.428-0.812c0-0.109,0.186-0.098,0.277,0.133    c0.093,0.229,0.416,0.923,0.787,0.775c0.371-0.146,0.893-0.314,0.904-0.546c0.011-0.229-0.162-0.497-0.349-0.483    c-0.186,0.012-0.382-0.122-0.382-0.255c0-0.134,0.034-0.084,0.254,0c0.222,0.085,0.29,0.229,0.626,0.255    c0.336,0.023,0.719,0.351,0.903,0.498c0.186,0.146,0.509,1.141,0.591,1.237c0.08,0.099,0.175,0.099,0.255-0.097    c0.082-0.195,0.429-0.812,0.626-0.984c0.197-0.17,0.208-0.399,0.323-0.254c0.116,0.146,0.614,0.51,0.649,0.729    c0.035,0.218-0.023,0.691,0.081,0.546c0.104-0.146,0.186-0.449,0.276-0.315c0.094,0.135,0.094,0.341,0.313,0.183    c0.221-0.157,0.603-0.219,0.395-0.559s-0.069-0.546,0.06-0.558c0.127-0.013,0.996-0.17,1.019-0.645    c0.023-0.473-0.302-0.728-0.148-0.971c0.148-0.243,0.368-0.461,0.416-0.315c0.046,0.146-0.116,0.618,0.092,0.546    c0.209-0.073,0.452-0.073,0.452-0.22c0-0.146-0.047-0.511,0.047-0.606c0.093-0.097,0.774-0.74,0.856-0.995    c0.081-0.255,0.232-0.473,0.104-0.667s-0.347-0.134-0.174-0.376c0.174-0.243,0.464-0.467,0.684-0.486    c0.703-0.061,0.505,0.809,0.516,1.002c0.014,0.194,0.014,0.681,0.117,0.438c0.104-0.243,0.225-0.541,0.434-0.747    s0.323-0.34,0.337-0.522c0.012-0.182,0.021-0.242,0.22-0.34c0.197-0.097,1.065-0.437,1.146-0.667    c0.08-0.229-0.104-0.438,0.104-0.424c0.208,0.011,0.405,0.242,0.51,0.121s0.336-0.339,0.324-0.461    C31.631,16.935,31.294,16.655,31.153,16.558z" /> <path d="M27.414,20.636c-0.07,0.159-0.104,0.183-0.208,0.511c-0.106,0.327-0.071,0.242-0.176,0.448    c-0.104,0.207-0.276,0.229-0.451,0.365c-0.175,0.134-0.221,0.399-0.221,0.399c-0.15,0.206,0.614-0.292,0.88-0.449    c0.267-0.157,0.198-0.34,0.221-0.595c0.023-0.255,0.095-0.292,0.208-0.401c0.115-0.108,0.023-0.327-0.032-0.484    C27.574,20.271,27.482,20.479,27.414,20.636z" /> <path d="M25.039,26.146c0.08-0.061,0.022-0.194,0.149-0.17c0.128,0.023,0.243,0.098,0.396,0.013    c0.149-0.086,0.277-0.05,0.254-0.194c-0.022-0.146,0-0.34-0.034-0.46c-0.035-0.122-0.243-0.159-0.395-0.024    c-0.149,0.134-0.357,0.34-0.357,0.266c0-0.071,0.091-0.266,0.045-0.388c-0.045-0.121,0.022-0.23-0.208-0.133    c-0.232,0.097-0.359,0.073-0.44,0.207s-0.174,0.364-0.312,0.218c-0.14-0.145-0.545-0.448-0.545-0.448    c-0.033-0.037-0.496-0.414-0.334-0.158c0.161,0.256,0.404,0.692,0.521,0.85c0.114,0.158,0.242,0.34,0.381,0.255    c0.14-0.085,0.163-0.109,0.349,0C24.69,26.086,24.958,26.207,25.039,26.146z" /> <path d="M27.878,25.807c-0.222-0.097-0.129-0.183-0.396-0.23s-0.486,0-0.557-0.048c-0.07-0.049-0.416-0.17-0.37,0    c0.047,0.171,0.359,0.218,0.439,0.267c0.081,0.049-0.115,0.158,0.034,0.242c0.15,0.084,0.255,0.243,0.452,0.194    s0.267,0.061,0.427,0.085c0.163,0.024,0.325-0.024,0.258-0.098c-0.07-0.072-0.115-0.17-0.104-0.254    C28.072,25.88,28.096,25.903,27.878,25.807z" /> <path d="M27.761,26.887c-0.081-0.243-0.278-0.691-0.323-0.474c-0.047,0.219-0.36,0.375-0.477,0.363    c-0.106-0.011-0.046-0.121-0.046-0.219c0-0.097-0.061-0.194-0.325-0.121c-0.268,0.073-0.323,0.328-0.395,0.304    c-0.068-0.023-0.255-0.073-0.37,0.062c-0.115,0.134-0.221,0.388-0.358,0.437c-0.141,0.049-0.604,0.109-0.604,0.305    c0,0.193,0.117,0.484,0.105,0.643s-0.224,0.521,0.058,0.631c0.162,0.064,0.277,0.073,0.465-0.023    c0.185-0.098,0.983-0.353,1.088-0.269c0.104,0.085,0.273,0.285,0.348,0.328c0.147,0.087,0.187,0.291,0.384,0.339    c0.194,0.049,0.347,0.073,0.427,0.073c0.082,0,0.37-0.097,0.44-0.268c0.069-0.171,0.197-0.57,0.255-0.765    c0.06-0.194,0.115-0.412-0.058-0.583C28.201,27.482,27.842,27.13,27.761,26.887z" /> <path d="M15.442,14.938c0.137,0.334,0.608,0.336,0.747,0.002c1.677-4.122,5.249-4.927,5.249-9.217    c-0.001-3.286-2.819-5.913-6.169-5.597C11.971,0.437,9.715,3.63,10.29,6.89C10.876,10.201,13.926,11.221,15.442,14.938z     M15.814,2.753c1.64,0,2.969,1.33,2.969,2.969c0,1.64-1.33,2.969-2.968,2.969c-1.64,0-2.969-1.329-2.969-2.969    S14.174,2.753,15.814,2.753z" /> </svg>
                </button>
            </div>
        </div>
    </div>
    <div class="itm item-expandable">
        <div class="layout-fixed">
            <div class="w20px v-top-i lh1">
                <svg class="h12px clr-symbol" viewBox="0 0 448.437 448.437"> <path d="M375.113,0H73.326c-8.319,0-15.088,6.768-15.088,15.086V433.35c0,8.319,6.769,15.087,15.088,15.087h301.787   c8.318,0,15.086-6.768,15.086-15.087V15.087C390.199,6.768,383.431,0,375.113,0z M252.082,48.597h94.273v140.486h-94.273V48.597z    M196.356,399.841h-94.273V259.354h94.273V399.841z M196.356,189.084h-94.273V48.597h94.273V189.084z M346.355,399.841h-94.272   V259.354h94.272V399.841z M346.05,226c0,4.531-3.688,8.219-8.219,8.219h-5.48c-3.256,0-6.064-1.907-7.395-4.658h-19.324   c-1.514,0-2.74-1.227-2.74-2.74v-5.205c0-1.513,1.227-2.74,2.74-2.74h19.324c1.33-2.75,4.141-4.657,7.395-4.657h5.48   c4.531,0,8.219,3.687,8.219,8.219V226z" fill="#FFFFFF" /> </svg>
            </div>
            <div class="v-top-i">
                <div class="text-title-4">Apt #/Unit #</div>
                <div class="text">{{customerDetail.apt_unit}}</div>
            </div>
        </div>
    </div>
    <div class="itm item-expandable">
        <div class="layout-fixed">
            <div class="w20px v-top-i lh1">
                <svg class="h12px clr-symbol" viewBox="0 0 512 512"> <g> <path fill="#81B4DE" d="M0,512h256V0H0V512z M160,64h64v64h-64V64z M160,192h64v64h-64V192z M160,320h64v64h-64V320z M32,64h64v64H32V64z M32,192   h64v64H32V192z M32,320h64v64H32V320z M288,160h224v32H288V160z M288,512h64V384h96v128h64V224H288V512z" /> </g> </svg>
            </div>
            <div class="v-top-i">
                <div class="text-title-4">City</div>
                <div class="text">{{customerDetail.city}}</div>
            </div>
        </div>
    </div>
    <div class="itm item-expandable">
        <div class="layout-fixed">
            <div class="w20px v-top-i lh1">
                <svg class="h12px clr-symbol" viewBox="0 0 21.186 21.186"> <g> <path fill="#81B4DE" d="M0.66,5.918c1.257-0.082,2.383,0.617,3.613,0.3c0.2-0.053,1.23,0.582,0.307,1.269C4.156,7.801,4.072,8.2,3.983,8.721   c-0.146,0.857,0.486,2.077-0.944,2.484c-0.28,0.08-0.013,0.313,0.06,0.452c0.331,0.629,0.285,1.21,0.239,1.935   c-0.053,0.854-0.244,1.561-0.518,2.321c-0.094,0.264-0.108,0.842,0.326,0.847c1.265,0.012,1.526,0.983,2.007,1.823   c0.331,0.577,0.881,1.309,1.591,0.6c1.005-1.004,2.121-1.607,3.494-1.272c2.31,0.564,3.024-1.939,4.797-2.349   c-0.49-1.43,2.429-2.213,0.721-3.925c-0.352-0.354,0.041-0.971,0.324-1.348c0.928-1.244,1.287-3,3.229-3.348   c0.542-0.097,0.968-0.776,1.478-1.146c0.502-0.367,0.426-0.871,0.322-1.333c-0.149-0.68-0.647-0.278-1.041-0.285   c-0.8-0.01-1.639,0.184-2.342-0.481c-0.193-0.185-0.716-0.249-0.951-0.12c-1.238,0.686-2.281-0.076-3.297-0.487   c-0.484-0.196-0.914-0.353-1.439-0.456c-2.021-0.398-4.073-0.101-6.115-0.319C4.322,2.142,2.74,1.635,1.079,1.72   C0.092,1.768,0.002,2.109,0,2.925C-0.002,4.023,1.031,4.842,0.66,5.918z" /> </g> </svg>
            </div>
            <div class="v-top-i">
                <div class="text-title-4">State</div>
                <div class="text">{{customerDetail.state}}</div>
            </div>
        </div>
    </div>
    <div class="itm item-expandable">
        <div class="layout-fixed">
            <div class="w20px v-top-i lh1">
                <svg class="h12px clr-symbol" viewBox="0 0 512 512"> <g> <path fill="#81B4DE" d="M144,274.438L0,192v-32h177.25c11.5,8.188,20.844,19.188,27.188,32H64l80,45.563l64-36.438v36.75L144,274.438z M208,320H32   v-91.281L0,210.438V352h208V320z M384,96c-9,0-19.938,0-32,0v128h-32V64h96V0H288v96c-58.813,0-123.875,0-160,0   c-32.469,0-62.531,12.031-86.063,32H128c43.313,0,82.188,28.125,96,68.875V384h-96H32H0v32h224v96h96v-96h192V192   C495.406,135.125,443.25,96,384,96z" /> </g> </svg>
            </div>
            <div class="v-top-i">
                <div class="text-title-4">Zip code</div>
                <div class="text">{{customerDetail.zipcode}}</div>
            </div>
        </div>
    </div>
    <div class="more-overlay clear" onclick="toggleExpand(this)" ng-click="resizeScroll('scrollCustomerDetail')">
        <div class="h40px layout-fixed w-auto-i center pdT10">
            <div class="text-link-1 pdR10">
                <span class="more-text">See more</span>
                <span class="less-text">See less</span>
            </div>
            <div>
                <button type="button" class="more-icon bg-transparent pd0-i relative">
                    <svg class="h12px clr-symbol-clickable" style="position: absolute; left: 4px; top: 1px" viewBox="0 0 210 210"> <path d="M25,80C11.215,80,0,91.215,0,105s11.215,25,25,25c13.785,0,25-11.215,25-25S38.785,80,25,80z" fill="#F19338 " /> <path d="M105,80c-13.785,0-25,11.215-25,25s11.215,25,25,25c13.785,0,25-11.215,25-25S118.785,80,105,80z" fill="#F19338 " /> <path d="M185,80c-13.785,0-25,11.215-25,25s11.215,25,25,25c13.785,0,25-11.215,25-25S198.785,80,185,80z" fill="#F19338" /> </svg>
                    <svg class="h24px" viewBox="0 0 512 512">  <path style="fill:#1075BB;" d="M196.267,375.467H47.787C24.747,375.467,0,359.253,0,332.8V46.933C0,22.187,23.04,0,47.787,0h417.28  C489.813,0,512,22.187,512,46.933v243.2c0,5.12-3.413,8.533-8.533,8.533c-5.12,0-8.533-3.413-8.533-8.533v-243.2  c0-15.36-14.507-29.867-29.867-29.867H47.787c-15.36,0-30.72,14.507-30.72,29.867V332.8c0,15.36,16.213,25.6,30.72,25.6h148.48  c5.12,0,8.533,3.413,8.533,8.533S201.387,375.467,196.267,375.467" /> <path style="fill:#FDC794;" d="M375.467,512L263.68,396.8c-40.107-40.107-40.107-104.96,0-145.067l0,0  c40.107-40.107,104.96-40.107,145.067,0L512,349.867V512H375.467z" /> <path style="fill:#FFF;" d="M288.427,372.907l35.84,35.84c4.267,4.267,9.387,5.973,15.36,5.973l0,0  c46.933-3.413,83.627-40.107,87.04-87.04l0,0c0-5.973-1.707-11.093-5.973-15.36l-35.84-35.84c-26.453-26.453-69.973-26.453-96.427,0  l0,0C261.12,302.933,261.12,345.6,288.427,372.907" /> <path style="fill:#FFFFFF;" d="M366.933,354.133c-16.213,16.213-24.747,40.96-34.987,58.88c2.56,0.853,5.12,1.707,8.533,0.853  c46.933-3.413,83.627-40.107,87.04-87.04c0-2.56,0-4.267-0.853-6.827h-0.853C407.04,331.093,383.147,337.067,366.933,354.133" /> <path style="fill:#F9A671;" d="M418.133,477.867c-2.56,0-4.267-0.853-5.973-2.56c-3.413-3.413-3.413-8.533,0-11.947l55.467-55.467  c3.413-3.413,8.533-3.413,11.947,0c3.413,3.413,3.413,8.533,0,11.947l-55.467,55.467C422.4,477.013,420.693,477.867,418.133,477.867  " /> </svg>
                </button>
                <button type="button" class="less-icon bg-transparent pd0-i relative">
                    <svg class="h16px clr-symbol-clickable" viewBox="0 0 407.437 407.437"> <polygon points="203.718,84.507 386.258,266.453 407.437,245.205 203.718,42.15 0,245.205 21.179,266.453  " /> <polygon points="0,344.039 21.179,365.287 203.718,183.341 386.258,365.287 407.437,344.039 203.718,140.984  " /> </svg>
                </button>
            </div>
        </div>
    </div>
</div>