﻿
/* ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  ============ EXTENDED METHOD JQUERY ========================
//////////////////////////////////////////////////////////////////////////////////////////////////////////// */
var GLOBAL = {};
GLOBAL["WINDOW_WIDTH"] = $(window).outerWidth();
GLOBAL['WINDOW_HEIGHT'] = $(window).outerHeight();
GLOBAL['WINDOW_SCROLLTOP'] = 0;

$.extend($.expr[":"], {
      "containsIGC": function(elem, i, match, array) {
      return (elem.textContent || elem.innerText || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
      }
});

(function($) {

      $(window).resize(function() {
            GLOBAL["WINDOW_WIDTH"] = $(window).outerWidth();
            GLOBAL['WINDOW_HEIGHT'] = $(window).outerHeight();
      })

      $(window).scroll(function() {
            GLOBAL['WINDOW_SCROLLTOP'] =  $(this).scrollTop();
      })

      $.fn.getCursorPosition = function() {
          var input = this.get(0);
          if (!input) return; // No (input) element found
          if ('selectionStart' in input) {
              // Standard-compliant browsers
              return input.selectionStart;
          } else if (document.selection) {
              // IE
              input.focus();
              var sel = document.selection.createRange();
              var selLen = document.selection.createRange().text.length;
              sel.moveStart('character', -input.value.length);
              return sel.text.length - selLen;
          }
      }

      $.fn.selectAutocomplete = function(options) {
            var $this = this;

            var defaults = {
                  inputPlaceholder: 'Search',
                  showWhenEmpty: true
            };
            var settings = $.extend(defaults, options);

            var $oSelect = $this.find('select');
            $this.hide();
            var oMultiple = $oSelect.attr('multiple');

            var $pInput = $('<div class="selected-input input-field-l-4 full-w">' +
                                          '<div class="input-field">' +
                                                '<input type="text" placeholder="'+settings.inputPlaceholder+'" value="" name="txtSelectedInput" class="full-w">' +
                                          '</div>' +
                                    '</div>');

            var $pSelectedTag = $('<div class="selected-tag clear"></div>');

            var $pSelect = $('<div class="selected-list"></div>');
            $pSelect.hide();
            $oSelect.find('option').each(function() {
                  var value = $(this).attr('value');
                  var text = $(this).text();
                  var selected = $(this).is(':selected');
                  var selectedClass = (selected) ? ' selected' : '';
                  var checkedAttr = (selected) ? ' checked=""' : '';

                  var $pOption;

                  if (typeof oMultiple !== typeof undefined && oMultiple !== false) {
                       $pOption = $('<div class="option layout-fixed '+selectedClass+'"><div class="w20px v-middle-i"><a class="checked-field-2 mgR3"><input type="checkbox" name="ckSelectedList" value="'+value+'" '+checkedAttr+'><i></i></a></div><div><span class="text">'+text+'</span></div></div>');
                       if (selected) {
                             var $pOptionTag = $('<div class="option layout-fixed"><div class="w20px v-middle-i"><a class="checked-field-2 mgR3"><input type="checkbox" name="ckSelectedList" value="'+value+'" checked=""><i></i></a></div><div><span class="text">'+text+'</span></div></div>');
                             $pOptionTag.appendTo($pSelectedTag);
                       }
                  } else {
                        if (value != "") {
                              $pOption = $('<div class="option layout-fixed '+selectedClass+'"><div class="w20px v-middle-i"><a class="radio-field-2 mgR3"><input type="radio" name="ckSelectedList" value="'+value+'" '+checkedAttr+'><i></i></a></div><div><span class="text">'+text+'</span></div></div>');
                        } else {
                              $pOption = $('<div class="option-label"><span class="text">'+text+'</span></div>');
                        }
                  }
                  $pOption.appendTo($pSelect);
            })


            var $pSelectArea = $('<div class="select-pseudo"></div>');
            $pSelectArea.append($pInput);
            if (typeof oMultiple !== typeof undefined && oMultiple !== false) {
                  $pSelectArea.append($pSelectedTag);
            } else {
                  if ($oSelect.val() != "") {
                        $pInput.find('input[type="text"]').val($oSelect.find('option:selected').text());
                  } else {
                        $pInput.find('input[type="text"]').val("");
                  }
            }
            $pSelectArea.append($pSelect);
            $pSelectArea.insertAfter($this);


            $pInput.find('input[type="text"]').on('focus', function() {
                  if (settings.showWhenEmpty) {
                        $pSelect.show();
                  } else {
                        $pSelect.hide();
                  }
            })

            $pInput.find('input[type="text"]').on('keyup', function() {
                  var value = $(this).val();
                  $pSelect.find('> .option').each(function() {
                        $(this).find('.text:containsIGC("'+value+'")').closest('.option').show();
                        $(this).find('.text:not(:containsIGC("'+value+'"))').closest('.option').hide();
                  })
            })

            $pSelect.find('> .option input[name="ckSelectedList"]').click(function() {
                  var checked = $(this).is(':checked');
                  var value = $(this).val();
                  var text = $(this).closest('.option').find('.text').text();

                  if (typeof oMultiple !== typeof undefined && oMultiple !== false) {
                        if (checked) {
                              $(this).closest('.option').addClass('selected');
                              $('<div class="option layout-fixed"><div class="w20px v-middle-i"><a class="checked-field-2 mgR3"><input type="checkbox" name="ckSelectedList" value="'+value+'" checked=""><i></i></a></div><div><span class="text">'+text+'</span></div></div>').appendTo($pSelectedTag);
                              $oSelect.find('option[value="'+value+'"]').prop('selected', 'selected');
                        } else {
                              $(this).closest('.option').removeClass('selected');
                              $pSelectedTag.find('input[value="'+value+'"]').closest('.option').remove();
                              $oSelect.find('option[value="'+value+'"]').removeProp('selected');
                        }
                  } else {
                        $(this).closest('.option').addClass('selected').siblings().removeClass('selected');
                        $oSelect.find('option[value="'+value+'"]').prop('selected', 'selected');
                        $pInput.find('input[type="text"]').val(text);
                  }
            })

            if (typeof oMultiple !== typeof undefined && oMultiple !== false) {
                  $pSelectedTag.delegate('> .option input[name="ckSelectedList"]', 'click', function() {
                        var value = $(this).val();
                        var text = $(this).closest('.option').find('.text').text();
                        $(this).closest('.option').remove();
                        $oSelect.find('option[value="'+value+'"]').removeProp('selected');
                        $pSelect.find('input[value="'+value+'"]').removeProp('checked');
                        $pSelect.find('input[value="'+value+'"]').closest('.option').removeClass('selected');
                  })
            }

            $(window).on("click.Bst", function(e) {
                  if ($pSelectArea.has(e.target).length === 0 && !$pSelectArea.is(e.target)) {
                        $pSelect.stop(true, true).slideUp(100);
                  }
                  if (typeof oMultiple !== typeof undefined && oMultiple !== false) {

                  } else {
                        if ($oSelect.val() != "") {
                              $pInput.find('input[type="text"]').val($oSelect.find('option:selected').text());
                        } else {
                              $pInput.find('input[type="text"]').val("");
                        }
                        $pSelect.find('> .option').show();
                  }
            });
      }

      $.fn.tabNav = function() {
            var $this = this;

            var tabActived = $this.find('.tab-link li.actived').attr('data-tab');

            activeTabContent(tabActived);
            $this.find('.tab-link li').click(function() {
                  tabActived = $(this).attr('data-tab');
                  activeTabLink(tabActived);
                  activeTabContent(tabActived);
            })

            function activeTabLink(tab) {
                  $this.find('.tab-link li[data-tab|="' + tab + '"]').addClass('actived').siblings().removeClass('actived');
            }

            function activeTabContent(tab) {
                  $this.find('.tab-content [data-tab|="' + tab + '"]').show().siblings().hide();
            }
      }

      $.fn.tabNavI = function() {
            var $this = this;

            var tabActived = $this.find('> .tab-link > ul > li.actived').attr('data-tab');

            activeTabContent(tabActived);
            $this.find('> .tab-link > ul > li').click(function() {
                  tabActived = $(this).attr('data-tab');
                  activeTabLink(tabActived);
                  activeTabContent(tabActived);
            })

            function activeTabLink(tab) {
                  $this.find('> .tab-link > ul > li[data-tab|="' + tab + '"]').addClass('actived').siblings().removeClass('actived');
            }

            function activeTabContent(tab) {
                  $this.find('> .tab-content > ul > li[data-tab|="' + tab + '"]').show().siblings().hide();
            }
      }

      /* Checkbox disabled Input  */
      $.fn.toggleDisabled = function(state, s) {
            var $this = this;
            $this.click(function() {
                  var isChecked = $(this).is(':checked');
                  if (state == "on") {
                        if (isChecked) {
                              $.each(s, function(index) {
                                    $(s[index]).attr('disabled', 'disabled');
                              })
                        } else {
                              $.each(s, function(index) {
                                    $(s[index]).removeAttr('disabled');
                              })
                        }
                  } else if (state == "off") {
                        if (isChecked) {
                              $.each(s, function(index) {
                                    $(s[index]).removeAttr('disabled');
                              })
                        } else {
                              $.each(s, function(index) {
                                    $(s[index]).attr('disabled', 'disabled');
                              })
                        }
                  }
            })
      }

      /* Table Respondsive */
      $.fn.tableRespondsive = function(options) {
            var $this = this;

            var defaults = {
                  paging: false,
                  pagingArg: {}
            };
            var settings = $.extend(defaults, options);

            // GLOBAL VARIABLE
            var $rowCaption;
            var $rowsContent;
            var lengthCollumnsCaption;
            var lengthRowsContent;

            var listWidthCollumnsCaption;
            var listTitleCollumnsCaption;
            var listHideWidthCollumnsCaption;


            // RUN
            init();


            // METHOD
            function init() {
                  $this.find('.col.link-row-respondsive').remove();
                  $this.find('.row-respondsive').remove();
                  $rowCaption = getRowCaptionTable();
                  $rowsContent = getRowsContentTable();
                  lengthCollumnsCaption = $rowCaption.find('> .col').length;
                  lengthRowsContent = $rowsContent.length;

                  if (!lengthCollumnsCaption || !lengthRowsContent) return;

                  listWidthCollumnsCaption = getWidthCollumnsCaptionTable();
                  listTitleCollumnsCaption = getTitleCollumnsCaptionTable();

                  // Rearrange Collumns for Content
                  $rowsContent.each(function() {
                        rearrangeCollumnsContentTable($(this));
                  })

                  // Set Width Collumns for Caption
                  setWidthCollumnsTable($rowCaption);

                  // Set Width Collumns for Content
                  $rowsContent.each(function() {
                        setWidthCollumnsTable($(this));
                  })

                  // Create Collumns Responsive Link for Caption
                  var hasCaptionResponsiveLink = $rowCaption.find('> .col.link-row-respondsive').length;
                  if (!hasCaptionResponsiveLink) {
                        createCollumnsResponsiveLink($rowCaption);
                  }

                  // Create Collumns Responsive Link & Rows Content Responsive for Content
                  $rowsContent.each(function() {
                        var hasContentResponsiveLink = $(this).next('.row-respondsive').length;
                        if (!hasContentResponsiveLink) {
                              createLinkRowsResponsiveContentTable($(this));
                        }
                  })

                  listHideWidthCollumnsCaption = getHideWidthCollumnsCaptionTable();

                  responsive();
                  $(window).resize(function() {
                        responsive();
                  })

                  rowMarkChecked();
                  collumnSort();
                  if (settings.paging) {
                      //  paging();
                  }
            }

            function setCallerOnMobile(){
                  using_mobile = navigator.userAgent.match(/(iPad)|(iPhone)|(iPod)|(andRoid)|(Linux)|(webOS)/i) != null;
                  if (using_mobile){
                        $('.onmobile a.inlineb').each(function() {
                              $(this).attr('href', 'tel:' + $(this).prev().text());
                        })
                  }
            }


            function responsive() {
                  // Set Hide Width Collumns for Caption
                  setHideWidthCollumnsTable('caption', $rowCaption);

                  // Set Hide Width Collumns for Content
                  $rowsContent.each(function() {
                        setHideWidthCollumnsTable('content', $(this), $(this).next('.row-respondsive'));
                  })

                  var noCollumnHidden = $rowCaption.find('> .col.hidden:not(".link-row-respondsive")').length;
                  if (noCollumnHidden) {
                        $rowCaption.each(function() {
                              $rowCaption.find('> .col.link-row-respondsive').removeClass('hidden');
                        })

                        // Set Hide Width Collumns for Content
                        $rowsContent.each(function() {
                              $rowsContent.find('> .col.link-row-respondsive').removeClass('hidden');
                        })
                  } else {
                        $rowCaption.each(function() {
                              $rowCaption.find('> .col.link-row-respondsive').addClass('hidden');
                        })

                        // Set Hide Width Collumns for Content
                        $rowsContent.each(function() {
                              $rowsContent.find('> .col.link-row-respondsive').addClass('hidden');
                        })
                  }

                  // Set Auto Width Collumns & Content for Caption
                  setAutoWidthCollumnsTable();
                  setCallerOnMobile();
            }

            function setAutoWidthCollumnsTable() {
                  var noVisibleCollumns = $rowCaption.find('> .col:not(".link-row-respondsive, .hidden")').length;
                  var $visibleCollumnsHasDataWidth = $rowCaption.find('> .col:not(".link-row-respondsive, .hidden")[data-width]');
                  var noVisibleCollumnsHasDataWidth = $visibleCollumnsHasDataWidth.length;
                  var noEmptyVisibleCollumnsHasDataWidth = $rowCaption.find('> .col:not(".link-row-respondsive, .hidden")[data-width=""]').length;

                  if(noVisibleCollumns == noVisibleCollumnsHasDataWidth && noEmptyVisibleCollumnsHasDataWidth == 0) {
                        var indexAutoWidthCollumns = $visibleCollumnsHasDataWidth.filter(':not(".width-fixed"):last').index();
                        $rowCaption.find('> .col:eq('+indexAutoWidthCollumns+')').addClass('width-auto').siblings().removeClass('width-auto');
                        $rowsContent.each(function() {
                              $(this).find('> .col:eq('+indexAutoWidthCollumns+')').addClass('width-auto').siblings().removeClass('width-auto');
                        })
                  } else {
                        $rowCaption.find('> .col').removeClass('width-auto');
                        $rowsContent.each(function() {
                              $(this).find('> .col').removeClass('width-auto');
                        })
                  }
            }

            function createLinkRowsResponsiveContentTable($row) {
                  var $rowsResponsive = createRowsResponsiveContentTable($row);
                  var $collumnResponsive = createCollumnsResponsiveLink($row);
                  $collumnResponsive.click(function() {
                        var $rowRespondsive = $(this).closest('.row').find('> .row-respondsive');
                        var isHidden = $rowRespondsive.is(':hidden');
                        (isHidden) ? $(this).removeClass('maximize').addClass('minimize') : $(this).removeClass('minimize').addClass('maximize');
                        (isHidden) ? $rowsResponsive.removeClass('collapse').addClass('expand') : $rowsResponsive.removeClass('expand').addClass('collapse');
                        $rowsResponsive.slideToggle(200);
                  })
            }

            function setHideWidthCollumnsTable(rowType, $rowContent, $rowResponsive) {
                  if(listHideWidthCollumnsCaption) {
                        for (var i = 0; i < listHideWidthCollumnsCaption.length; i++) {
                              if (GLOBAL["WINDOW_WIDTH"] <= listHideWidthCollumnsCaption[i]["hideWidth"] ) {
                                    $rowContent.find('> .col:eq('+ listHideWidthCollumnsCaption[i]["index"] +')').addClass('hidden');
                                    if (rowType != "caption") {
                                          $rowResponsive.find('> .table-detail .row:eq('+ ( listHideWidthCollumnsCaption[i]["index"] - 1 ) +')').removeClass('hidden');
                                    }
                              } else {
                                    $rowContent.find('> .col:eq('+ listHideWidthCollumnsCaption[i]["index"] +')').removeClass('hidden');
                                    if (rowType != "caption") {
                                          $rowResponsive.find('> .table-detail .row:eq('+ ( listHideWidthCollumnsCaption[i]["index"] - 1 ) +')').addClass('hidden');
                                    }
                              }
                        }
                  }
            }

            function getHideWidthCollumnsCaptionTable() {
                  var results = [];

                  $rowCaption.find('> .col').each(function(index) {
                        var $this = $(this);
                        var hwCollumn = $this.attr('data-hide-width');
                        if (hwCollumn != undefined && hwCollumn != "") {
                              var collumn = {};
                              collumn.index = index;
                              collumn.hideWidth = hwCollumn;
                              results.push(collumn);
                        }

                  })
                  return results;
            }

            function createCollumnsResponsiveLink($row) {
                  var hasResponsiveLink = $row.find('> .col.link-row-respondsive').length;
                  var $collumnResponsive = $('<div class="col link-row-respondsive"><i></i></div>');
                  $collumnResponsive.addClass('hidden').prependTo($row);
                  return $collumnResponsive;
            }

            function createRowsResponsiveContentTable($row) {
                  var $rowsResponsive = $('<div class="row-respondsive"></div>');
                  var $tableResponsive = $('<div class="table-detail table-detail-1"></div>');
                  for (var i = 0; i < listTitleCollumnsCaption.length; i++) {
                        var $rowTableResponsive = $('<div class="row"><div class="caption">'+((listTitleCollumnsCaption[i] == "") ? ' ' : listTitleCollumnsCaption[i]+':') +'</div><div class="content onmobile">'+$row.find('> .col:eq('+i+')').html()+'</div></div>');
                        $rowTableResponsive.addClass('hidden').appendTo($tableResponsive);
                  }
                  $tableResponsive.appendTo($rowsResponsive);
                  $rowsResponsive.insertAfter($row);

                  return $rowsResponsive;
            }

            function setWidthCollumnsTable($row) {
                  if(listWidthCollumnsCaption) {
                        for (var i = 0; i < listWidthCollumnsCaption.length; i++) {
                              $row.find('> .col:eq('+ listWidthCollumnsCaption[i]["index"] +')').css({ width: listWidthCollumnsCaption[i]["width"] });
                        }
                  }
            }

            function rearrangeCollumnsContentTable($row) {
                  var lengthCollumnContent = $row.find('> .col').length;
                  if (lengthCollumnContent > lengthCollumnsCaption) {
                        $row.find('> .col:gt('+(lengthCollumnsCaption - 1)+')').remove();
                  } else if (lengthCollumnContent < lengthCollumnsCaption) {
                        var noShortCollumns = lengthCollumnsCaption - lengthCollumnContent;
                        for (var i = 0; i < noShortCollumns ; i++) {
                              $row.append('<div class="col">-------</div>');
                        }
                  }
            }

            function getTitleCollumnsCaptionTable() {
                  var results = [];
                  $rowCaption.find('> .col').each(function() {
                        var $this = $(this);
                        var titleCollumn = $this.html();
                        results.push(titleCollumn);
                  })
                  return results;
            }

            function getWidthCollumnsCaptionTable() {
                  var results = [];

                  $rowCaption.find('> .col').each(function(index) {
                        var $this = $(this);
                        var wCollumn = $this.attr('data-width');
                        if (wCollumn != undefined && wCollumn != "") {
                              var collumn = {};
                              collumn.index = index;
                              collumn.width = wCollumn;
                              results.push(collumn);
                        }

                  })
                  return results;
            }

            function rowMarkChecked() {

                $this.delegate('[name="ckMarkAll"]', 'click', function () {
                    var isChecked = $(this).is(':checked');
                    var allMarkChecked = $this.find('[name="ckMark"]:checked').length;

                    if (isChecked) {
                       $this.find('[name="ckMark"]').prop('checked', true);
                       $this.find('[name="btnRemoveAll"]').removeClass('disabled');
                       $rowsContent.closest('.row').addClass('selected');
                    } else {
                       $this.find('[name="ckMark"]').prop('checked', false);
                       $this.find('[name="btnRemoveAll"]').addClass('disabled');
                       $rowsContent.closest('.row').removeClass('selected');
                    }

                    if (allMarkChecked == 1) {
                       $this.find('[name="btnEdit"]').removeClass('disabled');
                    } else {
                       $this.find('[name="btnEdit"]').addClass('disabled');
                    }
                })

                $this.delegate('[name="ckMark"]', 'click', function () {
                    var isChecked = $(this).is(':checked');
                    var allMark = $this.find('.row .row-display [name="ckMark"]').length;
                    var allMarkChecked = $this.find('.row .row-display [name="ckMark"]:checked').length;
                    if (isChecked) {
                       $(this).closest('.row').addClass('selected');
                    } else {
                       $(this).closest('.row').removeClass('selected');
                    }
                    if (allMarkChecked == allMark) {
                       $this.find('[name="ckMarkAll"]').prop('checked', true);
                       $this.find('[name="btnRemoveAll"]').removeClass('disabled');
                    } else {
                       $this.find('[name="ckMarkAll"]').prop('checked', false);
                       $this.find('[name="btnRemoveAll"]').addClass('disabled');
                       if (allMarkChecked > 0) {
                           $this.find('[name="btnRemoveAll"]').removeClass('disabled');
                       }
                    }

                    if (allMarkChecked == 1) {
                       $this.find('[name="btnEdit"]').removeClass('disabled');
                    } else {
                       $this.find('[name="btnEdit"]').addClass('disabled');
                    }
                })
            }

            function collumnSort() {
                var $tableCaptionCollumnSort = $rowCaption.find('> .col').filter('.has-sort');
                $tableCaptionCollumnSort.click(function () {
                    $(this).addClass('sorted').siblings().removeClass('sorted asc desc');
                    $(this).hasClass('desc') ? $(this).removeClass('desc').addClass('asc') : $(this).removeClass('asc').addClass('desc');
                })

            }

            function paging() {
                  var $pagingArea = $this.find('.paging');
                  var noPage = Math.ceil(settings.pagingArg.totalRow/settings.pagingArg.rowPerPage);
                  if (noPage == 1) {
                        $pagingArea.remove();
                  } else {
                        var $pagingRow = $pagingArea.find('.list-paging');
                        $pagingRow.empty();

                        var $prev = $('<li class="prev" data-page="'+(settings.pagingArg.currentPage - 1)+'"><a href="">Previous</a></li>');
                        $pagingRow.append($prev);
                        if (settings.pagingArg.currentPage == 1) {
                              $prev.addClass('disabled');
                        }

                        var $prevMore = $('<li class="prev-more none"><a href="">...</a></li>');
                        if (noPage > 10) {
                              $pagingRow.append($prevMore);
                              if (settings.pagingArg.currentPage - 10 > 0) {
                                    $prevMore.removeClass('none');
                              }
                        }

                        for (var i = 1; i <= noPage; i++) {
                              var current = (i == settings.pagingArg.currentPage) ? ' current disabled' : '';
                              var $page = $('<li class="paging-no'+current+'" data-page="'+i+'"><a href="" >'+i+'</a></li>');
                              $pagingRow.append($page);
                        }
                        if ((settings.pagingArg.currentPage - 5 >= 0 && settings.pagingArg.currentPage+5 <= noPage) || (settings.pagingArg.currentPage - 5 >= 0 && settings.pagingArg.currentPage+5 > noPage)) {
                              for (var i = 1; i <= settings.pagingArg.currentPage - 5; i++) {
                                    $pagingRow.find('.paging-no[data-page|="'+i+'"]').addClass('none');
                                    $prevMore.removeClass('none');
                              }
                        }
                        if (settings.pagingArg.currentPage - 5 >= 0 && settings.pagingArg.currentPage+5 > noPage) {
                              for (var i = noPage; i < settings.pagingArg.currentPage + 4; i++) {
                                    $pagingRow.find('.paging-no[data-page|="'+(settings.pagingArg.currentPage - (4) - (i - noPage + 1))+'"]').removeClass('none');
                              }
                        }

                        var $nextMore = $('<li class="next-more none"><a href="">...</a></li>');
                        if (noPage > 10) {
                              $pagingRow.append($nextMore);
                              if (settings.pagingArg.currentPage + 10 < noPage) {
                                    $nextMore.removeClass('none');
                              }
                        }
                        if ((settings.pagingArg.currentPage - 5 >= 0 && settings.pagingArg.currentPage+5 <= noPage) || (settings.pagingArg.currentPage - 5 < 0 && settings.pagingArg.currentPage+5 <= noPage)) {
                              for (var i = settings.pagingArg.currentPage + 5; i <= noPage; i++) {
                                    $pagingRow.find('.paging-no[data-page|="'+i+'"]').addClass('none');
                                    $nextMore.removeClass('none');
                              }
                        }

                        if (settings.pagingArg.currentPage - 5 < 0 && settings.pagingArg.currentPage+5 <= noPage) {
                              for (var i = settings.pagingArg.currentPage; i < 5; i++) {
                                    $pagingRow.find('.paging-no[data-page|="'+(settings.pagingArg.currentPage + (4) + (5-i))+'"]').removeClass('none');
                              }
                        }

                        var $next = $('<li class="next" onclick="'+settings.pagingArg.onclick+'('+(settings.pagingArg.currentPage + 1)+')"  data-page="'+(settings.pagingArg.currentPage + 1)+'"><a href="">Next</a></li>');
                        $pagingRow.append($next);
                        if (settings.pagingArg.currentPage == noPage) {
                              $next.addClass('disabled');
                        }

                        $pagingRow.find('a').attr('href', 'javascript:void(0)');
                  }



            }

            ///////////////////////////////////////////////////////////////////////////

            function isResponsivedRow($row) {
                  return ($row.hasClass('has-respondsive'));
            }

            function setResponsivedRow($row) {
                  $row.addClass('has-respondsive');
            }

            function getRowCaptionTable() {
                  return $this.find('> .caption > .row');
            }

            function getRowsContentTable() {
                  return $this.find('> .content > .row > .row-display');
            }

            function getRowsResponsiveTable() {
                  return $this.find('> .content > .row > .row-respondsive');
            }

            ///////////////////////////////////////////////////////////////////////////

      }

      /* Center Position  */
      $.fn.centerPosition = function(parent) {
            var $this = this;

            var w = $this.outerWidth();
            var h = $this.outerHeight();
            var wParent, hParent;

            center();
            $(window).resize(function() {
                  center();
            })


            function center() {
                  if (parent == "window") {
                        wParent = GLOBAL["WINDOW_WIDTH"];
                        hParent = GLOBAL["WINDOW_HEIGHT"];
                  }

                  if (hParent > h) {
                        $this.css({
                              top: (hParent - h) / 2
                        });
                  } else {
                        $this.css({
                              top: 0
                        });
                  }
                  if (wParent > w) {
                        $this.css({
                              left: (wParent - w) / 2
                        });
                  } else {
                        $this.css({
                              left: 0
                        });
                  }
            }
      }

      /* Toggle Slide */
      $.fn.toggleShow = function(s, options) {
            var $this = this;
            var l = $this.length;
            if (l == 0) {
                  console.log('Item toggle not exist!');
            } else if (l == 1) {
                  var $s = $(s);
                  $this.HANDLE_TOGGLE_ABSOLUTE($s, options);
                  $this.click(function() {
                        toggleHandle($(this), $s, options);
                  });
            } else {
                  var $s = $(this).siblings(s);
                  $this.HANDLE_TOGGLE_ABSOLUTE($s, options);
                  $this.click(function() {
                        $s = $(this).siblings(s);
                        toggleHandle($(this), $s, options);
                  });
            }
      };

      /*******************************************************************************************************************************************/

      $.fn.HANDLE_TOGGLE_ABSOLUTE = function($s, options) {
            var defaults = {
                  effect: "slide", // slide, fade
                  duration: 200,
                  outcollapse: false // out click collapse
            };
            var settings = $.extend(defaults, options);
            var $this = this;

            var isHidden = $s.is(':hidden');
            toggleStyle(isHidden, $this, $s);
      };
      $.fn.HANDLE_OUT_COLLAPSE_ABSOLUTE = function($s, settings) {
            var $this = this;
            $(window).on("click.Bst", function(e) {
                  if ($this.parent().has(e.target).length === 0 && !$this.parent().is(e.target)) {
                        switch (settings.effect) {
                              case 'fade':
                                    $s.stop(true, true).fadeOut(settings.duration);
                                    break;
                              default:
                                    $s.stop(true, true).slideUp(settings.duration);
                                    break;
                        }
                        $this.removeClass('minimize').addClass('maximize');
                        $s.removeClass('expand').addClass('collapse');
                  }
            });
      }

      function toggleHandle($this, $s, settings) {
            console.log('12312312')
            isHidden = $s.is(':hidden');
            switch (settings.effect) {
                  case 'fade':
                        (isHidden) ? $s.stop(true, true).fadeIn(settings.duration): $s.stop(true, true).fadeOut(settings.duration);
                        break;
                  default:
                        $s.stop(true, true).slideToggle(settings.duration);
                        break;
            }
            toggleStyle(!isHidden, $this, $s);
            (settings.outcollapse) ? $this.HANDLE_OUT_COLLAPSE_ABSOLUTE($s, settings): '';
      }

      function toggleStyle(isHidden, $this, $s) {
            (isHidden) ? $this.removeClass('minimize').addClass('maximize'): $this.removeClass('maximize').addClass('minimize');
            (isHidden) ? $s.removeClass('expand').addClass('collapse'): $s.removeClass('collapse').addClass('expand');
      }

}(jQuery));





/* ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
============ NORMAL METHODS =======================================
//////////////////////////////////////////////////////////////////////////////////////////////////////////// */

// Get parameter URL
function getParameterURL(name) {
      name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
      var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
            results = regex.exec(location.search);
      return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
}

// Random generator String
function generateString(string, number) {
      var result = "";
      var sLength = string.length;
      for (var i = 0; i < number; i++) {
            var random = Math.floor((Math.random() * sLength));
            result += string.charAt(random);
      }
      return result;
}
