/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


 function registerPushwooshAndroid() {
 	
 	var pushNotification = cordova.require("pushwoosh-cordova-plugin.PushNotification");

	//set push notifications handler
	document.addEventListener('push-notification',
		function(event,$ionicPopup) {
			var title = event.notification.title;
			var userData = event.notification.userdata;
			console.log(event.notification);
			//dump custom data to the console if it exists
			if (typeof(userData) != "undefined") {
				console.warn('user data: ' + JSON.stringify(userData));
			}
			//alert(JSON.stringify(userData));
			//and show alert
			var user_id=userData.user_id;
			var is_room = userData.is_room==true?'true':'';
			var url= 'chat.html#/board/chat/'+ user_id + '_'+is_room;
			redirectTo(url);
			
			// add plugin window.open by cmd : cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-inappbrowser.git
			// window.open(url_site + '/chats.html?user_id='+user_id, '_system', 'location=yes');
			
			// ionic.Platform.exitApp();
			// //stopping geopushes
			// pushNotification.stopGeoPushes();
		}
		);

	//initialize Pushwoosh with projectid: "GOOGLE_PROJECT_ID", appid : "PUSHWOOSH_APP_ID". This will trigger all pending push notifications on start.
	//pushNotification.onDeviceReady({ projectid: "375612629164", pw_appid : "17882-F2102" });
	//pushNotification.setApplicationIconBadgeNumber(5);
	// //register for push notifications
	// pushNotification.registerDevice(
	// 	function(token) {
	// 		//alert(token);
	// 		//callback when pushwoosh is 
	// 		document.getElementById('deviceToken').value=token;
	// 		onPushwooshAndroidInitialized(token);
	// 	},
	// 	function(status) {
	// 		alert("failed to register: " + status);
	// 		console.warn(JSON.stringify(['failed to register ', status]));
	// 	}
	// 	);
	

  //register for push notifications
  pushNotification.registerDevice(
    function(token) {
      //alert(token);
      //callback when pushwoosh is 
      document.getElementById('deviceToken').value=token;
      onPushwooshAndroidInitialized(token);
    },
    function(status) {
      //alert("failed to register: " + status);
      console.warn(JSON.stringify(['failed to register ', status]));
    }
    );
}

function onPushwooshAndroidInitialized(pushToken) {
	//output the token to the console
	console.warn('push token: ' + pushToken);

	var pushNotification = cordova.require("pushwoosh-cordova-plugin.PushNotification");

	//if you need push token at a later time you can always get it from Pushwoosh plugin
	pushNotification.getPushToken(
		function(token) {
			console.warn('push token: ' + token);
		}
		);

	//and HWID if you want to communicate with Pushwoosh API
	pushNotification.getPushwooshHWID(
		function(token) {
			console.warn('Pushwoosh HWID: ' + token);
		}
		);

	pushNotification.getTags(
		function(tags) {
			console.warn('tags for the device: ' + JSON.stringify(tags));
		},
		function(error) {
			console.warn('get tags error: ' + JSON.stringify(error));
		}
		);


	//set multi notificaiton mode
	pushNotification.setMultiNotificationMode();
	pushNotification.setEnableLED(true);

	//set single notification mode
	//pushNotification.setSingleNotificationMode();

	//disable sound and vibration
	//pushNotification.setSoundType(1);
	//pushNotification.setVibrateType(1);

	pushNotification.setLightScreenOnNotification(false);

	//setting list tags
	//pushNotification.setTags({"MyTag":["hello", "world"]});

	//settings tags
	pushNotification.setTags({
		deviceName: "hello",
		deviceId: 10
	},
	function(status) {
		console.warn('setTags success');
	},
	function(status) {
		console.warn('setTags failed');
	}
	);

	//Pushwoosh Android specific method that cares for the battery
	pushNotification.startGeoPushes();
}
