angular.module('feedtitlesService', []).factory('Feedtiltles', function($http) {
    return {
        getPaging: function(filter) {
            return $http({ method: 'POST', url: url_server + 'feedtitlepaging', data: filter, withCredentials: true });
        },
        getSelect: function() {
            return $http({ method: 'POST', url: url_server + 'feedtitle/getall' });
        },
        getSelect2: function(filter) {
            return $http({ method: 'POST', url: url_server + 'customereviews/search', data: filter });
        },
        show: function(id) {
            return $http.get(url_server + 'feedtitle/' + id, { withCredentials: true });
        },
        save: function(feedtitleData) {
            return $http({
                method: 'POST',
                url: url_server + 'feedtitle',
                data: feedtitleData,
                withCredentials: true
            });
        },
        update: function(id, data) {
            return $http.put(url_server + 'feedtitle/' + id, data, { withCredentials: true });
        },
        destroy: function(id) {
            return $http.delete(url_server + 'feedtitle/' + id, { withCredentials: true });
        }
    };
});
