// GROUP ***
angular.module('appointmentgroupsService',[]).factory('Appointmentgroups',function($http){
	
	return {
		getPaging:function(filter){
			return $http({method:'POST',url:url_server + 'appointmentgroupspaging',data:filter});
		},
		getAppointmenType:function(show_all){
			return $http({method:'POST',url:url_server + 'appointmentstypes', data:show_all});
		},
		getSelect:function(){
			return $http({method:'POST',
				headers:headers,
				url:url_server + 'appointmentgroups/getall',
				withCredentials: true});
			// return $http({method:'POST',url:url_server + 'appointmentgroups/getall'});
		},
		getSelect2:function(filter){
			return $http({method:'POST',url:url_server + 'appointmentgroups/search',data:filter});
		},
		show:function(id){
			return $http.get(url_server+ 'appointmentgroups/'+id);
		},
		getallappointmenttypesbygroup:function(id){
			return $http.get(url_server+ 'appointmentgroups/getalltypesbygroup/'+id);
		},
		save:function(appointmentgroupsData){
			return $http({method:'POST',
				url:url_server+'appointmentgroups',
				data:appointmentgroupsData});
		},
		saveAppointmentType:function(appointmentgroupsData){
			return $http({method:'POST',
				url:url_server+'addappointmenttype',
				data:appointmentgroupsData});
		},
		update:function(id, appointmentgroupsData){
			return $http.put(url_server+'appointmentgroups/'+id,appointmentgroupsData);
		},
		destroy:function(id,status){
			return $http({method:'POST',
				url:url_server+'appointmentgroups/active',
				data:{id:id, status:status}});
		},
		getUserByAppGroupId:function(id){
			
			return $http({method:'POST',
				headers:headers,
				url:url_server + 'appointmentgroups/getusersbyappgroup/'+id,
				withCredentials: true});

			// return $http({method:'POST',url:url_server + 'appointmentgroups/getusersbyappgroup/'+id});
		}
	};
})

// STATUS*****
angular.module('appointmentstatusesService',[]).factory('Appointmentstatuses',function($http){
	
	return {
		getPaging:function(filter){
			return $http({method:'POST',url:url_server + 'appointmentstatusespaging',data:filter});
		},
		getSelect:function(){
			return $http({method:'POST',url:url_server + 'appointmentstatuses/getall'});
		},
		getSelect2:function(filter){
			return $http({method:'POST',url:url_server + 'appointmentstatuses/search',data:filter});
		},
		show:function(id){
			return $http.get(url_server+ 'appointmentstatuses/'+id);
		},
		save:function(appointmentstatusesData){
			return $http({method:'POST',
				headers:headers,
				url:url_server+'appointmentstatuses',
				data:appointmentstatusesData,
				withCredentials: true});
			// return $http({method:'POST',
			// 				url:url_server+'appointmentstatuses',
			// 				data:appointmentstatusesData});
		},
		update:function(id, appointmentstatusesData){
			return $http.put(url_server+'appointmentstatuses/'+id,appointmentstatusesData);
		},
		destroy:function(id){
			return $http.delete(url_server + 'appointmentstatuses/'+id);
		}
	};
});

angular.module('appointmentchecklistsService',[]).factory('Appointmentchecklists',function($http){
	
	return {
		getPaging:function(filter){
			return $http({method:'POST',url:url_server + 'appointmentchecklistspaging',data:filter});
		},
		getSelect:function(){
			return $http({method:'POST',url:url_server + 'appointmentchecklists/getall'});
		},
		getSelect2:function(filter){
			return $http({method:'POST',url:url_server + 'appointmentchecklists/search',data:filter});
		},
		getlastestcell:function(appid){
			return $http({method:'POST',url:url_server + 'appointmentchecklists/latestcell',data:appid,withCredentials: true,headers:headers});
		},
		show:function(id){
			return $http.get(url_server+ 'appointmentchecklists/'+id);
		},
		save:function(appointmentchecklistsData){
			return $http({method:'POST',
				headers:headers,
				url:url_server+'appointmentchecklists',
				data:appointmentchecklistsData,
				withCredentials: true});
		},
		createTaskAuto:function(appointment_id, action, user_id, date){
			return $http({method:'POST',
				url:url_server+'appointmentchecklists/createTaskAuto',
				data:{appointment_id:appointment_id, action:action, user_id:user_id, date:date},
				withCredentials: true});
		},
		update:function(id, appointmentchecklistsData){
			return $http.put(url_server+'appointmentchecklists/'+id,appointmentchecklistsData);
		},
		destroy:function(id){
			return $http.delete(url_server + 'appointmentchecklists/'+id);
		},
		finishChecklist:function(appointmentchecklistsData){
			return $http({method:'POST',
				headers:headers,
				url:url_server+'finishchecklist',
				withCredentials: true,
				data:appointmentchecklistsData});
		},
		saveFWNote:function(data){
			return $http({method:'POST',url:url_server + 'appointmentchecklists/savefieldworkernote',headers:headers,withCredentials: true, data:data});
		},
		sendmail:function(data){
			return $http({method:'POST',url:url_server + 'appointmentchecklists/sendmail',headers:headers,withCredentials: true, data:data});
		},
		saveChecklist:function(data){
			return $http({method:'POST', url:url_server+'appointmentchecklists/savechecklist',headers:headers,withCredentials: true, data:data});
		},
		saveConsumedPart:function(data){
			return $http({method:'POST', url:url_server+'appointmentchecklists/saveconsumedpart',headers:headers,withCredentials: true, data:data});
		}
	};
});

