angular.module('tasksService', []).factory('Tasks', function($http) {
    return {
        getPaging: function(filter) {
            return $http({ method: 'POST', url: url_server + 'taskspaging', data: filter });
        },
        getSelect: function() {
            return $http({ method: 'POST', url: url_server + 'tasks/getall' });
        },
        getSelect2: function(filter) {
            return $http({ method: 'POST', url: url_server + 'tasks/search', data: filter });
        },
        updateassign: function(user_id, task_id) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/updateassign',
                data: { user_id: user_id, task_id: task_id },
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'tasks/updateassign',data:{user_id:user_id, task_id:task_id}});
        },
        updatetask: function(user_id, task_id, action, starttime, endtime, fdate, user_login) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/updatetask',
                data: { user_id: user_id, task_id: task_id, action: action, starttime: starttime, endtime: endtime, fdate: fdate, user_login: user_login },
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'tasks/updatetask',data:{user_id:user_id, task_id:task_id, action:action, starttime:starttime, endtime:endtime, fdate: fdate, user_login:user_login}});
        },
        createSubTask: function(parent_id, user_id) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/createSubTask',
                data: { parent_id: parent_id, user_id: user_id },
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'tasks/createSubTask',data:{parent_id:parent_id, user_id:user_id}});
        },
        getDataGroup: function(data) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/getDataGroup',
                data: { group_id: data },
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'tasks/getDataGroup',data:{group_id:data}});
        },
        updateInputTask: function(data) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/updateInputTask',
                data: { group_id: data },
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'tasks/updateInputTask',data:{group_id:data}});
        },
        delAttached: function(data) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/delAttached',
                data: data,
                withCredentials: true
            });

            // return $http({method:'POST',url:url_server + 'tasks/delAttached',data:data});
        },
        MessageTask: function(task_id, msg, user_id, type) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/MessageTask',
                data: { task_id: task_id, msg: msg, user_id: user_id, type: type },
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'tasks/MessageTask',data:{task_id:task_id, msg:msg, user_id:user_id, type:type}});
        },
        getListSubTask: function(task_id) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/getListSubTask',
                data: { task_id: task_id },
                withCredentials: true
            });

            // return $http({method:'POST',url:url_server + 'tasks/getListSubTask',data:{task_id:task_id}});
        },
        sendmail: function(task_id, action, userLogin, url) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/sendmail',
                data: { task_id: task_id, action: action, userLogin: userLogin, url: url },
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'tasks/sendmail',data:{task_id:task_id, action:action, userLogin:userLogin, url:url}});
        },
        createHistory: function(task_id, comments) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/createHistory',
                data: { task_id: task_id, comments: comments },
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'tasks/createHistory',data:{task_id:task_id, comments:comments}});
        },
        loadMoreTask: function(action, paging, user_id) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/loadmoretask',
                data: { user_id: user_id, action: action, paging: paging },
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'tasks/loadmoretask',data:{user_id:user_id,action:action,paging:paging}});
        },
        getHistory: function(task_id, comments) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/getHistory',
                data: { task_id: task_id },
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'tasks/getHistory',data:{task_id:task_id}});
        },
        Reassign_task_group: function(task_id, group_id) {
            return $http({ method: 'POST', url: url_server + 'tasks/Reassign_task_group', data: { task_id: task_id, group_id: group_id } });
        },
        uploadfile: function(file) {
            return Upload.upload({ method: 'POST', url: url_server + 'tasks/uploadfile', file: file });
        },
        show: function(id, phoneApp) {
            return $http({
                method: 'GET',
                headers: headers,
                url: url_server + 'tasks/' + id,
                params: { phoneApp: phoneApp },
                withCredentials: true
            });
            // return $http.get(url_server+ 'tasks/'+id);
        },
        save: function(tasksData) {
            return $http({
                method: 'POST',
                url: url_server + 'tasks',
                data: tasksData
            });
        },
        createTask: function(tasksData, id) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/createTask',
                data: { tasksData: tasksData, id: id },
                withCredentials: true
            });
            // return $http({method:'POST',
            //              url:url_server+'tasks/createTask',
            //              data:{tasksData:tasksData, id:id}});
        },
        getdataTask: function(user_id, incompletepaging, upcomingpaging, followingpaging, downtimepaging, completepaging, search, notification_task_id) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/getdataTask',
                data: {
                    user_id: user_id,
                    incompletepaging: incompletepaging,
                    upcomingpaging: upcomingpaging,
                    followingpaging: followingpaging,
                    downtimepaging: downtimepaging,
                    completepaging: completepaging,
                    search: search,
                    notification_task_id: notification_task_id
                },
                withCredentials: true
            });

            // return $http({method:'POST',
            //              url:url_server+'tasks/getdataTask',
            //              data:{user_id:user_id,incompletepaging:incompletepaging, upcomingpaging:upcomingpaging, followingpaging:followingpaging, downtimepaging:downtimepaging, completepaging:completepaging, notification_task_id:notification_task_id}});
        },
        update: function(id, tasksData) {
            return $http.put(url_server + 'tasks/' + id, tasksData);
        },
        destroy: function(id) {
            return $http.delete(url_server + 'tasks/' + id, {
                headers: headers,
                withCredentials: true
            });

            // return $http.delete(url_server + 'tasks/'+id);
        },
        changetype: function(oTask) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasks/changetype',
                data: { task: oTask },
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'tasks/changetype',data:{}});
        }
    };
});

// TASK STATUS SERVICE
angular.module('taskstatusesService', []).factory('Taskstatuses', function($http) {
    return {
        getPaging: function(filter) {
            return $http({ method: 'POST', url: url_server + 'taskstatusespaging', data: filter });
        },
        getSelect: function() {
            return $http({ method: 'POST', url: url_server + 'taskstatuses/getall' });
        },
        getSelect2: function(filter) {
            return $http({ method: 'POST', url: url_server + 'taskstatuses/search', data: filter });
        },
        show: function(id) {
            return $http.get(url_server + 'taskstatuses/' + id);
        },
        save: function(taskstatusesData) {
            return $http({
                method: 'POST',
                url: url_server + 'taskstatuses',
                data: taskstatusesData
            });
        },
        update: function(id, taskstatusesData) {
            return $http.put(url_server + 'taskstatuses/' + id, taskstatusesData);
        },
        destroy: function(id) {
            return $http.delete(url_server + 'taskstatuses/' + id);
        }
    };
});

// TASK TYPE SERVICE
angular.module('tasktypesService', []).factory('Tasktypes', function($http) {
    return {
        getPaging: function(filter) {
            return $http({ method: 'POST', url: url_server + 'tasktypespaging', data: filter });
        },
        getSelect: function() {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'tasktypes/getall',
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'tasktypes/getall'});
        },
        getSelect2: function(filter) {
            return $http({ method: 'POST', url: url_server + 'tasktypes/search', data: filter });
        },
        show: function(id) {
            return $http.get(url_server + 'tasktypes/' + id);
        },
        save: function(tasktypesData) {
            return $http({
                method: 'POST',
                url: url_server + 'tasktypes',
                data: tasktypesData
            });
        },
        update: function(id, tasktypesData) {
            return $http.put(url_server + 'tasktypes/' + id, tasktypesData);
        },
        destroy: function(id) {
            return $http.delete(url_server + 'tasktypes/' + id);
        }
    };
});

// TASK COMMENT SERVICE
angular.module('taskcommentsService', []).factory('Taskcomments', function($http) {
    return {
        getPaging: function(filter) {
            return $http({ method: 'POST', url: url_server + 'taskcommentspaging', data: filter });
        },
        getSelect: function() {
            return $http({ method: 'POST', url: url_server + 'taskcomments/getall' });
        },
        getSelect2: function(filter) {
            return $http({ method: 'POST', url: url_server + 'taskcomments/search', data: filter });
        },
        show: function(id) {
            return $http({
                method: 'GET',
                headers: headers,
                url: url_server + 'taskcomments/' + id,
                withCredentials: true
            });

            // return $http.get(url_server+ 'taskcomments/'+id);
        },
        save: function(taskcommentsData) {
            return $http({
                method: 'POST',
                url: url_server + 'taskcomments',
                data: taskcommentsData
            });
        },
        update: function(id, taskcommentsData) {
            return $http.put(url_server + 'taskcomments/' + id, taskcommentsData);
        },
        destroy: function(id) {
            return $http.delete(url_server + 'taskcomments/' + id);
        }
    };
});
angular.module('taskfilterService', []).factory('Taskfilters', function($http) {
    customer_id = 0;
    return {
        filter: function(filter) {
            return $http({ method: 'POST', url: url_server + 'taskfilters', data: filter, withCredentials: true });
        },
        savefilter: function(filter) {
            return $http({ method: 'POST', url: url_server + 'savequerytaskfilters', data: filter, withCredentials: true });
        },
        getAllTaskQuery: function() {
            return $http({ method: 'POST', url: url_server + 'gettaskquery', withCredentials: true });
        },
        updateTaskQuery: function(id, dataquerytask) {
            return $http.put(url_server + 'updatetaskquery/' + id, dataquerytask, { withCredentials: true });
        },
        destroy: function(id) {
            return $http.delete(url_server + 'taskquery/' + id, { withCredentials: true });
        },
        getDefaultTask: function(filter) {
            return $http({ method: 'POST', url: url_server + 'getdefaulteatatask', data: filter, withCredentials: true });
        }
    }

});
