angular.module('settingsService',[]).factory('Settings',function($http){
	var headers = {'Access-Control-Allow-Origin' : '*'};
	return {
		getPaging:function(filter){
			return $http({method:'POST',
				headers:headers,
				url:url_server + 'settingspaging',
				data:filter,
				withCredentials: true});
			// return $http({method:'POST',url:url_server + 'settingspaging',data:filter});
		},
		getSelect:function(){
			return $http({method:'POST',url:url_server + 'settings/getall'});
		},
		getSelect2:function(filter){
			return $http({method:'POST',url:url_server + 'settings/search',data:filter});
		},
		getDataTaskGroup:function(current, rows, show_all){
			return $http({method:'POST',
				headers:headers,
				url:url_server + 'settings/getDataTaskGroup',
				data:{current:current, rows:rows, show_all:show_all},
				withCredentials: true});
			// return $http({method:'POST',url:url_server + 'settings/getDataTaskGroup', data:{current:current, rows:rows, show_all:show_all}});
		},
		show:function(id){
			return $http.get(url_server+ 'settings/'+id);
		},
		save:function(settingsData){
			return $http({method:'POST',
							url:url_server+'settings',
							data:settingsData});
		},
		addCoupon:function(data){
			return $http({method:'POST',
							url:url_server+'settings/addCoupon',
							data:data,headers:headers,withCredentials: true});
		},
		deleteCoupon:function(id, status){
			return $http({method:'POST',
							url:url_server+'settings/deleteCoupon',
							data:{id:id, status:status},headers:headers,withCredentials: true});
		},
		editCoupon:function(data){
			return $http({method:'POST',
							url:url_server+'settings/editCoupon',
							data:data,headers:headers,withCredentials: true});
		},
		getEditCoupon:function(id){
			return $http({headers:headers,method:'POST',
							url:url_server+'settings/getEditCoupon',
							data:{id:id},withCredentials: true});
		},
		saveusernewfeed:function(newfeed, userlogin){
			return $http({method:'POST',
							url:url_server+'settings/saveusernewfeed',
							data:{newfeed:newfeed, userlogin:userlogin},
							withCredentials: true});
		},
		createTaskGroup:function(data){
			return $http({method:'POST',
				headers:headers,
				url:url_server + 'settings/createTaskGroup',
				data:data,
				withCredentials: true});
			
			// return $http({method:'POST',
			// 				url:url_server+'settings/createTaskGroup',
			// 				data:data});
		},
		getCoupon:function(show){
			return $http({headers:headers,method:'POST',url:url_server + 'settings/getCoupon', data:{show:show},withCredentials: true});
		},
		EditTaskGroup:function(assign, name, status, id, follow){
			return $http({method:'POST',
				headers:headers,
				url:url_server + 'settings/EditTaskGroup',
				data:{assign:assign, name:name, status:status, id:id, follow:follow},
				withCredentials: true});
			
			// return $http({method:'POST',
			// 				url:url_server+'settings/EditTaskGroup',
			// 				data:{assign:assign, name:name, status:status, id:id, follow:follow}});
		},
		update:function(id, settingsData){
			return $http.put(url_server+'settings/'+id,settingsData);
		},
		DeleteTaskGroup:function(id,status){
			return $http({method:'POST',
				headers:headers,
				url:url_server + 'settings/DeleteTaskGroup',
				data:{id:id, status:status},
				withCredentials: true});
			// return $http({method:'POST',url:url_server + 'settings/DeleteTaskGroup',data:{id:id, status:status}});
		},
		destroy:function(id){
			return $http.delete(url_server + 'settings/'+id);
		},
		getFeedTitle:function(){
			return $http({method:'POST',
				headers:headers,
				url:url_server + 'settings/getFeedTitle',
				withCredentials: true});
			// return $http({method:'POST',url:url_server + 'settings/getFeedTitle'});
		},
		getCriteria:function(){
			return $http.get(url_server+ 'settingsloadcriteria',{withCredentials: true});
		},
		updateCriteria:function(settingsData){
			return $http({method:'POST',
							url:url_server+'settingsupdatecriteria',
							data:settingsData,
							withCredentials: true});
		},
		loadMarketingMessage:function(){
			return $http({method:'GET',
				headers:headers,
				url:url_server + 'settingsloadmarketingmessage',
				withCredentials: true});
			// return $http.get(url_server+ 'settingsloadmarketingmessage');
		},
		updatemarketingmessage:function(settingsData){
			return $http({method:'POST',
				headers:headers,
				url:url_server + 'settingsloadmarketingmessage',
				data:settingsData,
				withCredentials: true});
			// return $http({method:'POST',
			// 				url:url_server+'settingsloadmarketingmessage',
			// 				data:settingsData});
		},
	};
});
