angular.module('ordersService', []).factory('Orders', function ($http) {
    return {
        getPaging: function (filter) {
            return $http({
                method: 'POST',
                url: url_server + 'orderspaging',
                data: filter,
                headers: headers,
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'orderspaging',data:filter});
        },
        getSelect: function () {
            return $http({
                method: 'POST',
                url: url_server + 'orders/getall'
            });
        },
        getSelect2: function (filter) {
            return $http({
                method: 'POST',
                url: url_server + 'orders/search',
                data: filter,
                withCredentials: true,
                headers: headers
            });
        },
        show: function (id) {
            return $http.get(url_server + 'orders/' + id);
        },
        save: function (ordersData) {
            return $http({
                method: 'POST',
                url: url_server + 'orders',
                data: ordersData,
                headers: headers,
                withCredentials: true
            });
        },
        update: function (id, ordersData) {
            return $http.put(url_server + 'orders/' + id, ordersData);
        },
        destroy: function (id) {
            return $http.delete(url_server + 'orders/' + id);
        },
        getByAppointment: function (app_id) {
            return $http({
                method: 'POST',
                url: url_server + 'orders/getappid',
                data: {
                    app_id: app_id
                },
                headers: headers,
                withCredentials: true
            });
        },
        sendMail: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'orders/sendmailtocustomer',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        }
    };
});
// ORDERTYPES ***
angular.module('ordertypesService', []).factory('Ordertypes', function ($http) {
    return {
        getPaging: function (invoice_id) {
            return $http({
                method: 'POST',
                url: url_server + 'ordertypespaging',
                data: {
                    invoice_id: invoice_id
                },
                withCredentials: true,
                headers: headers
            });
        },
        getSelect: function () {
            return $http({
                method: 'POST',
                url: url_server + 'ordertypes/getall',
                headers: headers,
                withCredentials: true
            });
        },
        getSelect2: function (filter) {
            return $http({
                method: 'POST',
                url: url_server + 'ordertypes/search',
                data: filter,
                headers: headers,
                withCredentials: true
            });
        },
        getDataProduct: function (id, service, action) {
            return $http({
                method: 'POST',
                url: url_server + 'ordertypes/getDataProduct',
                data: {
                    id: id,
                    service: service,
                    action : action
                },
                headers: headers,
                withCredentials: true
            });
        },
        export_file_pdf: function (order_id, action, mail, Jobsite_id, user_id) {
            return $http({method: 'POST', url: url_server + 'ordertypes/export_file_pdf',
                headers: headers,
                data: {user_id: user_id, order_id: order_id, Jobsite_id: Jobsite_id, action: action, mail: mail},
                headers: headers,
                withCredentials: true});
        },
        sentDataPayment: function (data) {
            return $http({
                method: 'POST',
                url: url_server + 'ordertypes/braintreeCreate',
                data: data,
                headers: headers,
                withCredentials: true
            });
        },
        insertSignature: function (order_id, data) {
            return $http({
                method: 'POST',
                url: url_server + 'ordertypes/insertSignature',
                data: {
                    order_id: order_id,
                    data: data
                },
                headers: headers,
                withCredentials: true
            });
        },
        getSignature: function (data) {
            return $http({
                method: 'POST',
                url: url_server + 'ordertypes/getSignature',
                data: data,
                headers: headers,
                withCredentials: true
            });
        },
        insertpaymenthistories: function (data, ChargeDate, list_id) {
            return $http({
                method: 'POST',
                url: url_server + 'ordertypes/insertpaymenthistories',
                headers: headers,
                withCredentials: true,
                data: {
                    list_id: list_id,
                    data: data,
                    ChargeDate: ChargeDate
                }
            });
        },
        check_invoice: function (order_id) {
            return $http({
                method: 'POST',
                url: url_server + 'ordertypes/check_invoice',
                data: {
                    order_id: order_id
                },
                headers: headers,
                withCredentials: true
            });
        },
        show: function (id) {
            return $http.get(url_server + 'ordertypes/' + id);
        },
        // save: function (invoiceData, Discount, Subtotal, id, user_id, refund, total, duedate, couponprice, coupon_id,service_id,store_location) {
        //     return $http({method: 'POST',
        //         url: url_server + 'ordertypes',
        //         data: {invoiceData: invoiceData, Discount: Discount, Subtotal: Subtotal, id: id, user_id: user_id, refund: refund,
        //             total: total, duedate: duedate, couponprice: couponprice, coupon_id: coupon_id,service_id:service_id,store_location:store_location},
        //             headers: headers,
        //             withCredentials: true
        //         });
        // },
        save: function (data) {
            return $http({method: 'POST',
                url: url_server + 'ordertypes',
                data: data,
                headers: headers,
                withCredentials: true
            });
        },
        update: function (id, ordertypesData) {
            return $http.put(url_server + 'ordertypes/' + id, ordertypesData);
        },
        destroy: function (id) {
            return $http.delete(url_server + 'ordertypes/' + id);
        },
        SaveWellFargoPlan: function (data) {
            return $http({withCredentials: true, method: 'POST', url: url_server + 'ordertypes/SaveWellFargoPlan',headers: headers, data: data});
        },
        checkReverToEstimate:function(data){
            return $http({method:'POST',url:url_server + 'ordertypes/checkrevertoestimate',data:data,headers: headers,withCredentials: true});
        },
        getInvoiceByCustomerId:function(data){
            return $http({method:'POST',url:url_server + 'ordertypes/getinvoicebycustomerid',data:data,headers: headers,withCredentials: true});
        },
        tranferPayment:function(data){
            return $http({method:'POST',url:url_server + 'ordertypes/tranferpayment',data:data,headers: headers,withCredentials: true});
        },
        reverttosaleorder:function(data){
            return $http({method:'POST',url:url_server + 'ordertypes/reverttosaleorder',data:data,headers: headers,withCredentials: true});
        },
        createSplitPayment:function(data){
            return $http({method:'POST',url:url_server + 'ordertypes/createSplitPayment',data:data,headers: headers,withCredentials: true});
        }
        
    };
});
angular.module('saleorderService', []).factory('Saleorder', function ($http) {
    return {
        check_saleorder:function(saleorder_id){
            return $http({method:'POST',
                url:url_server + 'saleorder/check_saleorder',
                headers: headers,
                withCredentials: true,
                data:{saleorder_id:saleorder_id}});
        },getPaging:function(saleorder_id){
            return $http({method:'POST',
                url:url_server + 'saleorderpaging',
                headers: headers,
                withCredentials: true,
                data:{saleorder_id:saleorder_id}});
        },
        getSignature:function(id){
            return $http({method:'POST',
                url:url_server + 'saleorder/getSignature',
                headers: headers,
                withCredentials: true,
                data:{id:id}});
        },
        convertToInvoice:function(id){
            return $http({method:'POST',
                url:url_server + 'saleorder/converttoinvoice',
                headers: headers,
                withCredentials: true,
                data:{id:id}});
        }
    };
});
// STATUS *****
angular.module('orderstatusesService', []).factory('Orderstatuses', function ($http) {
    return {
        getPaging: function (id,getNewPrice) {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatusespaging',
                data: {
                    id: id,
                    getNewPrice:getNewPrice
                },
                headers: headers,
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'orderstatusespaging',data:{id:id}});
        },
        getSelect: function () {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses/getall'
            });
        },
        getSelect2: function (filter) {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses/search',
                data: filter
            });
        },
        getTypeOfService: function () {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses/getTypeOfService',
                headers: headers,
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'orderstatuses/getTypeOfService'});
        },
        getRepresentative: function (user_id, estimate_id, customer_id) {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses/getRepresentative',
                data: {
                    user_id: user_id,
                    estimate_id: estimate_id,
                    customer_id: customer_id
                },
                headers: headers,
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'orderstatuses/getRepresentative', data:{user_id:user_id, estimate_id:estimate_id, customer_id:customer_id}});
        },
        opportunitiesExport: function (order_id, name) {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses/opportunitiesExport',
                data: {
                    order_id: order_id,
                    name: name
                },
                headers: headers,
                withCredentials: true
            });
        },
        check_Appointment_customer: function (customer_id, appointment_id, estimate_id) {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses/check_Appointment_customer',
                data: {
                    customer_id: customer_id,
                    appointment_id: appointment_id,
                    estimate_id: estimate_id
                },
                headers: headers,
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'orderstatuses/check_Appointment_customer', data:{customer_id:customer_id, appointment_id:appointment_id, estimate_id:estimate_id}});
        },
        getEstimateNumber: function (appointment_id) {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses/getEstimateNumber',
                data: {
                    appointment_id: appointment_id
                },
                headers: headers,
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'orderstatuses/getEstimateNumber', data:{appointment_id:appointment_id}});
        },
        create_task: function (mail, user_id, appointment_id, action, customer_id, link, order_id) {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses/create_task',
                data: {
                    order_id: order_id,
                    link: link,
                    user_id: user_id,
                    mail: mail,
                    appointment_id: appointment_id,
                    action: action,
                    customer_id: customer_id
                },
                headers: headers,
                withCredentials: true
            });
        },
        updateComment: function (data, id) {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses/updateComment',
                data: {
                    data: data,
                    id: id
                },
                headers: headers,
                withCredentials: true
            });
        },
        getProducttoByname: function (name) {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses/getProducttoByname',
                data: {
                    name: name
                },
                headers: headers,
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'orderstatuses/getProducttoByname', data:{name:name}});
        },
        getcustomermail: function (customer_id) {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses/getcustomermail',
                data: {customer_id: customer_id},
                headers: headers,
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'orderstatuses/getcustomermail', data:{customer_id:customer_id}});
        },
        saveMeasurements: function (id, product_id, data) {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses/saveMeasurements',
                data: {
                    id: id,
                    product_id: product_id,
                    data: data
                },
                headers: headers,
                withCredentials: true
            });
        },
        show: function (id) {
            return $http.get(url_server + 'orderstatuses/' + id);
        },
        save: function (orderstatusesData) {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses',
                data: orderstatusesData,
                headers: headers,
                withCredentials: true
            });
        },
        update: function (id, orderstatusesData) {
            return $http.put(url_server + 'orderstatuses/' + id, orderstatusesData);
        },
        destroy: function (id) {
            return $http.delete(url_server + 'orderstatuses/' + id);
        },
        ViewAllOrder: function (id) {
            return $http({method: 'POST', url: url_server + 'orderstatuses/ViewAllOrder', data: {id: id},headers: headers, withCredentials: true});
        },
        changeServiceLocation: function (Jobsite_id, order_id) {
            return $http({headers: headers,withCredentials: true, method: 'POST', url: url_server + 'orderstatuses/changeServiceLocation', data: {Jobsite_id: Jobsite_id, order_id: order_id}});
        },
        viewEstimatePdf: function (data) {
            return $http({method: 'POST', url: url_server + 'orderstatuses/viewestimatepdf',
                data: data,
                headers: headers,
                withCredentials: true});
        },
        getCornerstyles:function(){
            return $http({method:'POST',url:url_server + 'orderstatuses/getcornerstyles',headers: headers,withCredentials: true});
        },
        createToSchedule:function(data){
            return $http({method:'POST',url:url_server + 'orderstatuses/createtoschedule',data:data,headers: headers,withCredentials: true});
        }
    };
});
// Appointments
angular.module('appointmentsService', []).factory('Appointments', function($http, $cordovaFileTransfer,$ionicLoading) {

    return {
        getPaging: function(filter) {
            return $http({
                method: 'POST',
                url: url_server + 'appointmentspaging',
                data: filter
            });
        },
        getCriteria:function(){
            return $http({
                method: 'GET',
                headers: headers,
                url: url_server+ 'settingsloadcriteria',
                withCredentials: true
            });
        },
        getListToSchedule: function(filter) {

            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'appointments/getlisttochedule',
                data: filter,
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'appointments/getlisttochedule',data:filter});
        },
        getAppoinmentByDay: function(filter) {

            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'appointments/getappoinmentbyday',
                data: filter,
                withCredentials: true
            });
            // return $http({method:'POST',url:url_server + 'appointments/getappoinmentbyday',data:filter});
        },
        checkReloadCalendar: function(filter) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/checkreloadcalendar',
                data: filter
            });
        },
        getSelect: function() {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/getall'
            });
        },
        getSelect2: function(filter) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/search',
                data: filter
            });
        },
        getAppointmentType: function(search) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/getAppointmentType',
                data: {
                    search: search
                }
            });
        },
        searchAppointment: function(filter) {
           return $http({
            method: 'POST',
            headers: headers,
            url: url_server + 'appointments/searchappointment',
            data: filter,
            withCredentials: true
        });
            // return $http({
            //     method: 'POST',
            //     url: url_server + 'appointments/searchappointment',
            //     data: filter
            // });
        },
        checkappointment_id: function(appointment_id) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/checkappointment_id',
                data: {
                    appointment_id: appointment_id
                }
            });
        },
        appointmentshistory: function(id) {
            return $http.get(url_server + 'appointmentshistory/' + id);
        },
        show: function(id) {

            return $http({
                method: 'GET',
                headers: headers,
                url: url_server + 'appointments/' + id,
                withCredentials: true
            });
            // return $http.get(url_server+ 'appointments/'+id);
        },
        getDataHoverAppCell: function(id) {
            return $http.get(url_server + 'appointmentcellhover/' + id);
        },
        viewUnavailable: function(val) {
            return $http.get(url_server + 'appointments/viewunavailable/' + val);
        },
        showDataToSchedule: function(id) {
            //return $http.get(url_server + 'appointments/getdatatoschedule/' + id);
            return $http({
                method: 'GET',
                url: url_server + 'appointments/getdatatoschedule/' + id,
                headers:headers,
                withCredentials: true
            });
        },
        save: function(appointmentsData) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments',
                data: appointmentsData,
                headers:headers,
                withCredentials: true
            });
        },
        getZillow: function(data) {

            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'appointments/zillow',
                data: data,
                withCredentials: true
            });
            // return $http({method:'POST',
            //              url:url_server+'appointments/zillow',
            //              data:data});
        },
        update: function(id, appointmentsData) {

            return $http.put(url_server + 'appointments/' + id, appointmentsData, {
                headers: headers,
                withCredentials: true
            });
            // return $http.put(url_server+'appointments/'+id,appointmentsData);
        },
        assignToNewFieldworker: function(id, appointmentsData) {
            return $http.put(url_server + 'appointments/assigntonewfieldworker/' + id, appointmentsData);
        },
        checkInAppoimentGroup: function(id, appointmentsData) {
            return $http.put(url_server + 'appointments/checkinappoimentgroup/' + id, {
                appointmentgroupsId: appointmentsData
            });
        },
        cancelAndRedoAppoiment: function(appoinmentId, currentStatus) {
            return $http.put(url_server+'appointments/cancelandredoappoiment/'+appoinmentId,{currentStatus: currentStatus}, {
                headers:headers, withCredentials: true });
            
            // return $http.put(url_server + 'appointments/cancelandredoappoiment/' + appoinmentId, {
            //     currentStatus: currentStatus
            // });
        },
        checkAppoimentIsPending: function(id) {
            return $http.put(url_server + 'appointments/checkappoimentispending/' + id);
        },
        appointmentCellChange: function(id, appointmentsData) {
            return $http.put(url_server + 'appointments/cellchange/' + id, appointmentsData,{headers: headers,withCredentials: true});
        },
        arrivalConfirm: function(id, appointmentsData) {
            return $http.put(url_server + 'appointments/arrivalconfirm/' + id, appointmentsData);
        },
        destroy: function(id) {
            return $http.delete(url_server + 'appointments/' + id);
        },
        upLoadFileMan: function($oData, $oFile) {    
            // return $http({
            //     method: 'POST',
            //     headers: headers,
            //     url: url_server + 'appointments/upLoadFileMan',
            //     data: {
            //         fields: $oData,
            //         file: $oFile
            //     },
            //     withCredentials: true
            // });
            // return Upload.upload({url: url_server+'appointments/upLoadFileMan', fields: $oData, file: $oFile});
        },
        AddEditWorkingInvoice:function(appointment_id, order_id){
            return $http({method:'POST',
                url:url_server+'appointments/AddEditWorkingInvoice',
                data:{appointment_id:appointment_id, order_id:order_id},
                headers: headers,
                withCredentials: true
            });
        },
        showDowntimeTask: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/showdowntimetask',
                data: data,
                headers: headers,
                withCredentials: true
            });
        },
        replaceNewAddress: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/replacenewaddress',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        updateFlagNote: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/updateflagnote',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        sendMail: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/sendmailtocustomer',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        saveAndLoadOfficeNote: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/saveandloadofficenote',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        saveAndLoadFieldWorkerNote: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/saveandloadfieldworkernote',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        updateAppointmentInfor: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/updateappointmentinfor',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        getAppHistoryDetailByAppId: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/getapphistorydetailbyappid',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        }
        ,
        getAllEstimateInvoiceId: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/getallestimateinvoiceid',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        createPdfOrderByOrderId: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/createpdforderbyorderid',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        deleteFileOnViewer: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/deletefileonviewer',
                data: data,
                withCredentials: true,
                headers: headers,
            });
        },
        createToSchedule: function(appointmentsData) {
            return $http({
                method: 'POST',
                url: url_server + 'orderstatuses/createtoschedule',
                data: appointmentsData,
                withCredentials: true,
                headers: headers
            });
        },
        createPdfFile: function(appointmentsData) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/createpdffile',
                data: appointmentsData,
                withCredentials: true,
                headers: headers
            });
        },
        fileAddUrl: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'appointments/fileaddurl',
                data: data,
                withCredentials: true,
                headers: headers
            });
        },
        getFilesByAppid: function(id) {
            return $http({
                method: 'GET',
                url: url_server + 'appointmentsfilebyId/' + id,
                withCredentials: true,
                headers: headers
            });
        },
        getAppUrlByAppid: function(id) {
            return $http({
                method: 'GET',
                url: url_server + 'getAppUrlByAppid/' + id,
                withCredentials: true,
                headers: headers
            });
        }
    };
});
