var page = "opportunities.html";
var opportunityApp = angular.module('opportunityApp', ['menuController', 'chatController', 'customerController', 'customertypesService',//
    'authenticationSvc', 'leadsourcesService', 'opportunitytabsService', 'flagsService', 'opportunitiesService', //
    'groupsService', 'tabSlideBox', 'jobsitesService', 'customersService', 'callaheadsService', 'flexiblecustomersService', //
    'AppointmentsController', 'appointmentsService', 'listviewusersService', 'appointmentstatusesService', //
    'notetasksCtrl', 'notetasksService', 'notetasktypesService', 'ngSanitize', 'ivh.treeview',//
    'tasksService', 'ordertypesService', 'ordersService', 'orderstatusesService', //
    'notifiesCtrl','soundsService','chatsettingsService','userchatstatusesService','LocationServiceModulues','ngTagsInput','chatApp',
    'checklistController', 'checklistsService', 'servicesService','ui.taginput', 'appointmentchecklistsService', 'customerfilesService', 'doubleTap'
]);

opportunityApp.run(function ($ionicPlatform, $ionicLoading) {
    $ionicLoading.show({ template: templateLoading });
    $ionicPlatform.ready(function () {
        var devicePlatform = "";
        try {
            devicePlatform = device.platform;
        } catch (err) {
            console.log(err)
        }
        if (devicePlatform != "iPhone" && devicePlatform != "iOS") {
            // $scope.deviceLoading = "ios";
            isiOs = false;
        }
        //ionic.Platform.fullScreen();
        // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
        // for form inputs)
        if (window.cordova && window.cordova.plugins.Keyboard) {
            cordova.plugins.Keyboard.hideKeyboardAccessoryBar(false);
            cordova.plugins.Keyboard.disableScroll(true);
        }
        if (window.StatusBar) {
            // org.apache.cordova.statusbar required
            // StatusBar.styleDefault();
            StatusBar.show();
            StatusBar.backgroundColorByHexString("#327EBB");
            StatusBar.styleLightContent();
            //StatusBar.hide();
            StatusBar.overlaysWebView(false);
        }
    });

});

opportunityApp.config(function ($stateProvider, $urlRouterProvider) {
    $stateProvider

    /*/////////////////////// USERS ///////////////////////////*/

        .state('dashboard', {
            url: '/board',
            abstract: true,
            templateUrl: 'templates/dashboard/general/menu.html',
            controller: 'menuCtrl'
        })

    .state('dashboard.opportunity', {
        url: '/opportunity',
        views: {
            'menuContent': {
                templateUrl: 'templates/dashboard/opportunities/opportunity.tpl',
                controller: 'opportunityCtrl'
            }
        }
    })

    // if none of the above states are matched, use this as the fallback
    $urlRouterProvider.otherwise('/board/opportunity');
});

opportunityApp.directive('dateValidate', function ($cordovaToast) {
    return {
        require: "?ngModel",
        restrict: 'A',
        transclude: true,
        link: function (scope, elm, attr, ngModel) {
            var model = attr.dateValidate;
            scope.$watch(model, function (value) {
                // console.log(value);
                if (value == '' || value == undefined) return;
                if (moment(value).isValid()) {
                    var endDateValue = moment(value).add(1, 'days').format(conFig.formatDate.toUpperCase());
                    scope.toDate = endDateValue;
                }
            })
        }
    }
});

opportunityApp.directive('sglclick', ['$parse', function ($parse) {
    return {
        restrict: 'A',
        link: function (scope, element, attr) {
            var fn = $parse(attr['sglclick']);
            var delay = 300, clicks = 0, timer = null;
            element.on('click', function (event) {
                clicks++;  //count clicks
                if (clicks === 1) {
                    timer = setTimeout(function () {
                        scope.$apply(function () {
                            fn(scope, { $event: event });
                        });
                        clicks = 0;             //after action performed, reset counter
                    }, delay);
                } else {
                    clearTimeout(timer);    //prevent single-click action
                    clicks = 0;             //after action performed, reset counter
                }
            });
        }
    };
}])
