angular.module('opportunitiesService', []).factory('Opportunities', function($http) {
    return {
        getPaging: function(filter) {
            return $http({ method: 'POST', url: url_server + 'opportunitiespaging', data: filter });
        },
        getSelect: function() {
            return $http({ method: 'POST', url: url_server + 'opportunities/getall' });
        },
        getSelect2: function(filter) {
            return $http({ method: 'POST', url: url_server + 'opportunities/search', data: filter });
        },
        getAppointmentType: function(search) {
            return $http({ method: 'POST', url: url_server + 'opportunities/getAppointmentType', data: { search: search }, headers: headers, withCredentials: true });
        },
        show: function(id) {
            return $http.get(url_server + 'opportunities/' + id);
        },
        getAppointmentHistoryByCustomerId: function(id) {
            return $http.get(url_server + 'opportunities/getappointmenthistorybycustomerid/' + id);
        },
        getDataFollowUp: function(id) {
            return $http({
                headers: headers,
                method: 'GET',
                withCredentials: true,
                url: url_server + 'opportunities/getdatafollowup/' + id
            });
        },
        save: function(opportunitiesData) {
            return $http({
                method: 'POST',
                url: url_server + 'opportunities',
                data: opportunitiesData,
                headers: headers,
                withCredentials: true
            });
        },
        update_or_insert_customer: function(customer_data, customer_phone, is_customer,opp_id) {
            // console.log(customer_data, customer_phone);
            return $http({
                method: 'POST',
                url: url_server + 'opportunities/update_or_insert_customer',
                data: { customer_data: customer_data, customer_phone: customer_phone, is_customer: is_customer, opp_id:opp_id},
                headers: headers,
                withCredentials: true
            });
        },
        createTask: function(taskdata, userlogin) {
            return $http({
                method: 'POST',
                url: url_server + 'opportunities/createTask',
                data: { tasksData: taskdata, id: userlogin },
                headers: headers,
                withCredentials: true
            });
        },
        update: function(id, opportunitiesData) {
            return $http.put(url_server + 'opportunities/' + id, opportunitiesData);
        },
        convertToFollowUp: function(id, opportunitiesData) {
            return $http({
                method: 'PUT',
                headers: headers,
                url: url_server + 'opportunities/converttofollowup/' + id,
                data: opportunitiesData,
                withCredentials: true
            });
        },

        convertToFail: function(id, opportunitiesData) {
            return $http({
                method: 'PUT',
                url: url_server + 'opportunities/converttofail/' + id,
                data: opportunitiesData,
                headers: headers,
                withCredentials: true
            });
        },
        convertToFailOther: function(id, opportunitiesData) {
            return $http({
                method: 'PUT',
                url: url_server + 'opportunities/converttofailother/' + id,
                data: opportunitiesData,
                headers: headers,
                withCredentials: true
            });
        },
        convertToSuccessAddApp: function(id, opportunitiesData) {
            return $http.put(url_server + 'opportunities/converttosuccessaddapp/' + id, opportunitiesData);
        },
        followUpUpdate: function(id, opportunitiesData) {
            return $http({
                method: 'PUT',
                url: url_server + 'opportunities/followupupdate/' + id,
                data: opportunitiesData,
                headers: headers,
                withCredentials: true
            });
        },
        destroy: function(id) {
            return $http.delete(url_server + 'opportunities/' + id);
        },
        getFollowUpSubtab: function() {
            return $http({ method: 'POST', url: url_server + 'getFollowUpSubtab', headers: headers, withCredentials: true });
        },
        getCallListSubtab: function() {
            return $http({ method: 'POST', url: url_server + 'getCallListSubtab' });
        },
        folowUpSubtabContent: function(filter) {
            return $http({ method: 'POST', url: url_server + 'folowupsubtabcontent', data: filter, headers: headers, withCredentials: true });
        },
        getFailSubtab: function() {
            return $http({
                method: 'POST',
                url: url_server + 'getFailSubtab',
                headers: headers,
                withCredentials: true
            });
        },
        failSubtabContent: function(filter) {
            return $http({
                method: 'POST',
                url: url_server + 'failsubtabcontent',
                data: filter,
                headers: headers,
                withCredentials: true
            });
        },
        getOtherSubtab: function() {
            return $http({ method: 'POST', headers: headers, url: url_server + 'getOtherSubtab', withCredentials: true });
        },
        otherSubtabContent: function(filter) {
            return $http({ method: 'POST', url: url_server + 'othersubtabcontent', data: filter, headers: headers, withCredentials: true });
        },
        getCallListSubtab: function() {
            return $http({ method: 'POST', url: url_server + 'getCallListSubtab', headers: headers, withCredentials: true });
        },
        callListSubtabContent: function(filter) {
            return $http({ method: 'POST', url: url_server + 'calllistsubtabcontent', data: filter, headers: headers, withCredentials: true });
        },
        SuccessContent: function(curent_page) {
            return $http({ method: 'POST', url: url_server + 'SuccessContent', data: curent_page, headers: headers, withCredentials: true });
        },
        pendingContent: function(searchOpportunities) {
            return $http({
                method: 'POST',
                url: url_server + 'pendingContent',
                data: searchOpportunities,
                headers: headers,
                withCredentials: true
            });
        },
        import: function(url) {
            return $http({ method: 'POST', url: url_server + 'opportunities/import', data: { url: url } });
        },
        Import_anyway: function(url) {
            return $http({ method: 'POST', url: url_server + 'opportunities/Import_anyway', data: { url: url } });
        },
        // uploadFile:function(file){
        //  return Upload.upload({url: url_server+'opportunities/uploadFile' ,file: file});
        // },
        searchAllOpportunities: function(filter) {
            return $http({ method: 'POST', url: url_server + 'opportunities/searchallopportunities', data: filter, withCredentials: true });
        },
        countAllTab: function(filter) {
            return $http({
                method: 'POST',
                url: url_server + 'opportunities/countalltab',
                headers: headers,
                withCredentials: true
            });
        },
        getOpportunityQueries: function() {
            return $http({ method: 'POST', url: url_server + 'opportunitiesqueries', withCredentials: true });
        },
        getPhoneOpp: function(filter) {
            return $http({ method: 'POST', url: url_server + 'opportunities/searchphone', data: filter, withCredentials: true });
        },
        filter: function(opportunitiesData) {
            return $http({
                method: 'POST',
                url: url_server + 'opportunitiesfilter',
                data: opportunitiesData,
                withCredentials: true
            });
        },
        chechInputPhone: function(data) {
            return $http({
                method: 'POST',
                url: url_server + 'checkinputphone',
                data: data,
                withCredentials: true
            });
        },
        getOppotunitiesByCustomerId:function(id){
            return $http.get(url_server+ 'opportunities/getoppotunitiesbycustomerid/'+id,{ withCredentials: true});
        },
        getDuplicateCustomer:function(data){
            return $http({method:'POST',url:url_server+'opportunities/getduplicatecustomer',data:data,withCredentials: true});
        },
        setCustomerForOpp:function(data){
            return $http({method:'POST',url:url_server+'opportunities/setcustomerforopp',data:data,withCredentials: true});
        },
        actionSelectCustomer:function(data){
            return $http({method:'POST',url:url_server+'opportunities/actionselectcustomer',data:data,withCredentials: true,headers: headers});
        }
    };
});
