angular.module('newfeedsService',[]).factory('Newfeeds',function($http){
	return {
		getPaging:function(userlogin, search){
			return $http({method:'POST',url:url_server + 'newfeedspaging',
				data:{userlogin:userlogin, search:search},withCredentials: true});
		},
		getSelect:function(){
			return $http({method:'POST',url:url_server + 'newfeeds/getall',withCredentials: true});
		},
		getdepartment:function(){
			return $http({method:'POST',url:url_server + 'newfeeds/getdepartment',withCredentials: true});
		},
		getdataInDepartment:function(department_id){
			return $http({method:'POST',url:url_server + 'newfeeds/getdataInDepartment', data:department_id,withCredentials: true});
		},
		getSelect2:function(filter){
			return $http({method:'POST',url:url_server + 'newfeeds/search',data:filter});
		},
		rendernewfeed:function(filter){
			return $http({method:'POST',url:url_server + 'newfeeds/rendernewfeed'});
		},
		pin_unpin:function(id, user_id,unpin){
			return $http({method:'POST',url:url_server + 'newfeeds/pin_unpin',data:{id:id, user_id:user_id,unpin:unpin},withCredentials: true});
		},
		show:function(id){
			return $http.get(url_server+ 'newfeeds/'+id);
		},
		likeNewfeed:function(id){
			return $http.get(url_server+ 'newfeedlike/'+id,{withCredentials: true});
		},
		unLikeNewfeed:function(id){
			return $http.get(url_server+ 'newfeedunlike/'+id,{withCredentials: true});
		},
		countLikeById:function(id){
			return $http.get(url_server+ 'newfeedcountlikebyid/'+id,{withCredentials: true});
		},
		listLikeById:function(id){
            return $http.get(url_server+ 'newfeedlistlikebyid/'+id,{withCredentials: true});
        },
		save:function(newfeedsData){
			return $http({method:'POST',
							url:url_server+'newfeeds',
							data:newfeedsData});
		},
		comment:function(commentData){
			return $http({method:'POST',
							url:url_server+'newfeedcomment',
							data:commentData,
						    withCredentials: true});
		},
		update:function(id, newfeedsData){
			return $http.put(url_server+'newfeeds/'+id,newfeedsData);
		},
		destroy:function(id){
			return $http.delete(url_server + 'newfeeds/'+id);
		}
	};
});

angular.module('newfeedtypesService',[]).factory('Newfeedtypes',function($http){
	return {
		getPaging:function(filter){
			return $http({method:'POST',url:url_server + 'newfeedtypespaging',data:filter});
		},
		getSelect:function(){
			return $http({method:'POST',url:url_server + 'newfeedtypes/getall',withCredentials: true});
		},
		newfeedtypesOnUser:function(){
			console.log('test');
			return $http({method:'POST',url:url_server + 'newfeedtypes/newfeedtypesonuser',withCredentials: true});
		},
		getSelect2:function(filter){
			return $http({method:'POST',url:url_server + 'newfeedtypes/search',data:filter});
		},
		show:function(id){
			return $http.get(url_server+ 'newfeedtypes/'+id);
		},
		save:function(newfeedtypesData){
			return $http({method:'POST',
							url:url_server+'newfeedtypes',
							data:newfeedtypesData});
		},
		update:function(id, newfeedtypesData){
			return $http.put(url_server+'newfeedtypes/'+id,newfeedtypesData);
		},
		destroy:function(id){
			return $http.delete(url_server + 'newfeedtypes/'+id);
		}
	};
});


angular.module('feedtitlesService',[]).factory('Feedtiltles',function($http){
	return {
		getPaging:function(filter){
			return $http({method:'POST',url:url_server + 'feedtitlepaging',data:filter,withCredentials: true,headers: headers});
		},
		getSelect:function(){
			return $http({method:'POST',url:url_server + 'feedtitle/getall',withCredentials: true,headers: headers});
		},
		getSelect2:function(filter){
			return $http({method:'POST',url:url_server + 'customereviews/search',data:filter,withCredentials: true,headers: headers});
		},
		show:function(id){
			return $http.get(url_server+ 'feedtitle/'+id);
		},
		save:function(feedtitleData){
			return $http({method:'POST',
							url:url_server+'feedtitle',
							data:feedtitleData});
		},
		update:function(id, data){
			return $http.put(url_server+'feedtitle/'+id,data);
		},
		destroy:function(id){
			return $http.delete(url_server + 'feedtitle/'+id);
		}
	};
});

