angular.module('scheduleService', []).factory('Schedule', function($http) {
    var headers = {'Access-Control-Allow-Origin': '*'};
    return {
        getPaging: function(filter) {
            return $http({
                method: 'POST',
                headers: headers,
                url: url_server + 'schedulepaging',
                data: filter,
                withCredentials: true
            });
            // return $http({
            //     method: 'POST',
            //     url: url_server + 'schedulepaging',
            //     data: filter
            // });
        },
        getSelect: function() {
            return $http({
                method: 'POST',
                url: url_server + 'schedule/getall'
            });
        },
        getSelect2: function(filter) {
            return $http({
                method: 'POST',
                url: url_server + 'schedule/search',
                data: filter
            });
        },
        show: function(id) {
            return $http.get(url_server + 'schedule/' + id);
        },
        save: function(scheduleData) {
            return $http({
                method: 'POST',
                url: url_server + 'schedule',
                data: scheduleData
            });
        },
        update: function(id, scheduleData) {
            return $http.put(url_server + 'schedule/' + id, scheduleData);
        },
        destroy: function(id) {
            return $http.delete(url_server + 'schedule/' + id);
        }
    };
});