angular.module('chatSvc', []).factory('Lineitems',function($http){
	return {
		getPaging:function(filter){
			return $http({method:'POST',url:url_server + 'lineitemspaging',data:filter});
		},
		getSelect:function(){
			return $http({method:'POST',url:url_server + 'lineitems/getall'});
		},
		getSelect2:function(filter){
			return $http({method:'POST',url:url_server + 'lineitems/search',data:filter});
		},
		show:function(id){
			return $http.get(url_server+ 'lineitems/'+id);
		},
		save:function(lineitemsData){
			return $http({method:'POST',
				url:url_server+'lineitems',
				data:lineitemsData});
		},
		update:function(id, lineitemsData){
			return $http.put(url_server+'lineitems/'+id,lineitemsData);
		},
		destroy:function(id){
			return $http.delete(url_server + 'lineitems/'+id);
		},
		searchLibrary:function(libraryData){
			return $http({method:'POST',
				url:url_server+'lineitems/searchlibrary',
				data:libraryData,withCredentials: true});
		},
		searchChat:function(lineitemsData){
			return $http({method:'POST',
				url:url_server+'lineitems/searchchat',
				data:lineitemsData,withCredentials: true});
		},
		getContentSearchChat:function(message){
			return $http({method:'POST',
				url:url_server+'lineitems/getcontentsearchchat',
				data:message,withCredentials: true});
		},
		loadMoreMessage:function(data){
		return $http({method:'POST',
				url:url_server+'lineitems/loadmoremessage',
				data:data,withCredentials: true});	
		},
		uploadThumbnail:function(thumbnail){
			return $http({method:'POST',url:url_server + 'lineitems/upload',data:thumbnail,withCredentials: true});
		},
		getLinkcover:function(obj){
			return $http({method:'POST',url:url_server + 'lineitems/linkcover',data:obj,withCredentials: true});
		}
	};
});

angular.module('chatsettingsService',[]).factory('Chatsettings',function($http){
	return {
		getPaging:function(filter){
			return $http({method:'POST',url:url_server + 'chatsettingspaging',data:filter});
		},
		getSelect:function(){
			return $http({method:'POST',url:url_server + 'chatsettings/getall'});
		},
		getSelect2:function(filter){
			return $http({method:'POST',url:url_server + 'chatsettings/search',data:filter});
		},
		show:function(id){
			return $http.get(url_server+ 'chatsettings/'+id);
		},
		save:function(chatsettingsData){
			return $http({method:'POST',
				headers:headers,
				url:url_server+'chatsettings',
				data:chatsettingsData,
				withCredentials: true});
		},
		update:function(id, chatsettingsData){
			return $http.put(url_server+'chatsettings/'+id,chatsettingsData, {
				headers:headers, withCredentials: true });
		},
		destroy:function(id){
			return $http.delete(url_server + 'chatsettings/'+id);
		},
		hideContact:function(hideContactObj){
			return $http({method:'POST',url:url_server + 'chatsettings/hideContact',data:hideContactObj,withCredentials: true});
		},
		hideAllContact:function(hideContactObj){
			return $http({method:'POST',url:url_server + 'chatsettings/hideAllContact',data:hideContactObj,withCredentials: true});
		}
		,
		showHideContact:function(showHideContactObj){
			return $http({method:'POST',url:url_server + 'chatsettings/showHideContact',data:showHideContactObj,withCredentials: true});
		}
	};
});
