var page = "chat.html";
var chatApp = angular.module('chatApp', ['menuController', 'chatController', 'checklist-model', 'pouchdb', //
    'ngSanitize', 'soundsService', 'chatSvc', 'chatsettingsService', 'userchatstatusesService', //
    'roomsService', 'usersService', 'luegg.directives'
]).config(['$compileProvider',
    function ($compileProvider) {
        $compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|file|tel|mailto):/);
    }
]).run(['$rootScope',
    function ($rootScope) {
        $rootScope.scoped = {
            format: 'HH:mm:ss'
        };
        $rootScope.vm = {
            datetime: '05/13/2011 6:30 AM'
        }
    }
]);
chatApp.run(function ($ionicPlatform, $cordovaKeyboard, $ionicLoading) {
    $ionicLoading.show({ template: templateLoading });
    $ionicPlatform.ready(function () {
        var devicePlatform = "";
        try {
            devicePlatform = device.platform;
        } catch (err) {
            console.log(err)
        }
        if (devicePlatform != "iPhone" && devicePlatform != "iOS") {
            // $scope.deviceLoading = "ios";
            isiOs = false;
        } 
        // ionic.Platform.fullScreen();
        // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
        // for form inputs)
        if (window.cordova && window.cordova.plugins.Keyboard) {
            // cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
            // cordova.plugins.Keyboard.disableScroll(true);
        }
        if (window.StatusBar) {
            // org.apache.cordova.statusbar required
            //StatusBar.styleDefault();
            StatusBar.show();
            StatusBar.backgroundColorByHexString("#327EBB");
            StatusBar.styleLightContent();
            //StatusBar.hide();
            StatusBar.overlaysWebView(false);
        }
    });
})
chatApp.config(function ($stateProvider, $urlRouterProvider) {
    $stateProvider.state('dashboard', {
        url: '/board',
        abstract: true,
        templateUrl: 'templates/dashboard/general/menu.html',
        controller: 'menuCtrl'
    }).state('dashboard.chat', {
        url: '/chat/:dataPush',
        views: {
            'menuContent': {
                templateUrl: 'templates/dashboard/chat/chat.tpl',
                controller: 'chatCtrl'
            }
        }
    })
    // if none of the above states are matched, use this as the fallback
    $urlRouterProvider.otherwise('/board/chat/:dataPush');
})
chatApp.filter('propsFilter', function () {
    return function (items, props) {
        var out = [];
        if (angular.isArray(items)) {
            var keys = Object.keys(props);
            items.forEach(function (item) {
                var itemMatches = false;
                for (var i = 0; i < keys.length; i++) {
                    var prop = keys[i];
                    var text = props[prop].toLowerCase();
                    if (item[prop].toString().toLowerCase().indexOf(text) !== -1) {
                        itemMatches = true;
                        break;
                    }
                }
                if (itemMatches) {
                    out.push(item);
                }
            });
        } else {
            // Let the output be the input untouched
            out = items;
        }
        return out;
    };
});
chatApp.filter('highlight', function ($sce) {
    return function (text, phrase) {
        if (phrase) text = text.replace(new RegExp('(' + phrase + ')', 'gi'), '<b class="highlighted">$1</b>')
        return $sce.trustAsHtml(text)
    }
});
chatApp.directive('myText', ['$rootScope', function ($rootScope) {
    return {
        link: function (scope, element, attrs) {
            $rootScope.$on('insertEmotico', function (e, val) {
                var domElement = element[0];
                if (document.selection) {
                    domElement.focus();
                    var sel = document.selection.createRange();
                    sel.text = val;
                    domElement.focus();
                    //domElement.blur()
                } else if (domElement.selectionStart || domElement.selectionStart === 0) {
                    var startPos = domElement.selectionStart;
                    var endPos = domElement.selectionEnd;
                    var scrollTop = domElement.scrollTop;
                    var head = domElement.value.substring(0, startPos);
                    domElement.value = head + val + domElement.value.substring(endPos, domElement.value.length);
                    domElement.focus();
                    domElement.selectionStart = startPos + val.length;
                    domElement.selectionEnd = startPos + val.length;
                    domElement.scrollTop = scrollTop;
                    //  domElement.blur();
                } else {
                    domElement.value += val;
                    domElement.focus();
                }
            });
        }
    }
}]);
chatApp.directive('hashtag', ['$rootScope', function ($rootScope) {
    return {
        link: function (scope, element, attrs) {
            $rootScope.$on('hashtag', function (e, val, searh) {
                var domElement = element[0];
                //val = val.replace(/\s/g, '_');
                if (document.selection) {
                    domElement.focus();
                    var sel = document.selection.createRange();
                    sel.text = val;
                    domElement.focus();
                    //domElement.blur()
                } else if (domElement.selectionStart || domElement.selectionStart === 0) {
                    var startPos = domElement.selectionStart;
                    var endPos = domElement.selectionEnd;
                    var scrollTop = domElement.scrollTop;
                    var head = domElement.value.substring(0, startPos);
                    head = head.substring(0, head.length - searh.length);
                    domElement.value = head + val + domElement.value.substring(endPos, domElement.value.length);
                    domElement.focus();
                    domElement.selectionStart = startPos + val.length;
                    domElement.selectionEnd = startPos + val.length;
                    domElement.scrollTop = scrollTop;
                    //  domElement.blur();
                } else {
                    domElement.value += domElement.value.substring(0, domElement.value.length - searh.length) + val;
                    domElement.focus();
                }
                domElement.value += " ";
            });
        }
    }
}]);
chatApp.directive('bnWindowBlur', function ($window, $log) {
    return ({
        link: link,
        restrict: "A"
    });

    function link(scope, element, attributes) {
        var win = angular.element($window).on("blur mousemove touchstart touchmove touchend", handleBlur);
        scope.$on("$destroy", handleDestroy);

        function handleBlur(event) {
            scope.$apply(attributes.bnWindowBlur);
            //$log.warn( "Window blurred." );
        }
        // I teardown the directive.
        function handleDestroy() {
            win.off("blur mousemove touchstart touchmove touchend", handleBlur);
        }
    }
});
chatApp.directive('bnWindowFocus', function ($window, $log) {
    return ({
        link: link,
        restrict: "A"
    });

    function link(scope, element, attributes) {
        var win = angular.element($window).on("focus", handleBlur);
        scope.$on("$destroy", handleDestroy);

        function handleBlur(event) {
            scope.$apply(attributes.bnWindowBlur);
            //$log.warn( "Window blurred." );
        }
        // I teardown the directive.
        function handleDestroy() {
            win.off("focus", handleBlur);
        }
    }
});
// chatApp.directive('focusMe', function () {
//     return {
//         restrict: "A",
//         scope: {
//             onFocus: '&onFocus',
//             onBlur: '&onBlur',
//             focusOnBlur: '=focusOnBlur'
//         },
//         link: function (scope, elem) {
//             elem.on("focus", function () {
//                 scope.onFocus();
//                 scope.focusOnBlur = true;  //note the reassignment here, reason why I set '=' instead of '@' above.
//             });
//             elem.on("blur", function () {
//                 scope.onBlur();
//                 if (scope.focusOnBlur)
//                     elem[0].focus();
//             });
//         }
//     }
// });
chatApp.value('external', getParameterByName);
